/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.codeInsight.NullableNotNullDialog;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.MalformedPatternException;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.compiler.options.ComparingUtils;
import com.intellij.compiler.options.CompilerOptionsFilter;
import com.intellij.compiler.server.BuildManager;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class CompilerUIConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private static final Logger y = Logger.getInstance((String)"#com.intellij.compiler.options.CompilerUIConfigurable");
    private static final Set<CompilerOptionsFilter.Setting> f = EnumSet.of(CompilerOptionsFilter.Setting.EXTERNAL_BUILD, new CompilerOptionsFilter.Setting[]{CompilerOptionsFilter.Setting.AUTO_MAKE, CompilerOptionsFilter.Setting.PARALLEL_COMPILATION, CompilerOptionsFilter.Setting.REBUILD_MODULE_ON_DEPENDENCY_CHANGE, CompilerOptionsFilter.Setting.HEAP_SIZE, CompilerOptionsFilter.Setting.COMPILER_VM_OPTIONS});
    private final Set<CompilerOptionsFilter.Setting> i;
    private JPanel a;
    private final Project j;
    private RawCommandLineEditor l;
    private JCheckBox o;
    private JCheckBox b;
    private JBLabel e;
    private JCheckBox p;
    private JCheckBox n;
    private JCheckBox w;
    private JCheckBox r;
    private JTextField s;
    private JTextField k;
    private JTextField u;
    private JLabel v;
    private JLabel t;
    private JLabel h;
    private JCheckBox x;
    private JLabel m;
    private JLabel g;
    private JLabel c;
    private JButton q;
    private JLabel d;

    public CompilerUIConfigurable(@NotNull Project project2) {
        if (project2 == null) {
            CompilerUIConfigurable.a(0);
        }
        this.b();
        this.i = EnumSet.noneOf(CompilerOptionsFilter.Setting.class);
        this.j = project2;
        this.e.setText(XmlStringUtil.wrapInHtml((CharSequence)"Use <b>;</b> to separate patterns and <b>!</b> to negate a pattern. Accepted wildcards: <b>?</b> &mdash; exactly one symbol; <b>*</b> &mdash; zero or more symbols; <b>/</b> &mdash; path separator; <b>/**/</b> &mdash; any number of directories; <i>&lt;dir_name&gt;</i>:<i>&lt;pattern&gt;</i> &mdash; restrict to source roots with the specified name"));
        this.d.setText("<html>WARNING!<br>If option 'Clear output directory on rebuild' is enabled, the entire contents of directories where generated sources are stored WILL BE CLEARED on rebuild.</html>");
        this.d.setFont(this.d.getFont().deriveFont(1));
        this.e.setForeground((Color)new JBColor((Color)Gray._50, (Color)Gray._130));
        this.a(project2);
        this.u.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent documentEvent) {
                CompilerUIConfigurable.this.k.setEnabled(documentEvent.getDocument().getLength() == 0);
                CompilerUIConfigurable.this.s.setEnabled(ContainerUtil.find((Iterable)ParametersListUtil.parse((String)CompilerUIConfigurable.this.u.getText()), string -> StringUtil.startsWithIgnoreCase((String)string, (String)"-Xmx")) == null);
            }
        });
        this.q.addActionListener(NullableNotNullDialog.createActionListener((Component)this.a));
    }

    private void a(@NotNull Project project2) {
        if (project2 == null) {
            CompilerUIConfigurable.a(1);
        }
        CompilerOptionsFilter[] compilerOptionsFilterArray = (CompilerOptionsFilter[])CompilerOptionsFilter.EP_NAME.getExtensions();
        boolean bl2 = true;
        for (CompilerOptionsFilter object : compilerOptionsFilterArray) {
            bl2 = object.isAvailable(CompilerOptionsFilter.Setting.EXTERNAL_BUILD, project2);
            if (bl2) continue;
            this.i.add(CompilerOptionsFilter.Setting.EXTERNAL_BUILD);
            break;
        }
        block1: for (CompilerOptionsFilter compilerOptionsFilter : CompilerOptionsFilter.Setting.values()) {
            if (!bl2 && f.contains(compilerOptionsFilter)) {
                this.i.add((CompilerOptionsFilter.Setting)((Object)compilerOptionsFilter));
                continue;
            }
            for (CompilerOptionsFilter compilerOptionsFilter2 : compilerOptionsFilterArray) {
                if (compilerOptionsFilter2.isAvailable((CompilerOptionsFilter.Setting)((Object)compilerOptionsFilter), project2)) continue;
                this.i.add((CompilerOptionsFilter.Setting)((Object)compilerOptionsFilter));
                continue block1;
            }
        }
        HashMap hashMap = ContainerUtilRt.newHashMap();
        hashMap.put(CompilerOptionsFilter.Setting.RESOURCE_PATTERNS, ContainerUtilRt.newArrayList((Object[])new JComponent[]{this.m, this.l, this.e}));
        hashMap.put(CompilerOptionsFilter.Setting.CLEAR_OUTPUT_DIR_ON_REBUILD, Collections.singleton(this.o));
        hashMap.put(CompilerOptionsFilter.Setting.ADD_NOT_NULL_ASSERTIONS, Collections.singleton(this.b));
        hashMap.put(CompilerOptionsFilter.Setting.AUTO_SHOW_FIRST_ERROR_IN_EDITOR, Collections.singleton(this.p));
        hashMap.put(CompilerOptionsFilter.Setting.DISPLAY_NOTIFICATION_POPUP, Collections.singleton(this.n));
        hashMap.put(CompilerOptionsFilter.Setting.AUTO_MAKE, ContainerUtilRt.newArrayList((Object[])new JComponent[]{this.w, this.g}));
        hashMap.put(CompilerOptionsFilter.Setting.PARALLEL_COMPILATION, ContainerUtilRt.newArrayList((Object[])new JComponent[]{this.r, this.c}));
        hashMap.put(CompilerOptionsFilter.Setting.REBUILD_MODULE_ON_DEPENDENCY_CHANGE, ContainerUtilRt.newArrayList((Object[])new JComponent[]{this.x}));
        hashMap.put(CompilerOptionsFilter.Setting.HEAP_SIZE, ContainerUtilRt.newArrayList((Object[])new JComponent[]{this.v, this.s}));
        hashMap.put(CompilerOptionsFilter.Setting.COMPILER_VM_OPTIONS, ContainerUtilRt.newArrayList((Object[])new JComponent[]{this.h, this.u, this.t, this.k}));
        for (CompilerOptionsFilter.Setting setting : this.i) {
            Collection collection = (Collection)hashMap.get((Object)setting);
            if (collection == null) continue;
            for (JComponent jComponent : collection) {
                jComponent.setVisible(false);
            }
        }
    }

    public void reset() {
        CompilerConfigurationImpl compilerConfigurationImpl = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)this.j);
        CompilerWorkspaceConfiguration compilerWorkspaceConfiguration = CompilerWorkspaceConfiguration.getInstance((Project)this.j);
        this.p.setSelected(compilerWorkspaceConfiguration.AUTO_SHOW_ERRORS_IN_EDITOR);
        this.n.setSelected(compilerWorkspaceConfiguration.DISPLAY_NOTIFICATION_POPUP);
        this.o.setSelected(compilerWorkspaceConfiguration.CLEAR_OUTPUT_DIRECTORY);
        this.b.setSelected(compilerConfigurationImpl.isAddNotNullAssertions());
        this.w.setSelected(compilerWorkspaceConfiguration.MAKE_PROJECT_ON_SAVE);
        this.r.setSelected(compilerWorkspaceConfiguration.PARALLEL_COMPILATION);
        this.x.setSelected(compilerWorkspaceConfiguration.REBUILD_ON_DEPENDENCY_CHANGE);
        int n2 = JavacConfiguration.getOptions((Project)this.j, JavacConfiguration.class).MAXIMUM_HEAP_SIZE;
        this.s.setText(String.valueOf(compilerConfigurationImpl.getBuildProcessHeapSize(n2)));
        String string = compilerWorkspaceConfiguration.COMPILER_PROCESS_ADDITIONAL_VM_OPTIONS;
        this.u.setText(string == null ? "" : string.trim());
        this.k.setText(compilerConfigurationImpl.getBuildProcessVMOptions());
        compilerConfigurationImpl.convertPatterns();
        this.l.setText(CompilerUIConfigurable.a(compilerConfigurationImpl.getResourceFilePatterns()));
        if (PowerSaveMode.isEnabled()) {
            this.g.setText("(disabled in Power Save mode)");
            this.g.setFont(this.g.getFont().deriveFont(1));
        } else {
            this.g.setText("(only works while not running / debugging)");
            this.g.setFont(this.g.getFont().deriveFont(0));
        }
    }

    private static String a(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(";");
            }
            stringBuilder.append(stringArray[i2]);
        }
        return stringBuilder.toString();
    }

    public void apply() throws ConfigurationException {
        CompilerConfigurationImpl compilerConfigurationImpl = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)this.j);
        CompilerWorkspaceConfiguration compilerWorkspaceConfiguration = CompilerWorkspaceConfiguration.getInstance((Project)this.j);
        if (!this.i.contains((Object)CompilerOptionsFilter.Setting.AUTO_SHOW_FIRST_ERROR_IN_EDITOR)) {
            compilerWorkspaceConfiguration.AUTO_SHOW_ERRORS_IN_EDITOR = this.p.isSelected();
        }
        if (!this.i.contains((Object)CompilerOptionsFilter.Setting.DISPLAY_NOTIFICATION_POPUP)) {
            compilerWorkspaceConfiguration.DISPLAY_NOTIFICATION_POPUP = this.n.isSelected();
        }
        if (!this.i.contains((Object)CompilerOptionsFilter.Setting.CLEAR_OUTPUT_DIR_ON_REBUILD)) {
            compilerWorkspaceConfiguration.CLEAR_OUTPUT_DIRECTORY = this.o.isSelected();
        }
        if (!this.i.contains((Object)CompilerOptionsFilter.Setting.EXTERNAL_BUILD)) {
            if (!this.i.contains((Object)CompilerOptionsFilter.Setting.AUTO_MAKE)) {
                compilerWorkspaceConfiguration.MAKE_PROJECT_ON_SAVE = this.w.isSelected();
            }
            if (!this.i.contains((Object)CompilerOptionsFilter.Setting.PARALLEL_COMPILATION)) {
                compilerWorkspaceConfiguration.PARALLEL_COMPILATION = this.r.isSelected();
            }
            if (!this.i.contains((Object)CompilerOptionsFilter.Setting.REBUILD_MODULE_ON_DEPENDENCY_CHANGE)) {
                compilerWorkspaceConfiguration.REBUILD_ON_DEPENDENCY_CHANGE = this.x.isSelected();
            }
            if (!this.i.contains((Object)CompilerOptionsFilter.Setting.HEAP_SIZE)) {
                try {
                    compilerConfigurationImpl.setBuildProcessHeapSize(Integer.parseInt(this.s.getText().trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    y.info((Throwable)numberFormatException);
                }
            }
            if (!this.i.contains((Object)CompilerOptionsFilter.Setting.COMPILER_VM_OPTIONS)) {
                compilerWorkspaceConfiguration.COMPILER_PROCESS_ADDITIONAL_VM_OPTIONS = this.u.getText().trim();
                compilerConfigurationImpl.setBuildProcessVMOptions(this.k.getText().trim());
            }
        }
        if (!this.i.contains((Object)CompilerOptionsFilter.Setting.ADD_NOT_NULL_ASSERTIONS)) {
            compilerConfigurationImpl.setAddNotNullAssertions(this.b.isSelected());
        }
        if (!this.i.contains((Object)CompilerOptionsFilter.Setting.RESOURCE_PATTERNS)) {
            compilerConfigurationImpl.removeResourceFilePatterns();
            String string = this.l.getText().trim();
            CompilerUIConfigurable.applyResourcePatterns(string, compilerConfigurationImpl);
        }
        BuildManager.getInstance().clearState(this.j);
    }

    public static void applyResourcePatterns(String string, CompilerConfigurationImpl compilerConfigurationImpl) throws ConfigurationException {
        CharSequence charSequence;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        while (stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken();
            try {
                compilerConfigurationImpl.addResourceFilePattern((String)charSequence);
            }
            catch (MalformedPatternException malformedPatternException) {
                arrayList.add(new String[]{charSequence, malformedPatternException.getLocalizedMessage()});
            }
        }
        if (arrayList.size() > 0) {
            charSequence = new StringBuilder();
            for (Object e2 : arrayList) {
                String[] stringArray = (String[])e2;
                ((StringBuilder)charSequence).append("\n");
                ((StringBuilder)charSequence).append(stringArray[0]);
                ((StringBuilder)charSequence).append(": ");
                ((StringBuilder)charSequence).append(stringArray[1]);
            }
            throw new ConfigurationException(CompilerBundle.message((String)"error.compiler.configurable.malformed.patterns", (Object[])new Object[]{((StringBuilder)charSequence).toString()}), CompilerBundle.message((String)"bad.resource.patterns.dialog.title", (Object[])new Object[0]));
        }
    }

    public boolean isModified() {
        CompilerWorkspaceConfiguration compilerWorkspaceConfiguration = CompilerWorkspaceConfiguration.getInstance((Project)this.j);
        boolean bl2 = !this.i.contains((Object)CompilerOptionsFilter.Setting.AUTO_SHOW_FIRST_ERROR_IN_EDITOR) && ComparingUtils.isModified(this.p, compilerWorkspaceConfiguration.AUTO_SHOW_ERRORS_IN_EDITOR);
        bl2 |= !this.i.contains((Object)CompilerOptionsFilter.Setting.DISPLAY_NOTIFICATION_POPUP) && ComparingUtils.isModified(this.n, compilerWorkspaceConfiguration.DISPLAY_NOTIFICATION_POPUP);
        bl2 |= !this.i.contains((Object)CompilerOptionsFilter.Setting.AUTO_MAKE) && ComparingUtils.isModified(this.w, compilerWorkspaceConfiguration.MAKE_PROJECT_ON_SAVE);
        bl2 |= !this.i.contains((Object)CompilerOptionsFilter.Setting.PARALLEL_COMPILATION) && ComparingUtils.isModified(this.r, compilerWorkspaceConfiguration.PARALLEL_COMPILATION);
        bl2 |= !this.i.contains((Object)CompilerOptionsFilter.Setting.REBUILD_MODULE_ON_DEPENDENCY_CHANGE) && ComparingUtils.isModified(this.x, compilerWorkspaceConfiguration.REBUILD_ON_DEPENDENCY_CHANGE);
        bl2 |= !this.i.contains((Object)CompilerOptionsFilter.Setting.COMPILER_VM_OPTIONS) && ComparingUtils.isModified(this.u, compilerWorkspaceConfiguration.COMPILER_PROCESS_ADDITIONAL_VM_OPTIONS);
        CompilerConfigurationImpl compilerConfigurationImpl = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)this.j);
        bl2 |= !this.i.contains((Object)CompilerOptionsFilter.Setting.HEAP_SIZE) && ComparingUtils.isModified(this.s, compilerConfigurationImpl.getBuildProcessHeapSize(0));
        bl2 |= !this.i.contains((Object)CompilerOptionsFilter.Setting.COMPILER_VM_OPTIONS) && ComparingUtils.isModified(this.k, compilerConfigurationImpl.getBuildProcessVMOptions());
        bl2 |= !this.i.contains((Object)CompilerOptionsFilter.Setting.ADD_NOT_NULL_ASSERTIONS) && ComparingUtils.isModified(this.b, compilerConfigurationImpl.isAddNotNullAssertions());
        bl2 |= !this.i.contains((Object)CompilerOptionsFilter.Setting.CLEAR_OUTPUT_DIR_ON_REBUILD) && ComparingUtils.isModified(this.o, compilerWorkspaceConfiguration.CLEAR_OUTPUT_DIRECTORY);
        return bl2 |= !this.i.contains((Object)CompilerOptionsFilter.Setting.RESOURCE_PATTERNS) && ComparingUtils.isModified(this.l, CompilerUIConfigurable.a(compilerConfigurationImpl.getResourceFilePatterns()));
    }

    public String getDisplayName() {
        return "General";
    }

    public String getHelpTopic() {
        return null;
    }

    @NotNull
    public String getId() {
        if ("compiler.general" == null) {
            CompilerUIConfigurable.a(2);
        }
        return "compiler.general";
    }

    public JComponent createComponent() {
        return this.a;
    }

    private void a() {
        this.l = new RawCommandLineEditor(ParametersListUtil.COLON_LINE_PARSER, ParametersListUtil.COLON_LINE_JOINER);
        this.l.setDialogCaption("Resource patterns");
        this.s = new JTextField();
        this.s.setPreferredSize(new Dimension(JBUI.scale((int)50), this.s.getPreferredSize().height));
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/options/CompilerUIConfigurable";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/options/CompilerUIConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "tweakControls";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void b() {
        JLabel jLabel;
        JButton jButton;
        JCheckBox jCheckBox;
        JLabel jLabel2;
        JTextField jTextField;
        JTextField jTextField2;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JLabel jLabel3;
        JLabel jLabel4;
        JCheckBox jCheckBox4;
        JLabel jLabel5;
        JLabel jLabel6;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JBLabel jBLabel;
        JLabel jLabel7;
        JPanel jPanel;
        this.a();
        this.a = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(13, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, 1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.m = jLabel7 = new JLabel();
        this.a(jLabel7, ResourceBundle.getBundle("messages/CompilerBundle").getString("label.option.resource.patterns.text"));
        jPanel2.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        RawCommandLineEditor rawCommandLineEditor = this.l;
        rawCommandLineEditor.setFocusable(true);
        rawCommandLineEditor.setText("");
        jPanel2.add((Component)rawCommandLineEditor, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.e = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel.setText("label");
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 3, null, null, null, 1));
        this.o = jCheckBox7 = new JCheckBox();
        this.a(jCheckBox7, ResourceBundle.getBundle("messages/CompilerBundle").getString("label.option.clear.output.directory.on.rebuild"));
        jPanel.add((Component)jCheckBox7, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.p = jCheckBox6 = new JCheckBox();
        this.a(jCheckBox6, ResourceBundle.getBundle("messages/CompilerBundle").getString("label.option.autoshow.first.error"));
        jPanel.add((Component)jCheckBox6, new GridConstraints(3, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.w = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Build project automatically");
        jPanel.add((Component)jCheckBox5, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.v = jLabel6 = new JLabel();
        jLabel6.setText("Build process heap size (Mbytes):");
        jPanel.add((Component)jLabel6, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JTextField jTextField3 = this.s;
        jPanel.add((Component)jTextField3, new GridConstraints(8, 1, 1, 2, 8, 0, 6, 0, null, null, null));
        this.h = jLabel5 = new JLabel();
        jLabel5.setText("User-local build process VM options (overrides Shared options):");
        jPanel.add((Component)jLabel5, new GridConstraints(10, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.r = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Compile independent modules in parallel");
        jPanel.add((Component)jCheckBox4, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.c = jLabel4 = new JLabel();
        jLabel4.setText("(may require larger heap size)");
        jPanel.add((Component)jLabel4, new GridConstraints(6, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        this.g = jLabel3 = new JLabel();
        jLabel3.setText("(only works while not running / debugging)");
        jPanel.add((Component)jLabel3, new GridConstraints(5, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        this.x = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Rebuild module on dependency change");
        jPanel.add((Component)jCheckBox3, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.n = jCheckBox2 = new JCheckBox();
        this.a(jCheckBox2, ResourceBundle.getBundle("messages/CompilerBundle").getString("label.option.display.notification.popup"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.u = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(10, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.k = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(9, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.t = jLabel2 = new JLabel();
        jLabel2.setText("Shared build process VM options:");
        jPanel.add((Component)jLabel2, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.b = jCheckBox = new JCheckBox();
        this.a(jCheckBox, ResourceBundle.getBundle("messages/CompilerBundle").getString("add.notnull.assertions"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.q = jButton = new JButton();
        jButton.setText("Configure annotations...");
        jButton.setMnemonic('C');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.d = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(12, 0, 1, 3, 8, 0, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(11, 2, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.a;
    }

    private /* synthetic */ void a(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) == '&') {
                if (++i2 == string.length()) break;
                if (!bl2 && string.charAt(i2) != '&') {
                    bl2 = true;
                    c2 = string.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i2));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl2) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n2);
        }
    }

    private /* synthetic */ void a(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) == '&') {
                if (++i2 == string.length()) break;
                if (!bl2 && string.charAt(i2) != '&') {
                    bl2 = true;
                    c2 = string.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i2));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl2) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n2);
        }
    }
}

