/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.intellij.compiler.CompilerMessageImpl;
import com.intellij.compiler.ProblemsView;
import com.intellij.compiler.server.AutomakeCompileContext;
import com.intellij.compiler.server.DefaultMessageHandler;
import com.intellij.notification.Notification;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.problems.Problem;
import com.intellij.problems.WolfTheProblemSolver;
import java.util.Collections;
import java.util.UUID;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CmdlineRemoteProto;

class AutoMakeMessageHandler
extends DefaultMessageHandler {
    private static final Key<Notification> j = Key.create((String)"LAST_AUTO_MAKE_NOFITICATION");
    private CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status i;
    private final Project f;
    private final WolfTheProblemSolver g;
    private volatile boolean h = false;
    private final AutomakeCompileContext e;

    public AutoMakeMessageHandler(Project project2) {
        super(project2);
        this.f = project2;
        this.i = CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status.SUCCESS;
        this.g = WolfTheProblemSolver.getInstance((Project)project2);
        this.e = new AutomakeCompileContext(project2);
    }

    public boolean unprocessedFSChangesDetected() {
        return this.h;
    }

    @Override
    protected void handleBuildEvent(UUID uUID, CmdlineRemoteProto.Message.BuilderMessage.BuildEvent buildEvent) {
        if (this.f.isDisposed()) {
            return;
        }
        switch (buildEvent.getEventType()) {
            case BUILD_COMPLETED: {
                this.e.getProgressIndicator().stop();
                if (buildEvent.hasCompletionStatus()) {
                    CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status status;
                    this.i = status = buildEvent.getCompletionStatus();
                    if (status == CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status.CANCELED) {
                        this.e.getProgressIndicator().cancel();
                    }
                }
                int n2 = this.e.getMessageCount(CompilerMessageCategory.ERROR);
                int n3 = this.e.getMessageCount(CompilerMessageCategory.WARNING);
                SwingUtilities.invokeLater(() -> {
                    if (this.f.isDisposed()) {
                        return;
                    }
                    CompilationStatusListener compilationStatusListener = (CompilationStatusListener)this.f.getMessageBus().syncPublisher(CompilerTopics.COMPILATION_STATUS);
                    compilationStatusListener.automakeCompilationFinished(n2, n3, (CompileContext)this.e);
                });
                return;
            }
            case FILES_GENERATED: {
                CompilationStatusListener compilationStatusListener = (CompilationStatusListener)this.f.getMessageBus().syncPublisher(CompilerTopics.COMPILATION_STATUS);
                for (CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.GeneratedFile generatedFile : buildEvent.getGeneratedFilesList()) {
                    String string = FileUtil.toSystemIndependentName((String)generatedFile.getOutputRoot());
                    String string2 = FileUtil.toSystemIndependentName((String)generatedFile.getRelativePath());
                    compilationStatusListener.fileGenerated(string, string2);
                }
                return;
            }
            case CUSTOM_BUILDER_MESSAGE: {
                CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.CustomBuilderMessage customBuilderMessage;
                if (buildEvent.hasCustomBuilderMessage() && "JPS".equals((customBuilderMessage = buildEvent.getCustomBuilderMessage()).getBuilderId()) && "!unprocessed_fs_changes_detected!".equals(customBuilderMessage.getMessageType())) {
                    this.h = true;
                }
                return;
            }
        }
    }

    @Override
    protected void handleCompileMessage(UUID uUID, CmdlineRemoteProto.Message.BuilderMessage.CompileMessage compileMessage) {
        if (this.f.isDisposed()) {
            return;
        }
        CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind kind = compileMessage.getKind();
        if (kind == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.PROGRESS) {
            ProblemsView problemsView = ProblemsView.SERVICE.getInstance(this.f);
            if (compileMessage.hasDone()) {
                problemsView.setProgress(compileMessage.getText(), compileMessage.getDone());
            } else {
                problemsView.setProgress(compileMessage.getText());
            }
        } else {
            CompilerMessageCategory compilerMessageCategory = AutoMakeMessageHandler.a(kind);
            if (compilerMessageCategory != null) {
                String string = compileMessage.hasSourceFilePath() ? compileMessage.getSourceFilePath() : null;
                String string2 = string != null ? VirtualFileManager.constructUrl((String)"file", (String)FileUtil.toSystemIndependentName((String)string)) : null;
                long l2 = compileMessage.hasLine() ? compileMessage.getLine() : -1L;
                long l3 = compileMessage.hasColumn() ? compileMessage.getColumn() : -1L;
                CompilerMessage compilerMessage = this.e.createAndAddMessage(compilerMessageCategory, compileMessage.getText(), string2, (int)l2, (int)l3, null);
                if (kind == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.ERROR || kind == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.JPS_INFO) {
                    if (kind == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.ERROR) {
                        this.a(this.f, compileMessage);
                    }
                    if (compilerMessage != null) {
                        ProblemsView.SERVICE.getInstance(this.f).addMessage(compilerMessage, uUID);
                    }
                }
            }
        }
    }

    @Nullable
    private static CompilerMessageCategory a(CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind kind) {
        switch (kind) {
            case ERROR: {
                return CompilerMessageCategory.ERROR;
            }
            case WARNING: {
                return CompilerMessageCategory.WARNING;
            }
            case INFO: {
                return CompilerMessageCategory.INFORMATION;
            }
            case JPS_INFO: {
                return CompilerMessageCategory.INFORMATION;
            }
            case OTHER: {
                return CompilerMessageCategory.INFORMATION;
            }
        }
        return null;
    }

    @Override
    public void handleFailure(UUID uUID, CmdlineRemoteProto.Message.Failure failure) {
        String string;
        if (this.f.isDisposed()) {
            return;
        }
        String string2 = string = failure.hasDescription() ? failure.getDescription() : null;
        if (string == null) {
            string = failure.hasStacktrace() ? failure.getStacktrace() : "";
        }
        String string3 = "Auto build failure: " + string;
        CompilerManager.NOTIFICATION_GROUP.createNotification(string3, MessageType.INFO);
        ProblemsView.SERVICE.getInstance(this.f).addMessage(new CompilerMessageImpl(this.f, CompilerMessageCategory.ERROR, string3), uUID);
    }

    @Override
    public void sessionTerminated(UUID uUID) {
        Object object;
        String string = null;
        switch (this.i) {
            case SUCCESS: {
                break;
            }
            case UP_TO_DATE: {
                break;
            }
            case ERRORS: {
                string = "Auto build completed with errors";
                break;
            }
        }
        if (string != null) {
            object = CompilerManager.NOTIFICATION_GROUP.createNotification(string, MessageType.INFO);
            if (!this.f.isDisposed()) {
                object.notify(this.f);
            }
            this.f.putUserData(j, object);
        } else {
            object = (Notification)this.f.getUserData(j);
            if (object != null) {
                object.expire();
                this.f.putUserData(j, null);
            }
        }
        if (!this.f.isDisposed()) {
            object = ProblemsView.SERVICE.getInstance(this.f);
            ((ProblemsView)object).clearProgress();
            ((ProblemsView)object).clearOldMessages(null, uUID);
        }
    }

    private void a(Project project2, CmdlineRemoteProto.Message.BuilderMessage.CompileMessage compileMessage) {
        VirtualFile virtualFile;
        String string = compileMessage.getSourceFilePath();
        if (string != null && !project2.isDisposed() && (virtualFile = LocalFileSystem.getInstance().findFileByPath(string)) != null) {
            int n2 = (int)compileMessage.getLine();
            int n3 = (int)compileMessage.getColumn();
            if (n2 > 0 && n3 > 0) {
                Problem problem = this.g.convertToProblem(virtualFile, n2, n3, new String[]{compileMessage.getText()});
                this.g.weHaveGotProblems(virtualFile, Collections.singletonList(problem));
            } else {
                this.g.queue(virtualFile);
            }
        }
    }
}

