/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.intellij.compiler.server.BuilderMessageHandler;
import com.intellij.compiler.server.DelegatingMessageHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.api.RequestFuture;

@ChannelHandler.Sharable
class BuildMessageDispatcher
extends SimpleChannelInboundHandlerAdapter<CmdlineRemoteProto.Message> {
    private static final Logger b = Logger.getInstance((String)"#com.intellij.compiler.server.BuildMessageDispatcher");
    private static final AttributeKey<SessionData> d = AttributeKey.valueOf((String)"BuildMessageDispatcher.sessionData");
    private final Map<UUID, SessionData> c = new ConcurrentHashMap<UUID, SessionData>(16, 0.75f, 1);
    private final Set<UUID> a = ContainerUtil.newConcurrentSet();

    BuildMessageDispatcher() {
    }

    public void registerBuildMessageHandler(final @NotNull RequestFuture<? extends BuilderMessageHandler> requestFuture, @Nullable CmdlineRemoteProto.Message.ControllerMessage controllerMessage) {
        if (requestFuture == null) {
            BuildMessageDispatcher.a(0);
        }
        DelegatingMessageHandler delegatingMessageHandler = new DelegatingMessageHandler(){

            @Override
            protected BuilderMessageHandler getDelegateHandler() {
                return (BuilderMessageHandler)requestFuture.getMessageHandler();
            }

            @Override
            public void sessionTerminated(UUID uUID) {
                try {
                    super.sessionTerminated(uUID);
                }
                finally {
                    requestFuture.setDone();
                }
            }
        };
        UUID uUID = requestFuture.getRequestID();
        this.c.put(uUID, new SessionData(uUID, delegatingMessageHandler, controllerMessage));
    }

    @Nullable
    public BuilderMessageHandler unregisterBuildMessageHandler(UUID uUID) {
        this.a.remove(uUID);
        SessionData sessionData = this.c.remove(uUID);
        if (sessionData == null) {
            return null;
        }
        Channel channel = sessionData.channel;
        if (channel != null) {
            channel.attr(d).remove();
        }
        return sessionData.handler;
    }

    public void cancelSession(UUID uUID) {
        Channel channel;
        if (this.a.add(uUID) && (channel = this.getConnectedChannel(uUID)) != null) {
            channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)uUID, (CmdlineRemoteProto.Message.ControllerMessage)CmdlineProtoUtil.createCancelCommand()));
        }
    }

    @Nullable
    public Channel getConnectedChannel(UUID uUID) {
        Channel channel = this.getAssociatedChannel(uUID);
        return channel != null && channel.isActive() ? channel : null;
    }

    @Nullable
    public Channel getAssociatedChannel(UUID uUID) {
        SessionData sessionData = this.c.get(uUID);
        return sessionData != null ? sessionData.channel : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendBuildParameters(@NotNull UUID uUID, @NotNull CmdlineRemoteProto.Message.ControllerMessage controllerMessage) {
        if (uUID == null) {
            BuildMessageDispatcher.a(1);
        }
        if (controllerMessage == null) {
            BuildMessageDispatcher.a(2);
        }
        boolean bl2 = false;
        SessionData sessionData = this.c.get(uUID);
        if (sessionData != null) {
            SessionData sessionData2 = sessionData;
            synchronized (sessionData2) {
                if (sessionData.state == SessionData.State.WAITING_PARAMS) {
                    sessionData.state = SessionData.State.RUNNING;
                    Channel channel = sessionData.channel;
                    if (channel != null && channel.isActive()) {
                        sessionData.handler.buildStarted(uUID);
                        channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)uUID, (CmdlineRemoteProto.Message.ControllerMessage)controllerMessage));
                        bl2 = true;
                    }
                } else if (sessionData.state == SessionData.State.INITIAL) {
                    sessionData.params = controllerMessage;
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void messageReceived(ChannelHandlerContext channelHandlerContext, CmdlineRemoteProto.Message message) throws Exception {
        UUID uUID;
        Object object;
        boolean bl2;
        SessionData sessionData = (SessionData)channelHandlerContext.channel().attr(d).get();
        boolean bl3 = bl2 = sessionData == null;
        if (bl2) {
            object = message.getSessionId();
            uUID = new UUID(object.getMostSigBits(), object.getLeastSigBits());
            sessionData = this.c.get(uUID);
            if (sessionData != null) {
                sessionData.channel = channelHandlerContext.channel();
                channelHandlerContext.channel().attr(d).set((Object)sessionData);
            }
        } else {
            uUID = sessionData.sessionId;
        }
        try {
            BuilderMessageHandler builderMessageHandler = object = sessionData != null ? sessionData.handler : null;
            if (object == null) {
                b.info("No message handler registered for session " + uUID);
                return;
            }
            CmdlineRemoteProto.Message.Type type = message.getType();
            switch (type) {
                case FAILURE: {
                    object.handleFailure(uUID, message.getFailure());
                    return;
                }
                case BUILDER_MESSAGE: {
                    CmdlineRemoteProto.Message.BuilderMessage builderMessage = message.getBuilderMessage();
                    CmdlineRemoteProto.Message.BuilderMessage.Type type2 = builderMessage.getType();
                    if (type2 == CmdlineRemoteProto.Message.BuilderMessage.Type.PARAM_REQUEST) {
                        SessionData sessionData2 = sessionData;
                        synchronized (sessionData2) {
                            CmdlineRemoteProto.Message.ControllerMessage controllerMessage = sessionData.params;
                            if (controllerMessage != null) {
                                sessionData.state = SessionData.State.RUNNING;
                                object.buildStarted(uUID);
                                sessionData.params = null;
                                channelHandlerContext.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)uUID, (CmdlineRemoteProto.Message.ControllerMessage)controllerMessage));
                            } else if (sessionData.state == SessionData.State.INITIAL) {
                                sessionData.state = SessionData.State.WAITING_PARAMS;
                            } else {
                                this.cancelSession(uUID);
                            }
                            return;
                        }
                    }
                    object.handleBuildMessage(channelHandlerContext.channel(), uUID, builderMessage);
                    return;
                }
                default: {
                    b.info("Unsupported message type " + type);
                    return;
                }
            }
        }
        finally {
            if (bl2 && this.a.contains(uUID)) {
                channelHandlerContext.channel().writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)uUID, (CmdlineRemoteProto.Message.ControllerMessage)CmdlineProtoUtil.createCancelCommand()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        BuilderMessageHandler builderMessageHandler;
        try {
            super.channelInactive(channelHandlerContext);
        }
        catch (Throwable throwable) {
            BuilderMessageHandler builderMessageHandler2;
            SessionData sessionData = (SessionData)channelHandlerContext.channel().attr(d).get();
            if (sessionData != null && (builderMessageHandler2 = this.unregisterBuildMessageHandler(sessionData.sessionId)) != null) {
                builderMessageHandler2.sessionTerminated(sessionData.sessionId);
            }
            throw throwable;
        }
        SessionData sessionData = (SessionData)channelHandlerContext.channel().attr(d).get();
        if (sessionData != null && (builderMessageHandler = this.unregisterBuildMessageHandler(sessionData.sessionId)) != null) {
            builderMessageHandler.sessionTerminated(sessionData.sessionId);
        }
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        if (throwable != null) {
            b.info(throwable);
        }
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preloadedSessionId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        objectArray2[1] = "com/intellij/compiler/server/BuildMessageDispatcher";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerBuildMessageHandler";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "sendBuildParameters";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class SessionData {
        @NotNull
        final UUID sessionId;
        @NotNull
        final BuilderMessageHandler handler;
        volatile CmdlineRemoteProto.Message.ControllerMessage params;
        volatile Channel channel;
        State state;

        private SessionData(@NotNull UUID uUID, @NotNull BuilderMessageHandler builderMessageHandler, CmdlineRemoteProto.Message.ControllerMessage controllerMessage) {
            if (uUID == null) {
                SessionData.a(0);
            }
            if (builderMessageHandler == null) {
                SessionData.a(1);
            }
            this.state = State.INITIAL;
            this.sessionId = uUID;
            this.handler = builderMessageHandler;
            this.params = controllerMessage;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sessionId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "handler";
                    break;
                }
            }
            objectArray[1] = "com/intellij/compiler/server/BuildMessageDispatcher$SessionData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static enum State {
            INITIAL,
            WAITING_PARAMS,
            RUNNING;

        }
    }
}

