/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server.impl;

import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.compiler.server.CompileServerPlugin;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class BuildProcessClasspathManager {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.compiler.server.impl.BuildProcessClasspathManager");
    private List<String> b;
    private static final Map<String, String> c = new LinkedHashMap<String, String>();

    public List<String> getBuildProcessPluginsClasspath(Project project2) {
        List<String> list2 = this.a();
        List<String> list3 = BuildProcessClasspathManager.a(project2);
        if (list3.isEmpty()) {
            return list2;
        }
        list3.addAll(list2);
        return list3;
    }

    private List<String> a() {
        if (this.b == null) {
            this.b = BuildProcessClasspathManager.b();
        }
        return this.b;
    }

    private static List<String> b() {
        ArrayList arrayList = ContainerUtil.newArrayList();
        for (CompileServerPlugin compileServerPlugin : (CompileServerPlugin[])CompileServerPlugin.EP_NAME.getExtensions()) {
            PluginId pluginId = compileServerPlugin.getPluginDescriptor().getPluginId();
            IdeaPluginDescriptor ideaPluginDescriptor = PluginManager.getPlugin((PluginId)pluginId);
            a.assertTrue(ideaPluginDescriptor != null, (Object)pluginId);
            File file = ideaPluginDescriptor.getPath();
            if (file.isFile()) {
                arrayList.add(file.getPath());
                continue;
            }
            if (!file.isDirectory()) continue;
            for (String string : StringUtil.split((String)compileServerPlugin.getClasspath(), (String)";")) {
                File file2;
                File file3;
                File file4 = new File(new File(file, "lib"), string);
                File file5 = new File(file, "classes");
                if (file4.exists()) {
                    arrayList.add(file4.getPath());
                    continue;
                }
                if (file5.isDirectory()) {
                    arrayList.add(file5.getPath());
                    continue;
                }
                String string2 = FileUtil.getNameWithoutExtension((String)PathUtil.getFileName((String)string));
                if (c.containsKey(string2)) {
                    string2 = c.get(string2);
                }
                if ((file3 = file.getParentFile()).getName().equals("test")) {
                    file3 = new File(file3.getParentFile(), "production");
                }
                if ((file2 = new File(file3, string2)).exists()) {
                    arrayList.add(file2.getPath());
                    continue;
                }
                File file6 = BuildProcessClasspathManager.a(ideaPluginDescriptor);
                if (file6 != null) {
                    File file7 = new File(file6, "lib" + File.separator + PathUtil.getFileName((String)string));
                    if (file7.exists()) {
                        arrayList.add(file7.getPath());
                        continue;
                    }
                    a.error("Cannot add " + string + " from '" + ideaPluginDescriptor.getName() + ' ' + ideaPluginDescriptor.getVersion() + "' to external compiler classpath: library " + file7.getAbsolutePath() + " not found");
                    continue;
                }
                a.error("Cannot add " + string + " from '" + ideaPluginDescriptor.getName() + ' ' + ideaPluginDescriptor.getVersion() + "' to external compiler classpath: home directory of plugin not found");
            }
        }
        return arrayList;
    }

    @Nullable
    private static File a(IdeaPluginDescriptor ideaPluginDescriptor) {
        File file;
        String string = StringUtil.getShortName((String)ideaPluginDescriptor.getPluginId().getIdString());
        String string2 = System.getProperty("idea.external.build.development.plugins.dir");
        if (string2 != null && (file = new File(string2, string)).isDirectory()) {
            return file;
        }
        file = PluginPathManager.getPluginHome((String)string);
        if (!file.isDirectory() && StringUtil.isCapitalized((String)string)) {
            file = PluginPathManager.getPluginHome((String)StringUtil.decapitalize((String)string));
        }
        return file.isDirectory() ? file : null;
    }

    private static List<String> a(Project project2) {
        ArrayList arrayList = ContainerUtil.newArrayList();
        for (BuildProcessParametersProvider buildProcessParametersProvider : (BuildProcessParametersProvider[])project2.getExtensions(BuildProcessParametersProvider.EP_NAME)) {
            arrayList.addAll(buildProcessParametersProvider.getClassPath());
        }
        return arrayList;
    }

    public static List<String> getLauncherClasspath(Project project2) {
        ArrayList arrayList = ContainerUtil.newArrayList();
        for (BuildProcessParametersProvider buildProcessParametersProvider : (BuildProcessParametersProvider[])project2.getExtensions(BuildProcessParametersProvider.EP_NAME)) {
            arrayList.addAll(buildProcessParametersProvider.getLauncherClassPath());
        }
        return arrayList;
    }

    static {
        c.put("android-jps-plugin", "intellij.android.jps");
        c.put("ant-jps-plugin", "intellij.ant.jps");
        c.put("aspectj-jps-plugin", "intellij.aspectj.jps");
        c.put("devkit-jps-plugin", "intellij.devkit.jps");
        c.put("eclipse-jps-plugin", "intellij.eclipse.jps");
        c.put("error-prone-jps-plugin", "intellij.errorProne.jps");
        c.put("flex-jps-plugin", "intellij.flex.jps");
        c.put("gradle-jps-plugin", "intellij.gradle.jps");
        c.put("grails-jps-plugin", "intellij.groovy.grails.jps");
        c.put("groovy-jps-plugin", "intellij.groovy.jps");
        c.put("gwt-jps-plugin", "intellij.gwt.jps");
        c.put("google-app-engine-jps-plugin", "intellij.java.googleAppEngine.jps");
        c.put("ui-designer-jps-plugin", "intellij.java.guiForms.jps");
        c.put("intellilang-jps-plugin", "intellij.java.langInjection.jps");
        c.put("dmServer-jps-plugin", "intellij.javaee.appServers.dmServer.jps");
        c.put("weblogic-jps-plugin", "intellij.javaee.appServers.weblogic.jps");
        c.put("webSphere-jps-plugin", "intellij.javaee.appServers.websphere.jps");
        c.put("jpa-jps-plugin", "intellij.javaee.jpa.jps");
        c.put("javaee-jps-plugin", "intellij.javaee.jps");
        c.put("javaFX-jps-plugin", "intellij.javaFX.jps");
        c.put("maven-jps-plugin", "intellij.maven.jps");
        c.put("osmorc-jps-plugin", "intellij.osgi.jps");
        c.put("ruby-chef-jps-plugin", "intellij.ruby.chef.jps");
        c.put("android-common", "intellij.android.common");
        c.put("build-common", "intellij.android.buildCommon");
        c.put("android-rt", "intellij.android.rt");
        c.put("sdk-common", "android.sdktools.sdk-common");
        c.put("sdklib", "android.sdktools.sdklib");
        c.put("layoutlib-api", "android.sdktools.layoutlib-api");
        c.put("repository", "android.sdktools.repository");
        c.put("manifest-merger", "android.sdktools.manifest-merger");
        c.put("common-eclipse-util", "intellij.eclipse.common");
        c.put("flex-shared", "intellij.flex.shared");
        c.put("groovy-rt-constants", "intellij.groovy.constants.rt");
        c.put("grails-compiler-patch", "intellij.groovy.grails.compilerPatch");
        c.put("appEngine-runtime", "intellij.java.googleAppEngine.runtime");
        c.put("common-javaFX-plugin", "intellij.javaFX.common");
    }
}

