/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.ArrayAction;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.render.ArrayFilterInplaceEditor;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.MessageTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public abstract class ArrayFilterAction
extends AnAction {
    public void update(AnActionEvent anActionEvent) {
        anActionEvent.getPresentation().setEnabledAndVisible(ArrayFilterAction.a(anActionEvent) != null);
    }

    public static boolean isArrayFilter(TreeNode treeNode) {
        return treeNode instanceof MessageTreeNode && ((MessageTreeNode)treeNode).getLink() == ArrayRenderer.Filtered.FILTER_HYPERLINK;
    }

    @Nullable
    private static MessageTreeNode a(AnActionEvent anActionEvent) {
        Object object;
        Object[] objectArray;
        XDebuggerTree xDebuggerTree = XDebuggerTree.getTree((DataContext)anActionEvent.getDataContext());
        if (xDebuggerTree != null && !ArrayUtil.isEmpty((Object[])(objectArray = xDebuggerTree.getSelectionPaths())) && objectArray.length == 1 && ArrayFilterAction.isArrayFilter((TreeNode)(object = ((TreePath)objectArray[0]).getLastPathComponent()))) {
            return (MessageTreeNode)object;
        }
        return null;
    }

    public static class Delete
    extends ArrayFilterAction {
        public void actionPerformed(AnActionEvent anActionEvent) {
            MessageTreeNode messageTreeNode = ArrayFilterAction.a(anActionEvent);
            if (messageTreeNode != null) {
                TreeUtil.selectNode((JTree)messageTreeNode.getTree(), (TreeNode)messageTreeNode.getParent());
                ArrayAction.setArrayRenderer(NodeRendererSettings.getInstance().getArrayRenderer(), (XValueNodeImpl)messageTreeNode.getParent(), DebuggerManagerEx.getInstanceEx(anActionEvent.getProject()).getContext());
            }
        }
    }

    public static class Edit
    extends ArrayFilterAction {
        public void actionPerformed(AnActionEvent anActionEvent) {
            MessageTreeNode messageTreeNode = ArrayFilterAction.a(anActionEvent);
            if (messageTreeNode != null) {
                ArrayFilterInplaceEditor.edit((XDebuggerTreeNode)messageTreeNode, false);
            }
        }
    }
}

