/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.PopFrameAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.evaluate.XExpressionDialog;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThrowExceptionAction
extends DebuggerAction {
    public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
        if (anActionEvent == null) {
            ThrowExceptionAction.b(0);
        }
        final Project project2 = anActionEvent.getProject();
        final JavaStackFrame javaStackFrame = PopFrameAction.getStackFrame(anActionEvent);
        if (javaStackFrame == null || project2 == null) {
            return;
        }
        DebuggerContextImpl debuggerContextImpl = DebuggerAction.getDebuggerContext(anActionEvent.getDataContext());
        final DebugProcessImpl debugProcessImpl = debuggerContextImpl.getDebugProcess();
        if (debugProcessImpl == null) {
            return;
        }
        StackFrameProxyImpl stackFrameProxyImpl = javaStackFrame.getStackFrameProxy();
        ThreadReferenceProxyImpl threadReferenceProxyImpl = stackFrameProxyImpl.threadProxy();
        debugProcessImpl.getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContextImpl, threadReferenceProxyImpl){

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContextImpl) {
                if (suspendContextImpl == null) {
                    1.c(0);
                }
                ApplicationManager.getApplication().invokeLater(() -> new XExpressionDialog(project2, debugProcessImpl.getXdebugProcess().getEditorsProvider(), "throwExceptionValue", "Exception To Throw", javaStackFrame.getSourcePosition(), null){

                    protected void doOKAction() {
                        ThrowExceptionAction.a(project2, javaStackFrame, debugProcessImpl, this.getExpression(), (DialogWrapper)this);
                    }
                }.show());
            }

            private static /* synthetic */ void c(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/actions/ThrowExceptionAction$1", "threadAction"));
            }
        });
    }

    private static void a(final Value value, final ThreadReferenceProxyImpl threadReferenceProxyImpl, final DebugProcessImpl debugProcessImpl, final @Nullable DialogWrapper dialogWrapper) {
        debugProcessImpl.getManagerThread().schedule(new DebuggerCommandImpl(){

            @Override
            protected void action() {
                try {
                    threadReferenceProxyImpl.stop((ObjectReference)value);
                }
                catch (Exception exception) {
                    ThrowExceptionAction.a(debugProcessImpl.getProject(), DebuggerBundle.message((String)"error.throw.exception", (Object[])new Object[]{exception.getLocalizedMessage()}));
                    return;
                }
                SwingUtilities.invokeLater(() -> {
                    if (dialogWrapper != null) {
                        dialogWrapper.close(0);
                    }
                    debugProcessImpl.getSession().stepInto(true, null);
                });
            }
        });
    }

    private static void a(Project project2, String string) {
        PopFrameAction.showError(project2, string, UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"Debugger.ThrowException")));
    }

    private static void a(final Project project2, final JavaStackFrame javaStackFrame, final DebugProcessImpl debugProcessImpl, XExpression xExpression, final DialogWrapper dialogWrapper) {
        XDebuggerEvaluator xDebuggerEvaluator = javaStackFrame.getEvaluator();
        if (xDebuggerEvaluator != null) {
            xDebuggerEvaluator.evaluate(xExpression, new XDebuggerEvaluator.XEvaluationCallback(){

                public void evaluated(@NotNull XValue xValue) {
                    if (xValue == null) {
                        3.a(0);
                    }
                    if (xValue instanceof JavaValue) {
                        ThrowExceptionAction.a(((JavaValue)xValue).getDescriptor().getValue(), javaStackFrame.getDescriptor().getFrameProxy().threadProxy(), debugProcessImpl, dialogWrapper);
                    }
                }

                public void errorOccurred(@NotNull String string) {
                    if (string == null) {
                        3.a(1);
                    }
                    ThrowExceptionAction.a(project2, DebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]) + ": " + string);
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "result";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorMessage";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/debugger/actions/ThrowExceptionAction$3";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "evaluated";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "errorOccurred";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, javaStackFrame.getSourcePosition());
        } else {
            ThrowExceptionAction.a(project2, XDebuggerBundle.message((String)"xdebugger.evaluate.stack.frame.has.not.evaluator", (Object[])new Object[0]));
        }
    }

    public void update(@NotNull AnActionEvent anActionEvent) {
        JavaStackFrame javaStackFrame;
        boolean bl2;
        if (anActionEvent == null) {
            ThrowExceptionAction.b(1);
        }
        boolean bl3 = bl2 = (javaStackFrame = PopFrameAction.getStackFrame(anActionEvent)) != null && javaStackFrame.getDescriptor().getUiIndex() == 0;
        if (ActionPlaces.isMainMenuOrActionSearch((String)anActionEvent.getPlace()) || "DebuggerToolbar".equals(anActionEvent.getPlace())) {
            anActionEvent.getPresentation().setEnabled(bl2);
        } else {
            anActionEvent.getPresentation().setVisible(bl2);
        }
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/debugger/actions/ThrowExceptionAction";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

