/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.codeinsight;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.surroundWith.JavaExpressionSurrounder;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.codeinsight.RuntimeTypeEvaluator;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaWithRuntimeCastSurrounder
extends JavaExpressionSurrounder {
    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.runtime.type.template", (Object[])new Object[0]);
    }

    public boolean isApplicable(PsiExpression psiExpression) {
        if (!psiExpression.isPhysical()) {
            return false;
        }
        PsiFile psiFile = psiExpression.getContainingFile();
        if (!(psiFile instanceof PsiCodeFragment)) {
            return false;
        }
        if (!DefaultCodeFragmentFactory.isDebuggerFile(psiFile)) {
            return false;
        }
        return RuntimeTypeEvaluator.isSubtypeable(psiExpression);
    }

    public TextRange surroundExpression(Project project2, Editor editor, PsiExpression psiExpression) throws IncorrectOperationException {
        DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(project2).getContext();
        DebuggerSession debuggerSession = debuggerContextImpl.getDebuggerSession();
        if (debuggerSession != null) {
            ProgressWindow progressWindow = new ProgressWindow(true, psiExpression.getProject());
            SurroundWithCastWorker surroundWithCastWorker = new SurroundWithCastWorker(editor, psiExpression, debuggerContextImpl, (ProgressIndicator)progressWindow);
            progressWindow.setTitle(DebuggerBundle.message((String)"title.evaluating", (Object[])new Object[0]));
            debuggerContextImpl.getDebugProcess().getManagerThread().startProgress((DebuggerCommandImpl)surroundWithCastWorker, progressWindow);
        }
        return null;
    }

    private static class SurroundWithCastWorker
    extends RuntimeTypeEvaluator {
        private final Editor i;

        public SurroundWithCastWorker(Editor editor, PsiExpression psiExpression, DebuggerContextImpl debuggerContextImpl, ProgressIndicator progressIndicator) {
            super(editor, (PsiElement)psiExpression, debuggerContextImpl, progressIndicator);
            this.i = editor;
        }

        @Override
        protected void typeCalculationFinished(final @Nullable PsiType psiType) {
            if (psiType == null) {
                return;
            }
            this.hold();
            final Project project2 = this.myElement.getProject();
            DebuggerInvocationUtil.invokeLater(project2, () -> new WriteCommandAction(project2, CodeInsightBundle.message((String)"command.name.surround.with.runtime.cast", (Object[])new Object[0]), new PsiFile[0]){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void run(@NotNull Result result2) throws Throwable {
                    if (result2 == null) {
                        1.a(0);
                    }
                    try {
                        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)myElement.getProject()).getElementFactory();
                        PsiParenthesizedExpression psiParenthesizedExpression = (PsiParenthesizedExpression)psiElementFactory.createExpressionFromText("((" + psiType.getCanonicalText() + ")expr)", null);
                        ((PsiTypeCastExpression)psiParenthesizedExpression.getExpression()).getOperand().replace(myElement);
                        psiParenthesizedExpression = (PsiParenthesizedExpression)JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)psiParenthesizedExpression);
                        PsiExpression psiExpression = (PsiExpression)myElement.replace((PsiElement)psiParenthesizedExpression);
                        TextRange textRange = psiExpression.getTextRange();
                        i.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
                        i.getCaretModel().moveToOffset(textRange.getEndOffset());
                        i.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                    }
                    catch (IncorrectOperationException incorrectOperationException) {
                    }
                    finally {
                        this.release();
                    }
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/debugger/codeinsight/JavaWithRuntimeCastSurrounder$SurroundWithCastWorker$1", "run"));
                }
            }.execute(), this.myProgressIndicator.getModalityState());
        }
    }
}

