/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.PositionManagerFactory;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.NamedMethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.engine.requests.MethodReturnValueWatcher;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.debugger.ui.overhead.OverheadProducer;
import com.intellij.debugger.ui.overhead.OverheadTimings;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.sun.jdi.InternalException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugProcessEvents
extends DebugProcessImpl {
    private static final Logger A = Logger.getInstance(DebugProcessEvents.class);
    private static final String C = "REQUEST_HANDLER";
    private DebuggerEventThread z;
    private final AtomicBoolean B = new AtomicBoolean();

    public DebugProcessEvents(Project project2) {
        super(project2);
        DebuggerSettings.getInstance().addCapturePointsSettingsListener(this::a, this.myDisposable);
    }

    @Override
    protected void commitVM(VirtualMachine virtualMachine) {
        super.commitVM(virtualMachine);
        if (virtualMachine != null) {
            this.d();
            this.z = new DebuggerEventThread();
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)this.z);
        }
    }

    private static void a(DebugProcessEvents debugProcessEvents, Event event) {
        Requestor requestor = debugProcessEvents.getRequestsManager().findRequestor(event.request());
        Breakpoint breakpoint = null;
        if (requestor instanceof Breakpoint) {
            breakpoint = (Breakpoint)requestor;
        }
        String string = debugProcessEvents.getEventText((Pair<Breakpoint, Event>)Pair.create((Object)breakpoint, (Object)event));
        debugProcessEvents.showStatusText(string);
    }

    public String getEventText(Pair<Breakpoint, Event> pair2) {
        String string = "";
        Event event = (Event)pair2.getSecond();
        Breakpoint breakpoint = (Breakpoint)pair2.getFirst();
        if (event instanceof LocatableEvent) {
            try {
                string = breakpoint != null ? breakpoint.getEventMessage((LocatableEvent)event) : DebuggerBundle.message((String)"status.generic.breakpoint.reached", (Object[])new Object[0]);
            }
            catch (InternalException internalException) {
                string = DebuggerBundle.message((String)"status.generic.breakpoint.reached", (Object[])new Object[0]);
            }
        } else if (event instanceof VMStartEvent) {
            string = DebuggerBundle.message((String)"status.process.started", (Object[])new Object[0]);
        } else if (event instanceof VMDeathEvent) {
            string = DebuggerBundle.message((String)"status.process.terminated", (Object[])new Object[0]);
        } else if (event instanceof VMDisconnectEvent) {
            RemoteConnection remoteConnection = this.getConnection();
            String string2 = DebuggerBundle.getAddressDisplayName((RemoteConnection)remoteConnection);
            String string3 = DebuggerBundle.getTransportName((RemoteConnection)remoteConnection);
            string = DebuggerBundle.message((String)"status.disconnected", (Object[])new Object[]{string2, string3});
        }
        return string;
    }

    private static void a(SuspendContextImpl suspendContextImpl, ThreadReference threadReference) {
        ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContextImpl.getThread();
        suspendContextImpl.setThread(threadReference);
        if (threadReferenceProxyImpl == null) {
            suspendContextImpl.getDebugProcess().beforeSuspend(suspendContextImpl);
        }
    }

    private static Consumer<Event> b(Event event) {
        Object object;
        EventRequest eventRequest = event.request();
        Object object2 = object = eventRequest != null ? eventRequest.getProperty(C) : null;
        if (object instanceof Consumer) {
            return (Consumer)object;
        }
        return null;
    }

    private static void a(EventRequest eventRequest, Consumer<Event> consumer) {
        eventRequest.setSuspendPolicy(0);
        eventRequest.putProperty(C, consumer);
        eventRequest.enable();
    }

    private void a(SuspendContextImpl suspendContextImpl, VMStartEvent vMStartEvent) {
        DebugProcessEvents.a(suspendContextImpl, vMStartEvent.thread());
        A.debug("enter: processVMStartEvent()");
        DebugProcessEvents.a(this, vMStartEvent);
        this.getSuspendManager().voteResume(suspendContextImpl);
    }

    private void d() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        A.assertTrue(!this.isAttached());
        if (this.myState.compareAndSet(DebugProcessImpl.State.INITIAL, DebugProcessImpl.State.ATTACHED)) {
            VirtualMachineProxyImpl virtualMachineProxyImpl = this.getVirtualMachineProxy();
            EventRequestManager eventRequestManager = virtualMachineProxyImpl.eventRequestManager();
            if (virtualMachineProxyImpl.canGetMethodReturnValues()) {
                this.myReturnValueWatcher = new MethodReturnValueWatcher(eventRequestManager, this);
            }
            DebugProcessEvents.a(eventRequestManager.createThreadStartRequest(), (Consumer<Event>)((Consumer)event -> {
                ThreadReference threadReference = ((ThreadStartEvent)event).thread();
                this.getVirtualMachineProxy().threadStarted(threadReference);
                ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).threadStarted((DebugProcess)this, threadReference);
            }));
            DebugProcessEvents.a(eventRequestManager.createThreadDeathRequest(), (Consumer<Event>)((Consumer)event -> {
                ThreadReference threadReference = ((ThreadDeathEvent)event).thread();
                this.getVirtualMachineProxy().threadStopped(threadReference);
                ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).threadStopped((DebugProcess)this, threadReference);
            }));
            ((DebuggerManagerImpl)DebuggerManager.getInstance((Project)this.getProject())).getCustomPositionManagerFactories().map(function -> (PositionManager)function.fun((Object)this)).filter(Objects::nonNull).forEach(this::appendPositionManager);
            Stream.of(Extensions.getExtensions((ExtensionPointName)PositionManagerFactory.EP_NAME, (AreaInstance)this.getProject())).map(positionManagerFactory -> positionManagerFactory.createPositionManager((DebugProcess)this)).filter(Objects::nonNull).forEach(this::appendPositionManager);
            ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).processAttached((DebugProcess)this);
            this.a();
            ApplicationManager.getApplication().runReadAction(() -> {
                XDebugSession xDebugSession = this.getSession().getXDebugSession();
                if (xDebugSession != null) {
                    xDebugSession.initBreakpoints();
                }
            });
            String string = DebuggerBundle.getAddressDisplayName((RemoteConnection)this.getConnection());
            String string2 = DebuggerBundle.getTransportName((RemoteConnection)this.getConnection());
            this.showStatusText(DebuggerBundle.message((String)"status.connected", (Object[])new Object[]{string, string2}));
            A.debug("leave: processVMStartEvent()");
        }
    }

    private void a() {
        this.getManagerThread().invoke(new DebuggerCommandImpl(){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.HIGH;
            }

            @Override
            protected void action() {
                StackCapturingLineBreakpoint.deleteAll(DebugProcessEvents.this);
                StackCapturingLineBreakpoint.createAll(DebugProcessEvents.this);
            }
        });
    }

    private void a(SuspendContextImpl suspendContextImpl, @Nullable Event event) {
        if (this.isAttached() && (event == null || this.getVirtualMachineProxy().getVirtualMachine() == event.virtualMachine())) {
            try {
                DebugProcessEvents.a(suspendContextImpl, null);
                this.cancelRunToCursorBreakpoint();
            }
            finally {
                if (this.z != null) {
                    this.z.stopListening();
                    this.z = null;
                }
                this.closeProcess(false);
            }
        }
        if (event != null) {
            DebugProcessEvents.a(this, event);
        }
    }

    private void a(SuspendContextImpl suspendContextImpl, ClassPrepareEvent classPrepareEvent) {
        DebugProcessEvents.a(suspendContextImpl, classPrepareEvent.thread());
        if (A.isDebugEnabled()) {
            A.debug("Class prepared: " + classPrepareEvent.referenceType().name());
        }
        suspendContextImpl.getDebugProcess().getRequestsManager().processClassPrepared(classPrepareEvent);
        this.getSuspendManager().voteResume(suspendContextImpl);
    }

    private void a(SuspendContextImpl suspendContextImpl, StepEvent stepEvent) {
        Object object;
        ThreadReference threadReference = stepEvent.thread();
        DebugProcessEvents.a(suspendContextImpl, threadReference);
        RequestHint requestHint = (RequestHint)stepEvent.request().getProperty("hint");
        this.deleteStepRequests(stepEvent.thread());
        boolean bl2 = false;
        Project project2 = this.getProject();
        if (requestHint != null) {
            int n2 = requestHint.getNextStepDepth(suspendContextImpl);
            if (n2 == -100) {
                this.getSession().clearSteppingThrough();
                bl2 = true;
            } else if (n2 != 0) {
                object = suspendContextImpl.getThread();
                this.doStep(suspendContextImpl, (ThreadReferenceProxyImpl)object, requestHint.getSize(), n2, requestHint);
                bl2 = true;
            }
            if (!bl2 && requestHint.isRestoreBreakpoints()) {
                DebuggerManagerEx.getInstanceEx(project2).getBreakpointManager().enableBreakpoints(this);
            }
        }
        if (bl2) {
            this.getSuspendManager().voteResume(suspendContextImpl);
        } else {
            this.showStatusText("");
            if (this.myReturnValueWatcher != null) {
                this.myReturnValueWatcher.disable();
            }
            this.getSuspendManager().voteSuspend(suspendContextImpl);
            if (requestHint != null) {
                MethodFilter methodFilter = requestHint.getMethodFilter();
                if (methodFilter instanceof NamedMethodFilter && !requestHint.wasStepTargetMethodMatched()) {
                    object = "Method <b>" + ((NamedMethodFilter)methodFilter).getMethodName() + "()</b> has not been called";
                    XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification((String)object, MessageType.INFO).notify(project2);
                }
                if (requestHint.wasStepTargetMethodMatched() && requestHint.isResetIgnoreFilters()) {
                    this.checkPositionNotFiltered(suspendContextImpl.getThread(), (Consumer<List<ClassFilter>>)((Consumer)list2 -> this.mySession.resetIgnoreStepFiltersFlag()));
                }
            }
        }
    }

    private void a(SuspendContextImpl suspendContextImpl, final LocatableEvent locatableEvent) {
        ThreadReference threadReference = locatableEvent.thread();
        DebugProcessEvents.a(suspendContextImpl, threadReference);
        this.getManagerThread().schedule(new SuspendContextCommandImpl(suspendContextImpl){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void contextAction(@NotNull SuspendContextImpl var1_1) throws Exception {
                if (var1_1 == null) {
                    2.b(0);
                }
                if ((var3_3 = SuspendManagerUtil.getEvaluatingContext(var2_2 = DebugProcessEvents.this.getSuspendManager(), var1_1.getThread())) != null && !DebuggerSession.enableBreakpointsDuringEvaluation()) {
                    DebugProcessEvents.access$200(DebugProcessEvents.this, locatableEvent);
                    var2_2.voteResume(var1_1);
                    return;
                }
                var4_4 = (LocatableEventRequestor)DebugProcessEvents.this.getRequestsManager().findRequestor(locatableEvent.request());
                var5_5 = var4_4 != null && "SuspendNone".equals(var4_4.getSuspendPolicy()) != false;
                var6_6 = false;
                var7_7 = var4_4 instanceof OverheadProducer != false && var4_4 instanceof RunToCursorBreakpoint == false ? System.currentTimeMillis() : 0L;
                try {
                    v0 = var6_6 = var4_4 != null && var4_4.processLocatableEvent(this, locatableEvent) != false;
                    ** if (var7_7 <= 0L) goto lbl-1000
                }
                catch (LocatableEventRequestor.EventProcessingException var9_8) {
                    try {
                        if (DebugProcessEvents.access$900().isDebugEnabled()) {
                            DebugProcessEvents.access$900().debug(var9_8.getMessage());
                        }
                        var10_9 = new boolean[]{true};
                        DebuggerInvocationUtil.invokeAndWait(DebugProcessEvents.this.getProject(), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, a(com.intellij.debugger.engine.requests.LocatableEventRequestor com.intellij.debugger.engine.requests.LocatableEventRequestor$EventProcessingException boolean[] ), ()V)(this, (LocatableEventRequestor)var4_4, (LocatableEventRequestor.EventProcessingException)var9_8, (boolean[])var10_9), ModalityState.NON_MODAL);
                        var6_6 = var10_9[0];
                        v1 = var5_5 = var6_6 == false;
                        ** if (var7_7 <= 0L) goto lbl-1000
                    }
                    catch (Throwable var11_10) {
                        if (var7_7 > 0L) {
                            OverheadTimings.add(DebugProcessEvents.this, (OverheadProducer)var4_4, var6_6 != false || var4_4 instanceof StackCapturingLineBreakpoint != false ? 1L : 0L, System.currentTimeMillis() - var7_7);
                        }
                        throw var11_10;
                    }
lbl-1000:
                    // 1 sources

                    {
                        OverheadTimings.add(DebugProcessEvents.this, (OverheadProducer)var4_4, var6_6 != false || var4_4 instanceof StackCapturingLineBreakpoint != false ? 1L : 0L, System.currentTimeMillis() - var7_7);
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
lbl-1000:
                // 1 sources

                {
                    OverheadTimings.add(DebugProcessEvents.this, (OverheadProducer)var4_4, var6_6 != false || var4_4 instanceof StackCapturingLineBreakpoint != false ? 1L : 0L, System.currentTimeMillis() - var7_7);
                }
lbl-1000:
                // 2 sources

                {
                }
                if (var6_6 && var4_4 instanceof Breakpoint) {
                    ApplicationManager.getApplication().runReadAction((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, a(com.intellij.debugger.engine.requests.LocatableEventRequestor ), ()V)(this, (LocatableEventRequestor)var4_4));
                }
                if (!var6_6 || var5_5) {
                    var2_2.voteResume(var1_1);
                } else {
                    if (DebugProcessEvents.this.myReturnValueWatcher != null) {
                        DebugProcessEvents.this.myReturnValueWatcher.disable();
                    }
                    var2_2.voteSuspend(var1_1);
                    DebugProcessEvents.access$1000(DebugProcessEvents.this, locatableEvent);
                }
            }

            private /* synthetic */ void a(LocatableEventRequestor locatableEventRequestor) {
                XBreakpoint xBreakpoint;
                XDebugSession xDebugSession = DebugProcessEvents.this.getSession().getXDebugSession();
                if (xDebugSession != null && (xBreakpoint = ((Breakpoint)locatableEventRequestor).getXBreakpoint()) != null) {
                    ((XDebugSessionImpl)xDebugSession).processDependencies(xBreakpoint);
                }
            }

            private /* synthetic */ void a(LocatableEventRequestor locatableEventRequestor, LocatableEventRequestor.EventProcessingException eventProcessingException, boolean[] blArray) {
                String string = locatableEventRequestor instanceof Breakpoint ? ((Breakpoint)locatableEventRequestor).getDisplayName() : locatableEventRequestor.getClass().getSimpleName();
                String string2 = DebuggerBundle.message((String)"error.evaluating.breakpoint.condition.or.action", (Object[])new Object[]{string, eventProcessingException.getMessage()});
                blArray[0] = Messages.showYesNoDialog((Project)DebugProcessEvents.this.getProject(), (String)string2, (String)eventProcessingException.getTitle(), (Icon)Messages.getQuestionIcon()) == 0;
            }

            private static /* synthetic */ void b(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/DebugProcessEvents$2", "contextAction"));
            }
        });
    }

    private void a(@Nullable LocatableEvent locatableEvent) {
        if (locatableEvent != null && this.B.compareAndSet(false, true)) {
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> this.B.set(false), 1L, TimeUnit.SECONDS);
            XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(DebuggerBundle.message((String)"message.breakpoint.skipped", (Object[])new Object[]{locatableEvent.location()}), MessageType.WARNING).notify(this.getProject());
        }
    }

    @Nullable
    private static LocatableEvent a(EventSet eventSet) {
        return StreamEx.of((Collection)eventSet).select(LocatableEvent.class).findFirst().orElse(null);
    }

    private void a(SuspendContextImpl suspendContextImpl) {
        DebugProcessEvents.a(suspendContextImpl, null);
        this.getSuspendManager().voteResume(suspendContextImpl);
    }

    static /* synthetic */ void access$1000(DebugProcessEvents debugProcessEvents, Event event) {
        DebugProcessEvents.a(debugProcessEvents, event);
    }

    private class DebuggerEventThread
    implements Runnable {
        private final VirtualMachineProxyImpl b;
        private boolean a = false;

        DebuggerEventThread() {
            this.b = DebugProcessEvents.this.getVirtualMachineProxy();
        }

        public synchronized void stopListening() {
            this.a = true;
        }

        private synchronized boolean b() {
            return this.a;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String string = Thread.currentThread().getName();
            Thread.currentThread().setName("DebugProcessEvents");
            try {
                EventQueue eventQueue = this.b.eventQueue();
                while (!this.b()) {
                    try {
                        final EventSet eventSet = eventQueue.remove();
                        DebugProcessEvents.this.getManagerThread().invokeAndWait(new DebuggerCommandImpl(){

                            @Override
                            public PrioritizedTask.Priority getPriority() {
                                return PrioritizedTask.Priority.HIGH;
                            }

                            @Override
                            protected void action() throws Exception {
                                Object object22;
                                int n2 = 0;
                                for (Object object22 : eventSet) {
                                    if (DebugProcessEvents.this.myReturnValueWatcher != null && DebugProcessEvents.this.myReturnValueWatcher.isTrackingEnabled() && DebugProcessEvents.this.myReturnValueWatcher.processEvent((Event)object22)) {
                                        ++n2;
                                        continue;
                                    }
                                    Consumer object3 = DebugProcessEvents.b((Event)object22);
                                    if (object3 == null) continue;
                                    object3.consume(object22);
                                    ++n2;
                                }
                                if (n2 == eventSet.size()) {
                                    eventSet.resume();
                                    return;
                                }
                                LocatableEvent locatableEvent = DebugProcessEvents.a(eventSet);
                                if (eventSet.suspendPolicy() == 2) {
                                    for (SuspendContextImpl suspendContextImpl : DebugProcessEvents.this.getSuspendManager().getEventContexts()) {
                                        if (suspendContextImpl.getSuspendPolicy() != 2) continue;
                                        if (DebugProcessImpl.isResumeOnlyCurrentThread() && locatableEvent != null && !suspendContextImpl.isEvaluating()) {
                                            DebugProcessEvents.this.getSuspendManager().resume(suspendContextImpl);
                                            continue;
                                        }
                                        if (DebuggerSession.enableBreakpointsDuringEvaluation()) continue;
                                        DebugProcessEvents.this.a(locatableEvent);
                                        eventSet.resume();
                                        return;
                                    }
                                }
                                object22 = null;
                                if (DebugProcessImpl.isResumeOnlyCurrentThread() && locatableEvent != null) {
                                    for (SuspendContextImpl suspendContextImpl : DebugProcessEvents.this.getSuspendManager().getEventContexts()) {
                                        ThreadReferenceProxyImpl threadReferenceProxyImpl = DebugProcessEvents.this.getVirtualMachineProxy().getThreadReferenceProxy(locatableEvent.thread());
                                        if (suspendContextImpl.getSuspendPolicy() != 2 || !suspendContextImpl.isExplicitlyResumed(threadReferenceProxyImpl)) continue;
                                        suspendContextImpl.myResumedThreads.remove(threadReferenceProxyImpl);
                                        object22 = suspendContextImpl;
                                        ((SuspendContextImpl)((Object)object22)).myVotesToVote = eventSet.size();
                                        break;
                                    }
                                }
                                if (object22 == null) {
                                    object22 = DebugProcessEvents.this.getSuspendManager().pushSuspendContext(eventSet);
                                }
                                for (Event event : eventSet) {
                                    if (DebugProcessEvents.b(event) != null) {
                                        DebugProcessEvents.this.getSuspendManager().voteResume((SuspendContextImpl)((Object)object22));
                                        continue;
                                    }
                                    try {
                                        if (event instanceof VMStartEvent) {
                                            DebugProcessEvents.this.a((SuspendContextImpl)((Object)object22), (VMStartEvent)event);
                                            continue;
                                        }
                                        if (event instanceof VMDeathEvent || event instanceof VMDisconnectEvent) {
                                            DebugProcessEvents.this.a((SuspendContextImpl)((Object)object22), event);
                                            continue;
                                        }
                                        if (event instanceof ClassPrepareEvent) {
                                            DebugProcessEvents.this.a((SuspendContextImpl)((Object)object22), (ClassPrepareEvent)event);
                                            continue;
                                        }
                                        if (event instanceof StepEvent) {
                                            DebugProcessEvents.this.a((SuspendContextImpl)((Object)object22), (StepEvent)event);
                                            continue;
                                        }
                                        if (event instanceof LocatableEvent) {
                                            DebugProcessEvents.this.a((SuspendContextImpl)((Object)object22), (LocatableEvent)event);
                                            continue;
                                        }
                                        if (!(event instanceof ClassUnloadEvent)) continue;
                                        DebugProcessEvents.this.a((SuspendContextImpl)((Object)object22));
                                    }
                                    catch (VMDisconnectedException vMDisconnectedException) {
                                        A.debug((Throwable)vMDisconnectedException);
                                    }
                                    catch (InternalException internalException) {
                                        A.info((Throwable)internalException);
                                    }
                                    catch (Throwable throwable) {
                                        A.error(throwable);
                                    }
                                }
                            }
                        });
                    }
                    catch (InternalException internalException) {
                        A.debug((Throwable)internalException);
                    }
                    catch (ProcessCanceledException | VMDisconnectedException | InterruptedException throwable) {
                        throw throwable;
                    }
                    catch (Throwable throwable) {
                        A.debug(throwable);
                    }
                }
            }
            catch (VMDisconnectedException | InterruptedException exception) {
                this.a();
            }
            finally {
                Thread.interrupted();
                Thread.currentThread().setName(string);
            }
        }

        private void a() {
            DebugProcessEvents.this.getManagerThread().invokeAndWait(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    SuspendContextImpl suspendContextImpl = DebugProcessEvents.this.getSuspendManager().pushSuspendContext(0, 1);
                    DebugProcessEvents.this.a(suspendContextImpl, null);
                }
            });
        }
    }
}

