/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.Patches;
import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.ThreadBlockedMonitor;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationListener;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.intellij.debugger.engine.requests.MethodReturnValueWatcher;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.EmptyConnectorArgument;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.settings.CapturePoint;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.PrimitiveRenderer;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.ui.classFilter.DebuggerClassFilterProvider;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebugProcessImpl
extends UserDataHolderBase
implements DebugProcess {
    private static final Logger r = Logger.getInstance((String)"#com.intellij.debugger.engine.DebugProcessImpl");
    @NonNls
    private static final String o = "com.sun.jdi.SocketAttach";
    @NonNls
    private static final String x = "com.sun.jdi.SharedMemoryAttach";
    @NonNls
    private static final String n = "com.sun.jdi.SocketListen";
    @NonNls
    private static final String w = "com.sun.jdi.SharedMemoryListen";
    private final Project t;
    private final RequestManagerImpl a;
    private volatile VirtualMachineProxyImpl h = null;
    protected final EventDispatcher<DebugProcessListener> myDebugProcessDispatcher = EventDispatcher.create(DebugProcessListener.class);
    protected final EventDispatcher<EvaluationListener> myEvaluationDispatcher = EventDispatcher.create(EvaluationListener.class);
    private final List<ProcessListener> m = ContainerUtil.createLockFreeCopyOnWriteList();
    protected final AtomicReference<State> myState = new AtomicReference<State>(State.INITIAL);
    private volatile ExecutionResult i;
    private RemoteConnection f;
    private JavaDebugProcess y;
    private volatile Map<String, Connector.Argument> l;
    private final List<NodeRenderer> u = new ArrayList<NodeRenderer>();
    private final Map<Type, NodeRenderer> s = new HashMap<Type, NodeRenderer>();
    private final SuspendManagerImpl j = new SuspendManagerImpl(this);
    protected CompoundPositionManager myPositionManager = CompoundPositionManager.EMPTY;
    private final DebuggerManagerThreadImpl k;
    private final Semaphore g = new Semaphore();
    private final AtomicBoolean p = new AtomicBoolean(false);
    private final AtomicBoolean c = new AtomicBoolean(false);
    protected DebuggerSession mySession;
    @Nullable
    protected MethodReturnValueWatcher myReturnValueWatcher;
    protected final Disposable myDisposable = Disposer.newDisposable();
    private final Alarm v = new Alarm();
    private final ThreadBlockedMonitor d = new ThreadBlockedMonitor(this, this.myDisposable);
    private List<CapturePoint> q = Collections.emptyList();
    private static final int e;
    private volatile RunToCursorBreakpoint b;

    protected DebugProcessImpl(Project project2) {
        this.t = project2;
        this.k = new DebuggerManagerThreadImpl(this.myDisposable, this.t);
        this.a = new RequestManagerImpl(this);
        NodeRendererSettings.getInstance().addListener(this::e, this.myDisposable);
        this.e();
        this.myDebugProcessDispatcher.addListener((EventListener)new DebugProcessListener(){

            public void paused(SuspendContext suspendContext) {
                DebugProcessImpl.this.d.stopWatching(suspendContext.getSuspendPolicy() != 2 ? suspendContext.getThread() : null);
            }
        });
    }

    private void e() {
        this.getManagerThread().invoke(new DebuggerCommandImpl(){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.HIGH;
            }

            @Override
            protected void action() throws Exception {
                DebugProcessImpl.this.s.clear();
                DebugProcessImpl.this.u.clear();
                try {
                    NodeRendererSettings.getInstance().getAllRenderers().stream().filter(NodeRenderer::isEnabled).forEachOrdered(DebugProcessImpl.this.u::add);
                }
                finally {
                    DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.t, () -> {
                        DebuggerSession debuggerSession = DebugProcessImpl.this.mySession;
                        if (debuggerSession != null && debuggerSession.isAttached()) {
                            DebuggerAction.refreshViews(DebugProcessImpl.this.mySession.getXDebugSession());
                        }
                    });
                }
            }
        });
    }

    @Nullable
    public Pair<Method, Value> getLastExecutedMethod() {
        MethodReturnValueWatcher methodReturnValueWatcher = this.myReturnValueWatcher;
        if (methodReturnValueWatcher == null) {
            return null;
        }
        Method method = methodReturnValueWatcher.getLastExecutedMethod();
        if (method == null) {
            return null;
        }
        return Pair.create((Object)method, (Object)methodReturnValueWatcher.getLastMethodReturnValue());
    }

    public void setWatchMethodReturnValuesEnabled(boolean bl2) {
        MethodReturnValueWatcher methodReturnValueWatcher = this.myReturnValueWatcher;
        if (methodReturnValueWatcher != null) {
            methodReturnValueWatcher.setEnabled(bl2);
        }
    }

    public boolean canGetMethodReturnValue() {
        return this.myReturnValueWatcher != null;
    }

    public NodeRenderer getAutoRenderer(ValueDescriptor valueDescriptor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Type type = valueDescriptor.getType();
        if (!DebuggerManagerEx.getInstanceEx(this.getProject()).getContext().isEvaluationPossible()) {
            return DebugProcessImpl.getDefaultRenderer(type);
        }
        try {
            return this.s.computeIfAbsent(type, type2 -> this.u.stream().filter(nodeRenderer -> DebuggerUtilsImpl.suppressExceptions(() -> nodeRenderer.isApplicable(type), false, true, ClassNotPreparedException.class)).findFirst().orElseGet(() -> DebugProcessImpl.getDefaultRenderer(type)));
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            r.info((Throwable)classNotPreparedException);
            return DebugProcessImpl.getDefaultRenderer(type);
        }
    }

    @NotNull
    public static NodeRenderer getDefaultRenderer(Value value) {
        NodeRenderer nodeRenderer = DebugProcessImpl.getDefaultRenderer(value != null ? value.type() : null);
        if (nodeRenderer == null) {
            DebugProcessImpl.a(0);
        }
        return nodeRenderer;
    }

    @NotNull
    public static NodeRenderer getDefaultRenderer(Type type) {
        NodeRendererSettings nodeRendererSettings = NodeRendererSettings.getInstance();
        PrimitiveRenderer primitiveRenderer = nodeRendererSettings.getPrimitiveRenderer();
        if (primitiveRenderer.isApplicable(type)) {
            PrimitiveRenderer primitiveRenderer2 = primitiveRenderer;
            if (primitiveRenderer2 == null) {
                DebugProcessImpl.a(1);
            }
            return primitiveRenderer2;
        }
        ArrayRenderer arrayRenderer = nodeRendererSettings.getArrayRenderer();
        if (arrayRenderer.isApplicable(type)) {
            ArrayRenderer arrayRenderer2 = arrayRenderer;
            if (arrayRenderer2 == null) {
                DebugProcessImpl.a(2);
            }
            return arrayRenderer2;
        }
        ClassRenderer classRenderer = nodeRendererSettings.getClassRenderer();
        r.assertTrue(classRenderer.isApplicable(type), (Object)type.name());
        ClassRenderer classRenderer2 = classRenderer;
        if (classRenderer2 == null) {
            DebugProcessImpl.a(3);
        }
        return classRenderer2;
    }

    protected void commitVM(VirtualMachine virtualMachine) {
        if (!this.isInInitialState()) {
            r.error("State is invalid " + (Object)((Object)this.myState.get()));
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myPositionManager = new CompoundPositionManager(new PositionManagerImpl(this));
        r.debug("*******************VM attached******************");
        this.a(virtualMachine);
        this.h = new VirtualMachineProxyImpl(this, virtualMachine);
        virtualMachine.setDebugTraceMode(e);
    }

    private void c() {
        Map<String, Connector.Argument> map = this.l;
        try {
            if (map == null) {
                return;
            }
            if (this.f.isServerMode()) {
                ((ListeningConnector)DebugProcessImpl.b(n)).stopListening(map);
            }
        }
        catch (IllegalConnectorArgumentsException | IOException exception) {
            r.debug((Throwable)exception);
        }
        catch (ExecutionException executionException) {
            r.error((Throwable)executionException);
        }
    }

    public void printToConsole(String string) {
        this.i.getProcessHandler().notifyTextAvailable(string, ProcessOutputTypes.SYSTEM);
    }

    public ProcessHandler getProcessHandler() {
        return this.i != null ? this.i.getProcessHandler() : null;
    }

    protected void doStep(SuspendContextImpl suspendContextImpl, ThreadReferenceProxyImpl threadReferenceProxyImpl, int n2, int n3, RequestHint requestHint) {
        if (threadReferenceProxyImpl == null) {
            return;
        }
        try {
            ThreadReference threadReference = threadReferenceProxyImpl.getThreadReference();
            if (r.isDebugEnabled()) {
                r.debug("DO_STEP: creating step request for " + threadReference);
            }
            this.deleteStepRequests(threadReference);
            EventRequestManager eventRequestManager = this.getVirtualMachineProxy().eventRequestManager();
            StepRequest stepRequest = eventRequestManager.createStepRequest(threadReference, n2, n3);
            if (requestHint == null || !requestHint.isIgnoreFilters()) {
                this.checkPositionNotFiltered(threadReferenceProxyImpl, (Consumer<List<ClassFilter>>)((Consumer)list2 -> list2.forEach(classFilter -> stepRequest.addClassExclusionFilter(classFilter.getPattern()))));
            }
            stepRequest.setSuspendPolicy(suspendContextImpl.getSuspendPolicy() == 1 ? 1 : 2);
            stepRequest.addCountFilter(1);
            if (requestHint != null) {
                stepRequest.putProperty("hint", requestHint);
            }
            stepRequest.enable();
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
    }

    public void checkPositionNotFiltered(ThreadReferenceProxyImpl threadReferenceProxyImpl, Consumer<List<ClassFilter>> consumer) {
        String string;
        List<ClassFilter> list2 = DebugProcessImpl.d();
        if (!(list2.isEmpty() || (string = DebugProcessImpl.getCurrentClassName(threadReferenceProxyImpl)) != null && DebuggerUtilsEx.isFiltered(string, list2))) {
            consumer.consume(list2);
        }
    }

    @NotNull
    private static List<ClassFilter> d() {
        DebuggerSettings debuggerSettings = DebuggerSettings.getInstance();
        StreamEx streamEx = StreamEx.of((Object[])Extensions.getExtensions((ExtensionPointName)DebuggerClassFilterProvider.EP_NAME)).flatCollection(DebuggerClassFilterProvider::getFilters);
        if (debuggerSettings.TRACING_FILTERS_ENABLED) {
            streamEx = streamEx.prepend((Object[])debuggerSettings.getSteppingFilters());
        }
        List list2 = ((StreamEx)streamEx.filter(ClassFilter::isEnabled)).toList();
        if (list2 == null) {
            DebugProcessImpl.a(4);
        }
        return list2;
    }

    void deleteStepRequests(@Nullable ThreadReference threadReference) {
        EventRequestManager eventRequestManager = this.getVirtualMachineProxy().eventRequestManager();
        List<StepRequest> list2 = eventRequestManager.stepRequests();
        if (!list2.isEmpty()) {
            ArrayList<StepRequest> arrayList = new ArrayList<StepRequest>(list2.size());
            for (StepRequest stepRequest : list2) {
                ThreadReference threadReference2 = stepRequest.thread();
                try {
                    if (threadReference2.status() == -1 || threadReference != null && !threadReference.equals(threadReference2)) continue;
                    arrayList.add(stepRequest);
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    r.info((Throwable)illegalThreadStateException);
                }
                catch (ObjectCollectedException objectCollectedException) {}
            }
            eventRequestManager.deleteEventRequests(arrayList);
        }
    }

    @Nullable
    static String getCurrentClassName(ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        try {
            StackFrameProxyImpl stackFrameProxyImpl;
            if (threadReferenceProxyImpl != null && threadReferenceProxyImpl.frameCount() > 0 && (stackFrameProxyImpl = threadReferenceProxyImpl.frame(0)) != null) {
                ReferenceType referenceType;
                Location location = stackFrameProxyImpl.location();
                ReferenceType referenceType2 = referenceType = location == null ? null : location.declaringType();
                if (referenceType != null) {
                    return referenceType.name();
                }
            }
        }
        catch (EvaluateException evaluateException) {
            // empty catch block
        }
        return null;
    }

    private VirtualMachine a() throws ExecutionException {
        Object object;
        Connector.Argument argument;
        if (this.l != null) {
            throw new IOException(DebuggerBundle.message((String)"error.debugger.already.listening", (Object[])new Object[0]));
        }
        String string = this.f.getAddress();
        if (this.f.isServerMode()) {
            Connector.Argument argument2;
            Connector.Argument argument3;
            ListeningConnector listeningConnector = (ListeningConnector)DebugProcessImpl.findConnector(this.f.isUseSockets(), true);
            this.l = listeningConnector.defaultArguments();
            if (this.l == null) {
                throw new CantRunException(DebuggerBundle.message((String)"error.no.debug.listen.port", (Object[])new Object[0]));
            }
            if (string == null) {
                throw new CantRunException(DebuggerBundle.message((String)"error.no.debug.listen.port", (Object[])new Object[0]));
            }
            Connector.Argument argument4 = argument3 = this.f.isUseSockets() ? this.l.get("port") : this.l.get("name");
            if (argument3 != null) {
                argument3.setValue(string);
                if (string.length() == 0 || string.equals("0")) {
                    argument2 = new EmptyConnectorArgument("argForUniqueness");
                    this.l.put(((EmptyConnectorArgument)argument2).name(), argument2);
                }
            }
            if ((argument2 = this.l.get("timeout")) != null) {
                argument2.setValue("0");
            }
            try {
                String string2 = listeningConnector.startListening(this.l);
                String string3 = StringUtil.substringAfterLast((String)string2, (String)":");
                if (string3 != null) {
                    string2 = string3;
                }
                this.f.setAddress(string2);
                ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).connectorIsReady();
                VirtualMachine virtualMachine = listeningConnector.accept(this.l);
                return virtualMachine;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CantRunException(illegalArgumentException.getLocalizedMessage());
            }
            finally {
                if (this.l != null) {
                    try {
                        listeningConnector.stopListening(this.l);
                    }
                    catch (IllegalConnectorArgumentsException | IllegalArgumentException exception) {}
                }
            }
        }
        AttachingConnector attachingConnector = (AttachingConnector)DebugProcessImpl.findConnector(this.f.isUseSockets(), false);
        this.l = attachingConnector.defaultArguments();
        if (this.f.isUseSockets()) {
            argument = this.l.get("hostname");
            if (argument != null && this.f.getHostName() != null) {
                argument.setValue(this.f.getHostName());
            }
            if (string == null) {
                throw new CantRunException(DebuggerBundle.message((String)"error.no.debug.attach.port", (Object[])new Object[0]));
            }
            object = this.l.get("port");
            if (object != null) {
                object.setValue(string);
            }
        } else {
            if (string == null) {
                throw new CantRunException(DebuggerBundle.message((String)"error.no.shmem.address", (Object[])new Object[0]));
            }
            argument = this.l.get("name");
            if (argument != null) {
                argument.setValue(string);
            }
        }
        argument = this.l.get("timeout");
        if (argument != null) {
            argument.setValue("0");
        }
        ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).connectorIsReady();
        try {
            object = attachingConnector.attach(this.l);
            return object;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                throw new CantRunException(illegalArgumentException.getLocalizedMessage());
            }
            catch (IOException iOException) {
                throw new ExecutionException(DebugProcessImpl.processIOException(iOException, DebuggerBundle.getAddressDisplayName((RemoteConnection)this.f)), (Throwable)iOException);
            }
            catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
                throw new ExecutionException(DebugProcessImpl.processError(illegalConnectorArgumentsException), (Throwable)illegalConnectorArgumentsException);
            }
        }
        finally {
            this.l = null;
        }
    }

    public void showStatusText(String string) {
        this.v.cancelAllRequests();
        this.v.addRequest(() -> {
            if (!this.t.isDisposed()) {
                StatusBarUtil.setStatusBarInfo((Project)this.t, (String)string);
            }
        }, 50);
    }

    @NotNull
    public static Connector findConnector(boolean bl2, boolean bl3) throws ExecutionException {
        if (bl3) {
            Connector connector = DebugProcessImpl.b(bl2 ? n : w);
            if (connector == null) {
                DebugProcessImpl.a(5);
            }
            return connector;
        }
        Connector connector = DebugProcessImpl.b(bl2 ? o : x);
        if (connector == null) {
            DebugProcessImpl.a(6);
        }
        return connector;
    }

    @NotNull
    private static Connector b(String string) throws ExecutionException {
        VirtualMachineManager virtualMachineManager;
        try {
            virtualMachineManager = Bootstrap.virtualMachineManager();
        }
        catch (Error error) {
            throw new ExecutionException(DebuggerBundle.message((String)"debugger.jdi.bootstrap.error", (Object[])new Object[]{error.getClass().getName() + " : " + error.getLocalizedMessage()}));
        }
        Connector connector2 = StreamEx.of(virtualMachineManager.allConnectors()).findFirst(connector -> string.equals(connector.name())).orElse(null);
        if (connector2 == null) {
            throw new CantRunException(DebuggerBundle.message((String)"error.debug.connector.not.found", (Object[])new Object[]{string}));
        }
        Connector connector3 = connector2;
        if (connector3 == null) {
            DebugProcessImpl.a(7);
        }
        return connector3;
    }

    private void a(VirtualMachine virtualMachine) {
        Sdk sdk3;
        String string = virtualMachine.version();
        if ("1.4.0".equals(string)) {
            DebuggerInvocationUtil.swingInvokeLater(this.t, () -> Messages.showMessageDialog((Project)this.t, (String)DebuggerBundle.message((String)"warning.jdk140.unstable", (Object[])new Object[0]), (String)DebuggerBundle.message((String)"title.jdk140.unstable", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()));
        }
        if (this.getSession().getAlternativeJre() == null && ((sdk3 = this.getSession().getRunJre()) == null || sdk3.getSdkType() instanceof JavaSdkType) && !DebugProcessImpl.a(sdk3, string)) {
            Arrays.stream(ProjectJdkTable.getInstance().getAllJdks()).filter(sdk -> DebugProcessImpl.a(sdk, string)).findFirst().ifPresent(sdk2 -> {
                XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(DebuggerBundle.message((String)"message.remote.jre.version.mismatch", (Object[])new Object[]{string, sdk3 != null ? sdk3.getVersionString() : "unknown", sdk2.getName()}), MessageType.INFO).notify(this.t);
                this.getSession().setAlternativeJre((Sdk)sdk2);
            });
        }
    }

    private static boolean a(@Nullable Sdk sdk, String string) {
        if (sdk != null && sdk.getSdkType() instanceof JavaSdkType) {
            String string2 = sdk.getVersionString();
            return string2 != null && string2.contains(string);
        }
        return false;
    }

    public void addEvaluationListener(EvaluationListener evaluationListener) {
        this.myEvaluationDispatcher.addListener((EventListener)evaluationListener);
    }

    public void removeEvaluationListener(EvaluationListener evaluationListener) {
        this.myEvaluationDispatcher.removeListener((EventListener)evaluationListener);
    }

    public void addDebugProcessListener(DebugProcessListener debugProcessListener) {
        this.myDebugProcessDispatcher.addListener((EventListener)debugProcessListener);
    }

    public void removeDebugProcessListener(DebugProcessListener debugProcessListener) {
        this.myDebugProcessDispatcher.removeListener((EventListener)debugProcessListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcessListener(ProcessListener processListener) {
        List<ProcessListener> list2 = this.m;
        synchronized (list2) {
            if (this.getProcessHandler() != null) {
                this.getProcessHandler().addProcessListener(processListener);
            } else {
                this.m.add(processListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcessListener(ProcessListener processListener) {
        List<ProcessListener> list2 = this.m;
        synchronized (list2) {
            if (this.getProcessHandler() != null) {
                this.getProcessHandler().removeProcessListener(processListener);
            } else {
                this.m.remove(processListener);
            }
        }
    }

    public RemoteConnection getConnection() {
        return this.f;
    }

    public ExecutionResult getExecutionResult() {
        return this.i;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.t;
        if (project2 == null) {
            DebugProcessImpl.a(8);
        }
        return project2;
    }

    public boolean canRedefineClasses() {
        VirtualMachineProxyImpl virtualMachineProxyImpl = this.h;
        return virtualMachineProxyImpl != null && virtualMachineProxyImpl.canRedefineClasses();
    }

    public boolean canWatchFieldModification() {
        VirtualMachineProxyImpl virtualMachineProxyImpl = this.h;
        return virtualMachineProxyImpl != null && virtualMachineProxyImpl.canWatchFieldModification();
    }

    public boolean isInInitialState() {
        return this.myState.get() == State.INITIAL;
    }

    public boolean isAttached() {
        return this.myState.get() == State.ATTACHED;
    }

    public boolean isDetached() {
        return this.myState.get() == State.DETACHED;
    }

    public boolean isDetaching() {
        return this.myState.get() == State.DETACHING;
    }

    public RequestManagerImpl getRequestsManager() {
        return this.a;
    }

    @NotNull
    public VirtualMachineProxyImpl getVirtualMachineProxy() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        VirtualMachineProxyImpl virtualMachineProxyImpl = this.h;
        if (virtualMachineProxyImpl == null) {
            if (this.isInInitialState()) {
                throw new IllegalStateException("Virtual machine is not initialized yet");
            }
            throw new VMDisconnectedException();
        }
        VirtualMachineProxyImpl virtualMachineProxyImpl2 = virtualMachineProxyImpl;
        if (virtualMachineProxyImpl2 == null) {
            DebugProcessImpl.a(9);
        }
        return virtualMachineProxyImpl2;
    }

    public void appendPositionManager(PositionManager positionManager) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myPositionManager.appendPositionManager(positionManager);
    }

    public void setRunToCursorBreakpoint(@Nullable RunToCursorBreakpoint runToCursorBreakpoint) {
        this.b = runToCursorBreakpoint;
    }

    public void cancelRunToCursorBreakpoint() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        RunToCursorBreakpoint runToCursorBreakpoint = this.b;
        if (runToCursorBreakpoint != null) {
            this.setRunToCursorBreakpoint(null);
            this.getRequestsManager().deleteRequest(runToCursorBreakpoint);
            if (runToCursorBreakpoint.isRestoreBreakpoints()) {
                DebuggerManagerEx.getInstanceEx(this.getProject()).getBreakpointManager().enableBreakpoints(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeProcess(boolean bl2) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.myState.compareAndSet(State.INITIAL, State.DETACHING) || this.myState.compareAndSet(State.ATTACHED, State.DETACHING)) {
            try {
                this.getManagerThread().close();
            }
            finally {
                VirtualMachineProxyImpl virtualMachineProxyImpl = this.h;
                this.h = null;
                this.myPositionManager = CompoundPositionManager.EMPTY;
                this.myReturnValueWatcher = null;
                this.s.clear();
                this.u.clear();
                DebuggerUtils.cleanupAfterProcessFinish((DebugProcess)this);
                this.myState.compareAndSet(State.DETACHING, State.DETACHED);
                try {
                    ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).processDetached((DebugProcess)this, bl2);
                }
                finally {
                    if (virtualMachineProxyImpl != null) {
                        try {
                            virtualMachineProxyImpl.dispose();
                        }
                        catch (Throwable throwable) {}
                    }
                    this.g.up();
                }
            }
        }
    }

    private static String c(String string) {
        int n2 = 90;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i2 = 0; i2 < string.length(); i2 += 90) {
            stringBuilder.append(string.substring(i2, Math.min(i2 + 90, string.length()))).append('\n');
        }
        return stringBuilder.toString();
    }

    public static String processError(Exception exception) {
        String string;
        if (exception instanceof VMStartException) {
            VMStartException vMStartException = (VMStartException)exception;
            string = vMStartException.getLocalizedMessage();
        } else if (exception instanceof IllegalConnectorArgumentsException) {
            IllegalConnectorArgumentsException illegalConnectorArgumentsException = (IllegalConnectorArgumentsException)exception;
            List<String> list2 = illegalConnectorArgumentsException.argumentNames();
            string = DebugProcessImpl.c(DebuggerBundle.message((String)"error.invalid.argument", (Object[])new Object[]{list2.size()}) + ": " + illegalConnectorArgumentsException.getLocalizedMessage()) + list2;
            r.debug((Throwable)illegalConnectorArgumentsException);
        } else if (exception instanceof CantRunException) {
            string = exception.getLocalizedMessage();
        } else if (exception instanceof VMDisconnectedException) {
            string = DebuggerBundle.message((String)"error.vm.disconnected", (Object[])new Object[0]);
        } else if (exception instanceof IOException) {
            string = DebugProcessImpl.processIOException((IOException)exception, null);
        } else if (exception instanceof ExecutionException) {
            string = exception.getLocalizedMessage();
        } else {
            string = DebuggerBundle.message((String)"error.exception.while.connecting", (Object[])new Object[]{exception.getClass().getName(), exception.getLocalizedMessage()});
            r.debug((Throwable)exception);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String processIOException(@NotNull IOException iOException, @Nullable String string) {
        String string2;
        if (iOException == null) {
            DebugProcessImpl.a(10);
        }
        if (iOException instanceof UnknownHostException) {
            String string3 = DebuggerBundle.message((String)"error.unknown.host", (Object[])new Object[0]) + (string != null ? " (" + string + ")" : "") + ":\n" + iOException.getLocalizedMessage();
            if (string3 == null) {
                DebugProcessImpl.a(11);
            }
            return string3;
        }
        StringBuilder stringBuilder = StringBuilderSpinAllocator.alloc();
        try {
            stringBuilder.append(DebuggerBundle.message((String)"error.cannot.open.debugger.port", (Object[])new Object[0]));
            if (string != null) {
                stringBuilder.append(" (").append(string).append(")");
            }
            stringBuilder.append(": ");
            stringBuilder.append(iOException.getClass().getName()).append(" ");
            String string4 = iOException.getLocalizedMessage();
            if (!StringUtil.isEmpty((String)string4)) {
                stringBuilder.append('\"');
                stringBuilder.append(string4);
                stringBuilder.append('\"');
            }
            r.debug((Throwable)iOException);
            string2 = stringBuilder.toString();
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)stringBuilder);
        }
        String string5 = string2;
        if (string5 == null) {
            DebugProcessImpl.a(12);
        }
        return string5;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDisposable);
        this.a.setFilterThread(null);
    }

    public DebuggerManagerThreadImpl getManagerThread() {
        return this.k;
    }

    private static int a(SuspendContext suspendContext) {
        if (suspendContext.getSuspendPolicy() == 1 || DebugProcessImpl.isResumeOnlyCurrentThread()) {
            return 1;
        }
        return 0;
    }

    public void waitFor() {
        r.assertTrue(!DebuggerManagerThreadImpl.isManagerThread());
        this.g.waitFor();
    }

    public void waitFor(long l2) {
        r.assertTrue(!DebuggerManagerThreadImpl.isManagerThread());
        this.g.waitFor(l2);
    }

    public Value invokeMethod(@NotNull EvaluationContext evaluationContext, @NotNull ObjectReference objectReference, @NotNull Method method, @NotNull List<? extends Value> list2) throws EvaluateException {
        if (evaluationContext == null) {
            DebugProcessImpl.a(13);
        }
        if (objectReference == null) {
            DebugProcessImpl.a(14);
        }
        if (method == null) {
            DebugProcessImpl.a(15);
        }
        if (list2 == null) {
            DebugProcessImpl.a(16);
        }
        return this.invokeInstanceMethod(evaluationContext, objectReference, method, list2, 0);
    }

    public Value invokeInstanceMethod(@NotNull EvaluationContext evaluationContext, final @NotNull ObjectReference objectReference, @NotNull Method method, @NotNull List<? extends Value> list2, final int n2) throws EvaluateException {
        if (evaluationContext == null) {
            DebugProcessImpl.a(17);
        }
        if (objectReference == null) {
            DebugProcessImpl.a(18);
        }
        if (method == null) {
            DebugProcessImpl.a(19);
        }
        if (list2 == null) {
            DebugProcessImpl.a(20);
        }
        final ThreadReference threadReference = DebugProcessImpl.a(evaluationContext);
        return new InvokeCommand<Value>(method, list2){

            @Override
            protected Value invokeMethod(int n22, Method method, List<? extends Value> list2) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
                if (r.isDebugEnabled()) {
                    r.debug("Invoking " + objectReference.type().name() + "." + method.name());
                }
                return objectReference.invokeMethod(threadReference, method, list2, n22 | n2);
            }
        }.start((EvaluationContextImpl)evaluationContext, false);
    }

    private static ThreadReference a(EvaluationContext evaluationContext) throws EvaluateException {
        ThreadReferenceProxy threadReferenceProxy = evaluationContext.getSuspendContext().getThread();
        if (threadReferenceProxy == null) {
            throw EvaluateExceptionUtil.NULL_STACK_FRAME;
        }
        return threadReferenceProxy.getThreadReference();
    }

    public Value invokeMethod(EvaluationContext evaluationContext, ClassType classType, Method method, List<? extends Value> list2) throws EvaluateException {
        return this.invokeMethod(evaluationContext, classType, method, list2, 0, false);
    }

    public Value invokeMethod(@NotNull EvaluationContext evaluationContext, @NotNull ClassType classType, @NotNull Method method, @NotNull List<? extends Value> list2, boolean bl2) throws EvaluateException {
        if (evaluationContext == null) {
            DebugProcessImpl.a(21);
        }
        if (classType == null) {
            DebugProcessImpl.a(22);
        }
        if (method == null) {
            DebugProcessImpl.a(23);
        }
        if (list2 == null) {
            DebugProcessImpl.a(24);
        }
        return this.invokeMethod(evaluationContext, classType, method, list2, 0, bl2);
    }

    public Value invokeMethod(@NotNull EvaluationContext evaluationContext, final @NotNull ClassType classType, @NotNull Method method, @NotNull List<? extends Value> list2, final int n2, boolean bl2) throws EvaluateException {
        if (evaluationContext == null) {
            DebugProcessImpl.a(25);
        }
        if (classType == null) {
            DebugProcessImpl.a(26);
        }
        if (method == null) {
            DebugProcessImpl.a(27);
        }
        if (list2 == null) {
            DebugProcessImpl.a(28);
        }
        final ThreadReference threadReference = DebugProcessImpl.a(evaluationContext);
        return new InvokeCommand<Value>(method, list2){

            @Override
            protected Value invokeMethod(int n22, Method method, List<? extends Value> list2) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
                if (r.isDebugEnabled()) {
                    r.debug("Invoking " + classType.name() + "." + method.name());
                }
                return classType.invokeMethod(threadReference, method, list2, n22 | n2);
            }
        }.start((EvaluationContextImpl)evaluationContext, bl2);
    }

    public Value invokeMethod(EvaluationContext evaluationContext, final InterfaceType interfaceType, Method method, List<? extends Value> list2) throws EvaluateException {
        final ThreadReference threadReference = DebugProcessImpl.a(evaluationContext);
        return new InvokeCommand<Value>(method, list2){

            @Override
            protected Value invokeMethod(int n2, Method method, List<? extends Value> list2) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
                if (r.isDebugEnabled()) {
                    r.debug("Invoking " + interfaceType.name() + "." + method.name());
                }
                try {
                    return interfaceType.invokeMethod(threadReference, method, list2, n2);
                }
                catch (LinkageError linkageError) {
                    throw new IllegalStateException("Interface method invocation is not supported in JVM " + SystemInfo.JAVA_VERSION + ". Use JVM 1.8.0_45 or higher to run " + ApplicationNamesInfo.getInstance().getFullProductName());
                }
            }
        }.start((EvaluationContextImpl)evaluationContext, false);
    }

    public ArrayReference newInstance(ArrayType arrayType, int n2) throws EvaluateException {
        try {
            return arrayType.newInstance(n2);
        }
        catch (Exception exception) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)exception);
        }
    }

    public ObjectReference newInstance(@NotNull EvaluationContext evaluationContext, final @NotNull ClassType classType, @NotNull Method method, @NotNull List<? extends Value> list2) throws EvaluateException {
        if (evaluationContext == null) {
            DebugProcessImpl.a(29);
        }
        if (classType == null) {
            DebugProcessImpl.a(30);
        }
        if (method == null) {
            DebugProcessImpl.a(31);
        }
        if (list2 == null) {
            DebugProcessImpl.a(32);
        }
        final ThreadReference threadReference = DebugProcessImpl.a(evaluationContext);
        InvokeCommand<ObjectReference> invokeCommand = new InvokeCommand<ObjectReference>(method, list2){

            @Override
            protected ObjectReference invokeMethod(int n2, Method method, List<? extends Value> list2) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
                if (r.isDebugEnabled()) {
                    r.debug("New instance " + classType.name() + "." + method.name());
                }
                return classType.newInstance(threadReference, method, list2, n2);
            }
        };
        return (ObjectReference)invokeCommand.start((EvaluationContextImpl)evaluationContext, false);
    }

    public void clearCashes(int n2) {
        if (!this.isAttached()) {
            return;
        }
        switch (n2) {
            case 2: {
                this.getVirtualMachineProxy().clearCaches();
                break;
            }
            case 1: {
                this.getVirtualMachineProxy().clearCaches();
            }
        }
    }

    protected void beforeSuspend(SuspendContextImpl suspendContextImpl) {
        this.clearCashes(suspendContextImpl.getSuspendPolicy());
    }

    private void a(SuspendContextImpl suspendContextImpl, Method method, boolean bl2) {
        if (r.isDebugEnabled()) {
            r.debug("before invocation in  thread " + suspendContextImpl.getThread().name() + " method " + (method == null ? "null" : method.name()));
        }
        if (!bl2) {
            if (method != null) {
                this.showStatusText(DebuggerBundle.message((String)"progress.evaluating", (Object[])new Object[]{DebuggerUtilsEx.methodName(method)}));
            } else {
                this.showStatusText(DebuggerBundle.message((String)"title.evaluating", (Object[])new Object[0]));
            }
        }
    }

    private void a(SuspendContextImpl suspendContextImpl, boolean bl2) {
        if (r.isDebugEnabled()) {
            r.debug("after invocation in  thread " + suspendContextImpl.getThread().name());
        }
        if (!bl2) {
            this.showStatusText("");
        }
    }

    public ReferenceType findClass(EvaluationContext evaluationContext, String string, ClassLoaderReference classLoaderReference) throws EvaluateException {
        try {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            ReferenceType referenceType = null;
            for (ReferenceType referenceType2 : this.getVirtualMachineProxy().classesByName(string)) {
                if (!referenceType2.isPrepared() || !DebugProcessImpl.a(classLoaderReference, referenceType2)) continue;
                referenceType = referenceType2;
                break;
            }
            EvaluationContextImpl evaluationContextImpl = (EvaluationContextImpl)evaluationContext;
            if (referenceType == null && evaluationContextImpl.isAutoLoadClasses()) {
                return this.loadClass(evaluationContextImpl, string, classLoaderReference);
            }
            return referenceType;
        }
        catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InvocationException exception) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)exception);
        }
    }

    private static boolean a(ClassLoaderReference classLoaderReference, ReferenceType referenceType) {
        return classLoaderReference == null || classLoaderReference.equals(referenceType.classLoader()) || classLoaderReference.visibleClasses().contains(referenceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String d(String string) {
        if (string.indexOf(91) == -1) {
            return string;
        }
        int n2 = 0;
        while (string.endsWith("[]")) {
            string = string.substring(0, string.length() - 2);
            ++n2;
        }
        StringBuilder stringBuilder = StringBuilderSpinAllocator.alloc();
        try {
            StringUtil.repeatSymbol((Appendable)stringBuilder, (char)'[', (int)n2);
            String string2 = JVMNameUtil.getPrimitiveSignature(string);
            if (string2 != null) {
                stringBuilder.append(string2);
            } else {
                stringBuilder.append('L');
                stringBuilder.append(string);
                stringBuilder.append(';');
            }
            String string3 = stringBuilder.toString();
            return string3;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)stringBuilder);
        }
    }

    public ReferenceType loadClass(EvaluationContextImpl evaluationContextImpl, String string, ClassLoaderReference classLoaderReference) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        string = DebugProcessImpl.d(string);
        ReferenceType referenceType = null;
        VirtualMachineProxyImpl virtualMachineProxyImpl = this.getVirtualMachineProxy();
        ClassType classType = (ClassType)ContainerUtil.getFirstItem(virtualMachineProxyImpl.classesByName("java.lang.Class"));
        if (classType != null) {
            Method method;
            ArrayList<Value> arrayList = new ArrayList<Value>();
            arrayList.add(virtualMachineProxyImpl.mirrorOf(string));
            if (classLoaderReference != null) {
                method = DebuggerUtils.findMethod((ReferenceType)classType, (String)"forName", (String)"(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;");
                arrayList.add(virtualMachineProxyImpl.mirrorOf(true));
                arrayList.add(classLoaderReference);
            } else {
                method = DebuggerUtils.findMethod((ReferenceType)classType, (String)"forName", (String)"(Ljava/lang/String;)Ljava/lang/Class;");
            }
            Value value = this.invokeMethod((EvaluationContext)evaluationContextImpl, classType, method, arrayList);
            if (value instanceof ClassObjectReference) {
                referenceType = ((ClassObjectReference)value).reflectedType();
            }
        }
        return referenceType;
    }

    public void logThreads() {
        if (r.isDebugEnabled()) {
            try {
                Collection<ThreadReferenceProxyImpl> collection = this.getVirtualMachineProxy().allThreads();
                for (ThreadReferenceProxyImpl threadReferenceProxyImpl : collection) {
                    r.debug("Thread name=" + threadReferenceProxyImpl.name() + " suspendCount()=" + threadReferenceProxyImpl.getSuspendCount());
                }
            }
            catch (Exception exception) {
                r.debug((Throwable)exception);
            }
        }
    }

    public void onHotSwapFinished() {
        this.getPositionManager().clearCache();
        StackCapturingLineBreakpoint.clearCaches(this);
    }

    @NotNull
    public SuspendManager getSuspendManager() {
        SuspendManagerImpl suspendManagerImpl = this.j;
        if (suspendManagerImpl == null) {
            DebugProcessImpl.a(33);
        }
        return suspendManagerImpl;
    }

    @NotNull
    public CompoundPositionManager getPositionManager() {
        CompoundPositionManager compoundPositionManager = this.myPositionManager;
        if (compoundPositionManager == null) {
            DebugProcessImpl.a(34);
        }
        return compoundPositionManager;
    }

    public void stop(boolean bl2) {
        this.c.set(true);
        this.c();
        this.getManagerThread().terminateAndInvoke(this.createStopCommand(bl2), ApplicationManager.getApplication().isUnitTestMode() ? 0 : 3000);
    }

    @NotNull
    public StopCommand createStopCommand(boolean bl2) {
        StopCommand stopCommand = new StopCommand(bl2);
        if (stopCommand == null) {
            DebugProcessImpl.a(35);
        }
        return stopCommand;
    }

    @NotNull
    public GlobalSearchScope getSearchScope() {
        r.assertTrue(this.mySession != null, (Object)"Accessing debug session before its initialization");
        GlobalSearchScope globalSearchScope = this.mySession.getSearchScope();
        if (globalSearchScope == null) {
            DebugProcessImpl.a(36);
        }
        return globalSearchScope;
    }

    public void reattach(final DebugEnvironment debugEnvironment) throws ExecutionException {
        if (!this.c.get()) {
            this.getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    DebugProcessImpl.this.closeProcess(false);
                    this.a();
                }

                @Override
                protected void commandCancelled() {
                    this.a();
                }

                private void a() {
                    DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.t, () -> {
                        ((XDebugSessionImpl)DebugProcessImpl.this.getXdebugProcess().getSession()).reset();
                        DebugProcessImpl.this.myState.set(State.INITIAL);
                        DebugProcessImpl.this.f = debugEnvironment.getRemoteConnection();
                        DebugProcessImpl.this.getManagerThread().restartIfNeeded();
                        DebugProcessImpl.this.a(debugEnvironment);
                    });
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ExecutionResult attachVirtualMachine(DebugEnvironment debugEnvironment, DebuggerSession debuggerSession) throws ExecutionException {
        ExecutionResult executionResult;
        this.mySession = debuggerSession;
        this.g.down();
        ApplicationManager.getApplication().assertIsDispatchThread();
        r.assertTrue(this.isInInitialState());
        this.f = debugEnvironment.getRemoteConnection();
        this.a(debugEnvironment);
        try {
            List<ProcessListener> list2 = this.m;
            synchronized (list2) {
                this.i = executionResult = debugEnvironment.createExecutionResult();
                if (executionResult == null) {
                    this.f();
                    return null;
                }
                for (ProcessListener processListener : this.m) {
                    executionResult.getProcessHandler().addProcessListener(processListener);
                }
                this.m.clear();
            }
        }
        catch (ExecutionException executionException) {
            this.f();
            throw executionException;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return executionResult;
        }
        return executionResult;
    }

    private void f() {
        if (this.p.compareAndSet(false, true)) {
            this.stop(false);
        }
    }

    private void a(DebugEnvironment debugEnvironment) {
        final String string = debugEnvironment.getSessionName();
        final long l2 = debugEnvironment.getPollTimeout();
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.myDebugProcessDispatcher.addListener((EventListener)new DebugProcessListener(){

            public void connectorIsReady() {
                atomicBoolean.set(true);
                semaphore.up();
                DebugProcessImpl.this.myDebugProcessDispatcher.removeListener((EventListener)((Object)this));
            }
        });
        DebuggerManagerEx.getInstanceEx(this.t).getBreakpointManager().reloadBreakpoints();
        this.getManagerThread().schedule(new DebuggerCommandImpl(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void action() {
                VirtualMachine virtualMachine = null;
                try {
                    long l22 = System.currentTimeMillis();
                    while (true) {
                        try {
                            virtualMachine = DebugProcessImpl.this.a();
                        }
                        catch (ExecutionException executionException) {
                            Object object;
                            if (l2 > 0L && !DebugProcessImpl.this.f.isServerMode() && executionException.getCause() instanceof IOException) {
                                object = this;
                                synchronized (object) {
                                    try {
                                        this.wait(500L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        break;
                                    }
                                }
                            }
                            object = DebugProcessImpl.this.getProcessHandler();
                            boolean bl2 = object != null && (object.isProcessTerminating() || object.isProcessTerminated());
                            DebugProcessImpl.this.f();
                            DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.t, () -> {
                                if (DebugProcessImpl.this.i != null && !bl2 || !atomicBoolean.get()) {
                                    ExecutionUtil.handleExecutionError((Project)DebugProcessImpl.this.t, (String)ToolWindowId.DEBUG, (String)string, (Throwable)executionException);
                                }
                            });
                            break;
                            if (System.currentTimeMillis() - l22 < l2) continue;
                        }
                        break;
                    }
                }
                finally {
                    semaphore.up();
                }
                if (virtualMachine != null) {
                    final VirtualMachine virtualMachine2 = virtualMachine;
                    DebugProcessImpl.this.a(() -> DebugProcessImpl.this.getManagerThread().schedule(new DebuggerCommandImpl(){

                        @Override
                        protected void action() throws Exception {
                            try {
                                DebugProcessImpl.this.commitVM(virtualMachine2);
                            }
                            catch (VMDisconnectedException vMDisconnectedException) {
                                DebugProcessImpl.this.f();
                            }
                        }
                    }));
                } else {
                    DebugProcessImpl.this.f();
                }
            }

            @Override
            protected void commandCancelled() {
                try {
                    super.commandCancelled();
                }
                finally {
                    semaphore.up();
                }
            }
        });
        semaphore.waitFor();
    }

    private void a(final Runnable runnable) {
        class MyProcessAdapter
        extends ProcessAdapter {
            private boolean a = false;

            MyProcessAdapter() {
            }

            public synchronized void run() {
                if (!this.a) {
                    this.a = true;
                    runnable.run();
                }
                DebugProcessImpl.this.removeProcessListener((ProcessListener)this);
            }

            public void startNotified(@NotNull ProcessEvent processEvent) {
                if (processEvent == null) {
                    MyProcessAdapter.a(0);
                }
                this.run();
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/engine/DebugProcessImpl$1MyProcessAdapter", "startNotified"));
            }
        }
        MyProcessAdapter myProcessAdapter = new MyProcessAdapter();
        this.addProcessListener((ProcessListener)myProcessAdapter);
        if (this.i != null && this.i.getProcessHandler().isStartNotified()) {
            myProcessAdapter.run();
        }
    }

    public boolean isPausePressed() {
        VirtualMachineProxyImpl virtualMachineProxyImpl = this.h;
        return virtualMachineProxyImpl != null && virtualMachineProxyImpl.isPausePressed();
    }

    @NotNull
    public DebuggerCommandImpl createPauseCommand() {
        PauseCommand pauseCommand = new PauseCommand();
        if (pauseCommand == null) {
            DebugProcessImpl.a(37);
        }
        return pauseCommand;
    }

    @NotNull
    public ResumeCommand createResumeCommand(SuspendContextImpl suspendContextImpl) {
        ResumeCommand resumeCommand = this.createResumeCommand(suspendContextImpl, PrioritizedTask.Priority.HIGH);
        if (resumeCommand == null) {
            DebugProcessImpl.a(38);
        }
        return resumeCommand;
    }

    @NotNull
    public ResumeCommand createResumeCommand(SuspendContextImpl suspendContextImpl, final PrioritizedTask.Priority priority) {
        final BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(this.getProject()).getBreakpointManager();
        ResumeCommand resumeCommand = new ResumeCommand(suspendContextImpl){

            @Override
            public void contextAction() {
                breakpointManager.applyThreadFilter(DebugProcessImpl.this, null);
                if (DebugProcessImpl.this.myReturnValueWatcher != null) {
                    DebugProcessImpl.this.myReturnValueWatcher.clear();
                }
                super.contextAction();
            }

            @Override
            public PrioritizedTask.Priority getPriority() {
                return priority;
            }
        };
        if (resumeCommand == null) {
            DebugProcessImpl.a(39);
        }
        return resumeCommand;
    }

    @NotNull
    public ResumeCommand createStepOverCommand(SuspendContextImpl suspendContextImpl, boolean bl2) {
        ResumeCommand resumeCommand = this.createStepOverCommand(suspendContextImpl, bl2, -2);
        if (resumeCommand == null) {
            DebugProcessImpl.a(40);
        }
        return resumeCommand;
    }

    @NotNull
    public ResumeCommand createStepOverCommand(SuspendContextImpl suspendContextImpl, boolean bl2, int n2) {
        StepOverCommand stepOverCommand = new StepOverCommand(suspendContextImpl, bl2, n2);
        if (stepOverCommand == null) {
            DebugProcessImpl.a(41);
        }
        return stepOverCommand;
    }

    @NotNull
    public ResumeCommand createStepOutCommand(SuspendContextImpl suspendContextImpl) {
        ResumeCommand resumeCommand = this.createStepOutCommand(suspendContextImpl, -2);
        if (resumeCommand == null) {
            DebugProcessImpl.a(42);
        }
        return resumeCommand;
    }

    @NotNull
    public ResumeCommand createStepOutCommand(SuspendContextImpl suspendContextImpl, int n2) {
        StepOutCommand stepOutCommand = new StepOutCommand(suspendContextImpl, n2);
        if (stepOutCommand == null) {
            DebugProcessImpl.a(43);
        }
        return stepOutCommand;
    }

    @NotNull
    public ResumeCommand createStepIntoCommand(SuspendContextImpl suspendContextImpl, boolean bl2, MethodFilter methodFilter) {
        ResumeCommand resumeCommand = this.createStepIntoCommand(suspendContextImpl, bl2, methodFilter, -2);
        if (resumeCommand == null) {
            DebugProcessImpl.a(44);
        }
        return resumeCommand;
    }

    @NotNull
    public ResumeCommand createStepIntoCommand(SuspendContextImpl suspendContextImpl, boolean bl2, MethodFilter methodFilter, int n2) {
        StepIntoCommand stepIntoCommand = new StepIntoCommand(suspendContextImpl, bl2, methodFilter, n2);
        if (stepIntoCommand == null) {
            DebugProcessImpl.a(45);
        }
        return stepIntoCommand;
    }

    @NotNull
    public ResumeCommand createRunToCursorCommand(SuspendContextImpl suspendContextImpl, @NotNull XSourcePosition xSourcePosition, boolean bl2) throws EvaluateException {
        RunToCursorCommand runToCursorCommand;
        if (xSourcePosition == null) {
            DebugProcessImpl.a(46);
        }
        if ((runToCursorCommand = new RunToCursorCommand(suspendContextImpl, xSourcePosition, bl2)).e == null) {
            PsiFile psiFile = PsiManager.getInstance((Project)this.t).findFile(xSourcePosition.getFile());
            throw new EvaluateException(DebuggerBundle.message((String)"error.running.to.cursor.no.executable.code", (Object[])new Object[]{psiFile != null ? psiFile.getName() : "<No File>", xSourcePosition.getLine()}), null);
        }
        RunToCursorCommand runToCursorCommand2 = runToCursorCommand;
        if (runToCursorCommand2 == null) {
            DebugProcessImpl.a(47);
        }
        return runToCursorCommand2;
    }

    @NotNull
    public DebuggerCommandImpl createFreezeThreadCommand(ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        FreezeThreadCommand freezeThreadCommand = new FreezeThreadCommand(threadReferenceProxyImpl);
        if (freezeThreadCommand == null) {
            DebugProcessImpl.a(48);
        }
        return freezeThreadCommand;
    }

    @NotNull
    public SuspendContextCommandImpl createResumeThreadCommand(SuspendContextImpl suspendContextImpl, @NotNull ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        if (threadReferenceProxyImpl == null) {
            DebugProcessImpl.a(49);
        }
        ResumeThreadCommand resumeThreadCommand = new ResumeThreadCommand(suspendContextImpl, threadReferenceProxyImpl);
        if (resumeThreadCommand == null) {
            DebugProcessImpl.a(50);
        }
        return resumeThreadCommand;
    }

    @NotNull
    public SuspendContextCommandImpl createPopFrameCommand(DebuggerContextImpl debuggerContextImpl, StackFrameProxyImpl stackFrameProxyImpl) {
        PopFrameCommand popFrameCommand = new PopFrameCommand(debuggerContextImpl, stackFrameProxyImpl);
        if (popFrameCommand == null) {
            DebugProcessImpl.a(51);
        }
        return popFrameCommand;
    }

    @NotNull
    public DebuggerContextImpl getDebuggerContext() {
        DebuggerContextImpl debuggerContextImpl = this.mySession.getContextManager().getContext();
        if (debuggerContextImpl == null) {
            DebugProcessImpl.a(52);
        }
        return debuggerContextImpl;
    }

    public void setXDebugProcess(JavaDebugProcess javaDebugProcess) {
        this.y = javaDebugProcess;
    }

    @Nullable
    public JavaDebugProcess getXdebugProcess() {
        return this.y;
    }

    public boolean areBreakpointsMuted() {
        XDebugSession xDebugSession = this.mySession.getXDebugSession();
        return xDebugSession != null && xDebugSession.areBreakpointsMuted();
    }

    public DebuggerSession getSession() {
        return this.mySession;
    }

    static boolean isResumeOnlyCurrentThread() {
        return DebuggerSettings.getInstance().RESUME_ONLY_CURRENT_THREAD;
    }

    @NotNull
    public List<CapturePoint> getAgentInsertPoints() {
        List<CapturePoint> list2 = this.q;
        if (list2 == null) {
            DebugProcessImpl.a(53);
        }
        return list2;
    }

    public void setAgentInsertPoints(@NotNull List<CapturePoint> list2) {
        if (list2 == null) {
            DebugProcessImpl.a(54);
        }
        this.q = list2;
    }

    static {
        String string = System.getProperty("idea.debugger.trace");
        int n2 = 0;
        if (!StringUtil.isEmpty((String)string)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if ("SENDS".compareToIgnoreCase(string2) == 0) {
                    n2 |= 1;
                    continue;
                }
                if ("RAW_SENDS".compareToIgnoreCase(string2) == 0) {
                    n2 |= 0x1000000;
                    continue;
                }
                if ("RECEIVES".compareToIgnoreCase(string2) == 0) {
                    n2 |= 2;
                    continue;
                }
                if ("RAW_RECEIVES".compareToIgnoreCase(string2) == 0) {
                    n2 |= 0x2000000;
                    continue;
                }
                if ("EVENTS".compareToIgnoreCase(string2) == 0) {
                    n2 |= 4;
                    continue;
                }
                if ("REFTYPES".compareToIgnoreCase(string2) == 0) {
                    n2 |= 8;
                    continue;
                }
                if ("OBJREFS".compareToIgnoreCase(string2) == 0) {
                    n2 |= 0x10;
                    continue;
                }
                if ("ALL".compareToIgnoreCase(string2) != 0) continue;
                n2 |= 0xFFFFFF;
            }
        }
        e = n2;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 46: 
            case 49: 
            case 54: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 46: 
            case 49: 
            case 54: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/DebugProcessImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 13: 
            case 17: 
            case 21: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objRef";
                break;
            }
            case 15: 
            case 19: 
            case 23: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 16: 
            case 20: 
            case 24: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 22: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentInsertPoints";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveFilters";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findConnector";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualMachineProxy";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 46: 
            case 49: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/DebugProcessImpl";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "processIOException";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspendManager";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getPositionManager";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createStopCommand";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createPauseCommand";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createResumeCommand";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createStepOverCommand";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createStepOutCommand";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createStepIntoCommand";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createRunToCursorCommand";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createFreezeThreadCommand";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createResumeThreadCommand";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopFrameCommand";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebuggerContext";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getAgentInsertPoints";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processIOException";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "invokeMethod";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "invokeInstanceMethod";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createRunToCursorCommand";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createResumeThreadCommand";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "setAgentInsertPoints";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 46: 
            case 49: 
            case 54: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PopFrameCommand
    extends DebuggerContextCommandImpl {
        private final StackFrameProxyImpl h;

        public PopFrameCommand(DebuggerContextImpl debuggerContextImpl, StackFrameProxyImpl stackFrameProxyImpl) {
            super(debuggerContextImpl, stackFrameProxyImpl.threadProxy());
            this.h = stackFrameProxyImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void threadAction(@NotNull SuspendContextImpl suspendContextImpl) {
            if (suspendContextImpl == null) {
                PopFrameCommand.c(0);
            }
            ThreadReferenceProxyImpl threadReferenceProxyImpl = this.h.threadProxy();
            try {
                if (!DebugProcessImpl.this.getSuspendManager().isSuspended(threadReferenceProxyImpl)) {
                    this.notifyCancelled();
                    return;
                }
            }
            catch (ObjectCollectedException objectCollectedException) {
                this.notifyCancelled();
                return;
            }
            if (!suspendContextImpl.suspends(threadReferenceProxyImpl)) {
                suspendContextImpl.postponeCommand(this);
                return;
            }
            if (this.h.isBottom()) {
                DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.t, () -> Messages.showMessageDialog((Project)DebugProcessImpl.this.t, (String)DebuggerBundle.message((String)"error.pop.bottom.stackframe", (Object[])new Object[0]), (String)ActionsBundle.actionText((String)"Debugger.PopFrame"), (Icon)Messages.getErrorIcon()));
                return;
            }
            try {
                threadReferenceProxyImpl.popFrames(this.h);
            }
            catch (EvaluateException evaluateException) {
                DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.t, () -> Messages.showMessageDialog((Project)DebugProcessImpl.this.t, (String)DebuggerBundle.message((String)"error.pop.stackframe", (Object[])new Object[]{evaluateException.getLocalizedMessage()}), (String)ActionsBundle.actionText((String)"Debugger.PopFrame"), (Icon)Messages.getErrorIcon()));
                r.info((Throwable)evaluateException);
            }
            finally {
                DebugProcessImpl.this.getSuspendManager().popFrame(suspendContextImpl);
            }
        }

        private static /* synthetic */ void c(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/DebugProcessImpl$PopFrameCommand", "threadAction"));
        }
    }

    private class FreezeThreadCommand
    extends DebuggerCommandImpl {
        private final ThreadReferenceProxyImpl b;

        public FreezeThreadCommand(ThreadReferenceProxyImpl threadReferenceProxyImpl) {
            this.b = threadReferenceProxyImpl;
        }

        @Override
        protected void action() throws Exception {
            SuspendManager suspendManager = DebugProcessImpl.this.getSuspendManager();
            if (!suspendManager.isFrozen(this.b)) {
                suspendManager.freezeThread(this.b);
                SuspendContextImpl suspendContextImpl = DebugProcessImpl.this.j.pushSuspendContext(1, 0);
                suspendContextImpl.setThread(this.b.getThreadReference());
                ((DebugProcessListener)DebugProcessImpl.this.myDebugProcessDispatcher.getMulticaster()).paused((SuspendContext)suspendContextImpl);
            }
        }
    }

    private class ResumeThreadCommand
    extends SuspendContextCommandImpl {
        private final ThreadReferenceProxyImpl d;

        public ResumeThreadCommand(@NotNull SuspendContextImpl suspendContextImpl, ThreadReferenceProxyImpl threadReferenceProxyImpl) {
            if (threadReferenceProxyImpl == null) {
                ResumeThreadCommand.b(0);
            }
            super(suspendContextImpl);
            this.d = threadReferenceProxyImpl;
        }

        @Override
        public void contextAction() {
            Set<SuspendContextImpl> set = SuspendManagerUtil.getSuspendingContexts(DebugProcessImpl.this.getSuspendManager(), this.d);
            for (SuspendContextImpl suspendContextImpl : set) {
                if (suspendContextImpl.getSuspendPolicy() == 1 && suspendContextImpl.getThread() == this.d) {
                    DebugProcessImpl.this.getSession().getXDebugSession().sessionResumed();
                    DebugProcessImpl.this.getManagerThread().invoke(DebugProcessImpl.this.createResumeCommand(suspendContextImpl));
                    continue;
                }
                DebugProcessImpl.this.getSuspendManager().resumeThread(suspendContextImpl, this.d);
            }
        }

        private static /* synthetic */ void b(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "com/intellij/debugger/engine/DebugProcessImpl$ResumeThreadCommand", "<init>"));
        }
    }

    private class PauseCommand
    extends DebuggerCommandImpl {
        @Override
        public void action() {
            if (!DebugProcessImpl.this.isAttached() || DebugProcessImpl.this.getVirtualMachineProxy().isPausePressed()) {
                return;
            }
            DebugProcessImpl.this.logThreads();
            DebugProcessImpl.this.getVirtualMachineProxy().suspend();
            DebugProcessImpl.this.logThreads();
            SuspendContextImpl suspendContextImpl = DebugProcessImpl.this.j.pushSuspendContext(2, 0);
            ((DebugProcessListener)DebugProcessImpl.this.myDebugProcessDispatcher.getMulticaster()).paused((SuspendContext)suspendContextImpl);
        }
    }

    public abstract class ResumeCommand
    extends SuspendContextCommandImpl {
        @Nullable
        protected final ThreadReferenceProxyImpl myContextThread;

        public ResumeCommand(SuspendContextImpl suspendContextImpl) {
            super(suspendContextImpl);
            ThreadReferenceProxyImpl threadReferenceProxyImpl = DebugProcessImpl.this.getDebuggerContext().getThreadProxy();
            this.myContextThread = threadReferenceProxyImpl != null ? threadReferenceProxyImpl : (suspendContextImpl != null ? suspendContextImpl.getThread() : null);
        }

        @Override
        public PrioritizedTask.Priority getPriority() {
            return PrioritizedTask.Priority.HIGH;
        }

        @Override
        public void contextAction() {
            DebugProcessImpl.this.showStatusText(DebuggerBundle.message((String)"status.process.resumed", (Object[])new Object[0]));
            this.resumeAction();
            ((DebugProcessListener)DebugProcessImpl.this.myDebugProcessDispatcher.getMulticaster()).resumed((SuspendContext)this.getSuspendContext());
        }

        protected void resumeAction() {
            DebugProcessImpl.this.getSuspendManager().resume(this.getSuspendContext());
        }

        @Nullable
        public ThreadReferenceProxyImpl getContextThread() {
            return this.myContextThread;
        }

        protected void applyThreadFilter(ThreadReferenceProxy threadReferenceProxy) {
            if (this.getSuspendContext().getSuspendPolicy() == 2) {
                BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.getProject()).getBreakpointManager();
                breakpointManager.applyThreadFilter(DebugProcessImpl.this, threadReferenceProxy.getThreadReference());
            }
        }
    }

    private abstract class StepCommand
    extends ResumeCommand {
        public StepCommand(SuspendContextImpl suspendContextImpl) {
            super(suspendContextImpl);
        }

        @Override
        protected void resumeAction() {
            SuspendContextImpl suspendContextImpl = this.getSuspendContext();
            if (suspendContextImpl != null && (suspendContextImpl.getSuspendPolicy() == 1 || DebugProcessImpl.isResumeOnlyCurrentThread())) {
                DebugProcessImpl.this.d.startWatching(this.myContextThread);
            }
            if (suspendContextImpl != null && DebugProcessImpl.isResumeOnlyCurrentThread() && suspendContextImpl.getSuspendPolicy() == 2 && this.myContextThread != null) {
                DebugProcessImpl.this.getSuspendManager().resumeThread(suspendContextImpl, this.myContextThread);
            } else {
                super.resumeAction();
            }
        }
    }

    private class RunToCursorCommand
    extends StepCommand {
        private final RunToCursorBreakpoint e;
        private final boolean d;

        private RunToCursorCommand(@NotNull SuspendContextImpl suspendContextImpl, XSourcePosition xSourcePosition, boolean bl2) {
            if (xSourcePosition == null) {
                RunToCursorCommand.b(0);
            }
            super(suspendContextImpl);
            this.d = bl2;
            this.e = DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.t).getBreakpointManager().addRunToCursorBreakpoint(xSourcePosition, bl2);
        }

        @Override
        public void contextAction() {
            DebugProcessImpl.this.showStatusText(DebuggerBundle.message((String)"status.run.to.cursor", (Object[])new Object[0]));
            DebugProcessImpl.this.cancelRunToCursorBreakpoint();
            if (this.e == null) {
                return;
            }
            if (this.d) {
                DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.t).getBreakpointManager().disableBreakpoints(DebugProcessImpl.this);
            }
            this.applyThreadFilter(this.getContextThread());
            SuspendContextImpl suspendContextImpl = this.getSuspendContext();
            this.e.setSuspendPolicy(suspendContextImpl.getSuspendPolicy() == 1 ? "SuspendThread" : "SuspendAll");
            DebugProcessImpl debugProcessImpl = suspendContextImpl.getDebugProcess();
            this.e.createRequest(debugProcessImpl);
            DebugProcessImpl.this.setRunToCursorBreakpoint(this.e);
            if (debugProcessImpl.getRequestsManager().getWarning(this.e) == null) {
                super.contextAction();
            } else {
                DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.t, () -> {
                    Messages.showErrorDialog((String)DebuggerBundle.message((String)"error.running.to.cursor.no.executable.code", (Object[])new Object[]{this.e.getSourcePosition().getFile().getName(), this.e.getLineIndex() + 1}), (String)UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"RunToCursor")));
                    DebuggerSession debuggerSession = debugProcessImpl.getSession();
                    debuggerSession.getContextManager().setState(DebuggerContextUtil.createDebuggerContext(debuggerSession, suspendContextImpl), DebuggerSession.State.PAUSED, DebuggerSession.Event.CONTEXT, null);
                });
            }
        }

        private static /* synthetic */ void b(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/engine/DebugProcessImpl$RunToCursorCommand", "<init>"));
        }
    }

    public class StepOverCommand
    extends StepCommand {
        private final boolean d;
        private final int e;

        public StepOverCommand(SuspendContextImpl suspendContextImpl, boolean bl2, int n2) {
            super(suspendContextImpl);
            this.d = bl2;
            this.e = n2;
        }

        protected int getStepSize() {
            return 2;
        }

        @NotNull
        protected String getStatusText() {
            String string = DebuggerBundle.message((String)"status.step.over", (Object[])new Object[0]);
            if (string == null) {
                StepOverCommand.b(0);
            }
            return string;
        }

        @NotNull
        protected RequestHint getHint(SuspendContextImpl suspendContextImpl, ThreadReferenceProxyImpl threadReferenceProxyImpl) {
            RequestHint requestHint = new RequestHint(threadReferenceProxyImpl, suspendContextImpl, 2);
            requestHint.setRestoreBreakpoints(this.d);
            requestHint.setIgnoreFilters(this.d || DebugProcessImpl.this.mySession.shouldIgnoreSteppingFilters());
            RequestHint requestHint2 = requestHint;
            if (requestHint2 == null) {
                StepOverCommand.b(1);
            }
            return requestHint2;
        }

        @Override
        public void contextAction() {
            DebugProcessImpl.this.showStatusText(this.getStatusText());
            SuspendContextImpl suspendContextImpl = this.getSuspendContext();
            ThreadReferenceProxyImpl threadReferenceProxyImpl = this.getContextThread();
            RequestHint requestHint = this.getHint(suspendContextImpl, threadReferenceProxyImpl);
            this.applyThreadFilter(threadReferenceProxyImpl);
            MethodReturnValueWatcher methodReturnValueWatcher = DebugProcessImpl.this.myReturnValueWatcher;
            if (methodReturnValueWatcher != null) {
                methodReturnValueWatcher.enable(threadReferenceProxyImpl.getThreadReference());
            }
            DebugProcessImpl.this.doStep(suspendContextImpl, threadReferenceProxyImpl, this.e, this.getStepSize(), requestHint);
            if (this.d) {
                DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.t).getBreakpointManager().disableBreakpoints(DebugProcessImpl.this);
            }
            super.contextAction();
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/debugger/engine/DebugProcessImpl$StepOverCommand";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatusText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHint";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private class StepIntoCommand
    extends StepCommand {
        private final boolean f;
        private final MethodFilter e;
        @Nullable
        private final StepIntoBreakpoint g;
        private final int d;

        public StepIntoCommand(SuspendContextImpl suspendContextImpl, @Nullable boolean bl2, MethodFilter methodFilter, int n2) {
            super(suspendContextImpl);
            this.f = bl2 || methodFilter != null;
            this.e = methodFilter;
            this.g = methodFilter instanceof BreakpointStepMethodFilter ? DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.t).getBreakpointManager().addStepIntoBreakpoint((BreakpointStepMethodFilter)methodFilter) : null;
            this.d = n2;
        }

        @Override
        public void contextAction() {
            DebugProcessImpl.this.showStatusText(DebuggerBundle.message((String)"status.step.into", (Object[])new Object[0]));
            SuspendContextImpl suspendContextImpl = this.getSuspendContext();
            ThreadReferenceProxyImpl threadReferenceProxyImpl = this.getContextThread();
            RequestHint requestHint = this.e != null ? new RequestHint(threadReferenceProxyImpl, suspendContextImpl, this.e) : new RequestHint(threadReferenceProxyImpl, suspendContextImpl, 1);
            requestHint.setResetIgnoreFilters(this.e != null && !DebugProcessImpl.this.mySession.shouldIgnoreSteppingFilters());
            if (this.f) {
                try {
                    DebugProcessImpl.this.mySession.setIgnoreStepFiltersFlag(threadReferenceProxyImpl.frameCount());
                }
                catch (EvaluateException evaluateException) {
                    r.info((Throwable)evaluateException);
                }
            }
            requestHint.setIgnoreFilters(this.f || DebugProcessImpl.this.mySession.shouldIgnoreSteppingFilters());
            this.applyThreadFilter(threadReferenceProxyImpl);
            if (this.g != null) {
                this.g.setSuspendPolicy(suspendContextImpl.getSuspendPolicy() == 1 ? "SuspendThread" : "SuspendAll");
                this.g.createRequest(suspendContextImpl.getDebugProcess());
                this.g.setRequestHint(requestHint);
                DebugProcessImpl.this.setRunToCursorBreakpoint(this.g);
            }
            DebugProcessImpl.this.doStep(suspendContextImpl, threadReferenceProxyImpl, this.d, 1, requestHint);
            super.contextAction();
        }
    }

    private class StepOutCommand
    extends StepCommand {
        private final int d;

        public StepOutCommand(SuspendContextImpl suspendContextImpl, int n2) {
            super(suspendContextImpl);
            this.d = n2;
        }

        @Override
        public void contextAction() {
            DebugProcessImpl.this.showStatusText(DebuggerBundle.message((String)"status.step.out", (Object[])new Object[0]));
            SuspendContextImpl suspendContextImpl = this.getSuspendContext();
            ThreadReferenceProxyImpl threadReferenceProxyImpl = this.getContextThread();
            RequestHint requestHint = new RequestHint(threadReferenceProxyImpl, suspendContextImpl, 3);
            requestHint.setIgnoreFilters(DebugProcessImpl.this.mySession.shouldIgnoreSteppingFilters());
            this.applyThreadFilter(threadReferenceProxyImpl);
            MethodReturnValueWatcher methodReturnValueWatcher = DebugProcessImpl.this.myReturnValueWatcher;
            if (methodReturnValueWatcher != null) {
                methodReturnValueWatcher.enable(threadReferenceProxyImpl.getThreadReference());
            }
            DebugProcessImpl.this.doStep(suspendContextImpl, threadReferenceProxyImpl, this.d, 3, requestHint);
            super.contextAction();
        }
    }

    protected class StopCommand
    extends DebuggerCommandImpl {
        private final boolean b;

        public StopCommand(boolean bl2) {
            this.b = bl2;
        }

        @Override
        public PrioritizedTask.Priority getPriority() {
            return PrioritizedTask.Priority.HIGH;
        }

        @Override
        protected void action() throws Exception {
            if (DebugProcessImpl.this.isAttached()) {
                VirtualMachineProxyImpl virtualMachineProxyImpl = DebugProcessImpl.this.getVirtualMachineProxy();
                if (this.b) {
                    virtualMachineProxyImpl.exit(-1);
                } else {
                    try {
                        virtualMachineProxyImpl.resume();
                    }
                    finally {
                        virtualMachineProxyImpl.dispose();
                    }
                }
            } else {
                try {
                    DebugProcessImpl.this.c();
                }
                finally {
                    DebugProcessImpl.this.closeProcess(true);
                }
            }
        }
    }

    private abstract class InvokeCommand<E extends Value> {
        private final Method b;
        private final List<Value> a;

        protected InvokeCommand(@NotNull Method method, List<? extends Value> list2) {
            if (method == null) {
                InvokeCommand.a(0);
            }
            if (list2 == null) {
                InvokeCommand.a(1);
            }
            this.b = method;
            this.a = new ArrayList<Value>(list2);
        }

        public String toString() {
            return "INVOKE: " + super.toString();
        }

        protected abstract E invokeMethod(int var1, Method var2, List<? extends Value> var3) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException;

        E start(EvaluationContextImpl evaluationContextImpl, boolean bl2) throws EvaluateException {
            while (true) {
                try {
                    return this.startInternal(evaluationContextImpl, bl2);
                }
                catch (ClassNotLoadedException classNotLoadedException) {
                    ReferenceType referenceType = null;
                    try {
                        if (!evaluationContextImpl.isAutoLoadClasses()) continue;
                        referenceType = DebugProcessImpl.this.loadClass(evaluationContextImpl, classNotLoadedException.className(), evaluationContextImpl.getClassLoader());
                        continue;
                    }
                    catch (Exception exception) {
                        referenceType = null;
                    }
                    if (referenceType != null) continue;
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)classNotLoadedException);
                }
                break;
            }
        }

        E startInternal(EvaluationContextImpl evaluationContextImpl, boolean bl2) throws EvaluateException, ClassNotLoadedException {
            Iterator<SuspendContextImpl> iterator;
            DebuggerManagerThreadImpl.assertIsManagerThread();
            SuspendContextImpl suspendContextImpl = evaluationContextImpl.getSuspendContext();
            SuspendManagerUtil.assertSuspendContext(suspendContextImpl);
            ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContextImpl.getThread();
            if (SuspendManagerUtil.isEvaluating(DebugProcessImpl.this.getSuspendManager(), threadReferenceProxyImpl)) {
                throw EvaluateExceptionUtil.NESTED_EVALUATION_ERROR;
            }
            if (!suspendContextImpl.suspends(threadReferenceProxyImpl)) {
                throw EvaluateExceptionUtil.THREAD_WAS_RESUMED;
            }
            Set<SuspendContextImpl> set = SuspendManagerUtil.getSuspendingContexts(DebugProcessImpl.this.getSuspendManager(), threadReferenceProxyImpl);
            ThreadReference threadReference = threadReferenceProxyImpl.getThreadReference();
            ((EvaluationListener)DebugProcessImpl.this.myEvaluationDispatcher.getMulticaster()).evaluationStarted(suspendContextImpl);
            DebugProcessImpl.this.a(suspendContextImpl, this.b, bl2);
            Object object = null;
            try {
                for (Object object2 : set) {
                    ThreadReferenceProxyImpl object3 = object2.getThread();
                    if (object3 == threadReferenceProxyImpl) continue;
                    if (r.isDebugEnabled()) {
                        r.debug("Resuming " + threadReferenceProxyImpl + " that is paused by " + object3);
                    }
                    r.assertTrue(object3 == null || !threadReference.equals(object3.getThreadReference()));
                    DebugProcessImpl.this.getSuspendManager().resumeThread((SuspendContextImpl)((Object)object2), threadReferenceProxyImpl);
                }
                object = SuspendManagerUtil.prepareForResume(suspendContextImpl);
                suspendContextImpl.setIsEvaluating(evaluationContextImpl);
                DebugProcessImpl.this.getVirtualMachineProxy().clearCaches();
                iterator = this.a(suspendContextImpl);
            }
            catch (IncompatibleThreadStateException | InternalException | InvalidTypeException | InvocationException | ObjectCollectedException | UnsupportedOperationException exception) {
                try {
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)exception);
                }
                catch (Throwable throwable) {
                    suspendContextImpl.setIsEvaluating(null);
                    if (object != null) {
                        SuspendManagerUtil.restoreAfterResume(suspendContextImpl, object);
                    }
                    for (SuspendContextImpl suspendContextImpl2 : DebugProcessImpl.this.j.getEventContexts()) {
                        if (!set.contains((Object)suspendContextImpl2) || suspendContextImpl2.isEvaluating() || suspendContextImpl2.suspends(threadReferenceProxyImpl)) continue;
                        DebugProcessImpl.this.j.suspendThread(suspendContextImpl2, threadReferenceProxyImpl);
                    }
                    r.debug("getVirtualMachine().clearCaches()");
                    DebugProcessImpl.this.getVirtualMachineProxy().clearCaches();
                    DebugProcessImpl.this.a(suspendContextImpl, bl2);
                    ((EvaluationListener)DebugProcessImpl.this.myEvaluationDispatcher.getMulticaster()).evaluationFinished(suspendContextImpl);
                    throw throwable;
                }
            }
            suspendContextImpl.setIsEvaluating(null);
            if (object != null) {
                SuspendManagerUtil.restoreAfterResume(suspendContextImpl, object);
            }
            for (SuspendContextImpl suspendContextImpl3 : DebugProcessImpl.this.j.getEventContexts()) {
                if (!set.contains((Object)suspendContextImpl3) || suspendContextImpl3.isEvaluating() || suspendContextImpl3.suspends(threadReferenceProxyImpl)) continue;
                DebugProcessImpl.this.j.suspendThread(suspendContextImpl3, threadReferenceProxyImpl);
            }
            r.debug("getVirtualMachine().clearCaches()");
            DebugProcessImpl.this.getVirtualMachineProxy().clearCaches();
            DebugProcessImpl.this.a(suspendContextImpl, bl2);
            ((EvaluationListener)DebugProcessImpl.this.myEvaluationDispatcher.getMulticaster()).evaluationFinished(suspendContextImpl);
            return (E)iterator;
        }

        private E a(SuspendContextImpl suspendContextImpl) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
            int n2 = DebugProcessImpl.a(suspendContextImpl);
            Exception[] exceptionArray = new Exception[1];
            Value[] valueArray = new Value[1];
            DebugProcessImpl.this.getManagerThread().startLongProcessAndFork(() -> {
                ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContextImpl.getThread();
                try {
                    try {
                        Mirror mirror;
                        int n3;
                        if (r.isDebugEnabled()) {
                            VirtualMachineProxyImpl virtualMachineProxyImpl = DebugProcessImpl.this.getVirtualMachineProxy();
                            virtualMachineProxyImpl.logThreads();
                            r.debug("Invoke in " + threadReferenceProxyImpl.name());
                            this.a(threadReferenceProxyImpl, suspendContextImpl);
                        }
                        if (this.b.isVarArgs() && (n3 = this.b.argumentTypeNames().size() - 1) >= 0 && this.a.size() > n3) {
                            List<Object> list2;
                            Value value2 = this.a.get(n3);
                            if (this.a.size() == n3 + 1) {
                                if (value2 instanceof ArrayReference && ((ArrayType)(mirror = (ArrayReference)value2).referenceType()).componentType() instanceof InterfaceType && (list2 = this.b.argumentTypeNames()).size() > n3 && ((String)list2.get(n3)).startsWith("java.lang.Object")) {
                                    this.a.remove(n3);
                                    this.a.addAll(mirror.getValues());
                                }
                            } else if (value2 == null) {
                                int n4 = this.a.size();
                                list2 = this.b.argumentTypes();
                                int n5 = list2.size();
                                ArrayType arrayType = (ArrayType)list2.get(list2.size() - 1);
                                int n6 = n4 - n5 + 1;
                                ArrayReference arrayReference = arrayType.newInstance(n6);
                                arrayReference.setValues(0, this.a, n5 - 1, n6);
                                this.a.set(n5 - 1, arrayReference);
                                this.a.subList(n5, n4).clear();
                            }
                        }
                        for (Value value2 : this.a) {
                            if (!(value2 instanceof ArrayReference)) continue;
                            mirror = value2.type();
                            while (mirror instanceof ArrayType) {
                                mirror = ((ArrayType)mirror).componentType();
                            }
                        }
                        if (!Patches.IBM_JDK_DISABLE_COLLECTION_BUG) {
                            StreamEx.of(this.a).select(ObjectReference.class).forEach(DebuggerUtilsEx::disableCollection);
                        }
                        if ((e & 1) != 0) {
                            this.a.forEach(Object::toString);
                        }
                        if ((e & 1) != 0) {
                            StreamEx.of(this.a).findAny(ThreadReference.class::isInstance).ifPresent(value -> {
                                System.err.println("[JDI: workaround for invocation of " + this.b + "]");
                                this.b.virtualMachine().setDebugTraceMode(e & 0xFFFFFFFE);
                            });
                        }
                        valueArray[0] = this.invokeMethod(n2, this.b, this.a);
                    }
                    finally {
                        if ((e & 1) != 0) {
                            this.b.virtualMachine().setDebugTraceMode(e);
                        }
                        if (!Patches.IBM_JDK_DISABLE_COLLECTION_BUG) {
                            StreamEx.of(this.a).select(ObjectReference.class).forEach(DebuggerUtilsEx::enableCollection);
                        }
                    }
                }
                catch (Exception exception) {
                    exceptionArray[0] = exception;
                }
            });
            if (exceptionArray[0] != null) {
                if (exceptionArray[0] instanceof InvocationException) {
                    throw (InvocationException)exceptionArray[0];
                }
                if (exceptionArray[0] instanceof ClassNotLoadedException) {
                    throw (ClassNotLoadedException)exceptionArray[0];
                }
                if (exceptionArray[0] instanceof IncompatibleThreadStateException) {
                    throw (IncompatibleThreadStateException)exceptionArray[0];
                }
                if (exceptionArray[0] instanceof InvalidTypeException) {
                    throw (InvalidTypeException)exceptionArray[0];
                }
                if (exceptionArray[0] instanceof RuntimeException) {
                    throw (RuntimeException)exceptionArray[0];
                }
                r.error("Unexpected exception", new Throwable().initCause(exceptionArray[0]));
            }
            return (E)valueArray[0];
        }

        private void a(ThreadReferenceProxyImpl threadReferenceProxyImpl, SuspendContextImpl suspendContextImpl) {
            r.assertTrue(suspendContextImpl.isEvaluating());
            try {
                boolean bl2 = threadReferenceProxyImpl.isSuspended();
                r.assertTrue(bl2, (Object)threadReferenceProxyImpl);
            }
            catch (ObjectCollectedException objectCollectedException) {
                // empty catch block
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "method";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "args";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/engine/DebugProcessImpl$InvokeCommand";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static enum State {
        INITIAL,
        ATTACHED,
        DETACHING,
        DETACHED;

    }
}

