/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.ide.util.JavaAnonymousClassesHelper;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JVMNameUtil {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.debugger.engine.JVMNameUtil");
    public static final String CONSTRUCTOR_NAME = "<init>";

    @Nullable
    public static String getPrimitiveSignature(String string) {
        if (PsiType.BOOLEAN.getCanonicalText().equals(string)) {
            return "Z";
        }
        if (PsiType.BYTE.getCanonicalText().equals(string)) {
            return "B";
        }
        if (PsiType.CHAR.getCanonicalText().equals(string)) {
            return "C";
        }
        if (PsiType.SHORT.getCanonicalText().equals(string)) {
            return "S";
        }
        if (PsiType.INT.getCanonicalText().equals(string)) {
            return "I";
        }
        if (PsiType.LONG.getCanonicalText().equals(string)) {
            return "J";
        }
        if (PsiType.FLOAT.getCanonicalText().equals(string)) {
            return "F";
        }
        if (PsiType.DOUBLE.getCanonicalText().equals(string)) {
            return "D";
        }
        if (PsiType.VOID.getCanonicalText().equals(string)) {
            return "V";
        }
        return null;
    }

    private static void a(JVMNameBuffer jVMNameBuffer, PsiType psiType) {
        if (psiType == null) {
            return;
        }
        PsiType psiType2 = TypeConversionUtil.erasure((PsiType)psiType);
        if (psiType2 instanceof PsiArrayType) {
            jVMNameBuffer.append(new JVMRawText("["));
            JVMNameUtil.a(jVMNameBuffer, ((PsiArrayType)psiType2).getComponentType());
        } else if (psiType2 instanceof PsiClassType) {
            JVMName jVMName = JVMNameUtil.getJVMQualifiedName(psiType2);
            JVMNameUtil.a(jVMNameBuffer, jVMName);
        } else if (psiType2 instanceof PsiPrimitiveType) {
            jVMNameBuffer.append(JVMNameUtil.getPrimitiveSignature(psiType2.getCanonicalText()));
        } else {
            a.error("unknown type " + psiType.getCanonicalText());
        }
    }

    private static void a(JVMNameBuffer jVMNameBuffer, final JVMName jVMName) {
        jVMNameBuffer.append("L");
        if (jVMName instanceof JVMRawText) {
            jVMNameBuffer.append(((JVMRawText)jVMName).getName().replace('.', '/'));
        } else {
            jVMNameBuffer.append(new JVMName(){

                @Override
                public String getName(DebugProcessImpl debugProcessImpl) throws EvaluateException {
                    return jVMName.getName(debugProcessImpl).replace('.', '/');
                }

                @Override
                public String getDisplayName(DebugProcessImpl debugProcessImpl) {
                    return jVMName.getDisplayName(debugProcessImpl);
                }
            });
        }
        jVMNameBuffer.append(";");
    }

    @NotNull
    public static JVMName getJVMRawText(String string) {
        JVMRawText jVMRawText = new JVMRawText(string);
        if (jVMRawText == null) {
            JVMNameUtil.a(0);
        }
        return jVMRawText;
    }

    public static JVMName getJVMQualifiedName(PsiType psiType) {
        if (psiType instanceof PsiArrayType) {
            PsiArrayType psiArrayType = (PsiArrayType)psiType;
            JVMName jVMName = JVMNameUtil.getJVMQualifiedName(psiArrayType.getComponentType());
            JVMNameBuffer jVMNameBuffer = new JVMNameBuffer();
            jVMNameBuffer.append(jVMName);
            jVMNameBuffer.append("[]");
            return jVMNameBuffer.toName();
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)psiType);
        if (psiClass == null) {
            return JVMNameUtil.getJVMRawText(psiType.getCanonicalText());
        }
        return JVMNameUtil.getJVMQualifiedName(psiClass);
    }

    @NotNull
    public static JVMName getJVMQualifiedName(@NotNull PsiClass psiClass) {
        String string;
        if (psiClass == null) {
            JVMNameUtil.a(1);
        }
        if ((string = JVMNameUtil.getNonAnonymousClassName(psiClass)) != null) {
            JVMName jVMName = JVMNameUtil.getJVMRawText(string);
            if (jVMName == null) {
                JVMNameUtil.a(2);
            }
            return jVMName;
        }
        JVMClassAt jVMClassAt = new JVMClassAt(SourcePosition.createFromElement((PsiElement)psiClass));
        if (jVMClassAt == null) {
            JVMNameUtil.a(3);
        }
        return jVMClassAt;
    }

    @Nullable
    public static JVMName getContextClassJVMQualifiedName(@Nullable SourcePosition sourcePosition) {
        PsiClass psiClass = JVMNameUtil.getClassAt(sourcePosition);
        if (psiClass == null) {
            return null;
        }
        String string = JVMNameUtil.getNonAnonymousClassName(psiClass);
        if (string != null) {
            return JVMNameUtil.getJVMRawText(string);
        }
        return new JVMClassAt(sourcePosition);
    }

    @Nullable
    public static String getNonAnonymousClassName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JVMNameUtil.a(4);
        }
        if (PsiUtil.isLocalOrAnonymousClass((PsiClass)psiClass)) {
            return null;
        }
        String string = psiClass.getName();
        if (string == null) {
            return null;
        }
        PsiClass psiClass2 = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class, (boolean)true);
        if (psiClass2 != null) {
            String string2 = JVMNameUtil.getNonAnonymousClassName(psiClass2);
            if (string2 == null) {
                return null;
            }
            return string2 + "$" + string;
        }
        return DebuggerManager.getInstance((Project)psiClass.getProject()).getVMClassQualifiedName(psiClass);
    }

    @NotNull
    public static JVMName getJVMConstructorSignature(@Nullable PsiMethod psiMethod, @Nullable PsiClass psiClass) {
        JVMName jVMName = JVMNameUtil.a(psiMethod, true, psiClass);
        if (jVMName == null) {
            JVMNameUtil.a(5);
        }
        return jVMName;
    }

    @NotNull
    public static JVMName getJVMSignature(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            JVMNameUtil.a(6);
        }
        JVMName jVMName = JVMNameUtil.a(psiMethod, psiMethod.isConstructor(), psiMethod.getContainingClass());
        if (jVMName == null) {
            JVMNameUtil.a(7);
        }
        return jVMName;
    }

    @NotNull
    public static String getJVMMethodName(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            JVMNameUtil.a(8);
        }
        String string = psiMethod.isConstructor() ? CONSTRUCTOR_NAME : psiMethod.getName();
        if (string == null) {
            JVMNameUtil.a(9);
        }
        return string;
    }

    @NotNull
    private static JVMName a(@Nullable PsiMethod psiMethod, boolean bl2, @Nullable PsiClass psiClass) {
        PsiParameter[] psiParameterArray;
        JVMNameBuffer jVMNameBuffer = new JVMNameBuffer();
        jVMNameBuffer.append("(");
        if (bl2 && psiClass != null && (psiParameterArray = psiClass.getContainingClass()) != null && !psiClass.hasModifierProperty("static")) {
            JVMNameUtil.a(jVMNameBuffer, JVMNameUtil.getJVMQualifiedName((PsiClass)psiParameterArray));
        }
        if (psiMethod != null) {
            for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                JVMNameUtil.a(jVMNameBuffer, psiParameter.getType());
            }
        }
        jVMNameBuffer.append(")");
        if (!bl2 && psiMethod != null) {
            JVMNameUtil.a(jVMNameBuffer, psiMethod.getReturnType());
        } else {
            jVMNameBuffer.append(new JVMRawText("V"));
        }
        JVMName jVMName = jVMNameBuffer.toName();
        if (jVMName == null) {
            JVMNameUtil.a(10);
        }
        return jVMName;
    }

    @Nullable
    public static PsiClass getClassAt(@Nullable SourcePosition sourcePosition) {
        if (sourcePosition == null) {
            return null;
        }
        PsiElement psiElement = sourcePosition.getElementAt();
        return psiElement != null && psiElement.isValid() ? (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class, (boolean)false) : null;
    }

    @Nullable
    public static String getSourcePositionClassDisplayName(DebugProcessImpl debugProcessImpl, @Nullable SourcePosition sourcePosition) {
        Object object;
        if (sourcePosition == null) {
            return null;
        }
        PsiFile psiFile = sourcePosition.getFile();
        if (psiFile instanceof JspFile) {
            return psiFile.getName();
        }
        PsiClass psiClass = JVMNameUtil.getClassAt(sourcePosition);
        if (psiClass != null && (object = psiClass.getQualifiedName()) != null) {
            return object;
        }
        if (debugProcessImpl != null && debugProcessImpl.isAttached() && !(object = debugProcessImpl.getPositionManager().getAllClasses(sourcePosition)).isEmpty()) {
            return ((ReferenceType)object.get(0)).name();
        }
        if (psiClass == null) {
            if (psiFile instanceof PsiClassOwner) {
                return psiFile.getName();
            }
            return DebuggerBundle.message((String)"string.file.line.position", (Object[])new Object[]{psiFile.getName(), sourcePosition.getLine()});
        }
        return JVMNameUtil.calcClassDisplayName(psiClass);
    }

    static String calcClassDisplayName(final PsiClass psiClass) {
        String string = psiClass.getQualifiedName();
        if (string != null) {
            return string;
        }
        PsiClass psiClass2 = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class, (boolean)true);
        if (psiClass2 == null) {
            return null;
        }
        String string2 = psiClass.getName();
        if (string2 != null) {
            return JVMNameUtil.calcClassDisplayName(psiClass2) + "$" + string2;
        }
        final Ref ref = new Ref((Object)0);
        try {
            psiClass2.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitAnonymousClass(PsiAnonymousClass psiAnonymousClass) {
                    ref.set((Object)((Integer)ref.get() + 1));
                    if (psiClass.equals(psiAnonymousClass)) {
                        throw new ProcessCanceledException();
                    }
                }
            });
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        return JVMNameUtil.calcClassDisplayName(psiClass2) + "$" + ref.get();
    }

    @Nullable
    public static String getSourcePositionPackageDisplayName(DebugProcessImpl debugProcessImpl, @Nullable SourcePosition sourcePosition) {
        int n2;
        String string;
        Object object;
        if (sourcePosition == null) {
            return null;
        }
        PsiFile psiFile = sourcePosition.getFile();
        if (psiFile instanceof JspFile) {
            PsiDirectory psiDirectory = psiFile.getContainingDirectory();
            return psiDirectory != null ? psiDirectory.getVirtualFile().getPresentableUrl() : null;
        }
        PsiClass psiClass = JVMNameUtil.getClassAt(sourcePosition);
        if (psiClass != null && (object = PsiUtil.getTopLevelClass((PsiElement)psiClass)) != null && (string = object.getQualifiedName()) != null) {
            int n3 = string.lastIndexOf(46);
            return n3 > 0 ? string.substring(0, n3) : "";
        }
        if (psiFile instanceof PsiClassOwner && !StringUtil.isEmpty((String)(object = ((PsiClassOwner)psiFile).getPackageName()))) {
            return object;
        }
        if (debugProcessImpl != null && debugProcessImpl.isAttached() && !(object = debugProcessImpl.getPositionManager().getAllClasses(sourcePosition)).isEmpty() && (n2 = (string = ((ReferenceType)object.get(0)).name()).lastIndexOf(46)) >= 0) {
            return string.substring(0, n2);
        }
        return "";
    }

    public static PsiClass getTopLevelParentClass(PsiClass psiClass) {
        return (PsiClass)PsiTreeUtil.getTopmostParentOfType((PsiElement)psiClass, PsiClass.class);
    }

    @Nullable
    public static String getClassVMName(@Nullable PsiClass psiClass) {
        if (psiClass == null || PsiUtil.isLocalClass((PsiClass)psiClass)) {
            return null;
        }
        if (psiClass instanceof PsiAnonymousClass) {
            String string = JVMNameUtil.getClassVMName((PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class));
            if (string == null) {
                return null;
            }
            return string + JavaAnonymousClassesHelper.getName((PsiAnonymousClass)((PsiAnonymousClass)psiClass));
        }
        return ClassUtil.getJVMClassName((PsiClass)psiClass);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/JVMNameUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getJVMRawText";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/JVMNameUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getJVMQualifiedName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getJVMConstructorSignature";
                break;
            }
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getJVMSignature";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getJVMMethodName";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getJVMQualifiedName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNonAnonymousClassName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getJVMSignature";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getJVMMethodName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JVMClassAt
    implements JVMName {
        private final SourcePosition a;

        public JVMClassAt(SourcePosition sourcePosition) {
            this.a = sourcePosition;
        }

        @Override
        public String getName(DebugProcessImpl debugProcessImpl) throws EvaluateException {
            List<ReferenceType> list2 = debugProcessImpl.getPositionManager().getAllClasses(this.a);
            if (list2.size() > 1) {
                String string = (String)ReadAction.compute(() -> JVMNameUtil.getClassVMName(JVMNameUtil.getClassAt(this.a)));
                for (ReferenceType referenceType : list2) {
                    if (!Comparing.equal((String)referenceType.name(), (String)string)) continue;
                    return string;
                }
            }
            if (!list2.isEmpty()) {
                return list2.get(0).name();
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"error.class.not.loaded", (Object[])new Object[]{this.getDisplayName(debugProcessImpl)}));
        }

        @Override
        public String getDisplayName(DebugProcessImpl debugProcessImpl) {
            return (String)ReadAction.compute(() -> JVMNameUtil.getSourcePositionClassDisplayName(debugProcessImpl, this.a));
        }
    }

    private static class JVMRawText
    implements JVMName {
        private String a;

        public JVMRawText(String string) {
            this.a = string;
        }

        @Override
        public String getName(DebugProcessImpl debugProcessImpl) throws EvaluateException {
            return this.a;
        }

        @Override
        public String getDisplayName(DebugProcessImpl debugProcessImpl) {
            return this.a;
        }

        public String getName() {
            return this.a;
        }

        public void setName(String string) {
            this.a = string;
        }

        public String toString() {
            return this.a;
        }
    }

    private static class JVMNameBuffer {
        private final List<JVMName> a = new ArrayList<JVMName>();

        private JVMNameBuffer() {
        }

        public void append(@NotNull JVMName jVMName) {
            if (jVMName == null) {
                JVMNameBuffer.a(0);
            }
            this.a.add(jVMName);
        }

        public void append(char c2) {
            this.append(Character.toString(c2));
        }

        public void append(String string) {
            this.a.add(JVMNameUtil.getJVMRawText(string));
        }

        public JVMName toName() {
            final ArrayList<JVMName> arrayList = new ArrayList<JVMName>();
            for (JVMName jVMName : this.a) {
                if (jVMName instanceof JVMRawText && !arrayList.isEmpty() && arrayList.get(arrayList.size() - 1) instanceof JVMRawText) {
                    JVMRawText jVMRawText = (JVMRawText)arrayList.get(arrayList.size() - 1);
                    jVMRawText.setName(jVMRawText.getName() + ((JVMRawText)jVMName).getName());
                    continue;
                }
                arrayList.add(jVMName);
            }
            if (arrayList.size() == 1) {
                return (JVMName)arrayList.get(0);
            }
            if (arrayList.isEmpty()) {
                return new JVMRawText("");
            }
            return new JVMName(){
                String myName = null;

                @Override
                public String getName(DebugProcessImpl debugProcessImpl) throws EvaluateException {
                    if (this.myName == null) {
                        String string = "";
                        for (JVMName jVMName : arrayList) {
                            string = string + jVMName.getName(debugProcessImpl);
                        }
                        this.myName = string;
                    }
                    return this.myName;
                }

                @Override
                public String getDisplayName(DebugProcessImpl debugProcessImpl) {
                    if (this.myName == null) {
                        String string = "";
                        for (JVMName jVMName : arrayList) {
                            string = string + jVMName.getDisplayName(debugProcessImpl);
                        }
                        return string;
                    }
                    return this.myName;
                }
            };
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/debugger/engine/JVMNameUtil$JVMNameBuffer", "append"));
        }
    }
}

