/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaBreakpointHandler;
import com.intellij.debugger.engine.JavaBreakpointHandlerFactory;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.JavaValueMarker;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.impl.SourceCodeChecker;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.memory.component.InstancesTracker;
import com.intellij.debugger.memory.component.MemoryViewDebugProcessData;
import com.intellij.debugger.memory.ui.ClassesFilteredView;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.AlternativeSourceNotificationProvider;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.impl.ThreadsPanel;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.overhead.OverheadView;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.JavaDebuggerEditorsProvider;

public class JavaDebugProcess
extends XDebugProcess {
    private final DebuggerSession e;
    private final JavaDebuggerEditorsProvider b;
    private final XBreakpointHandler<?>[] d;
    private final NodeManagerImpl a;
    private static final JavaBreakpointHandlerFactory[] c = new JavaBreakpointHandlerFactory[]{JavaBreakpointHandler.JavaLineBreakpointHandler::new, JavaBreakpointHandler.JavaExceptionBreakpointHandler::new, JavaBreakpointHandler.JavaFieldBreakpointHandler::new, JavaBreakpointHandler.JavaMethodBreakpointHandler::new, JavaBreakpointHandler.JavaWildcardBreakpointHandler::new};

    public static JavaDebugProcess create(@NotNull XDebugSession xDebugSession, DebuggerSession debuggerSession) {
        if (xDebugSession == null) {
            JavaDebugProcess.b(0);
        }
        JavaDebugProcess javaDebugProcess = new JavaDebugProcess(xDebugSession, debuggerSession);
        debuggerSession.getProcess().setXDebugProcess(javaDebugProcess);
        return javaDebugProcess;
    }

    protected JavaDebugProcess(final @NotNull XDebugSession xDebugSession, final DebuggerSession debuggerSession) {
        if (xDebugSession == null) {
            JavaDebugProcess.b(1);
        }
        super(xDebugSession);
        this.e = debuggerSession;
        this.b = new JavaDebuggerEditorsProvider();
        final DebugProcessImpl debugProcessImpl = debuggerSession.getProcess();
        this.d = (XBreakpointHandler[])StreamEx.of((Object[])c).append(Extensions.getExtensions(JavaBreakpointHandlerFactory.EP_NAME)).map(javaBreakpointHandlerFactory -> javaBreakpointHandlerFactory.createHandler(debugProcessImpl)).toArray(XBreakpointHandler[]::new);
        this.e.getContextManager().addListener(new DebuggerContextListener(){

            @Override
            public void changeEvent(final @NotNull DebuggerContextImpl debuggerContextImpl, DebuggerSession.Event event) {
                if (debuggerContextImpl == null) {
                    1.a(0);
                }
                if (event == DebuggerSession.Event.PAUSE || event == DebuggerSession.Event.CONTEXT || event == DebuggerSession.Event.REFRESH || event == DebuggerSession.Event.REFRESH_WITH_STACK && JavaDebugProcess.this.e.isPaused()) {
                    final SuspendContextImpl suspendContextImpl = debuggerContextImpl.getSuspendContext();
                    if (suspendContextImpl != null && (JavaDebugProcess.this.a(debuggerContextImpl) || event == DebuggerSession.Event.REFRESH_WITH_STACK)) {
                        debugProcessImpl.getManagerThread().schedule(new SuspendContextCommandImpl(suspendContextImpl){

                            @Override
                            public void contextAction(@NotNull SuspendContextImpl suspendContextImpl2) throws Exception {
                                if (suspendContextImpl2 == null) {
                                    1.b(0);
                                }
                                ThreadReferenceProxyImpl threadReferenceProxyImpl = debuggerContextImpl.getThreadProxy();
                                suspendContextImpl.initExecutionStacks(threadReferenceProxyImpl);
                                Pair pair2 = (Pair)ContainerUtil.getFirstItem(DebuggerUtilsEx.getEventDescriptors(suspendContextImpl));
                                if (pair2 != null) {
                                    XBreakpoint xBreakpoint = ((Breakpoint)pair2.getFirst()).getXBreakpoint();
                                    Event event = (Event)pair2.getSecond();
                                    if (xBreakpoint != null && event instanceof LocatableEvent && threadReferenceProxyImpl != null && ((LocatableEvent)event).thread() == threadReferenceProxyImpl.getThreadReference()) {
                                        ((XDebugSessionImpl)JavaDebugProcess.this.getSession()).breakpointReachedNoProcessing(xBreakpoint, (XSuspendContext)suspendContextImpl);
                                        JavaDebugProcess.this.b(debuggerContextImpl);
                                        SourceCodeChecker.checkSource(debuggerContextImpl);
                                        return;
                                    }
                                }
                                JavaDebugProcess.this.getSession().positionReached((XSuspendContext)suspendContextImpl);
                                JavaDebugProcess.this.b(debuggerContextImpl);
                                SourceCodeChecker.checkSource(debuggerContextImpl);
                            }

                            private static /* synthetic */ void b(int n2) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaDebugProcess$1$1", "contextAction"));
                            }
                        });
                    }
                } else if (event == DebuggerSession.Event.ATTACHED) {
                    JavaDebugProcess.this.getSession().rebuildViews();
                }
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContext", "com/intellij/debugger/engine/JavaDebugProcess$1", "changeEvent"));
            }
        });
        this.a = new NodeManagerImpl(xDebugSession.getProject(), null){

            @Override
            @NotNull
            public DebuggerTreeNodeImpl createNode(NodeDescriptor nodeDescriptor, EvaluationContext evaluationContext) {
                DebuggerTreeNodeImpl debuggerTreeNodeImpl = new DebuggerTreeNodeImpl(null, nodeDescriptor);
                if (debuggerTreeNodeImpl == null) {
                    2.c(0);
                }
                return debuggerTreeNodeImpl;
            }

            @Override
            public DebuggerTreeNodeImpl createMessageNode(MessageDescriptor messageDescriptor) {
                return new DebuggerTreeNodeImpl(null, messageDescriptor);
            }

            @Override
            @NotNull
            public DebuggerTreeNodeImpl createMessageNode(String string) {
                DebuggerTreeNodeImpl debuggerTreeNodeImpl = new DebuggerTreeNodeImpl(null, new MessageDescriptor(string));
                if (debuggerTreeNodeImpl == null) {
                    2.c(1);
                }
                return debuggerTreeNodeImpl;
            }

            private static /* synthetic */ void c(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/debugger/engine/JavaDebugProcess$2";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createNode";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createMessageNode";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        xDebugSession.addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                JavaDebugProcess.this.saveNodeHistory();
                this.a(xDebugSession.getCurrentStackFrame());
            }

            public void stackFrameChanged() {
                XStackFrame xStackFrame = xDebugSession.getCurrentStackFrame();
                if (xStackFrame instanceof JavaStackFrame) {
                    this.a(xStackFrame);
                    StackFrameProxyImpl stackFrameProxyImpl = ((JavaStackFrame)xStackFrame).getStackFrameProxy();
                    DebuggerContextUtil.setStackFrame(debuggerSession.getContextManager(), stackFrameProxyImpl);
                    JavaDebugProcess.this.a(stackFrameProxyImpl);
                }
            }

            private void a(@Nullable XStackFrame xStackFrame) {
                VirtualFile virtualFile;
                XSourcePosition xSourcePosition;
                if (xStackFrame != null && (xSourcePosition = xStackFrame.getSourcePosition()) != null && !AlternativeSourceNotificationProvider.isFileProcessed(virtualFile = xSourcePosition.getFile())) {
                    EditorNotifications.getInstance((Project)xDebugSession.getProject()).updateNotifications(virtualFile);
                }
            }
        });
    }

    private void b(DebuggerContextImpl debuggerContextImpl) {
        SuspendContextImpl suspendContextImpl = debuggerContextImpl.getSuspendContext();
        if (suspendContextImpl != null && !suspendContextImpl.suspends(debuggerContextImpl.getThreadProxy())) {
            ((XDebugSessionImpl)this.getSession()).unsetPaused();
        }
    }

    private boolean a(DebuggerContextImpl debuggerContextImpl) {
        SuspendContextImpl suspendContextImpl = debuggerContextImpl.getSuspendContext();
        SuspendContextImpl suspendContextImpl2 = (SuspendContextImpl)this.getSession().getSuspendContext();
        if (suspendContextImpl != null && !((Object)((Object)suspendContextImpl)).equals((Object)suspendContextImpl2)) {
            return true;
        }
        JavaExecutionStack javaExecutionStack = suspendContextImpl2 != null ? suspendContextImpl2.getActiveExecutionStack() : null;
        return javaExecutionStack == null || !Comparing.equal((Object)debuggerContextImpl.getThreadProxy(), (Object)javaExecutionStack.getThreadProxy());
    }

    public void saveNodeHistory() {
        this.a(this.a().getContext().getFrameProxy());
    }

    private void a(final StackFrameProxyImpl stackFrameProxyImpl) {
        this.e.getProcess().getManagerThread().invoke(new DebuggerCommandImpl(){

            @Override
            protected void action() throws Exception {
                JavaDebugProcess.this.a.setHistoryByContext(stackFrameProxyImpl);
            }

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }
        });
    }

    private DebuggerStateManager a() {
        return this.e.getContextManager();
    }

    public DebuggerSession getDebuggerSession() {
        return this.e;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        JavaDebuggerEditorsProvider javaDebuggerEditorsProvider = this.b;
        if (javaDebuggerEditorsProvider == null) {
            JavaDebugProcess.b(2);
        }
        return javaDebuggerEditorsProvider;
    }

    public void startStepOver(@Nullable XSuspendContext xSuspendContext) {
        this.e.stepOver(false);
    }

    public void startStepInto(@Nullable XSuspendContext xSuspendContext) {
        this.e.stepInto(false, null);
    }

    public void startForceStepInto(@Nullable XSuspendContext xSuspendContext) {
        this.e.stepInto(true, null);
    }

    public void startStepOut(@Nullable XSuspendContext xSuspendContext) {
        this.e.stepOut();
    }

    public void stop() {
        this.e.dispose();
        this.a.dispose();
    }

    public void startPausing() {
        this.e.pause();
    }

    public void resume(@Nullable XSuspendContext xSuspendContext) {
        this.e.resume();
    }

    public void runToPosition(@NotNull XSourcePosition xSourcePosition, @Nullable XSuspendContext xSuspendContext) {
        if (xSourcePosition == null) {
            JavaDebugProcess.b(3);
        }
        this.e.runToCursor(xSourcePosition, false);
    }

    @NotNull
    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        if (this.d == null) {
            JavaDebugProcess.b(4);
        }
        return this.d;
    }

    public boolean checkCanInitBreakpoints() {
        return false;
    }

    @Nullable
    protected ProcessHandler doGetProcessHandler() {
        return this.e.getProcess().getProcessHandler();
    }

    @NotNull
    public ExecutionConsole createConsole() {
        ExecutionConsole executionConsole = this.e.getProcess().getExecutionResult().getExecutionConsole();
        if (executionConsole != null) {
            ExecutionConsole executionConsole2 = executionConsole;
            if (executionConsole2 == null) {
                JavaDebugProcess.b(5);
            }
            return executionConsole2;
        }
        ExecutionConsole executionConsole3 = super.createConsole();
        if (executionConsole3 == null) {
            JavaDebugProcess.b(6);
        }
        return executionConsole3;
    }

    @NotNull
    public XDebugTabLayouter createTabLayouter() {
        XDebugTabLayouter xDebugTabLayouter = new XDebugTabLayouter(){

            public void registerAdditionalContent(@NotNull RunnerLayoutUi runnerLayoutUi) {
                if (runnerLayoutUi == null) {
                    5.a(0);
                }
                this.c(runnerLayoutUi);
                this.a(runnerLayoutUi);
                this.b(runnerLayoutUi);
            }

            @NotNull
            public Content registerConsoleContent(@NotNull RunnerLayoutUi runnerLayoutUi, @NotNull ExecutionConsole executionConsole) {
                if (runnerLayoutUi == null) {
                    5.a(1);
                }
                if (executionConsole == null) {
                    5.a(2);
                }
                Content content = null;
                if (executionConsole instanceof ExecutionConsoleEx) {
                    ((ExecutionConsoleEx)executionConsole).buildUi(runnerLayoutUi);
                    content = runnerLayoutUi.findContent("ConsoleContent");
                }
                if (content == null) {
                    content = super.registerConsoleContent(runnerLayoutUi, executionConsole);
                }
                Content content2 = content;
                if (content2 == null) {
                    5.a(3);
                }
                return content2;
            }

            private void c(@NotNull RunnerLayoutUi runnerLayoutUi) {
                if (runnerLayoutUi == null) {
                    5.a(4);
                }
                final ThreadsPanel threadsPanel = new ThreadsPanel(JavaDebugProcess.this.e.getProject(), JavaDebugProcess.this.a());
                final Content content = runnerLayoutUi.createContent("ThreadsContent", (JComponent)threadsPanel, XDebuggerBundle.message((String)"debugger.session.tab.threads.title", (Object[])new Object[0]), AllIcons.Debugger.Threads, null);
                content.setCloseable(false);
                runnerLayoutUi.addContent(content, 0, PlaceInGrid.left, true);
                runnerLayoutUi.addListener((ContentManagerListener)new ContentManagerAdapter(){

                    public void selectionChanged(ContentManagerEvent contentManagerEvent) {
                        if (contentManagerEvent.getContent() == content) {
                            if (content.isSelected()) {
                                threadsPanel.setUpdateEnabled(true);
                                if (threadsPanel.isRefreshNeeded()) {
                                    threadsPanel.rebuildIfVisible(DebuggerSession.Event.CONTEXT);
                                }
                            } else {
                                threadsPanel.setUpdateEnabled(false);
                            }
                        }
                    }
                }, (Disposable)content);
            }

            private void a(@NotNull RunnerLayoutUi runnerLayoutUi) {
                if (runnerLayoutUi == null) {
                    5.a(5);
                }
                if (!Registry.is((String)"debugger.enable.memory.view")) {
                    return;
                }
                final XDebugSession xDebugSession = JavaDebugProcess.this.getSession();
                DebugProcessImpl debugProcessImpl = JavaDebugProcess.this.e.getProcess();
                InstancesTracker instancesTracker = InstancesTracker.getInstance(JavaDebugProcess.this.e.getProject());
                final ClassesFilteredView classesFilteredView = new ClassesFilteredView(xDebugSession, debugProcessImpl, instancesTracker);
                final Content content = runnerLayoutUi.createContent("MemoryView", (JComponent)((Object)classesFilteredView), "Memory", AllIcons.Debugger.MemoryView.Active, null);
                content.setCloseable(false);
                content.setShouldDisposeContent(true);
                final MemoryViewDebugProcessData memoryViewDebugProcessData = new MemoryViewDebugProcessData();
                debugProcessImpl.putUserData(MemoryViewDebugProcessData.KEY, memoryViewDebugProcessData);
                xDebugSession.addSessionListener(new XDebugSessionListener(){

                    public void sessionStopped() {
                        xDebugSession.removeSessionListener((XDebugSessionListener)this);
                        memoryViewDebugProcessData.getTrackedStacks().clear();
                    }
                });
                runnerLayoutUi.addContent(content, 0, PlaceInGrid.right, true);
                final DebuggerManagerThreadImpl debuggerManagerThreadImpl = debugProcessImpl.getManagerThread();
                runnerLayoutUi.addListener((ContentManagerListener)new ContentManagerAdapter(){

                    public void selectionChanged(ContentManagerEvent contentManagerEvent) {
                        if (contentManagerEvent != null && contentManagerEvent.getContent() == content) {
                            classesFilteredView.setActive(content.isSelected(), debuggerManagerThreadImpl);
                        }
                    }
                }, (Disposable)content);
            }

            private void b(@NotNull RunnerLayoutUi runnerLayoutUi) {
                if (runnerLayoutUi == null) {
                    5.a(6);
                }
                if (!Registry.is((String)"debugger.enable.overhead.monitor")) {
                    return;
                }
                DebugProcessImpl debugProcessImpl = JavaDebugProcess.this.e.getProcess();
                OverheadView overheadView = new OverheadView(debugProcessImpl);
                Content content = runnerLayoutUi.createContent("OverheadMonitor", (JComponent)((Object)overheadView), "Overhead", AllIcons.Debugger.Overhead, null);
                overheadView.setBouncer(() -> {
                    if (runnerLayoutUi == null) {
                        5.a(7);
                    }
                    runnerLayoutUi.setBouncing(content, true);
                });
                content.setCloseable(false);
                content.setShouldDisposeContent(true);
                runnerLayoutUi.addContent(content, 0, PlaceInGrid.right, true);
            }

            private static /* synthetic */ void a(int n2) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n3;
                String string;
                switch (n2) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        n3 = 3;
                        break;
                    }
                    case 3: {
                        n3 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ui";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "console";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/debugger/engine/JavaDebugProcess$5";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/debugger/engine/JavaDebugProcess$5";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "registerConsoleContent";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "registerAdditionalContent";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "registerConsoleContent";
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "registerThreadsPanel";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "registerMemoryViewPanel";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "registerOverheadMonitor";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$registerOverheadMonitor$0";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n2) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (xDebugTabLayouter == null) {
            JavaDebugProcess.b(7);
        }
        return xDebugTabLayouter;
    }

    public void registerAdditionalActions(@NotNull DefaultActionGroup defaultActionGroup, @NotNull DefaultActionGroup defaultActionGroup2, @NotNull DefaultActionGroup defaultActionGroup3) {
        if (defaultActionGroup == null) {
            JavaDebugProcess.b(8);
        }
        if (defaultActionGroup2 == null) {
            JavaDebugProcess.b(9);
        }
        if (defaultActionGroup3 == null) {
            JavaDebugProcess.b(10);
        }
        Constraints constraints = new Constraints(Anchor.BEFORE, "Runner.Layout");
        defaultActionGroup.add((AnAction)Separator.getInstance(), constraints);
        defaultActionGroup.add(ActionManager.getInstance().getAction("DumpThreads"), constraints);
        defaultActionGroup.add((AnAction)Separator.getInstance(), constraints);
        Constraints constraints2 = new Constraints(Anchor.BEFORE, "XDebugger.ToggleSortValues");
        defaultActionGroup3.addAction((AnAction)new WatchLastMethodReturnValueAction(), constraints2);
        defaultActionGroup3.addAction((AnAction)new AutoVarsSwitchAction(), constraints2);
    }

    @Nullable
    private static DebugProcessImpl a(@Nullable Project project2) {
        XDebugProcess xDebugProcess;
        XDebugSession xDebugSession;
        if (project2 != null && (xDebugSession = XDebuggerManager.getInstance((Project)project2).getCurrentSession()) != null && (xDebugProcess = xDebugSession.getDebugProcess()) instanceof JavaDebugProcess) {
            return ((JavaDebugProcess)xDebugProcess).getDebuggerSession().getProcess();
        }
        return null;
    }

    public NodeManagerImpl getNodeManager() {
        return this.a;
    }

    public String getCurrentStateMessage() {
        String string = this.e.getStateDescription();
        return string != null ? string : super.getCurrentStateMessage();
    }

    @Nullable
    public XValueMarkerProvider<?, ?> createValueMarkerProvider() {
        return new JavaValueMarker();
    }

    public boolean isLibraryFrameFilterSupported() {
        return true;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/JavaDebugProcess";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftToolbar";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topToolbar";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/JavaDebugProcess";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorsProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointHandlers";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTabLayouter";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runToPosition";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerAdditionalActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class WatchLastMethodReturnValueAction
    extends ToggleAction {
        private final String b = DebuggerBundle.message((String)"action.watches.method.return.value.enable", (Object[])new Object[0]);
        private final String a = DebuggerBundle.message((String)"action.watches.method.return.value.unavailable.reason", (Object[])new Object[0]);

        public WatchLastMethodReturnValueAction() {
            super("", DebuggerBundle.message((String)"action.watch.method.return.value.description", (Object[])new Object[0]), null);
        }

        public void update(@NotNull AnActionEvent anActionEvent) {
            if (anActionEvent == null) {
                WatchLastMethodReturnValueAction.a(0);
            }
            super.update(anActionEvent);
            Presentation presentation = anActionEvent.getPresentation();
            DebugProcessImpl debugProcessImpl = JavaDebugProcess.a(anActionEvent.getProject());
            if (debugProcessImpl == null || debugProcessImpl.canGetMethodReturnValue()) {
                presentation.setEnabled(true);
                presentation.setText(this.b);
            } else {
                presentation.setEnabled(false);
                presentation.setText(this.a);
            }
        }

        public boolean isSelected(AnActionEvent anActionEvent) {
            return DebuggerSettings.getInstance().WATCH_RETURN_VALUES;
        }

        public void setSelected(AnActionEvent anActionEvent, boolean bl2) {
            DebuggerSettings.getInstance().WATCH_RETURN_VALUES = bl2;
            DebugProcessImpl debugProcessImpl = JavaDebugProcess.a(anActionEvent.getProject());
            if (debugProcessImpl != null) {
                debugProcessImpl.setWatchMethodReturnValuesEnabled(bl2);
            }
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/engine/JavaDebugProcess$WatchLastMethodReturnValueAction", "update"));
        }
    }

    private static class AutoVarsSwitchAction
    extends ToggleAction {
        private volatile boolean a;

        public AutoVarsSwitchAction() {
            super(DebuggerBundle.message((String)"action.auto.variables.mode", (Object[])new Object[0]), DebuggerBundle.message((String)"action.auto.variables.mode.description", (Object[])new Object[0]), null);
            this.a = DebuggerSettings.getInstance().AUTO_VARIABLES_MODE;
        }

        public boolean isSelected(AnActionEvent anActionEvent) {
            return this.a;
        }

        public void setSelected(AnActionEvent anActionEvent, boolean bl2) {
            this.a = bl2;
            DebuggerSettings.getInstance().AUTO_VARIABLES_MODE = bl2;
            XDebuggerUtilImpl.rebuildAllSessionsViews((Project)anActionEvent.getProject());
        }
    }
}

