/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.sun.jdi.InternalException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.event.EventSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.jetbrains.annotations.NotNull;

public class SuspendManagerImpl
implements SuspendManager {
    private static final Logger b = Logger.getInstance((String)"#com.intellij.debugger.engine.SuspendManager");
    private final Deque<SuspendContextImpl> d;
    private final Deque<SuspendContextImpl> a;
    private final Set<ThreadReferenceProxyImpl> e;
    private final DebugProcessImpl c;
    public int suspends;

    public SuspendManagerImpl(@NotNull DebugProcessImpl debugProcessImpl) {
        if (debugProcessImpl == null) {
            SuspendManagerImpl.a(0);
        }
        this.d = new ConcurrentLinkedDeque<SuspendContextImpl>();
        this.a = new ConcurrentLinkedDeque<SuspendContextImpl>();
        this.e = Collections.synchronizedSet(new HashSet());
        this.suspends = 0;
        this.c = debugProcessImpl;
        this.c.addDebugProcessListener(new DebugProcessAdapterImpl(){

            @Override
            public void processDetached(DebugProcessImpl debugProcessImpl, boolean bl2) {
                SuspendManagerImpl.this.d.clear();
                SuspendManagerImpl.this.a.clear();
                SuspendManagerImpl.this.e.clear();
            }
        });
    }

    @Override
    public SuspendContextImpl pushSuspendContext(int n2, int n3) {
        SuspendContextImpl suspendContextImpl = new SuspendContextImpl(this.c, n2, n3, null){

            @Override
            protected void resumeImpl() {
                b.debug("Start resuming...");
                SuspendManagerImpl.this.c.logThreads();
                switch (this.getSuspendPolicy()) {
                    case 2: {
                        int n2 = 5;
                        while (--n2 > 0) {
                            try {
                                SuspendManagerImpl.this.c.getVirtualMachineProxy().resume();
                            }
                            catch (InternalException internalException) {
                                if (internalException.errorCode() == 13) continue;
                                b.error((Throwable)internalException);
                            }
                            break;
                        }
                        b.debug("VM resumed ");
                        break;
                    }
                    case 1: {
                        SuspendManagerImpl.this.e.remove(this.getThread());
                        this.getThread().resume();
                        if (!b.isDebugEnabled()) break;
                        b.debug("Thread resumed : " + this.getThread().toString());
                        break;
                    }
                    case 0: {
                        b.debug("None resumed");
                    }
                }
                if (b.isDebugEnabled()) {
                    b.debug("Suspends = " + SuspendManagerImpl.this.suspends);
                }
                SuspendManagerImpl.this.c.logThreads();
            }
        };
        this.a(suspendContextImpl);
        return suspendContextImpl;
    }

    @Override
    public SuspendContextImpl pushSuspendContext(final EventSet eventSet) {
        SuspendContextImpl suspendContextImpl = new SuspendContextImpl(this.c, eventSet.suspendPolicy(), eventSet.size(), eventSet){

            @Override
            protected void resumeImpl() {
                if (b.isDebugEnabled()) {
                    b.debug("Start resuming eventSet " + eventSet.toString() + " suspendPolicy = " + eventSet.suspendPolicy() + ",size = " + eventSet.size());
                }
                SuspendManagerImpl.this.c.logThreads();
                int n2 = 5;
                while (--n2 > 0) {
                    try {
                        eventSet.resume();
                        break;
                    }
                    catch (ObjectCollectedException objectCollectedException) {
                        b.info((Throwable)objectCollectedException);
                    }
                    catch (InternalException internalException) {
                        if (internalException.errorCode() == 13 && eventSet.suspendPolicy() == 2) continue;
                        b.error((Throwable)internalException);
                        break;
                    }
                }
                b.debug("Set resumed ");
                SuspendManagerImpl.this.c.logThreads();
            }
        };
        this.a(suspendContextImpl);
        return suspendContextImpl;
    }

    private void a(SuspendContextImpl suspendContextImpl) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.d.addFirst(suspendContextImpl);
        ++this.suspends;
        if (b.isDebugEnabled()) {
            b.debug("Push context : Suspends = " + this.suspends);
        }
    }

    @Override
    public void resume(SuspendContextImpl suspendContextImpl) {
        SuspendManagerUtil.prepareForResume(suspendContextImpl);
        this.c.logThreads();
        this.popContext(suspendContextImpl);
        suspendContextImpl.resume();
        this.c.clearCashes(suspendContextImpl.getSuspendPolicy());
    }

    @Override
    public void popFrame(SuspendContextImpl suspendContextImpl) {
        this.popContext(suspendContextImpl);
        SuspendContextImpl suspendContextImpl2 = this.pushSuspendContext(suspendContextImpl.getSuspendPolicy(), 0);
        suspendContextImpl2.setThread(suspendContextImpl.getThread().getThreadReference());
        this.notifyPaused(suspendContextImpl2);
    }

    @Override
    public SuspendContextImpl getPausedContext() {
        return this.a.peekFirst();
    }

    public void popContext(SuspendContextImpl suspendContextImpl) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        --this.suspends;
        if (b.isDebugEnabled()) {
            b.debug("popContext, suspends = " + this.suspends);
        }
        this.d.remove((Object)suspendContextImpl);
        this.a.remove((Object)suspendContextImpl);
    }

    void pushPausedContext(SuspendContextImpl suspendContextImpl) {
        if (b.isDebugEnabled()) {
            b.assertTrue(this.d.contains((Object)suspendContextImpl));
        }
        this.a.addFirst(suspendContextImpl);
    }

    public boolean hasEventContext(SuspendContextImpl suspendContextImpl) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return this.d.contains((Object)suspendContextImpl);
    }

    @Override
    public List<SuspendContextImpl> getEventContexts() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return new ArrayList<SuspendContextImpl>(this.d);
    }

    @Override
    public boolean isFrozen(ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        return this.e.contains(threadReferenceProxyImpl);
    }

    @Override
    public boolean isSuspended(ThreadReferenceProxyImpl threadReferenceProxyImpl) throws ObjectCollectedException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        boolean bl2 = this.isFrozen(threadReferenceProxyImpl) ? true : this.d.stream().anyMatch(suspendContextImpl -> suspendContextImpl.suspends(threadReferenceProxyImpl));
        return bl2 && (threadReferenceProxyImpl == null || threadReferenceProxyImpl.isSuspended());
    }

    @Override
    public void suspendThread(SuspendContextImpl suspendContextImpl, ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        b.assertTrue(threadReferenceProxyImpl != suspendContextImpl.getThread(), (Object)"Thread is already suspended at the breakpoint");
        if (suspendContextImpl.isExplicitlyResumed(threadReferenceProxyImpl)) {
            suspendContextImpl.myResumedThreads.remove(threadReferenceProxyImpl);
            threadReferenceProxyImpl.suspend();
        }
    }

    @Override
    public void resumeThread(SuspendContextImpl suspendContextImpl, @NotNull ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        if (threadReferenceProxyImpl == null) {
            SuspendManagerImpl.a(1);
        }
        b.assertTrue(!suspendContextImpl.isExplicitlyResumed(threadReferenceProxyImpl));
        if (suspendContextImpl.myResumedThreads == null) {
            suspendContextImpl.myResumedThreads = new HashSet<ThreadReferenceProxyImpl>();
        }
        suspendContextImpl.myResumedThreads.add(threadReferenceProxyImpl);
        threadReferenceProxyImpl.resume();
    }

    @Override
    public void freezeThread(ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        if (this.e.add(threadReferenceProxyImpl)) {
            threadReferenceProxyImpl.suspend();
        }
    }

    @Override
    public void unfreezeThread(ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        if (this.e.remove(threadReferenceProxyImpl)) {
            threadReferenceProxyImpl.resume();
        }
    }

    private void b(final SuspendContextImpl suspendContextImpl) {
        b.assertTrue(suspendContextImpl.myVotesToVote > 0);
        --suspendContextImpl.myVotesToVote;
        if (b.isDebugEnabled()) {
            b.debug("myVotesToVote = " + suspendContextImpl.myVotesToVote);
        }
        if (suspendContextImpl.myVotesToVote == 0) {
            if (suspendContextImpl.myIsVotedForResume) {
                this.c.getManagerThread().schedule(new DebuggerCommandImpl(){

                    @Override
                    protected void action() throws Exception {
                        SuspendManagerImpl.this.resume(suspendContextImpl);
                    }

                    @Override
                    public PrioritizedTask.Priority getPriority() {
                        return PrioritizedTask.Priority.HIGH;
                    }
                });
            } else {
                b.debug("vote paused");
                this.c.logThreads();
                this.c.cancelRunToCursorBreakpoint();
                if (!Registry.is((String)"debugger.keep.step.requests")) {
                    ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContextImpl.getThread();
                    this.c.deleteStepRequests(threadReferenceProxyImpl != null ? threadReferenceProxyImpl.getThreadReference() : null);
                }
                this.notifyPaused(suspendContextImpl);
            }
        }
    }

    public void notifyPaused(SuspendContextImpl suspendContextImpl) {
        this.pushPausedContext(suspendContextImpl);
        ((DebugProcessListener)this.c.myDebugProcessDispatcher.getMulticaster()).paused((SuspendContext)suspendContextImpl);
    }

    @Override
    public void voteResume(SuspendContextImpl suspendContextImpl) {
        b.debug("Resume voted");
        this.b(suspendContextImpl);
    }

    @Override
    public void voteSuspend(SuspendContextImpl suspendContextImpl) {
        suspendContextImpl.myIsVotedForResume = false;
        this.b(suspendContextImpl);
    }

    public List<SuspendContextImpl> getPausedContexts() {
        return new ArrayList<SuspendContextImpl>(this.a);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/SuspendManagerImpl";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resumeThread";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

