/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.TypeEvaluator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class NewClassInstanceEvaluator
implements Evaluator {
    private static final Logger a = Logger.getInstance(NewClassInstanceEvaluator.class);
    private final TypeEvaluator c;
    private final JVMName b;
    private final Evaluator[] d;

    public NewClassInstanceEvaluator(TypeEvaluator typeEvaluator, JVMName jVMName, Evaluator[] evaluatorArray) {
        this.c = typeEvaluator;
        this.b = jVMName;
        this.d = evaluatorArray;
    }

    @Override
    public Object evaluate(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        ObjectReference objectReference;
        List list2;
        DebugProcessImpl debugProcessImpl = evaluationContextImpl.getDebugProcess();
        Object object2 = this.c.evaluate(evaluationContextImpl);
        if (!(object2 instanceof ClassType)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.evaluate.class.type", (Object[])new Object[0]));
        }
        ClassType classType = (ClassType)object2;
        Method method = DebuggerUtils.findMethod((ReferenceType)classType, (String)"<init>", (String)this.b.getName(debugProcessImpl));
        if (method == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.resolve.constructor", (Object[])new Object[]{this.b.getDisplayName(debugProcessImpl)}));
        }
        if (!ArrayUtil.isEmpty((Object[])this.d)) {
            list2 = new ArrayList(this.d.length);
            for (Evaluator evaluator : this.d) {
                Object object = evaluator.evaluate(evaluationContextImpl);
                if (!(object instanceof Value) && object != null) {
                    a.error("Unable to call newInstance, evaluator " + evaluator + " result is not Value, but " + object);
                }
                list2.add((Value)object);
            }
        } else {
            list2 = Collections.emptyList();
        }
        try {
            objectReference = debugProcessImpl.newInstance(evaluationContextImpl, classType, method, list2);
        }
        catch (EvaluateException evaluateException) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)evaluateException);
        }
        return objectReference;
    }
}

