/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Type;
import com.sun.jdi.Value;

public class TypeCastEvaluator
implements Evaluator {
    private final Evaluator c;
    private final String a;
    private final boolean b;

    public TypeCastEvaluator(Evaluator evaluator, String string, boolean bl2) {
        this.c = evaluator;
        this.a = string;
        this.b = bl2;
    }

    @Override
    public Object evaluate(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        Type type;
        Value value = (Value)this.c.evaluate(evaluationContextImpl);
        if (value == null) {
            if (this.b) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.cast.null", (Object[])new Object[]{this.a}));
            }
            return null;
        }
        VirtualMachineProxyImpl virtualMachineProxyImpl = evaluationContextImpl.getDebugProcess().getVirtualMachineProxy();
        if (DebuggerUtils.isInteger((Value)value)) {
            if ((value = DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.a, ((PrimitiveValue)value).longValue())) == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.cast.numeric", (Object[])new Object[]{this.a}));
            }
        } else if (DebuggerUtils.isNumeric((Value)value)) {
            if ((value = DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.a, ((PrimitiveValue)value).doubleValue())) == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.cast.numeric", (Object[])new Object[]{this.a}));
            }
        } else if (value instanceof BooleanValue) {
            if ((value = DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.a, ((BooleanValue)value).booleanValue())) == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.cast.boolean", (Object[])new Object[]{this.a}));
            }
        } else if (value instanceof CharValue) {
            if ((value = DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.a, ((CharValue)value).charValue())) == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.cast.char", (Object[])new Object[]{this.a}));
            }
        } else if (value instanceof ObjectReference && !DebuggerUtils.instanceOf((Type)(type = value.type()), (String)this.a)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.cast.object", (Object[])new Object[]{type.name(), this.a}));
        }
        return value;
    }
}

