/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DebuggerContextImpl
implements DebuggerContext {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerContextImpl");
    public static final DebuggerContextImpl EMPTY_CONTEXT = DebuggerContextImpl.createDebuggerContext(null, null, null, null);
    private boolean g;
    @Nullable
    private final DebuggerSession e;
    private final SuspendContextImpl f;
    private final ThreadReferenceProxyImpl h;
    private StackFrameProxyImpl b;
    private SourcePosition c;
    private PsiElement d;

    private DebuggerContextImpl(@Nullable DebuggerSession debuggerSession, @Nullable SuspendContextImpl suspendContextImpl, ThreadReferenceProxyImpl threadReferenceProxyImpl, StackFrameProxyImpl stackFrameProxyImpl, SourcePosition sourcePosition, PsiElement psiElement, boolean bl2) {
        a.assertTrue(stackFrameProxyImpl == null || threadReferenceProxyImpl == null || threadReferenceProxyImpl == stackFrameProxyImpl.threadProxy());
        this.e = debuggerSession;
        this.h = threadReferenceProxyImpl;
        this.b = stackFrameProxyImpl;
        this.c = sourcePosition;
        this.f = suspendContextImpl;
        this.d = psiElement;
        this.g = bl2;
    }

    @Nullable
    public DebuggerSession getDebuggerSession() {
        return this.e;
    }

    @Nullable
    public DebugProcessImpl getDebugProcess() {
        return this.e != null ? this.e.getProcess() : null;
    }

    @Nullable
    public ThreadReferenceProxyImpl getThreadProxy() {
        return this.h;
    }

    public SuspendContextImpl getSuspendContext() {
        return this.f;
    }

    public Project getProject() {
        return this.e != null ? this.e.getProject() : null;
    }

    @Nullable
    public StackFrameProxyImpl getFrameProxy() {
        a.assertTrue(this.g);
        return this.b;
    }

    public SourcePosition getSourcePosition() {
        a.assertTrue(this.g);
        return this.c;
    }

    public PsiElement getContextElement() {
        a.assertTrue(this.g);
        PsiElement psiElement = this.d;
        if (psiElement != null && !psiElement.isValid()) {
            this.d = ContextUtil.getContextElement(this.c);
        }
        return this.d;
    }

    public EvaluationContextImpl createEvaluationContext(Value value) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return new EvaluationContextImpl(this.getSuspendContext(), this.getFrameProxy(), value);
    }

    @Nullable
    public EvaluationContextImpl createEvaluationContext() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        SuspendContextImpl suspendContextImpl = this.getSuspendContext();
        return suspendContextImpl != null ? new EvaluationContextImpl(suspendContextImpl, this.getFrameProxy()) : null;
    }

    @NotNull
    public static DebuggerContextImpl createDebuggerContext(@Nullable DebuggerSession debuggerSession, @Nullable SuspendContextImpl suspendContextImpl, ThreadReferenceProxyImpl threadReferenceProxyImpl, StackFrameProxyImpl stackFrameProxyImpl) {
        a.assertTrue(stackFrameProxyImpl == null || threadReferenceProxyImpl == null || threadReferenceProxyImpl == stackFrameProxyImpl.threadProxy());
        DebuggerContextImpl debuggerContextImpl = new DebuggerContextImpl(debuggerSession, suspendContextImpl, threadReferenceProxyImpl, stackFrameProxyImpl, null, null, suspendContextImpl == null);
        if (debuggerContextImpl == null) {
            DebuggerContextImpl.a(0);
        }
        return debuggerContextImpl;
    }

    public void initCaches() {
        if (this.g) {
            return;
        }
        this.g = true;
        if (this.b == null && this.h != null) {
            try {
                this.b = this.h.frameCount() > 0 ? this.h.frame(0) : null;
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        if (this.b != null) {
            if (this.c == null) {
                this.c = ContextUtil.getSourcePosition((StackFrameContext)this);
            }
            this.d = ContextUtil.getContextElement(this.c);
        }
    }

    public void setPositionCache(SourcePosition sourcePosition) {
        this.c = sourcePosition;
    }

    public boolean isInitialised() {
        return this.g;
    }

    public boolean isEvaluationPossible() {
        DebugProcessImpl debugProcessImpl = this.getDebugProcess();
        return debugProcessImpl != null && debugProcessImpl.getSuspendManager().getPausedContext() != null;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/DebuggerContextImpl", "createDebuggerContext"));
    }
}

