/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.NameMapper;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessEvents;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.RemoteDebugProcessHandler;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.debugger.settings.CaptureSettingsProvider;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.GetJPDADialog;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.debugger.ui.tree.render.BatchEvaluator;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DebuggerManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class DebuggerManagerImpl
extends DebuggerManagerEx
implements PersistentStateComponent<Element> {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerManagerImpl");
    public static final String LOCALHOST_ADDRESS_FALLBACK = "127.0.0.1";
    private final Project b;
    private final HashMap<ProcessHandler, DebuggerSession> j = new HashMap();
    private final BreakpointManager i;
    private final List<NameMapper> c = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<Function<DebugProcess, PositionManager>> d = new SmartList();
    private final EventDispatcher<DebuggerManagerListener> f = EventDispatcher.create(DebuggerManagerListener.class);
    private final MyDebuggerStateManager k = new MyDebuggerStateManager();
    private final DebuggerContextListener l = new DebuggerContextListener(){

        @Override
        public void changeEvent(@NotNull DebuggerContextImpl debuggerContextImpl, DebuggerSession.Event event) {
            if (debuggerContextImpl == null) {
                1.a(0);
            }
            DebuggerSession debuggerSession = debuggerContextImpl.getDebuggerSession();
            if (event == DebuggerSession.Event.PAUSE && DebuggerManagerImpl.this.k.b != debuggerSession) {
                DebuggerManagerImpl.this.k.setState(debuggerContextImpl, debuggerSession != null ? debuggerSession.getState() : DebuggerSession.State.DISPOSED, event, null);
                return;
            }
            if (DebuggerManagerImpl.this.k.b == debuggerSession) {
                DebuggerManagerImpl.this.k.fireStateChanged(debuggerContextImpl, event);
            }
            if (event == DebuggerSession.Event.ATTACHED) {
                ((DebuggerManagerListener)DebuggerManagerImpl.this.f.getMulticaster()).sessionAttached(debuggerSession);
            } else if (event == DebuggerSession.Event.DETACHED) {
                ((DebuggerManagerListener)DebuggerManagerImpl.this.f.getMulticaster()).sessionDetached(debuggerSession);
            } else if (event == DebuggerSession.Event.DISPOSE) {
                DebuggerManagerImpl.this.a(debuggerSession);
                if (DebuggerManagerImpl.this.k.b == debuggerSession) {
                    DebuggerManagerImpl.this.k.setState(DebuggerContextImpl.EMPTY_CONTEXT, DebuggerSession.State.DISPOSED, DebuggerSession.Event.DISPOSE, null);
                }
            }
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContext", "com/intellij/debugger/impl/DebuggerManagerImpl$1", "changeEvent"));
        }
    };
    @NonNls
    private static final String h = "idea.xdebug.key";
    private static final String e = "debugger-agent.jar";
    private static final String g = "debugger-agent-storage.jar";

    public void addClassNameMapper(NameMapper nameMapper) {
        this.c.add(nameMapper);
    }

    public void removeClassNameMapper(NameMapper nameMapper) {
        this.c.remove(nameMapper);
    }

    public String getVMClassQualifiedName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            DebuggerManagerImpl.a(0);
        }
        for (NameMapper nameMapper : this.c) {
            String string = nameMapper.getQualifiedName(psiClass);
            if (string == null) continue;
            return string;
        }
        return psiClass.getQualifiedName();
    }

    @Override
    public void addDebuggerManagerListener(DebuggerManagerListener debuggerManagerListener) {
        this.f.addListener((EventListener)debuggerManagerListener);
    }

    @Override
    public void removeDebuggerManagerListener(DebuggerManagerListener debuggerManagerListener) {
        this.f.removeListener((EventListener)debuggerManagerListener);
    }

    public DebuggerManagerImpl(Project project2, StartupManager startupManager) {
        this.b = project2;
        this.i = new BreakpointManager(this.b, startupManager, this);
        if (!project2.isDefault()) {
            project2.getMessageBus().connect().subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

                public void globalSchemeChange(EditorColorsScheme editorColorsScheme) {
                    DebuggerManagerImpl.this.getBreakpointManager().updateBreakpointsUI();
                }
            });
        }
    }

    @Override
    @Nullable
    public DebuggerSession getSession(DebugProcess debugProcess) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.getSessions().stream().filter(debuggerSession -> debugProcess == debuggerSession.getProcess()).findFirst().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Collection<DebuggerSession> getSessions() {
        HashMap<ProcessHandler, DebuggerSession> hashMap = this.j;
        // MONITORENTER : hashMap
        Collection<DebuggerSession> collection = this.j.values();
        ArrayList<DebuggerSession> arrayList = collection.isEmpty() ? Collections.emptyList() : new ArrayList<DebuggerSession>(collection);
        // MONITOREXIT : hashMap
        if (arrayList != null) return arrayList;
        DebuggerManagerImpl.a(1);
        return arrayList;
    }

    public void projectOpened() {
        this.i.init();
    }

    @Nullable
    public Element getState() {
        Element element = new Element("state");
        this.i.writeExternal(element);
        return element;
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            DebuggerManagerImpl.a(2);
        }
        this.i.readExternal(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.i.writeExternal(element);
    }

    @Deprecated
    public Stream<Function<DebugProcess, PositionManager>> getCustomPositionManagerFactories() {
        return this.d.stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public DebuggerSession attachVirtualMachine(@NotNull DebugEnvironment debugEnvironment) throws ExecutionException {
        if (debugEnvironment == null) {
            DebuggerManagerImpl.a(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        DebugProcessEvents debugProcessEvents = new DebugProcessEvents(this.b);
        DebuggerSession debuggerSession = DebuggerSession.create(debugEnvironment.getSessionName(), debugProcessEvents, debugEnvironment);
        ExecutionResult executionResult = debuggerSession.getProcess().getExecutionResult();
        if (executionResult == null) {
            return null;
        }
        debuggerSession.getContextManager().addListener(this.l);
        this.getContextManager().setState(DebuggerContextUtil.createDebuggerContext(debuggerSession, debuggerSession.getContextManager().getContext().getSuspendContext()), debuggerSession.getState(), DebuggerSession.Event.CONTEXT, null);
        ProcessHandler processHandler = executionResult.getProcessHandler();
        HashMap<ProcessHandler, DebuggerSession> hashMap = this.j;
        synchronized (hashMap) {
            this.j.put(processHandler, debuggerSession);
        }
        if (!(processHandler instanceof RemoteDebugProcessHandler)) {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processWillTerminate(@NotNull ProcessEvent processEvent, boolean bl2) {
                    ProcessHandler processHandler;
                    DebugProcessImpl debugProcessImpl;
                    if (processEvent == null) {
                        3.a(0);
                    }
                    if ((debugProcessImpl = DebuggerManagerImpl.this.getDebugProcess(processHandler = processEvent.getProcessHandler())) != null) {
                        debugProcessImpl.stop(bl2 && (!(processHandler instanceof KillableColoredProcessHandler) || !((KillableColoredProcessHandler)processHandler).shouldKillProcessSoftly()));
                        if (!DebuggerManagerThreadImpl.isManagerThread()) {
                            if (SwingUtilities.isEventDispatchThread()) {
                                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                                    ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                                    debugProcessImpl.waitFor(10000L);
                                }, "Waiting For Debugger Response", false, debugProcessImpl.getProject());
                            } else {
                                debugProcessImpl.waitFor(10000L);
                            }
                        }
                    }
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/impl/DebuggerManagerImpl$3", "processWillTerminate"));
                }
            });
        }
        ((DebuggerManagerListener)this.f.getMulticaster()).sessionCreated(debuggerSession);
        if (debugProcessEvents.isDetached() || debugProcessEvents.isDetaching()) {
            debuggerSession.dispose();
            return null;
        }
        if (debugEnvironment.isRemote()) {
            debugProcessEvents.putUserData(BatchEvaluator.REMOTE_SESSION_KEY, Boolean.TRUE);
        }
        return debuggerSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugProcessImpl getDebugProcess(ProcessHandler processHandler) {
        HashMap<ProcessHandler, DebuggerSession> hashMap = this.j;
        synchronized (hashMap) {
            DebuggerSession debuggerSession = this.j.get(processHandler);
            return debuggerSession != null ? debuggerSession.getProcess() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DebuggerSession getDebugSession(ProcessHandler processHandler) {
        HashMap<ProcessHandler, DebuggerSession> hashMap = this.j;
        synchronized (hashMap) {
            return this.j.get(processHandler);
        }
    }

    public void addDebugProcessListener(final ProcessHandler processHandler, final DebugProcessListener debugProcessListener) {
        DebugProcessImpl debugProcessImpl = this.getDebugProcess(processHandler);
        if (debugProcessImpl != null) {
            debugProcessImpl.addDebugProcessListener(debugProcessListener);
        } else {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent processEvent) {
                    DebugProcessImpl debugProcessImpl;
                    if (processEvent == null) {
                        4.a(0);
                    }
                    if ((debugProcessImpl = DebuggerManagerImpl.this.getDebugProcess(processHandler)) != null) {
                        debugProcessImpl.addDebugProcessListener(debugProcessListener);
                    }
                    processHandler.removeProcessListener((ProcessListener)this);
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/impl/DebuggerManagerImpl$4", "startNotified"));
                }
            });
        }
    }

    public void removeDebugProcessListener(final ProcessHandler processHandler, final DebugProcessListener debugProcessListener) {
        DebugProcessImpl debugProcessImpl = this.getDebugProcess(processHandler);
        if (debugProcessImpl != null) {
            debugProcessImpl.removeDebugProcessListener(debugProcessListener);
        } else {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent processEvent) {
                    DebugProcessImpl debugProcessImpl;
                    if (processEvent == null) {
                        5.a(0);
                    }
                    if ((debugProcessImpl = DebuggerManagerImpl.this.getDebugProcess(processHandler)) != null) {
                        debugProcessImpl.removeDebugProcessListener(debugProcessListener);
                    }
                    processHandler.removeProcessListener((ProcessListener)this);
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/impl/DebuggerManagerImpl$5", "startNotified"));
                }
            });
        }
    }

    public boolean isDebuggerManagerThread() {
        return DebuggerManagerThreadImpl.isManagerThread();
    }

    @NotNull
    public String getComponentName() {
        if ("DebuggerManager" == null) {
            DebuggerManagerImpl.a(4);
        }
        return "DebuggerManager";
    }

    @Override
    @NotNull
    public BreakpointManager getBreakpointManager() {
        BreakpointManager breakpointManager = this.i;
        if (breakpointManager == null) {
            DebuggerManagerImpl.a(5);
        }
        return breakpointManager;
    }

    @Override
    @NotNull
    public DebuggerContextImpl getContext() {
        DebuggerContextImpl debuggerContextImpl = this.getContextManager().getContext();
        if (debuggerContextImpl == null) {
            DebuggerManagerImpl.a(6);
        }
        return debuggerContextImpl;
    }

    @Override
    @NotNull
    public DebuggerStateManager getContextManager() {
        MyDebuggerStateManager myDebuggerStateManager = this.k;
        if (myDebuggerStateManager == null) {
            DebuggerManagerImpl.a(7);
        }
        return myDebuggerStateManager;
    }

    public void registerPositionManagerFactory(Function<DebugProcess, PositionManager> function) {
        this.d.add(function);
    }

    public void unregisterPositionManagerFactory(Function<DebugProcess, PositionManager> function) {
        this.d.remove(function);
    }

    private static void a(JavaParameters javaParameters) throws ExecutionException {
        Sdk sdk = javaParameters.getJdk();
        if (sdk == null) {
            throw new ExecutionException(DebuggerBundle.message((String)"error.jdk.not.specified", (Object[])new Object[0]));
        }
        JavaSdkVersion javaSdkVersion = JavaSdk.getInstance().getVersion(sdk);
        if (javaSdkVersion == JavaSdkVersion.JDK_1_0 || javaSdkVersion == JavaSdkVersion.JDK_1_1) {
            String string = sdk.getVersionString();
            throw new ExecutionException(DebuggerBundle.message((String)"error.unsupported.jdk.version", (Object[])new Object[]{string}));
        }
        if (SystemInfo.isWindows && javaSdkVersion == JavaSdkVersion.JDK_1_2) {
            VirtualFile virtualFile = sdk.getHomeDirectory();
            if (virtualFile == null || !virtualFile.isValid()) {
                String string = sdk.getVersionString();
                throw new ExecutionException(DebuggerBundle.message((String)"error.invalid.jdk.home", (Object[])new Object[]{string}));
            }
            File file = new File(virtualFile.getPath().replace('/', File.separatorChar) + File.separator + "bin" + File.separator + "jdwp.dll");
            if (!file.exists()) {
                GetJPDADialog getJPDADialog = new GetJPDADialog();
                getJPDADialog.show();
                throw new ExecutionException(DebuggerBundle.message((String)"error.debug.libraries.missing", (Object[])new Object[0]));
            }
        }
    }

    private static boolean b(Sdk sdk) {
        if (SystemInfo.isMac) {
            return false;
        }
        if (sdk == null) {
            return false;
        }
        String string = JdkUtil.getJdkMainAttribute((Sdk)sdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        if (string == null || StringUtil.compareVersionNumbers((String)string, (String)"1.4") >= 0) {
            return false;
        }
        if (string.startsWith("1.2") && SystemInfo.isWindows) {
            return true;
        }
        if ((string = string + ".0").startsWith("1.3.0") && SystemInfo.isWindows) {
            return true;
        }
        if ((string.startsWith("1.3.1_07") || string.startsWith("1.3.1_08")) && SystemInfo.isWindows) {
            return false;
        }
        return DebuggerSettings.getInstance().FORCE_CLASSIC_VM;
    }

    public static RemoteConnection createDebugParameters(JavaParameters javaParameters, boolean bl2, int n2, String string, boolean bl3) throws ExecutionException {
        return DebuggerManagerImpl.createDebugParameters(javaParameters, bl2, n2, string, bl3, true);
    }

    /*
     * Unable to fully structure code
     */
    public static RemoteConnection createDebugParameters(JavaParameters var0, boolean var1_1, int var2_2, String var3_3, boolean var4_4, boolean var5_5) throws ExecutionException {
        if (var4_4) {
            DebuggerManagerImpl.a(var0);
        }
        var6_6 = var2_2 == 0;
        var7_7 = "";
        if (StringUtil.isEmptyOrSpaces((String)var3_3)) {
            try {
                var7_7 = DebuggerUtils.getInstance().findAvailableDebugAddress(var6_6);
            }
            catch (ExecutionException var8_8) {
                if (!var4_4) ** GOTO lbl13
                throw var8_8;
            }
        } else {
            var7_7 = var3_3;
        }
lbl13:
        // 3 sources

        var8_9 = var1_1 != false && var6_6 != false ? "127.0.0.1:" + var7_7 : var7_7;
        var9_10 = "transport=" + DebugProcessImpl.findConnector(var6_6, var1_1).transport().name() + ",address=" + var8_9;
        var9_10 = var1_1 != false ? var9_10 + ",suspend=y,server=n" : var9_10 + ",suspend=n,server=y";
        if (StringUtil.containsWhitespaces((CharSequence)var9_10)) {
            var9_10 = "\"" + var9_10 + "\"";
        }
        var10_11 = var9_10;
        ApplicationManager.getApplication().runReadAction((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, a(com.intellij.execution.configurations.JavaParameters boolean java.lang.String ), ()V)((JavaParameters)var0, (boolean)var5_5, (String)var10_11));
        return new RemoteConnection(var6_6, "127.0.0.1", var7_7, var1_1);
    }

    private static void b(JavaParameters javaParameters) {
        if (StackCapturingLineBreakpoint.isAgentEnabled()) {
            String string = "-javaagent:";
            ParametersList parametersList = javaParameters.getVMParametersList();
            if (parametersList.getParameters().stream().noneMatch(string2 -> string2.startsWith(string) && string2.contains(e))) {
                String string3;
                Sdk sdk = javaParameters.getJdk();
                String string4 = string3 = sdk != null ? JdkUtil.getJdkMainAttribute((Sdk)sdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION) : null;
                if (string3 != null) {
                    JavaSdkVersion javaSdkVersion = JavaSdkVersion.fromVersionString((String)string3);
                    if (javaSdkVersion != null && javaSdkVersion.isAtLeast(JavaSdkVersion.JDK_1_6)) {
                        Object object;
                        File file = new File(PathUtil.getJarPathForClass(DebuggerManagerImpl.class));
                        File file2 = file.isFile() ? new File(file.getParentFile(), "rt/debugger-agent.jar") : (((File)(object = new File(file.getParentFile().getParentFile().getParentFile(), "project-artifacts"))).exists() ? new File((File)object, "debugger_agent/debugger-agent.jar") : new File(file.getParentFile().getParentFile(), "/artifacts/debugger_agent/debugger-agent.jar"));
                        if (file2.exists()) {
                            object = DebuggerManagerImpl.a(file2.getAbsolutePath());
                            if (object != null) {
                                parametersList.add(string + (String)object + "=" + DebuggerManagerImpl.a());
                            }
                        } else {
                            a.warn("Capture agent not found: " + file2);
                        }
                    } else {
                        a.warn("Capture agent is not supported for jre " + string3);
                    }
                }
            }
        }
    }

    @Nullable
    private static String a(String string) {
        if (string.contains(" ")) {
            File file = new File(PathManager.getSystemPath(), "captureAgent");
            String string2 = DebuggerManagerImpl.a(string, file);
            if (string2 == null) {
                try {
                    file = FileUtil.createTempDirectory((String)"capture", (String)"jars");
                    string2 = DebuggerManagerImpl.a(string, file);
                    if (string2 == null && file.getAbsolutePath().contains(" ")) {
                        a.info("Capture agent was not used since the agent path contained spaces: " + string);
                        return null;
                    }
                }
                catch (IOException iOException) {
                    a.info((Throwable)iOException);
                    return null;
                }
            }
            return string2;
        }
        return string;
    }

    @Nullable
    private static String a(String string, File file) {
        if (!file.getAbsolutePath().contains(" ")) {
            try {
                file.mkdirs();
                Path path = Paths.get(string, new String[0]);
                Path path2 = file.toPath().resolve(e);
                Files.copy(path, path2, StandardCopyOption.REPLACE_EXISTING);
                Files.copy(path.getParent().resolve(g), file.toPath().resolve(g), StandardCopyOption.REPLACE_EXISTING);
                return path2.toString();
            }
            catch (IOException iOException) {
                a.info((Throwable)iOException);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String a() {
        Properties properties = new Properties();
        if (Registry.is((String)"debugger.capture.points.agent.debug")) {
            properties.setProperty("debug", "true");
        }
        int n2 = 0;
        for (CaptureSettingsProvider.AgentPoint object2 : CaptureSettingsProvider.getPoints()) {
            properties.setProperty((object2.isCapture() ? "capture" : "insert") + n2++, object2.myClassName + " " + object2.myMethodName + " " + object2.myMethodDesc + " " + object2.myKey.asString());
        }
        try {
            File file = FileUtil.createTempFile((String)"capture", (String)".props");
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                properties.store(fileOutputStream, null);
                String throwable3 = file.getAbsolutePath();
                return throwable3;
            }
        }
        catch (IOException iOException) {
            a.error((Throwable)iOException);
            return null;
        }
    }

    private static boolean c(Sdk sdk) {
        String string;
        if (DebuggerSettings.getInstance().DISABLE_JIT) {
            return true;
        }
        return sdk != null && (string = JdkUtil.getJdkMainAttribute((Sdk)sdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION)) != null && (string.startsWith("1.2") || string.startsWith("1.3"));
    }

    private static boolean d(Sdk sdk) {
        if (sdk == null) {
            return true;
        }
        if (DebuggerSettings.getInstance().DISABLE_JIT) {
            return true;
        }
        String string = JdkUtil.getJdkMainAttribute((Sdk)sdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        return string == null || string.startsWith("1.4") || string.startsWith("1.3") || string.startsWith("1.2") || string.startsWith("1.1") || string.startsWith("1.0");
    }

    private static boolean a(Sdk sdk) {
        if (sdk == null) {
            return false;
        }
        String string = JdkUtil.getJdkMainAttribute((Sdk)sdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        if (string == null) {
            return false;
        }
        return !string.startsWith("1.4") && !string.startsWith("1.3") && !string.startsWith("1.2") && !string.startsWith("1.1") && !string.startsWith("1.0");
    }

    public static RemoteConnection createDebugParameters(JavaParameters javaParameters, GenericDebuggerRunnerSettings genericDebuggerRunnerSettings, boolean bl2) throws ExecutionException {
        return DebuggerManagerImpl.createDebugParameters(javaParameters, genericDebuggerRunnerSettings.LOCAL, genericDebuggerRunnerSettings.getTransport(), genericDebuggerRunnerSettings.getDebugPort(), bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(DebuggerSession debuggerSession) {
        ProcessHandler processHandler = debuggerSession.getProcess().getProcessHandler();
        HashMap<ProcessHandler, DebuggerSession> hashMap = this.j;
        synchronized (hashMap) {
            DebuggerSession debuggerSession2 = this.j.remove(processHandler);
            a.assertTrue(debuggerSession2 != null);
            ((DebuggerManagerListener)this.f.getMulticaster()).sessionRemoved(debuggerSession);
        }
    }

    private static /* synthetic */ void a(JavaParameters javaParameters, boolean bl2, String string) {
        boolean bl3;
        JavaSdkUtil.addRtJar((PathsList)javaParameters.getClassPath());
        if (bl2) {
            DebuggerManagerImpl.b(javaParameters);
        }
        Sdk sdk = javaParameters.getJdk();
        boolean bl4 = DebuggerManagerImpl.b(sdk);
        boolean bl5 = DebuggerManagerImpl.c(sdk);
        String string2 = System.getProperty(h, "-Xdebug");
        boolean bl6 = bl3 = DebuggerManagerImpl.d(sdk) || !"-Xdebug".equals(string2);
        if (bl4 || bl5 || bl3 || !DebuggerManagerImpl.a(sdk)) {
            javaParameters.getVMParametersList().replaceOrPrepend("-Xrunjdwp:", "-Xrunjdwp:" + string);
        } else {
            javaParameters.getVMParametersList().replaceOrPrepend("-Xrunjdwp:", "");
            javaParameters.getVMParametersList().replaceOrPrepend("-agentlib:jdwp=", "-agentlib:jdwp=" + string);
        }
        if (bl5) {
            javaParameters.getVMParametersList().replaceOrPrepend("-Djava.compiler=", "-Djava.compiler=NONE");
            javaParameters.getVMParametersList().replaceOrPrepend("-Xnoagent", "-Xnoagent");
        }
        if (bl3) {
            javaParameters.getVMParametersList().replaceOrPrepend(string2, string2);
        } else {
            javaParameters.getVMParametersList().replaceOrPrepend("-Xdebug", "");
        }
        javaParameters.getVMParametersList().replaceOrPrepend("-classic", bl4 ? "-classic" : "");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/DebuggerManagerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/DebuggerManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextManager";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVMClassQualifiedName";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "attachVirtualMachine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDebuggerStateManager
    extends DebuggerStateManager {
        private DebuggerSession b;

        private MyDebuggerStateManager() {
        }

        @Override
        @NotNull
        public DebuggerContextImpl getContext() {
            DebuggerContextImpl debuggerContextImpl = this.b == null ? DebuggerContextImpl.EMPTY_CONTEXT : this.b.getContextManager().getContext();
            if (debuggerContextImpl == null) {
                MyDebuggerStateManager.b(0);
            }
            return debuggerContextImpl;
        }

        @Override
        public void setState(@NotNull DebuggerContextImpl debuggerContextImpl, DebuggerSession.State state, DebuggerSession.Event event, String string) {
            if (debuggerContextImpl == null) {
                MyDebuggerStateManager.b(1);
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.b = debuggerContextImpl.getDebuggerSession();
            if (this.b != null) {
                this.b.getContextManager().setState(debuggerContextImpl, state, event, string);
            } else {
                this.fireStateChanged(debuggerContextImpl, event);
            }
        }

        private static /* synthetic */ void b(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 2;
                    break;
                }
                case 1: {
                    n3 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/impl/DebuggerManagerImpl$MyDebuggerStateManager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/impl/DebuggerManagerImpl$MyDebuggerStateManager";
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setState";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

