/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.application.options.CodeStyle;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.SourcePositionHighlighter;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactoryContextWrapper;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.EditorTextProvider;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.execution.filters.ExceptionFilters;
import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.ui.content.Content;
import com.intellij.unscramble.ThreadDumpPanel;
import com.intellij.unscramble.ThreadState;
import com.intellij.util.DocumentUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.ui.ExecutionPointHighlighter;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerUtilsEx
extends DebuggerUtils {
    private static final Logger d = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerUtilsEx");
    private static Set<String> f;
    private static int a;
    private static int b;
    private static final String c = "Dump";
    private static final Key<Map<String, String>> e;
    public static final Comparator<Method> LAMBDA_ORDINAL_COMPARATOR;

    public static List<CodeFragmentFactory> getCodeFragmentFactories(@Nullable PsiElement psiElement) {
        DefaultCodeFragmentFactory defaultCodeFragmentFactory = DefaultCodeFragmentFactory.getInstance();
        CodeFragmentFactory[] codeFragmentFactoryArray = (CodeFragmentFactory[])ApplicationManager.getApplication().getExtensions(CodeFragmentFactory.EXTENSION_POINT_NAME);
        ArrayList<CodeFragmentFactory> arrayList = new ArrayList<CodeFragmentFactory>(codeFragmentFactoryArray.length);
        if (codeFragmentFactoryArray.length > 0) {
            for (CodeFragmentFactory codeFragmentFactory : codeFragmentFactoryArray) {
                if (codeFragmentFactory == defaultCodeFragmentFactory || !codeFragmentFactory.isContextAccepted(psiElement)) continue;
                arrayList.add(codeFragmentFactory);
            }
        }
        arrayList.add(defaultCodeFragmentFactory);
        return arrayList;
    }

    public static PsiMethod findPsiMethod(PsiFile psiFile, int n2) {
        PsiElement psiElement = null;
        while (n2 >= 0 && (psiElement = psiFile.findElementAt(n2)) == null) {
            --n2;
        }
        while (psiElement != null) {
            if (psiElement instanceof PsiClass || psiElement instanceof PsiLambdaExpression) {
                return null;
            }
            if (psiElement instanceof PsiMethod) {
                return (PsiMethod)psiElement;
            }
            psiElement = psiElement.getParent();
        }
        return null;
    }

    public static boolean isAssignableFrom(@NotNull String string, @NotNull ReferenceType referenceType) {
        if (string == null) {
            DebuggerUtilsEx.a(0);
        }
        if (referenceType == null) {
            DebuggerUtilsEx.a(1);
        }
        if ("java.lang.Object".equals(string)) {
            return true;
        }
        return DebuggerUtilsEx.getSuperClass(string, referenceType) != null;
    }

    public static ReferenceType getSuperClass(@NotNull String string, @NotNull ReferenceType referenceType) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (string == null) {
            DebuggerUtilsEx.a(2);
        }
        if (referenceType == null) {
            DebuggerUtilsEx.a(3);
        }
        if (string.equals(referenceType.name())) {
            return referenceType;
        }
        if (referenceType instanceof ClassType) {
            object4 = (ClassType)referenceType;
            object3 = object4.superclass();
            if (object3 != null && (object2 = DebuggerUtilsEx.getSuperClass(string, (ReferenceType)object3)) != null) {
                return object2;
            }
            object2 = object4.allInterfaces();
            object = object2.iterator();
            while (object.hasNext()) {
                InterfaceType interfaceType = (InterfaceType)object.next();
                ReferenceType referenceType2 = DebuggerUtilsEx.getSuperClass(string, interfaceType);
                if (referenceType2 == null) continue;
                return referenceType2;
            }
        }
        if (referenceType instanceof InterfaceType) {
            object4 = ((InterfaceType)referenceType).superinterfaces();
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (InterfaceType)object3.next();
                object = DebuggerUtilsEx.getSuperClass(string, (ReferenceType)object2);
                if (object == null) continue;
                return object;
            }
        }
        return null;
    }

    public static boolean valuesEqual(Value value, Value value2) {
        if (value == null) {
            return value2 == null;
        }
        if (value2 == null) {
            return false;
        }
        if (value instanceof StringReference && value2 instanceof StringReference) {
            return ((StringReference)value).value().equals(((StringReference)value2).value());
        }
        return value.equals(value2);
    }

    public static String getValueOrErrorAsString(EvaluationContext evaluationContext, Value value) {
        try {
            return DebuggerUtilsEx.getValueAsString((EvaluationContext)evaluationContext, (Value)value);
        }
        catch (EvaluateException evaluateException) {
            return evaluateException.getMessage();
        }
    }

    public static boolean isCharOrInteger(Value value) {
        return value instanceof CharValue || DebuggerUtilsEx.isInteger((Value)value);
    }

    public static boolean isCharOrIntegerArray(Value value) {
        if (value == null) {
            return false;
        }
        if (f == null) {
            f = new HashSet<String>();
            f.add("C");
            f.add("B");
            f.add("S");
            f.add("I");
            f.add("J");
        }
        String string = value.type().signature();
        int n2 = 0;
        while (string.charAt(n2) == '[') {
            ++n2;
        }
        if (n2 == 0) {
            return false;
        }
        string = string.substring(n2, string.length());
        return f.contains(string);
    }

    public static ClassFilter create(Element element) throws InvalidDataException {
        ClassFilter classFilter = new ClassFilter();
        DefaultJDOMExternalizer.readExternal((Object)classFilter, (Element)element);
        return classFilter;
    }

    private static boolean a(ClassFilter classFilter, String string) {
        if (!classFilter.isEnabled()) {
            return false;
        }
        try {
            if (classFilter.matches(string)) {
                return true;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            d.debug((Throwable)patternSyntaxException);
        }
        return false;
    }

    public static boolean isFiltered(@NotNull String string, ClassFilter[] classFilterArray) {
        if (string == null) {
            DebuggerUtilsEx.a(4);
        }
        return DebuggerUtilsEx.isFiltered(string, Arrays.asList(classFilterArray));
    }

    public static boolean isFiltered(@NotNull String string, List<ClassFilter> list2) {
        if (string == null) {
            DebuggerUtilsEx.a(5);
        }
        if (string.indexOf(91) != -1) {
            return false;
        }
        return list2.stream().anyMatch(classFilter -> {
            if (string == null) {
                DebuggerUtilsEx.a(27);
            }
            return DebuggerUtilsEx.a(classFilter, string);
        });
    }

    public static int getEnabledNumber(ClassFilter[] classFilterArray) {
        return (int)Arrays.stream(classFilterArray).filter(ClassFilter::isEnabled).count();
    }

    public static ClassFilter[] readFilters(List<Element> list2) throws InvalidDataException {
        if (ContainerUtil.isEmpty(list2)) {
            return ClassFilter.EMPTY_ARRAY;
        }
        ClassFilter[] classFilterArray = new ClassFilter[list2.size()];
        int n2 = list2.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            classFilterArray[i2] = DebuggerUtilsEx.create(list2.get(i2));
        }
        return classFilterArray;
    }

    public static void writeFilters(Element element, @NonNls String string, ClassFilter[] classFilterArray) throws WriteExternalException {
        for (ClassFilter classFilter : classFilterArray) {
            Element element2 = new Element(string);
            element.addContent(element2);
            DefaultJDOMExternalizer.writeExternal((Object)classFilter, (Element)element2);
        }
    }

    public static boolean filterEquals(ClassFilter[] classFilterArray, ClassFilter[] classFilterArray2) {
        if (classFilterArray.length != classFilterArray2.length) {
            return false;
        }
        HashSet hashSet = new HashSet(Math.max((int)((float)classFilterArray.length / 0.75f) + 1, 16));
        HashSet hashSet2 = new HashSet(Math.max((int)((float)classFilterArray2.length / 0.75f) + 1, 16));
        Collections.addAll(hashSet, classFilterArray);
        Collections.addAll(hashSet2, classFilterArray2);
        return hashSet2.equals(hashSet);
    }

    private static boolean b(List<Element> list2, List<Element> list3) {
        if (list2 == null) {
            return list3 == null;
        }
        if (list3 == null) {
            return false;
        }
        if (list2.size() != list3.size()) {
            return false;
        }
        Iterator<Element> iterator = list2.iterator();
        for (Element element : list3) {
            Element element2 = iterator.next();
            if (DebuggerUtilsEx.elementsEqual(element2, element)) continue;
            return false;
        }
        return true;
    }

    private static boolean a(List<Attribute> list2, List<Attribute> list3) {
        if (list2 == null) {
            return list3 == null;
        }
        if (list3 == null) {
            return false;
        }
        if (list2.size() != list3.size()) {
            return false;
        }
        Iterator<Attribute> iterator = list2.iterator();
        for (Attribute attribute : list3) {
            Attribute attribute2 = iterator.next();
            if (Comparing.equal((String)attribute2.getName(), (String)attribute.getName()) && Comparing.equal((String)attribute2.getValue(), (String)attribute.getValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean elementsEqual(Element element, Element element2) {
        if (element == null) {
            return element2 == null;
        }
        if (!Comparing.equal((String)element.getName(), (String)element2.getName())) {
            return false;
        }
        if (!DebuggerUtilsEx.b(element.getChildren(), element2.getChildren())) {
            return false;
        }
        return DebuggerUtilsEx.a(element.getAttributes(), element2.getAttributes());
    }

    public static boolean externalizableEqual(JDOMExternalizable jDOMExternalizable, JDOMExternalizable jDOMExternalizable2) {
        Element element = new Element("root");
        Element element2 = new Element("root");
        try {
            jDOMExternalizable.writeExternal(element);
        }
        catch (WriteExternalException writeExternalException) {
            d.debug((Throwable)writeExternalException);
        }
        try {
            jDOMExternalizable2.writeExternal(element2);
        }
        catch (WriteExternalException writeExternalException) {
            d.debug((Throwable)writeExternalException);
        }
        return DebuggerUtilsEx.elementsEqual(element, element2);
    }

    @NotNull
    public static List<Pair<Breakpoint, Event>> getEventDescriptors(@Nullable SuspendContextImpl suspendContextImpl) {
        EventSet eventSet;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (suspendContextImpl != null && !ContainerUtil.isEmpty((Collection)(eventSet = suspendContextImpl.getEventSet()))) {
            List list2 = ContainerUtil.newSmartList();
            RequestManagerImpl requestManagerImpl = suspendContextImpl.getDebugProcess().getRequestsManager();
            for (Event event : eventSet) {
                Requestor requestor = requestManagerImpl.findRequestor(event.request());
                if (!(requestor instanceof Breakpoint)) continue;
                list2.add(Pair.create((Object)((Breakpoint)requestor), (Object)event));
            }
            List list3 = list2;
            if (list3 == null) {
                DebuggerUtilsEx.a(6);
            }
            return list3;
        }
        List<Pair<Breakpoint, Event>> list4 = Collections.emptyList();
        if (list4 == null) {
            DebuggerUtilsEx.a(7);
        }
        return list4;
    }

    public static TextWithImports getEditorText(Editor editor) {
        if (editor == null) {
            return null;
        }
        Project project2 = editor.getProject();
        if (project2 == null) {
            return null;
        }
        String string = editor.getSelectionModel().getSelectedText();
        if (string == null) {
            TextWithImports textWithImports;
            EditorTextProvider editorTextProvider;
            PsiElement psiElement;
            int n2 = editor.getCaretModel().getOffset();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
            if (psiFile != null && (psiElement = psiFile.findElementAt(n2)) != null && (editorTextProvider = (EditorTextProvider)EditorTextProvider.EP.forLanguage(psiElement.getLanguage())) != null && (textWithImports = editorTextProvider.getEditorText(psiElement)) != null) {
                return textWithImports;
            }
        } else {
            return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, string);
        }
        return null;
    }

    public static void addThreadDump(Project project2, List<ThreadState> list2, RunnerLayoutUi runnerLayoutUi, DebuggerSession debuggerSession) {
        TextConsoleBuilder textConsoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project2);
        textConsoleBuilder.filters(ExceptionFilters.getFilters((GlobalSearchScope)debuggerSession.getSearchScope()));
        ConsoleView consoleView = textConsoleBuilder.getConsole();
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        consoleView.allowHeavyFilters();
        ThreadDumpPanel threadDumpPanel = new ThreadDumpPanel(project2, consoleView, defaultActionGroup, list2);
        String string = "Dump #" + b;
        Content content = runnerLayoutUi.createContent(string, (JComponent)threadDumpPanel, string, null, null);
        content.putUserData(RunnerContentUi.LIGHTWEIGHT_CONTENT_MARKER, (Object)Boolean.TRUE);
        content.setCloseable(true);
        content.setDescription("Thread Dump");
        runnerLayoutUi.addContent(content);
        runnerLayoutUi.selectAndFocus(content, true, true);
        ++a;
        ++b;
        Disposer.register((Disposable)content, (Disposable)new Disposable(){

            public void dispose() {
                a--;
                if (a == 0) {
                    b = 1;
                }
            }
        });
        Disposer.register((Disposable)content, (Disposable)consoleView);
        runnerLayoutUi.selectAndFocus(content, true, false);
        if (list2.size() > 0) {
            threadDumpPanel.selectStackFrame(0);
        }
    }

    public static void keep(Value value, EvaluationContext evaluationContext) {
        if (value instanceof ObjectReference) {
            ((SuspendContextImpl)evaluationContext.getSuspendContext()).keep((ObjectReference)value);
        }
    }

    public abstract DebuggerTreeNode getSelectedNode(DataContext var1);

    public abstract EvaluatorBuilder getEvaluatorBuilder();

    @NotNull
    public static CodeFragmentFactory getCodeFragmentFactory(@Nullable PsiElement psiElement, @Nullable FileType fileType) {
        DefaultCodeFragmentFactory defaultCodeFragmentFactory = DefaultCodeFragmentFactory.getInstance();
        if (fileType == null) {
            if (psiElement == null) {
                DefaultCodeFragmentFactory defaultCodeFragmentFactory2 = defaultCodeFragmentFactory;
                if (defaultCodeFragmentFactory2 == null) {
                    DebuggerUtilsEx.a(8);
                }
                return defaultCodeFragmentFactory2;
            }
            CodeFragmentFactory[] codeFragmentFactoryArray = psiElement.getContainingFile();
            fileType = codeFragmentFactoryArray != null ? codeFragmentFactoryArray.getFileType() : null;
        }
        for (CodeFragmentFactory codeFragmentFactory : (CodeFragmentFactory[])ApplicationManager.getApplication().getExtensions(CodeFragmentFactory.EXTENSION_POINT_NAME)) {
            if (codeFragmentFactory == defaultCodeFragmentFactory || fileType != null && !codeFragmentFactory.getFileType().equals(fileType) || !codeFragmentFactory.isContextAccepted(psiElement)) continue;
            CodeFragmentFactory codeFragmentFactory2 = codeFragmentFactory;
            if (codeFragmentFactory2 == null) {
                DebuggerUtilsEx.a(9);
            }
            return codeFragmentFactory2;
        }
        DefaultCodeFragmentFactory defaultCodeFragmentFactory3 = defaultCodeFragmentFactory;
        if (defaultCodeFragmentFactory3 == null) {
            DebuggerUtilsEx.a(10);
        }
        return defaultCodeFragmentFactory3;
    }

    @NotNull
    public static CodeFragmentFactory findAppropriateCodeFragmentFactory(TextWithImports textWithImports, PsiElement psiElement) {
        CodeFragmentFactory codeFragmentFactory = (CodeFragmentFactory)ReadAction.compute(() -> DebuggerUtilsEx.getCodeFragmentFactory(psiElement, textWithImports.getFileType()));
        CodeFragmentFactoryContextWrapper codeFragmentFactoryContextWrapper = new CodeFragmentFactoryContextWrapper(codeFragmentFactory);
        if (codeFragmentFactoryContextWrapper == null) {
            DebuggerUtilsEx.a(11);
        }
        return codeFragmentFactoryContextWrapper;
    }

    public static String methodNameWithArguments(Method method) {
        return method.name() + "(" + StringUtil.join(method.argumentTypeNames(), DebuggerUtilsEx::getSimpleName, (String)", ") + ")";
    }

    public static String getSimpleName(String string) {
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public static String methodName(Method method) {
        return DebuggerUtilsEx.methodName(DebuggerUtilsEx.signatureToName(method.declaringType().signature()), method.name(), method.signature());
    }

    public static String methodName(final String string, final String string2, String string3) {
        try {
            return new SigReader(string3){

                @Override
                String getMethodName() {
                    return string2;
                }

                @Override
                String getClassName() {
                    return string;
                }
            }.getSignature();
        }
        catch (Exception exception) {
            if (d.isDebugEnabled()) {
                d.debug("Internal error : unknown signature" + string3);
            }
            return string + "." + string2;
        }
    }

    public static String signatureToName(String string) {
        return new SigReader(string).getSignature();
    }

    @Nullable
    public static List<Location> allLineLocations(Method method) {
        try {
            return method.allLineLocations();
        }
        catch (AbsentInformationException absentInformationException) {
            return null;
        }
    }

    @Nullable
    public static List<Location> allLineLocations(ReferenceType referenceType) {
        try {
            return referenceType.allLineLocations();
        }
        catch (AbsentInformationException absentInformationException) {
            return null;
        }
        catch (ObjectCollectedException objectCollectedException) {
            return Collections.emptyList();
        }
    }

    public static int getLineNumber(Location location, boolean bl2) {
        try {
            return location.lineNumber() - (bl2 ? 1 : 0);
        }
        catch (IllegalArgumentException | InternalError throwable) {
            return -1;
        }
    }

    public static String getSourceName(Location location, Function<Throwable, String> function) {
        try {
            return location.sourceName();
        }
        catch (AbsentInformationException | InternalError throwable) {
            return function.apply(throwable);
        }
    }

    public static boolean isVoid(@NotNull Method method) {
        if (method == null) {
            DebuggerUtilsEx.a(12);
        }
        return "void".equals(method.returnTypeName());
    }

    @Nullable
    public static Method getMethod(Location location) {
        try {
            return location.method();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            d.info((Throwable)illegalArgumentException);
            return null;
        }
    }

    public static Value createValue(VirtualMachineProxyImpl virtualMachineProxyImpl, String string, double d2) {
        if (PsiType.DOUBLE.getPresentableText().equals(string)) {
            return virtualMachineProxyImpl.mirrorOf(d2);
        }
        if (PsiType.FLOAT.getPresentableText().equals(string)) {
            return virtualMachineProxyImpl.mirrorOf((float)d2);
        }
        return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, (long)d2);
    }

    public static Value createValue(VirtualMachineProxyImpl virtualMachineProxyImpl, String string, long l2) {
        if (PsiType.LONG.getPresentableText().equals(string)) {
            return virtualMachineProxyImpl.mirrorOf(l2);
        }
        if (PsiType.INT.getPresentableText().equals(string)) {
            return virtualMachineProxyImpl.mirrorOf((int)l2);
        }
        if (PsiType.SHORT.getPresentableText().equals(string)) {
            return virtualMachineProxyImpl.mirrorOf((short)l2);
        }
        if (PsiType.BYTE.getPresentableText().equals(string)) {
            return virtualMachineProxyImpl.mirrorOf((byte)l2);
        }
        if (PsiType.CHAR.getPresentableText().equals(string)) {
            return virtualMachineProxyImpl.mirrorOf((char)l2);
        }
        if (PsiType.DOUBLE.getPresentableText().equals(string)) {
            return virtualMachineProxyImpl.mirrorOf((double)l2);
        }
        if (PsiType.FLOAT.getPresentableText().equals(string)) {
            return virtualMachineProxyImpl.mirrorOf((float)l2);
        }
        return null;
    }

    public static Value createValue(VirtualMachineProxyImpl virtualMachineProxyImpl, String string, boolean bl2) {
        if (PsiType.BOOLEAN.getPresentableText().equals(string)) {
            return virtualMachineProxyImpl.mirrorOf(bl2);
        }
        return null;
    }

    public static Value createValue(VirtualMachineProxyImpl virtualMachineProxyImpl, String string, char c2) {
        if (PsiType.CHAR.getPresentableText().equals(string)) {
            return virtualMachineProxyImpl.mirrorOf(c2);
        }
        if (PsiType.LONG.getPresentableText().equals(string)) {
            return virtualMachineProxyImpl.mirrorOf((long)c2);
        }
        if (PsiType.INT.getPresentableText().equals(string)) {
            return virtualMachineProxyImpl.mirrorOf((int)c2);
        }
        if (PsiType.SHORT.getPresentableText().equals(string)) {
            return virtualMachineProxyImpl.mirrorOf((short)c2);
        }
        if (PsiType.BYTE.getPresentableText().equals(string)) {
            return virtualMachineProxyImpl.mirrorOf((byte)c2);
        }
        return null;
    }

    public static String truncateString(String string) {
        if (string.length() > 1005) {
            return string.substring(0, 1005);
        }
        return string;
    }

    public static String getThreadStatusText(int n2) {
        switch (n2) {
            case 3: {
                return DebuggerBundle.message((String)"status.thread.monitor", (Object[])new Object[0]);
            }
            case 5: {
                return DebuggerBundle.message((String)"status.thread.not.started", (Object[])new Object[0]);
            }
            case 1: {
                return DebuggerBundle.message((String)"status.thread.running", (Object[])new Object[0]);
            }
            case 2: {
                return DebuggerBundle.message((String)"status.thread.sleeping", (Object[])new Object[0]);
            }
            case -1: {
                return DebuggerBundle.message((String)"status.thread.unknown", (Object[])new Object[0]);
            }
            case 4: {
                return DebuggerBundle.message((String)"status.thread.wait", (Object[])new Object[0]);
            }
            case 0: {
                return DebuggerBundle.message((String)"status.thread.zombie", (Object[])new Object[0]);
            }
        }
        return DebuggerBundle.message((String)"status.thread.undefined", (Object[])new Object[0]);
    }

    public static String prepareValueText(String string, Project project2) {
        string = StringUtil.unquoteString((String)string);
        string = StringUtil.unescapeStringCharacters((String)string);
        int n2 = CodeStyle.getSettings((Project)project2).getTabSize((FileType)StdFileTypes.JAVA);
        if (n2 < 0) {
            n2 = 0;
        }
        return string.replace("\t", StringUtil.repeat((String)" ", (int)n2));
    }

    public static void setAlternativeSourceUrl(String string, String string2, Project project2) {
        ConcurrentHashMap<String, String> concurrentHashMap = (ConcurrentHashMap<String, String>)project2.getUserData(e);
        if (concurrentHashMap == null) {
            concurrentHashMap = new ConcurrentHashMap<String, String>();
            project2.putUserData(e, concurrentHashMap);
        }
        concurrentHashMap.put(string, string2);
    }

    @Nullable
    public static String getAlternativeSourceUrl(@Nullable String string, Project project2) {
        Map map = (Map)project2.getUserData(e);
        return map != null ? (String)map.get(string) : null;
    }

    @Nullable
    public static XSourcePosition toXSourcePosition(@Nullable SourcePosition sourcePosition) {
        if (sourcePosition != null) {
            VirtualFile virtualFile = sourcePosition.getFile().getVirtualFile();
            if (virtualFile == null) {
                virtualFile = sourcePosition.getFile().getOriginalFile().getVirtualFile();
            }
            if (virtualFile != null) {
                return new JavaXSourcePosition(sourcePosition, virtualFile);
            }
        }
        return null;
    }

    @Nullable
    public static SourcePosition toSourcePosition(@Nullable XSourcePosition xSourcePosition, Project project2) {
        if (xSourcePosition != null) {
            if (xSourcePosition instanceof JavaXSourcePosition) {
                return ((JavaXSourcePosition)xSourcePosition).b;
            }
            PsiFile psiFile = DebuggerUtilsEx.getPsiFile(xSourcePosition, project2);
            if (psiFile != null) {
                return SourcePosition.createFromLine((PsiFile)psiFile, (int)xSourcePosition.getLine());
            }
        }
        return null;
    }

    @Nullable
    public static PsiFile getPsiFile(@Nullable XSourcePosition xSourcePosition, Project project2) {
        VirtualFile virtualFile;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (xSourcePosition != null && (virtualFile = xSourcePosition.getFile()).isValid()) {
            return PsiManager.getInstance((Project)project2).findFile(virtualFile);
        }
        return null;
    }

    @Nullable
    public static PsiElement findElementAt(@Nullable PsiFile psiFile, int n2) {
        return psiFile != null ? psiFile.findElementAt(n2) : null;
    }

    public static String getLocationMethodQName(@NotNull Location location) {
        if (location == null) {
            DebuggerUtilsEx.a(13);
        }
        StringBuilder stringBuilder = new StringBuilder();
        ReferenceType referenceType = location.declaringType();
        if (referenceType != null) {
            stringBuilder.append(referenceType.name()).append('.');
        }
        stringBuilder.append(location.method().name());
        return stringBuilder.toString();
    }

    private static PsiElement a(PsiElement psiElement) {
        PsiElement psiElement2 = psiElement.getNextSibling();
        if (psiElement2 != null) {
            return psiElement2;
        }
        if ((psiElement = psiElement.getParent()) != null) {
            return DebuggerUtilsEx.a(psiElement);
        }
        return null;
    }

    public static boolean isLambdaClassName(String string) {
        return DebuggerUtilsEx.getLambdaBaseClassName(string) != null;
    }

    @Nullable
    public static String getLambdaBaseClassName(String string) {
        return StringUtil.substringBefore((String)string, (String)"$$Lambda$");
    }

    public static boolean isLambdaName(@Nullable String string) {
        return !StringUtil.isEmpty((String)string) && string.startsWith("lambda$");
    }

    public static boolean isLambda(@Nullable Method method) {
        return method != null && DebuggerUtilsEx.isLambdaName(method.name());
    }

    public static int getLambdaOrdinal(@NotNull String string) {
        int n2;
        if (string == null) {
            DebuggerUtilsEx.a(14);
        }
        if ((n2 = string.lastIndexOf(36)) > -1) {
            try {
                return Integer.parseInt(string.substring(n2 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static List<PsiLambdaExpression> collectLambdas(@NotNull SourcePosition sourcePosition, final boolean bl2) {
        PsiElement psiElement;
        if (sourcePosition == null) {
            DebuggerUtilsEx.a(15);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile psiFile = sourcePosition.getFile();
        final int n2 = sourcePosition.getLine();
        final Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
        if (document == null || n2 >= document.getLineCount()) {
            return Collections.emptyList();
        }
        PsiElement psiElement2 = sourcePosition.getElementAt();
        if (psiElement2 == null) {
            return Collections.emptyList();
        }
        TextRange textRange = DocumentUtil.getLineTextRange((Document)document, (int)n2);
        while ((psiElement = psiElement2.getParent()) != null && psiElement.getTextOffset() >= textRange.getStartOffset()) {
            psiElement2 = psiElement;
        }
        psiElement = new SmartList();
        JavaRecursiveElementVisitor javaRecursiveElementVisitor = new JavaRecursiveElementVisitor((List)psiElement){
            final /* synthetic */ List val$lambdas;
            {
                this.val$lambdas = list2;
            }

            public void visitLambdaExpression(PsiLambdaExpression psiLambdaExpression) {
                super.visitLambdaExpression(psiLambdaExpression);
                if (!bl2 || DebuggerUtilsEx.getFirstElementOnTheLine(psiLambdaExpression, document, n2) != null) {
                    this.val$lambdas.add(psiLambdaExpression);
                }
            }
        };
        psiElement2.accept((PsiElementVisitor)javaRecursiveElementVisitor);
        PsiElement psiElement3 = DebuggerUtilsEx.a(psiElement2);
        while (psiElement3 != null && DebuggerUtilsEx.intersects(textRange, psiElement3)) {
            psiElement3.accept((PsiElementVisitor)javaRecursiveElementVisitor);
            psiElement3 = DebuggerUtilsEx.a(psiElement3);
        }
        psiElement3 = DebuggerUtilsEx.getContainingMethod(psiElement2);
        if (psiElement3 instanceof PsiLambdaExpression && !psiElement.contains(psiElement3)) {
            psiElement.add((PsiLambdaExpression)psiElement3);
        }
        return psiElement;
    }

    @Nullable
    public static PsiElement getBody(PsiElement psiElement) {
        if (psiElement instanceof PsiParameterListOwner) {
            return ((PsiParameterListOwner)psiElement).getBody();
        }
        if (psiElement instanceof PsiClassInitializer) {
            return ((PsiClassInitializer)psiElement).getBody();
        }
        return null;
    }

    @NotNull
    public static PsiParameter[] getParameters(PsiElement psiElement) {
        if (psiElement instanceof PsiParameterListOwner) {
            PsiParameter[] psiParameterArray = ((PsiParameterListOwner)psiElement).getParameterList().getParameters();
            if (psiParameterArray == null) {
                DebuggerUtilsEx.a(16);
            }
            return psiParameterArray;
        }
        if (PsiParameter.EMPTY_ARRAY == null) {
            DebuggerUtilsEx.a(17);
        }
        return PsiParameter.EMPTY_ARRAY;
    }

    public static boolean evaluateBoolean(ExpressionEvaluator expressionEvaluator, EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        Object object = UnBoxingEvaluator.unbox(expressionEvaluator.evaluate((EvaluationContext)evaluationContextImpl), evaluationContextImpl);
        if (!(object instanceof BooleanValue)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.boolean.expected", (Object[])new Object[0]));
        }
        return ((BooleanValue)object).booleanValue();
    }

    public static boolean intersects(@NotNull TextRange textRange, @NotNull PsiElement psiElement) {
        TextRange textRange2;
        if (textRange == null) {
            DebuggerUtilsEx.a(18);
        }
        if (psiElement == null) {
            DebuggerUtilsEx.a(19);
        }
        return (textRange2 = psiElement.getTextRange()) != null && textRange2.intersects(textRange);
    }

    @Nullable
    public static PsiElement getFirstElementOnTheLine(PsiLambdaExpression psiLambdaExpression, Document document, int n2) {
        PsiStatement[] psiStatementArray;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        TextRange textRange = DocumentUtil.getLineTextRange((Document)document, (int)n2);
        if (!DebuggerUtilsEx.intersects(textRange, (PsiElement)psiLambdaExpression)) {
            return null;
        }
        PsiElement psiElement = psiLambdaExpression.getBody();
        if (psiElement == null || !DebuggerUtilsEx.intersects(textRange, psiElement)) {
            return null;
        }
        if (psiElement instanceof PsiCodeBlock && (psiStatementArray = ((PsiCodeBlock)psiElement).getStatements()).length > 0) {
            for (PsiStatement psiStatement : psiStatementArray) {
                if (textRange.contains(psiStatement.getTextOffset())) {
                    return psiStatement;
                }
                if (!DebuggerUtilsEx.intersects(textRange, (PsiElement)psiStatement)) continue;
                for (PsiElement psiElement2 : SyntaxTraverser.psiTraverser((PsiElement)psiStatement)) {
                    if (!textRange.contains(psiElement2.getTextOffset())) continue;
                    return psiElement2;
                }
            }
            return null;
        }
        return psiElement;
    }

    public static boolean inTheMethod(@NotNull SourcePosition sourcePosition, @NotNull PsiElement psiElement) {
        PsiElement psiElement2;
        if (sourcePosition == null) {
            DebuggerUtilsEx.a(20);
        }
        if (psiElement == null) {
            DebuggerUtilsEx.a(21);
        }
        if ((psiElement2 = sourcePosition.getElementAt()) == null) {
            return false;
        }
        return Comparing.equal((Object)DebuggerUtilsEx.getContainingMethod(psiElement2), (Object)psiElement);
    }

    public static boolean inTheSameMethod(@NotNull SourcePosition sourcePosition, @NotNull SourcePosition sourcePosition2) {
        if (sourcePosition == null) {
            DebuggerUtilsEx.a(22);
        }
        if (sourcePosition2 == null) {
            DebuggerUtilsEx.a(23);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiElement psiElement = sourcePosition.getElementAt();
        PsiElement psiElement2 = sourcePosition2.getElementAt();
        if (psiElement == null) {
            return psiElement2 == null;
        }
        if (psiElement2 != null) {
            PsiElement psiElement3 = DebuggerUtilsEx.getContainingMethod(psiElement);
            PsiElement psiElement4 = DebuggerUtilsEx.getContainingMethod(psiElement2);
            return Comparing.equal((Object)psiElement3, (Object)psiElement4);
        }
        return false;
    }

    public static boolean methodMatches(@NotNull PsiMethod psiMethod, String string, String string2, String string3, DebugProcessImpl debugProcessImpl) {
        if (psiMethod == null) {
            DebuggerUtilsEx.a(24);
        }
        PsiClass psiClass = psiMethod.getContainingClass();
        try {
            return psiClass != null && Objects.equals(JVMNameUtil.getClassVMName(psiClass), string) && JVMNameUtil.getJVMMethodName(psiMethod).equals(string2) && JVMNameUtil.getJVMSignature(psiMethod).getName(debugProcessImpl).equals(string3);
        }
        catch (EvaluateException evaluateException) {
            d.debug((Throwable)evaluateException);
            return false;
        }
    }

    @Nullable
    public static PsiElement getContainingMethod(@Nullable PsiElement psiElement) {
        return PsiTreeUtil.getContextOfType((PsiElement)psiElement, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class, PsiClassInitializer.class});
    }

    @Nullable
    public static PsiElement getContainingMethod(@Nullable SourcePosition sourcePosition) {
        if (sourcePosition == null) {
            return null;
        }
        return DebuggerUtilsEx.getContainingMethod(sourcePosition.getElementAt());
    }

    public static void disableCollection(ObjectReference objectReference) {
        try {
            objectReference.disableCollection();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static void enableCollection(ObjectReference objectReference) {
        try {
            objectReference.enableCollection();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static int bytecodeToSourceLine(PsiFile psiFile, int n2) {
        int n3;
        LineNumbersMapping lineNumbersMapping;
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile != null && (lineNumbersMapping = (LineNumbersMapping)virtualFile.getUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY)) != null && (n3 = lineNumbersMapping.bytecodeToSource(n2 + 1)) > -1) {
            return n3 - 1;
        }
        return -1;
    }

    public static boolean isInLibraryContent(@Nullable VirtualFile virtualFile, @NotNull Project project2) {
        if (project2 == null) {
            DebuggerUtilsEx.a(25);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (project2 == null) {
                DebuggerUtilsEx.a(26);
            }
            if (virtualFile == null) {
                return true;
            }
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
            return projectFileIndex.isInLibraryClasses(virtualFile) || projectFileIndex.isInLibrarySource(virtualFile);
        });
    }

    public static boolean isInJavaSession(AnActionEvent anActionEvent) {
        Project project2;
        XDebugSession xDebugSession = (XDebugSession)anActionEvent.getData(XDebugSession.DATA_KEY);
        if (xDebugSession == null && (project2 = anActionEvent.getProject()) != null) {
            xDebugSession = XDebuggerManager.getInstance((Project)project2).getCurrentSession();
        }
        return xDebugSession != null && xDebugSession.getDebugProcess() instanceof JavaDebugProcess;
    }

    static {
        a = 0;
        b = 1;
        e = Key.create((String)"DEBUGGER_ALTERNATIVE_SOURCE_MAPPING");
        LAMBDA_ORDINAL_COMPARATOR = Comparator.comparingInt(method -> DebuggerUtilsEx.getLambdaOrdinal(method.name()));
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseQualifiedName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedType";
                break;
            }
            case 4: 
            case 5: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/DebuggerUtilsEx";
                break;
            }
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos1";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos2";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/DebuggerUtilsEx";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventDescriptors";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeFragmentFactory";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findAppropriateCodeFragmentFactory";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableFrom";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFiltered";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isVoid";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getLocationMethodQName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLambdaOrdinal";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectLambdas";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "inTheMethod";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "inTheSameMethod";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "methodMatches";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isInLibraryContent";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isInLibraryContent$3";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isFiltered$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JavaXSourcePosition
    implements XSourcePosition,
    ExecutionPointHighlighter.HighlighterProvider {
        private final SourcePosition b;
        @NotNull
        private final VirtualFile a;

        public JavaXSourcePosition(@NotNull SourcePosition sourcePosition, @NotNull VirtualFile virtualFile) {
            if (sourcePosition == null) {
                JavaXSourcePosition.a(0);
            }
            if (virtualFile == null) {
                JavaXSourcePosition.a(1);
            }
            this.b = sourcePosition;
            this.a = virtualFile;
        }

        public int getLine() {
            return this.b.getLine();
        }

        public int getOffset() {
            return this.b.getOffset();
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.a;
            if (virtualFile == null) {
                JavaXSourcePosition.a(2);
            }
            return virtualFile;
        }

        @NotNull
        public Navigatable createNavigatable(@NotNull Project project2) {
            if (project2 == null) {
                JavaXSourcePosition.a(3);
            }
            OpenFileDescriptor openFileDescriptor = XSourcePositionImpl.doCreateOpenFileDescriptor((Project)project2, (XSourcePosition)this);
            if (openFileDescriptor == null) {
                JavaXSourcePosition.a(4);
            }
            return openFileDescriptor;
        }

        @Nullable
        public TextRange getHighlightRange() {
            return SourcePositionHighlighter.getHighlightRangeFor((SourcePosition)this.b);
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourcePosition";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/impl/DebuggerUtilsEx$JavaXSourcePosition";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/impl/DebuggerUtilsEx$JavaXSourcePosition";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNavigatable";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createNavigatable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SigReader {
        final String buffer;
        int pos = 0;

        SigReader(String string) {
            this.buffer = string;
        }

        int get() {
            return this.buffer.charAt(this.pos++);
        }

        int peek() {
            return this.buffer.charAt(this.pos);
        }

        boolean eof() {
            return this.buffer.length() <= this.pos;
        }

        @NonNls
        String getSignature() {
            if (this.eof()) {
                return "";
            }
            switch (this.get()) {
                case 90: {
                    return "boolean";
                }
                case 66: {
                    return "byte";
                }
                case 67: {
                    return "char";
                }
                case 83: {
                    return "short";
                }
                case 73: {
                    return "int";
                }
                case 74: {
                    return "long";
                }
                case 70: {
                    return "float";
                }
                case 68: {
                    return "double";
                }
                case 86: {
                    return "void";
                }
                case 76: {
                    int n2 = this.pos;
                    this.pos = this.buffer.indexOf(59, n2) + 1;
                    d.assertTrue(this.pos > 0);
                    return this.buffer.substring(n2, this.pos - 1).replace('/', '.');
                }
                case 91: {
                    return this.getSignature() + "[]";
                }
                case 40: {
                    StringBuilder stringBuilder = new StringBuilder("(");
                    String string = "";
                    while (this.peek() != 41) {
                        stringBuilder.append(string);
                        stringBuilder.append(this.getSignature());
                        string = ", ";
                    }
                    this.get();
                    stringBuilder.append(")");
                    return this.getSignature() + " " + this.getClassName() + "." + this.getMethodName() + " " + stringBuilder;
                }
            }
            return null;
        }

        String getMethodName() {
            return "";
        }

        String getClassName() {
            return "";
        }
    }
}

