/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugEnvironment;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.GenericDebuggerParametersRunnerConfigurable;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.PatchedRunnableState;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteConnectionCreator;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationWithRunnerSettings;
import com.intellij.execution.configurations.RunConfigurationWithSuppressedDefaultDebugAction;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.JavaPatchableProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericDebuggerRunner
extends JavaPatchableProgramRunner<GenericDebuggerRunnerSettings> {
    public boolean canRun(@NotNull String string, @NotNull RunProfile runProfile) {
        if (string == null) {
            GenericDebuggerRunner.a(0);
        }
        if (runProfile == null) {
            GenericDebuggerRunner.a(1);
        }
        return string.equals(DefaultDebugExecutor.EXECUTOR_ID) && runProfile instanceof ModuleRunProfile && !(runProfile instanceof RunConfigurationWithSuppressedDefaultDebugAction);
    }

    @NotNull
    public String getRunnerId() {
        if ("Debug" == null) {
            GenericDebuggerRunner.a(2);
        }
        return "Debug";
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState runProfileState, @NotNull ExecutionEnvironment executionEnvironment) throws ExecutionException {
        if (runProfileState == null) {
            GenericDebuggerRunner.a(3);
        }
        if (executionEnvironment == null) {
            GenericDebuggerRunner.a(4);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        return this.createContentDescriptor(runProfileState, executionEnvironment);
    }

    @Nullable
    protected RunContentDescriptor createContentDescriptor(@NotNull RunProfileState runProfileState, @NotNull ExecutionEnvironment executionEnvironment) throws ExecutionException {
        if (runProfileState == null) {
            GenericDebuggerRunner.a(5);
        }
        if (executionEnvironment == null) {
            GenericDebuggerRunner.a(6);
        }
        if (runProfileState instanceof JavaCommandLine) {
            JavaParameters javaParameters = ((JavaCommandLine)runProfileState).getJavaParameters();
            GenericDebuggerRunner.runCustomPatchers((JavaParameters)javaParameters, (Executor)executionEnvironment.getExecutor(), (RunProfile)executionEnvironment.getRunProfile());
            boolean bl2 = true;
            RemoteConnection remoteConnection = null;
            if (runProfileState instanceof RemoteConnectionCreator) {
                remoteConnection = ((RemoteConnectionCreator)runProfileState).createRemoteConnection(executionEnvironment);
                bl2 = ((RemoteConnectionCreator)runProfileState).isPollConnection();
            }
            if (remoteConnection == null) {
                int n2;
                remoteConnection = DebuggerManagerImpl.createDebugParameters(javaParameters, true, n2, (n2 = DebuggerSettings.getInstance().DEBUGGER_TRANSPORT) == 0 ? "0" : "", false);
                bl2 = true;
            }
            return this.attachVirtualMachine(runProfileState, executionEnvironment, remoteConnection, bl2);
        }
        if (runProfileState instanceof PatchedRunnableState) {
            RemoteConnection remoteConnection = GenericDebuggerRunner.a(new JavaParameters(), executionEnvironment.getRunnerSettings());
            return this.attachVirtualMachine(runProfileState, executionEnvironment, remoteConnection, true);
        }
        if (runProfileState instanceof RemoteState) {
            RemoteConnection remoteConnection = GenericDebuggerRunner.a((RemoteState)runProfileState, executionEnvironment.getRunnerSettings());
            return this.attachVirtualMachine(runProfileState, executionEnvironment, remoteConnection, false);
        }
        return null;
    }

    @Nullable
    protected RunContentDescriptor attachVirtualMachine(RunProfileState runProfileState, @NotNull ExecutionEnvironment executionEnvironment, RemoteConnection remoteConnection, boolean bl2) throws ExecutionException {
        if (executionEnvironment == null) {
            GenericDebuggerRunner.a(7);
        }
        return this.attachVirtualMachine(runProfileState, executionEnvironment, remoteConnection, bl2 ? 30000L : 0L);
    }

    @Nullable
    protected RunContentDescriptor attachVirtualMachine(RunProfileState runProfileState, @NotNull ExecutionEnvironment executionEnvironment, RemoteConnection remoteConnection, long l2) throws ExecutionException {
        if (executionEnvironment == null) {
            GenericDebuggerRunner.a(8);
        }
        DefaultDebugEnvironment defaultDebugEnvironment = new DefaultDebugEnvironment(executionEnvironment, runProfileState, remoteConnection, l2);
        final DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx(executionEnvironment.getProject()).attachVirtualMachine(defaultDebugEnvironment);
        if (debuggerSession == null) {
            return null;
        }
        final DebugProcessImpl debugProcessImpl = debuggerSession.getProcess();
        return XDebuggerManager.getInstance((Project)executionEnvironment.getProject()).startSession(executionEnvironment, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession xDebugSession) {
                if (xDebugSession == null) {
                    1.a(0);
                }
                XDebugSessionImpl xDebugSessionImpl = (XDebugSessionImpl)xDebugSession;
                ExecutionResult executionResult = debugProcessImpl.getExecutionResult();
                xDebugSessionImpl.addExtraActions(executionResult.getActions());
                if (executionResult instanceof DefaultExecutionResult) {
                    xDebugSessionImpl.addRestartActions(((DefaultExecutionResult)executionResult).getRestartActions());
                }
                JavaDebugProcess javaDebugProcess = JavaDebugProcess.create(xDebugSession, debuggerSession);
                if (javaDebugProcess == null) {
                    1.a(1);
                }
                return javaDebugProcess;
            }

            private static /* synthetic */ void a(int n2) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n3;
                String string;
                switch (n2) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        n3 = 3;
                        break;
                    }
                    case 1: {
                        n3 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/debugger/impl/GenericDebuggerRunner$1";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/debugger/impl/GenericDebuggerRunner$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n2) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }).getRunContentDescriptor();
    }

    private static RemoteConnection a(RemoteState remoteState, RunnerSettings runnerSettings) {
        RemoteConnection remoteConnection = remoteState.getRemoteConnection();
        GenericDebuggerRunnerSettings genericDebuggerRunnerSettings = (GenericDebuggerRunnerSettings)runnerSettings;
        if (genericDebuggerRunnerSettings != null) {
            remoteConnection.setUseSockets(genericDebuggerRunnerSettings.getTransport() == 0);
            remoteConnection.setAddress(genericDebuggerRunnerSettings.getDebugPort());
        }
        return remoteConnection;
    }

    public GenericDebuggerRunnerSettings createConfigurationData(ConfigurationInfoProvider configurationInfoProvider) {
        return new GenericDebuggerRunnerSettings();
    }

    public void patch(JavaParameters javaParameters, RunnerSettings runnerSettings, RunProfile runProfile, boolean bl2) throws ExecutionException {
        GenericDebuggerRunner.a(javaParameters, runnerSettings);
        GenericDebuggerRunner.runCustomPatchers((JavaParameters)javaParameters, (Executor)((Executor)Executor.EXECUTOR_EXTENSION_NAME.findExtension(DefaultDebugExecutor.class)), (RunProfile)runProfile);
    }

    private static RemoteConnection a(JavaParameters javaParameters, RunnerSettings runnerSettings) throws ExecutionException {
        GenericDebuggerRunnerSettings genericDebuggerRunnerSettings = (GenericDebuggerRunnerSettings)runnerSettings;
        if (StringUtil.isEmpty((String)genericDebuggerRunnerSettings.getDebugPort())) {
            genericDebuggerRunnerSettings.setDebugPort(DebuggerUtils.getInstance().findAvailableDebugAddress(genericDebuggerRunnerSettings.getTransport() == 0));
        }
        return DebuggerManagerImpl.createDebugParameters(javaParameters, genericDebuggerRunnerSettings, false);
    }

    public SettingsEditor<GenericDebuggerRunnerSettings> getSettingsEditor(Executor executor, RunConfiguration runConfiguration) {
        if (runConfiguration instanceof RunConfigurationWithRunnerSettings && ((RunConfigurationWithRunnerSettings)runConfiguration).isSettingsNeeded()) {
            return new GenericDebuggerParametersRunnerConfigurable(runConfiguration.getProject());
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/GenericDebuggerRunner";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/GenericDebuggerRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerId";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createContentDescriptor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "attachVirtualMachine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

