/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapFile;
import com.intellij.debugger.impl.HotSwapProgress;
import com.intellij.debugger.impl.MultiProcessCommand;
import com.intellij.debugger.impl.ReloadClassesWorker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class HotSwapManager
extends AbstractProjectComponent {
    private final Map<DebuggerSession, Long> b = new HashMap<DebuggerSession, Long>();
    private static final String a = ".class";

    public HotSwapManager(Project project2, DebuggerManagerEx debuggerManagerEx) {
        super(project2);
        debuggerManagerEx.addDebuggerManagerListener(new DebuggerManagerListener(){

            @Override
            public void sessionCreated(DebuggerSession debuggerSession) {
                HotSwapManager.this.b.put(debuggerSession, System.currentTimeMillis());
            }

            @Override
            public void sessionRemoved(DebuggerSession debuggerSession) {
                HotSwapManager.this.b.remove(debuggerSession);
            }
        });
    }

    @NotNull
    public String getComponentName() {
        if ("HotSwapManager" == null) {
            HotSwapManager.a(0);
        }
        return "HotSwapManager";
    }

    private long a(DebuggerSession debuggerSession) {
        Long l2 = this.b.get(debuggerSession);
        return l2 != null ? l2 : 0L;
    }

    void setTimeStamp(DebuggerSession debuggerSession, long l2) {
        this.b.put(debuggerSession, l2);
    }

    public Map<String, HotSwapFile> scanForModifiedClasses(DebuggerSession debuggerSession, HotSwapProgress hotSwapProgress) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        long l2 = this.a(debuggerSession);
        HashMap<String, HotSwapFile> hashMap = new HashMap<String, HotSwapFile>();
        ArrayList arrayList = new ArrayList();
        ApplicationManager.getApplication().runReadAction(() -> {
            List list3 = OrderEnumerator.orderEntries((Project)this.myProject).withoutSdk().withoutLibraries().getPathsList().getRootDirs();
            for (VirtualFile virtualFile : list3) {
                arrayList.add(new File(virtualFile.getPath()));
            }
        });
        for (File file : arrayList) {
            String string = FileUtil.toCanonicalPath((String)file.getPath());
            HotSwapManager.a(file, string, string + "/", hashMap, hotSwapProgress, l2);
        }
        return hashMap;
    }

    private static boolean a(File file, String string, String string2, Map<String, HotSwapFile> map, HotSwapProgress hotSwapProgress, long l2) {
        if (hotSwapProgress.isCancelled()) {
            return false;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (HotSwapManager.a(file2, string + "/" + file2.getName(), string2, map, hotSwapProgress, l2)) continue;
                return false;
            }
        } else if ((SystemInfo.isFileSystemCaseSensitive ? StringUtil.endsWith((CharSequence)string, (CharSequence)a) : StringUtil.endsWithIgnoreCase((String)string, (String)a)) && file.lastModified() > l2) {
            hotSwapProgress.setText(DebuggerBundle.message((String)"progress.hotswap.scanning.path", (Object[])new Object[]{string}));
            String string3 = string.substring(string2.length(), string.length() - a.length()).replace('/', '.');
            map.put(string3, new HotSwapFile(file));
        }
        return true;
    }

    public static HotSwapManager getInstance(Project project2) {
        return (HotSwapManager)((Object)project2.getComponent(HotSwapManager.class));
    }

    private void a(DebuggerSession debuggerSession, Map<String, HotSwapFile> map, HotSwapProgress hotSwapProgress) {
        long l2 = System.currentTimeMillis();
        new ReloadClassesWorker(debuggerSession, hotSwapProgress).reloadClasses(map);
        if (hotSwapProgress.isCancelled()) {
            debuggerSession.setModifiedClassesScanRequired(true);
        } else {
            this.setTimeStamp(debuggerSession, l2);
        }
    }

    public static Map<DebuggerSession, Map<String, HotSwapFile>> findModifiedClasses(List<DebuggerSession> list2, Map<String, List<String>> map) {
        HashMap<DebuggerSession, Map<String, HotSwapFile>> hashMap = new HashMap<DebuggerSession, Map<String, HotSwapFile>>();
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        for (DebuggerSession object : list2) {
            arrayList.add(new Pair((Object)object, (Object)HotSwapManager.getInstance(object.getProject()).a(object)));
        }
        for (Map.Entry entry : map.entrySet()) {
            File file = new File((String)entry.getKey());
            for (String string : (List)entry.getValue()) {
                if (!(SystemInfo.isFileSystemCaseSensitive ? StringUtil.endsWith((CharSequence)string, (CharSequence)a) : StringUtil.endsWithIgnoreCase((String)string, (String)a))) continue;
                String string2 = string.substring(0, string.length() - a.length()).replace('/', '.');
                HotSwapFile hotSwapFile = new HotSwapFile(new File(file, string));
                long l2 = hotSwapFile.file.lastModified();
                for (Pair pair2 : arrayList) {
                    DebuggerSession debuggerSession2 = (DebuggerSession)pair2.first;
                    if (l2 <= (Long)pair2.second) continue;
                    hashMap.computeIfAbsent(debuggerSession2, debuggerSession -> new HashMap()).put(string2, hotSwapFile);
                }
            }
        }
        return hashMap;
    }

    public static Map<DebuggerSession, Map<String, HotSwapFile>> scanForModifiedClasses(List<DebuggerSession> list2, final HotSwapProgress hotSwapProgress) {
        final HashMap<DebuggerSession, Map<String, HotSwapFile>> hashMap = new HashMap<DebuggerSession, Map<String, HotSwapFile>>();
        MultiProcessCommand multiProcessCommand = new MultiProcessCommand();
        hotSwapProgress.setCancelWorker(() -> multiProcessCommand.cancel());
        for (final DebuggerSession debuggerSession : list2) {
            if (!debuggerSession.isAttached()) continue;
            multiProcessCommand.addCommand(debuggerSession.getProcess(), new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    hotSwapProgress.setDebuggerSession(debuggerSession);
                    Map<String, HotSwapFile> map = HotSwapManager.getInstance(hotSwapProgress.getProject()).scanForModifiedClasses(debuggerSession, hotSwapProgress);
                    if (!map.isEmpty()) {
                        hashMap.put(debuggerSession, map);
                    }
                }
            });
        }
        hotSwapProgress.setTitle(DebuggerBundle.message((String)"progress.hotswap.scanning.classes", (Object[])new Object[0]));
        multiProcessCommand.run();
        if (hotSwapProgress.isCancelled()) {
            for (final DebuggerSession debuggerSession : list2) {
                debuggerSession.setModifiedClassesScanRequired(true);
            }
            return new HashMap<DebuggerSession, Map<String, HotSwapFile>>();
        }
        return hashMap;
    }

    public static void reloadModifiedClasses(final Map<DebuggerSession, Map<String, HotSwapFile>> map, final HotSwapProgress hotSwapProgress) {
        MultiProcessCommand multiProcessCommand = new MultiProcessCommand();
        hotSwapProgress.setCancelWorker(() -> multiProcessCommand.cancel());
        for (final DebuggerSession debuggerSession : map.keySet()) {
            multiProcessCommand.addCommand(debuggerSession.getProcess(), new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    hotSwapProgress.setDebuggerSession(debuggerSession);
                    HotSwapManager.getInstance(hotSwapProgress.getProject()).a(debuggerSession, (Map)map.get(debuggerSession), hotSwapProgress);
                }

                @Override
                protected void commandCancelled() {
                    debuggerSession.setModifiedClassesScanRequired(true);
                }
            });
        }
        hotSwapProgress.setTitle(DebuggerBundle.message((String)"progress.hotswap.reloading", (Object[])new Object[0]));
        multiProcessCommand.run();
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/HotSwapManager", "getComponentName"));
    }
}

