/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecompiledLocalVariable {
    public static final String PARAM_PREFIX = "param_";
    public static final String SLOT_PREFIX = "slot_";
    private final int c;
    private final String a;
    private final boolean d;
    private final Collection<String> b;

    public DecompiledLocalVariable(int n2, boolean bl2, @Nullable String string, @NotNull Collection<String> collection) {
        if (collection == null) {
            DecompiledLocalVariable.a(0);
        }
        this.c = n2;
        this.d = bl2;
        this.a = string;
        this.b = collection;
    }

    public int getSlot() {
        return this.c;
    }

    @Nullable
    public String getSignature() {
        return this.a;
    }

    public boolean isParam() {
        return this.d;
    }

    @NotNull
    public String getDefaultName() {
        String string = (this.d ? PARAM_PREFIX : SLOT_PREFIX) + this.c;
        if (string == null) {
            DecompiledLocalVariable.a(1);
        }
        return string;
    }

    public String getDisplayName() {
        String string = StringUtil.join(this.b, (String)" | ");
        if (this.d && this.b.size() == 1) {
            return string;
        }
        if (!this.b.isEmpty()) {
            return string + " (" + this.getDefaultName() + ")";
        }
        return this.getDefaultName();
    }

    @NotNull
    public Collection<String> getMatchedNames() {
        Collection<String> collection = this.b;
        if (collection == null) {
            DecompiledLocalVariable.a(2);
        }
        return collection;
    }

    public String toString() {
        return this.getDisplayName() + " (slot " + this.c + ", " + this.a + ")";
    }

    public static int getParamId(@Nullable String string) {
        String string2;
        if (!StringUtil.isEmpty((String)string) && (string2 = StringUtil.substringAfter((String)string, (String)PARAM_PREFIX)) != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/jdi/DecompiledLocalVariable";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/jdi/DecompiledLocalVariable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchedNames";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

