/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.SimpleStackFrameContext;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.MultiMap;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class LocalVariablesUtil {
    private static final Logger g;
    private static final boolean f;
    private static Class<?> a;
    private static Constructor<?> i;
    private static Method b;
    private static Method j;
    private static final boolean d;
    private static Class<?> e;
    private static Constructor<?> k;
    private static Method c;
    private static Method h;

    public static Map<DecompiledLocalVariable, Value> fetchValues(@NotNull StackFrameProxyImpl stackFrameProxyImpl, DebugProcess debugProcess, boolean bl2) throws Exception {
        if (stackFrameProxyImpl == null) {
            LocalVariablesUtil.a(0);
        }
        LinkedHashMap<DecompiledLocalVariable, Value> linkedHashMap = new LinkedHashMap<DecompiledLocalVariable, Value>();
        Location location = stackFrameProxyImpl.location();
        com.sun.jdi.Method method = location.method();
        int n2 = LocalVariablesUtil.a(method);
        MultiMap<Integer, String> multiMap = bl2 ? LocalVariablesUtil.a(new SimpleStackFrameContext(stackFrameProxyImpl, debugProcess), n2) : MultiMap.empty();
        int n3 = LocalVariablesUtil.b(method);
        List<String> list2 = method.argumentTypeNames();
        List<Value> list3 = stackFrameProxyImpl.getArgumentValues();
        for (int i2 = 0; i2 < list3.size(); ++i2) {
            linkedHashMap.put(new DecompiledLocalVariable(n3, true, null, multiMap.get((Object)n3)), list3.get(i2));
            n3 += LocalVariablesUtil.a(list2.get(i2));
        }
        if (!bl2 || !f) {
            return linkedHashMap;
        }
        List<DecompiledLocalVariable> list4 = LocalVariablesUtil.a(stackFrameProxyImpl.getVirtualMachine(), location, multiMap);
        StackFrame stackFrame = stackFrameProxyImpl.getStackFrame();
        for (int i3 = list4.size(); i3 > 0; --i3) {
            try {
                return LocalVariablesUtil.a(linkedHashMap, list4.subList(0, i3), stackFrame);
            }
            catch (Exception exception) {
                g.debug((Throwable)exception);
                continue;
            }
        }
        return linkedHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<DecompiledLocalVariable, Value> a(Map<DecompiledLocalVariable, Value> map, List<DecompiledLocalVariable> list2, StackFrame stackFrame) throws Exception {
        Object object;
        Object object2;
        Long l2 = (Long)ReflectionUtil.getField(stackFrame.getClass(), (Object)stackFrame, Long.TYPE, (String)"id");
        VirtualMachine virtualMachine = stackFrame.virtualMachine();
        Method method = virtualMachine.getClass().getDeclaredMethod("state", new Class[0]);
        method.setAccessible(true);
        Object object3 = LocalVariablesUtil.a(list2);
        Object object4 = object2 = method.invoke((Object)virtualMachine, new Object[0]);
        synchronized (object4) {
            object = b.invoke(null, virtualMachine, stackFrame.thread(), l2, object3);
        }
        object4 = j.invoke(null, virtualMachine, object);
        Value[] valueArray = (Value[])ReflectionUtil.getField(object4.getClass(), (Object)object4, Value[].class, (String)"values");
        if (list2.size() != valueArray.length) {
            throw new InternalException("Wrong number of values returned from target VM");
        }
        int n2 = 0;
        for (DecompiledLocalVariable decompiledLocalVariable : list2) {
            map.put(decompiledLocalVariable, valueArray[n2++]);
        }
        return map;
    }

    public static boolean canSetValues() {
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setValue(StackFrame stackFrame, int n2, Value value) throws EvaluateException {
        try {
            Object object;
            Object object2;
            Long l2 = (Long)ReflectionUtil.getField(stackFrame.getClass(), (Object)stackFrame, Long.TYPE, (String)"id");
            VirtualMachine virtualMachine = stackFrame.virtualMachine();
            Method method = virtualMachine.getClass().getDeclaredMethod("state", new Class[0]);
            method.setAccessible(true);
            Object object3 = LocalVariablesUtil.a(n2, value);
            Object object4 = object2 = method.invoke((Object)virtualMachine, new Object[0]);
            synchronized (object4) {
                object = c.invoke(null, virtualMachine, stackFrame.thread(), l2, object3);
            }
            h.invoke(null, virtualMachine, object);
        }
        catch (Exception exception) {
            throw new EvaluateException("Unable to set value", (Throwable)exception);
        }
    }

    private static Object a(int n2, Value value) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Object object = Array.newInstance(e, 1);
        Array.set(object, 0, k.newInstance(n2, value));
        return object;
    }

    private static Object a(Collection<DecompiledLocalVariable> collection) throws Exception {
        Object object = Array.newInstance(a, collection.size());
        int n2 = 0;
        for (DecompiledLocalVariable decompiledLocalVariable : collection) {
            Object obj = i.newInstance(decompiledLocalVariable.getSlot(), (byte)decompiledLocalVariable.getSignature().charAt(0));
            Array.set(object, n2++, obj);
        }
        return object;
    }

    private static Method a(Class clazz, String string) throws NoSuchMethodException {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!string.equals(method.getName())) continue;
            method.setAccessible(true);
            return method;
        }
        throw new NoSuchMethodException(clazz.getName() + "." + string);
    }

    @NotNull
    private static List<DecompiledLocalVariable> a(VirtualMachineProxyImpl virtualMachineProxyImpl, Location location, final MultiMap<Integer, String> multiMap) {
        block12: {
            ArrayList<DecompiledLocalVariable> arrayList;
            HashMap hashMap;
            block13: {
                byte[] byArray;
                com.sun.jdi.Method method;
                block11: {
                    if (!virtualMachineProxyImpl.canGetBytecodes()) {
                        List<DecompiledLocalVariable> list2 = Collections.emptyList();
                        if (list2 == null) {
                            LocalVariablesUtil.a(1);
                        }
                        return list2;
                    }
                    g.assertTrue(location != null);
                    method = location.method();
                    Location location2 = method.location();
                    if (location2 != null && location2.codeIndex() >= 0L) break block11;
                    List<DecompiledLocalVariable> list3 = Collections.emptyList();
                    if (list3 == null) {
                        LocalVariablesUtil.a(2);
                    }
                    return list3;
                }
                long l2 = location.codeIndex();
                if (l2 <= 0L || (byArray = method.bytecodes()) == null || byArray.length <= 0) break block12;
                final int n2 = LocalVariablesUtil.a(method);
                hashMap = new HashMap();
                MethodBytecodeUtil.visit(method, l2, new MethodVisitor(393216){

                    public void visitVarInsn(int n22, int n3) {
                        if (n3 >= n2) {
                            DecompiledLocalVariable decompiledLocalVariable = (DecompiledLocalVariable)hashMap.get(n3);
                            String string = MethodBytecodeUtil.getVarInstructionType(n22).getDescriptor();
                            if (decompiledLocalVariable == null || !string.equals(decompiledLocalVariable.getSignature())) {
                                decompiledLocalVariable = new DecompiledLocalVariable(n3, false, string, multiMap.get((Object)n3));
                                hashMap.put(n3, decompiledLocalVariable);
                            }
                        }
                    }
                }, false);
                if (!hashMap.isEmpty()) break block13;
                List<DecompiledLocalVariable> list4 = Collections.emptyList();
                if (list4 == null) {
                    LocalVariablesUtil.a(3);
                }
                return list4;
            }
            try {
                ArrayList<DecompiledLocalVariable> arrayList2 = new ArrayList<DecompiledLocalVariable>(hashMap.values());
                arrayList2.sort(Comparator.comparingInt(DecompiledLocalVariable::getSlot));
                arrayList = arrayList2;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                break block12;
            }
            catch (Exception exception) {
                g.error((Throwable)exception);
            }
            if (arrayList == null) {
                LocalVariablesUtil.a(4);
            }
            return arrayList;
        }
        List<DecompiledLocalVariable> list5 = Collections.emptyList();
        if (list5 == null) {
            LocalVariablesUtil.a(5);
        }
        return list5;
    }

    @NotNull
    private static MultiMap<Integer, String> a(@NotNull StackFrameContext stackFrameContext, int n2) {
        SourcePosition sourcePosition;
        if (stackFrameContext == null) {
            LocalVariablesUtil.a(6);
        }
        if ((sourcePosition = ContextUtil.getSourcePosition(stackFrameContext)) != null) {
            MultiMap multiMap = (MultiMap)ReadAction.compute(() -> {
                PsiElement psiElement = sourcePosition.getElementAt();
                PsiElement psiElement2 = DebuggerUtilsEx.getContainingMethod(psiElement);
                if (psiElement2 != null) {
                    MultiMap multiMap = new MultiMap();
                    int n3 = Math.max(0, n2 - LocalVariablesUtil.a(psiElement2));
                    for (PsiParameter psiParameter : DebuggerUtilsEx.getParameters(psiElement2)) {
                        multiMap.putValue((Object)n3, (Object)psiParameter.getName());
                        n3 += LocalVariablesUtil.a(psiParameter.getType());
                    }
                    PsiElement psiElement3 = DebuggerUtilsEx.getBody(psiElement2);
                    if (psiElement3 != null) {
                        try {
                            psiElement3.accept((PsiElementVisitor)new LocalVariableNameFinder(n2, (MultiMap<Integer, String>)multiMap, psiElement));
                        }
                        catch (Exception exception) {
                            g.info((Throwable)exception);
                        }
                    }
                    return multiMap;
                }
                return MultiMap.empty();
            });
            if (multiMap == null) {
                LocalVariablesUtil.a(7);
            }
            return multiMap;
        }
        MultiMap multiMap = MultiMap.empty();
        if (multiMap == null) {
            LocalVariablesUtil.a(8);
        }
        return multiMap;
    }

    private static int a(PsiElement psiElement) {
        return Arrays.stream(DebuggerUtilsEx.getParameters(psiElement)).mapToInt(psiParameter -> LocalVariablesUtil.a(psiParameter.getType())).sum();
    }

    private static int a(PsiType psiType) {
        if (PsiType.DOUBLE.equals((Object)psiType) || PsiType.LONG.equals((Object)psiType)) {
            return 2;
        }
        return 1;
    }

    private static int b(com.sun.jdi.Method method) {
        return method.isStatic() ? 0 : 1;
    }

    private static int a(com.sun.jdi.Method method) {
        return LocalVariablesUtil.b(method) + method.argumentTypeNames().stream().mapToInt(LocalVariablesUtil::a).sum();
    }

    private static int a(String string) {
        if ("double".equals(string) || "long".equals(string)) {
            return 2;
        }
        return 1;
    }

    static {
        Class<?> clazz;
        String string;
        g = Logger.getInstance((String)"#com.intellij.debugger.jdi.LocalVariablesUtil");
        boolean bl2 = false;
        try {
            string = "com.sun.tools.jdi.JDWP$StackFrame$GetValues";
            a = Class.forName(string + "$SlotInfo");
            i = a.getDeclaredConstructor(Integer.TYPE, Byte.TYPE);
            i.setAccessible(true);
            clazz = Class.forName(string);
            b = LocalVariablesUtil.a(clazz, "enqueueCommand");
            j = LocalVariablesUtil.a(clazz, "waitForReply");
            bl2 = true;
        }
        catch (Throwable throwable) {
            g.info(throwable);
        }
        f = bl2;
        bl2 = false;
        try {
            string = "com.sun.tools.jdi.JDWP$StackFrame$SetValues";
            e = Class.forName(string + "$SlotInfo");
            k = e.getDeclaredConstructors()[0];
            k.setAccessible(true);
            clazz = Class.forName(string);
            c = LocalVariablesUtil.a(clazz, "enqueueCommand");
            h = LocalVariablesUtil.a(clazz, "waitForReply");
            bl2 = true;
        }
        catch (Throwable throwable) {
            g.info(throwable);
        }
        d = bl2;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameProxy";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/jdi/LocalVariablesUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/jdi/LocalVariablesUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectVariablesFromBytecode";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "calcNames";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fetchValues";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calcNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LocalVariableNameFinder
    extends JavaRecursiveElementVisitor {
        private final MultiMap<Integer, String> a;
        private int c;
        private final PsiElement d;
        private final Deque<Integer> b = new LinkedList<Integer>();
        private boolean e = false;

        public LocalVariableNameFinder(int n2, MultiMap<Integer, String> multiMap, PsiElement psiElement) {
            this.a = multiMap;
            this.c = n2;
            this.d = psiElement;
        }

        private boolean a(PsiElement psiElement) {
            return !this.e && PsiTreeUtil.isContextAncestor((PsiElement)psiElement, (PsiElement)this.d, (boolean)false);
        }

        public void visitElement(PsiElement psiElement) {
            if (psiElement == this.d) {
                this.e = true;
            } else {
                super.visitElement(psiElement);
            }
        }

        public void visitLocalVariable(PsiLocalVariable psiLocalVariable) {
            super.visitLocalVariable(psiLocalVariable);
            if (!this.e) {
                this.a(psiLocalVariable.getName());
                this.c += LocalVariablesUtil.a(psiLocalVariable.getType());
            }
        }

        public void visitSynchronizedStatement(PsiSynchronizedStatement psiSynchronizedStatement) {
            if (this.a((PsiElement)psiSynchronizedStatement)) {
                this.b.push(this.c);
                try {
                    this.a("<monitor>");
                    ++this.c;
                    super.visitSynchronizedStatement(psiSynchronizedStatement);
                }
                finally {
                    this.c = this.b.pop();
                }
            }
        }

        private void a(String string) {
            this.a.putValue((Object)this.c, (Object)string);
        }

        public void visitCodeBlock(PsiCodeBlock psiCodeBlock) {
            if (this.a((PsiElement)psiCodeBlock)) {
                this.b.push(this.c);
                try {
                    super.visitCodeBlock(psiCodeBlock);
                }
                finally {
                    this.c = this.b.pop();
                }
            }
        }

        public void visitForStatement(PsiForStatement psiForStatement) {
            if (this.a((PsiElement)psiForStatement)) {
                this.b.push(this.c);
                try {
                    super.visitForStatement(psiForStatement);
                }
                finally {
                    this.c = this.b.pop();
                }
            }
        }

        public void visitForeachStatement(PsiForeachStatement psiForeachStatement) {
            if (this.a((PsiElement)psiForeachStatement)) {
                this.b.push(this.c);
                try {
                    super.visitForeachStatement(psiForeachStatement);
                }
                finally {
                    this.c = this.b.pop();
                }
            }
        }

        public void visitCatchSection(PsiCatchSection psiCatchSection) {
            if (this.a((PsiElement)psiCatchSection)) {
                this.b.push(this.c);
                try {
                    super.visitCatchSection(psiCatchSection);
                }
                finally {
                    this.c = this.b.pop();
                }
            }
        }

        public void visitResourceList(PsiResourceList psiResourceList) {
            if (this.a((PsiElement)psiResourceList)) {
                this.b.push(this.c);
                try {
                    super.visitResourceList(psiResourceList);
                }
                finally {
                    this.c = this.b.pop();
                }
            }
        }

        public void visitClass(PsiClass psiClass) {
        }
    }
}

