/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.Patches;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.jdi.ClassesByNameProvider;
import com.intellij.debugger.jdi.JdiTimer;
import com.intellij.debugger.jdi.ObjectReferenceProxyImpl;
import com.intellij.debugger.jdi.StringReferenceProxy;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThreeState;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InternalException;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidValue;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.request.EventRequestManager;
import com.sun.tools.jdi.JNITypeParser;
import com.sun.tools.jdi.TargetVM;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualMachineProxyImpl
implements JdiTimer,
VirtualMachineProxy {
    private static final Logger e = Logger.getInstance((String)"#com.intellij.debugger.jdi.VirtualMachineProxyImpl");
    private final DebugProcessImpl s;
    private final VirtualMachine j;
    private int v;
    private int u;
    private final Map<ObjectReference, ObjectReferenceProxyImpl> z;
    private final Map<String, StringReference> n;
    @NotNull
    private final Map<ThreadReference, ThreadReferenceProxyImpl> p;
    private final Map<ThreadGroupReference, ThreadGroupReferenceProxyImpl> y;
    private boolean h;
    private List<ReferenceType> x;
    private Map<ReferenceType, List<ReferenceType>> f;
    public final Throwable mySuspendLogger;
    private final boolean C;
    private final boolean d;
    private final Capability q;
    private final Capability B;
    private final Capability c;
    private final Capability w;
    private final Capability A;
    private final Capability g;
    private final Capability a;
    private final Capability b;
    private final Capability k;
    private final Capability t;
    private final Capability m;
    private final Capability F;
    private final Capability l;
    private final Capability E;
    private final Capability i;
    private final Capability D;
    private final Capability r;
    private final Capability o;
    private final Capability G;

    public VirtualMachineProxyImpl(DebugProcessImpl debugProcessImpl, @NotNull VirtualMachine virtualMachine) {
        if (virtualMachine == null) {
            VirtualMachineProxyImpl.a(0);
        }
        this.v = 0;
        this.u = 0;
        this.z = new HashMap<ObjectReference, ObjectReferenceProxyImpl>();
        this.n = new HashMap<String, StringReference>();
        this.p = new ConcurrentHashMap<ThreadReference, ThreadReferenceProxyImpl>();
        this.y = new HashMap<ThreadGroupReference, ThreadGroupReferenceProxyImpl>();
        this.h = true;
        this.f = new HashMap<ReferenceType, List<ReferenceType>>();
        this.mySuspendLogger = new Throwable();
        this.q = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.j.canWatchFieldModification();
            }
        };
        this.B = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.j.canWatchFieldAccess();
            }
        };
        this.c = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.isJ2ME();
            }
        };
        this.w = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.j.canGetBytecodes();
            }
        };
        this.A = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.j.canGetSyntheticAttribute();
            }
        };
        this.g = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.j.canGetOwnedMonitorInfo();
            }
        };
        this.a = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.j.canGetMonitorFrameInfo();
            }
        };
        this.b = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.j.canGetCurrentContendedMonitor();
            }
        };
        this.k = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.j.canGetMonitorInfo();
            }
        };
        this.t = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.d && VirtualMachineProxyImpl.this.j.canUseInstanceFilters();
            }
        };
        this.m = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.d && VirtualMachineProxyImpl.this.j.canRedefineClasses();
            }
        };
        this.F = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.d && VirtualMachineProxyImpl.this.j.canAddMethod();
            }
        };
        this.l = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.d && VirtualMachineProxyImpl.this.j.canUnrestrictedlyRedefineClasses();
            }
        };
        this.E = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.d && VirtualMachineProxyImpl.this.j.canPopFrames();
            }
        };
        this.i = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.j.canForceEarlyReturn();
            }
        };
        this.D = new Capability(){

            @Override
            protected boolean calcValue() {
                if (!VirtualMachineProxyImpl.this.C) {
                    return false;
                }
                try {
                    Method method = VirtualMachine.class.getMethod("canGetInstanceInfo", new Class[0]);
                    return (Boolean)method.invoke((Object)VirtualMachineProxyImpl.this.j, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    e.error((Throwable)reflectiveOperationException);
                }
                return false;
            }
        };
        this.r = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.d && VirtualMachineProxyImpl.this.j.canGetSourceDebugExtension();
            }
        };
        this.o = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.d && VirtualMachineProxyImpl.this.j.canRequestVMDeathEvent();
            }
        };
        this.G = new Capability(){

            @Override
            protected boolean calcValue() {
                if (VirtualMachineProxyImpl.this.C) {
                    try {
                        Method method = VirtualMachine.class.getDeclaredMethod("canGetMethodReturnValues", new Class[0]);
                        Boolean bl2 = (Boolean)method.invoke((Object)VirtualMachineProxyImpl.this.j, new Object[0]);
                        return bl2;
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                        // empty catch block
                    }
                }
                return false;
            }
        };
        this.j = virtualMachine;
        this.s = debugProcessImpl;
        this.C = this.versionHigher("1.5");
        this.d = this.C || this.versionHigher("1.4");
        this.canRedefineClasses();
        this.canWatchFieldModification();
        this.canPopFrames();
        try {
            virtualMachine.allClasses();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw vMDisconnectedException;
        }
        catch (Throwable throwable) {
            e.info(throwable);
        }
        virtualMachine.topLevelThreadGroups().forEach(this::threadGroupCreated);
    }

    @NotNull
    public VirtualMachine getVirtualMachine() {
        VirtualMachine virtualMachine = this.j;
        if (virtualMachine == null) {
            VirtualMachineProxyImpl.a(1);
        }
        return virtualMachine;
    }

    public ClassesByNameProvider getClassesByNameProvider() {
        return this::classesByName;
    }

    public List<ReferenceType> classesByName(@NotNull String string) {
        if (string == null) {
            VirtualMachineProxyImpl.a(2);
        }
        return this.j.classesByName(string);
    }

    public List<ReferenceType> nestedTypes(ReferenceType referenceType) {
        List<Object> list2 = this.f.get(referenceType);
        if (list2 == null) {
            List<Object> list3 = Collections.emptyList();
            try {
                list3 = referenceType.nestedTypes();
            }
            catch (Throwable throwable) {
                e.info(throwable);
            }
            if (!list3.isEmpty()) {
                HashSet<Object> hashSet = new HashSet<Object>();
                ClassLoaderReference classLoaderReference = referenceType.classLoader();
                for (Object object : list3) {
                    try {
                        if (!(classLoaderReference == null ? object.classLoader() == null : classLoaderReference.equals(object.classLoader()))) continue;
                        hashSet.add(object);
                    }
                    catch (ObjectCollectedException objectCollectedException) {}
                }
                if (!hashSet.isEmpty()) {
                    HashSet hashSet2 = new HashSet();
                    for (ReferenceType referenceType2 : hashSet) {
                        hashSet2.addAll(this.nestedTypes(referenceType2));
                    }
                    hashSet.removeAll(hashSet2);
                }
                list2 = hashSet.isEmpty() ? Collections.emptyList() : new ArrayList(hashSet);
            } else {
                list2 = Collections.emptyList();
            }
            this.f.put(referenceType, list2);
        }
        return list2;
    }

    public List<ReferenceType> allClasses() {
        List<ReferenceType> list2 = this.x;
        if (list2 == null) {
            this.x = list2 = this.j.allClasses();
        }
        return list2;
    }

    public String toString() {
        return this.j.toString();
    }

    public void redefineClasses(Map<ReferenceType, byte[]> map) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            this.j.redefineClasses(map);
        }
        finally {
            this.clearCaches();
        }
    }

    public Collection<ThreadReferenceProxyImpl> allThreads() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.h) {
            this.h = false;
            for (ThreadReference threadReference : this.j.allThreads()) {
                this.getThreadReferenceProxy(threadReference);
            }
        }
        return new ArrayList<ThreadReferenceProxyImpl>(this.p.values());
    }

    public void threadStarted(ThreadReference threadReference) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.getThreadReferenceProxy(threadReference);
    }

    public void threadStopped(ThreadReference threadReference) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.p.remove(threadReference);
    }

    public void suspend() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ++this.u;
        this.j.suspend();
        this.clearCaches();
    }

    public void resume() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.u > 0) {
            --this.u;
        }
        this.clearCaches();
        e.debug("before resume VM");
        try {
            this.j.resume();
        }
        catch (InternalException internalException) {
            e.info((Throwable)internalException);
        }
        e.debug("VM resumed");
    }

    public List<ThreadGroupReferenceProxyImpl> topLevelThreadGroups() {
        return StreamEx.of(this.getVirtualMachine().topLevelThreadGroups()).map(this::getThreadGroupReferenceProxy).toList();
    }

    public void threadGroupCreated(ThreadGroupReference threadGroupReference) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.isJ2ME()) {
            ThreadGroupReferenceProxyImpl threadGroupReferenceProxyImpl = new ThreadGroupReferenceProxyImpl(this, threadGroupReference);
            this.y.put(threadGroupReference, threadGroupReferenceProxyImpl);
        }
    }

    public boolean isJ2ME() {
        return VirtualMachineProxyImpl.a(this.getVirtualMachine());
    }

    private static boolean a(VirtualMachine virtualMachine) {
        return virtualMachine.version().startsWith("1.0");
    }

    public void threadGroupRemoved(ThreadGroupReference threadGroupReference) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.y.remove(threadGroupReference);
    }

    public EventQueue eventQueue() {
        return this.j.eventQueue();
    }

    public EventRequestManager eventRequestManager() {
        return this.j.eventRequestManager();
    }

    @Deprecated
    public VoidValue mirrorOf() throws EvaluateException {
        return this.mirrorOfVoid();
    }

    public VoidValue mirrorOfVoid() {
        return this.j.mirrorOfVoid();
    }

    public BooleanValue mirrorOf(boolean bl2) {
        return this.j.mirrorOf(bl2);
    }

    public ByteValue mirrorOf(byte by2) {
        return this.j.mirrorOf(by2);
    }

    public CharValue mirrorOf(char c2) {
        return this.j.mirrorOf(c2);
    }

    public ShortValue mirrorOf(short s2) {
        return this.j.mirrorOf(s2);
    }

    public IntegerValue mirrorOf(int n2) {
        return this.j.mirrorOf(n2);
    }

    public LongValue mirrorOf(long l2) {
        return this.j.mirrorOf(l2);
    }

    public FloatValue mirrorOf(float f2) {
        return this.j.mirrorOf(f2);
    }

    public DoubleValue mirrorOf(double d2) {
        return this.j.mirrorOf(d2);
    }

    public StringReference mirrorOf(String string) {
        return this.j.mirrorOf(string);
    }

    public StringReference mirrorOfStringLiteral(String string, ThrowableComputable<StringReference, EvaluateException> throwableComputable) throws EvaluateException {
        StringReference stringReference = this.n.get(string);
        if (stringReference != null && !stringReference.isCollected()) {
            return stringReference;
        }
        stringReference = (StringReference)throwableComputable.compute();
        this.n.put(string, stringReference);
        return stringReference;
    }

    public Process process() {
        return this.j.process();
    }

    public void dispose() {
        try {
            this.j.dispose();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            e.info((Throwable)unsupportedOperationException);
        }
        finally {
            Thread thread;
            TargetVM targetVM;
            if (Patches.JDK_BUG_EVENT_CONTROLLER_LEAK && (targetVM = (TargetVM)ReflectionUtil.getField(this.j.getClass(), (Object)this.j, TargetVM.class, (String)"target")) != null && (thread = (Thread)ReflectionUtil.getField(targetVM.getClass(), (Object)targetVM, Thread.class, (String)"eventController")) != null) {
                thread.stop();
            }
        }
    }

    public void exit(int n2) {
        this.j.exit(n2);
    }

    public boolean canWatchFieldModification() {
        return this.q.isAvailable();
    }

    public boolean canWatchFieldAccess() {
        return this.B.isAvailable();
    }

    public boolean canInvokeMethods() {
        return !this.c.isAvailable();
    }

    public boolean canGetBytecodes() {
        return this.w.isAvailable();
    }

    public boolean canGetSyntheticAttribute() {
        return this.A.isAvailable();
    }

    public boolean canGetOwnedMonitorInfo() {
        return this.g.isAvailable();
    }

    public boolean canGetMonitorFrameInfo() {
        return this.a.isAvailable();
    }

    public boolean canGetCurrentContendedMonitor() {
        return this.b.isAvailable();
    }

    public boolean canGetMonitorInfo() {
        return this.k.isAvailable();
    }

    public boolean canUseInstanceFilters() {
        return this.t.isAvailable();
    }

    public boolean canRedefineClasses() {
        return this.m.isAvailable();
    }

    public boolean canAddMethod() {
        return this.F.isAvailable();
    }

    public boolean canUnrestrictedlyRedefineClasses() {
        return this.l.isAvailable();
    }

    public boolean canPopFrames() {
        return this.E.isAvailable();
    }

    public boolean canForceEarlyReturn() {
        return this.i.isAvailable();
    }

    public boolean canGetInstanceInfo() {
        return this.D.isAvailable();
    }

    public final boolean versionHigher(String string) {
        return this.j.version().compareTo(string) >= 0;
    }

    public boolean canGetSourceDebugExtension() {
        return this.r.isAvailable();
    }

    public boolean canRequestVMDeathEvent() {
        return this.o.isAvailable();
    }

    public boolean canGetMethodReturnValues() {
        return this.G.isAvailable();
    }

    public String getDefaultStratum() {
        return this.d ? this.j.getDefaultStratum() : null;
    }

    public String description() {
        return this.j.description();
    }

    public String version() {
        return this.j.version();
    }

    public String name() {
        return this.j.name();
    }

    public void setDebugTraceMode(int n2) {
        this.j.setDebugTraceMode(n2);
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public ThreadReferenceProxyImpl getThreadReferenceProxy(@Nullable ThreadReference threadReference2) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (threadReference2 == null) {
            return null;
        }
        return this.p.computeIfAbsent(threadReference2, threadReference -> new ThreadReferenceProxyImpl(this, (ThreadReference)threadReference));
    }

    public ThreadGroupReferenceProxyImpl getThreadGroupReferenceProxy(ThreadGroupReference threadGroupReference) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (threadGroupReference == null) {
            return null;
        }
        ThreadGroupReferenceProxyImpl threadGroupReferenceProxyImpl = this.y.get(threadGroupReference);
        if (threadGroupReferenceProxyImpl == null && !this.c.isAvailable()) {
            threadGroupReferenceProxyImpl = new ThreadGroupReferenceProxyImpl(this, threadGroupReference);
            this.y.put(threadGroupReference, threadGroupReferenceProxyImpl);
        }
        return threadGroupReferenceProxyImpl;
    }

    public ObjectReferenceProxyImpl getObjectReferenceProxy(ObjectReference objectReference) {
        if (objectReference != null) {
            if (objectReference instanceof ThreadReference) {
                return this.getThreadReferenceProxy((ThreadReference)objectReference);
            }
            if (objectReference instanceof ThreadGroupReference) {
                return this.getThreadGroupReferenceProxy((ThreadGroupReference)objectReference);
            }
            ObjectReferenceProxyImpl objectReferenceProxyImpl = this.z.get(objectReference);
            if (objectReferenceProxyImpl == null) {
                objectReferenceProxyImpl = objectReference instanceof StringReference ? new StringReferenceProxy(this, (StringReference)objectReference) : new ObjectReferenceProxyImpl(this, objectReference);
                this.z.put(objectReference, objectReferenceProxyImpl);
            }
            return objectReferenceProxyImpl;
        }
        return null;
    }

    public boolean equals(Object object) {
        e.assertTrue(object instanceof VirtualMachineProxyImpl);
        return this.j.equals(((VirtualMachineProxyImpl)object).getVirtualMachine());
    }

    public int hashCode() {
        return this.j.hashCode();
    }

    public void clearCaches() {
        e.debug("VM cleared");
        this.x = null;
        if (!this.f.isEmpty()) {
            this.f = new HashMap<ReferenceType, List<ReferenceType>>(this.f.size());
        }
        ++this.v;
    }

    @Override
    public int getCurrentTime() {
        return this.v;
    }

    public DebugProcess getDebugProcess() {
        return this.s;
    }

    public static boolean isCollected(ObjectReference objectReference) {
        try {
            return !VirtualMachineProxyImpl.a(objectReference.virtualMachine()) && objectReference.isCollected();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            e.info((Throwable)unsupportedOperationException);
            return false;
        }
    }

    public String getResumeStack() {
        return StringUtil.getThrowableText((Throwable)this.mySuspendLogger);
    }

    public boolean isPausePressed() {
        return this.u > 0;
    }

    public boolean isSuspended() {
        return this.allThreads().stream().anyMatch(threadReferenceProxyImpl -> threadReferenceProxyImpl.getSuspendCount() != 0);
    }

    public void logThreads() {
        if (e.isDebugEnabled()) {
            for (ThreadReferenceProxyImpl threadReferenceProxyImpl : this.allThreads()) {
                if (threadReferenceProxyImpl.isCollected()) continue;
                e.debug("suspends " + threadReferenceProxyImpl + " " + threadReferenceProxyImpl.getSuspendCount() + " " + threadReferenceProxyImpl.isSuspended());
            }
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualMachine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/jdi/VirtualMachineProxyImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/jdi/VirtualMachineProxyImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualMachine";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "classesByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class Capability {
        private ThreeState a = ThreeState.UNSURE;

        private Capability() {
        }

        public final boolean isAvailable() {
            if (this.a == ThreeState.UNSURE) {
                try {
                    this.a = ThreeState.fromBoolean((boolean)this.calcValue());
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    e.info((Throwable)vMDisconnectedException);
                    this.a = ThreeState.NO;
                }
            }
            return this.a.toBoolean();
        }

        protected abstract boolean calcValue();
    }

    static final class JNITypeParserReflect {
        static final Method typeNameToSignatureMethod = ReflectionUtil.getDeclaredMethod(JNITypeParser.class, (String)"typeNameToSignature", (Class[])new Class[]{String.class});

        JNITypeParserReflect() {
        }

        @Nullable
        static String typeNameToSignature(@NotNull String string) {
            if (string == null) {
                JNITypeParserReflect.a(0);
            }
            if (typeNameToSignatureMethod != null) {
                try {
                    return (String)typeNameToSignatureMethod.invoke(null, string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        static {
            if (typeNameToSignatureMethod == null) {
                e.warn("Unable to find JNITypeParser.typeNameToSignature method");
            }
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/debugger/jdi/VirtualMachineProxyImpl$JNITypeParserReflect", "typeNameToSignature"));
        }
    }
}

