/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.action;

import com.intellij.debugger.memory.action.ShowInstancesAction;
import com.intellij.debugger.memory.ui.ClassesTable;
import com.intellij.debugger.memory.ui.InstancesWindow;
import com.intellij.debugger.memory.utils.InstancesProvider;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.sun.jdi.ReferenceType;

public class ShowNewInstancesAction
extends ShowInstancesAction {
    private static final String a = "Show New Instances";

    @Override
    protected boolean isEnabled(AnActionEvent anActionEvent) {
        ReferenceType referenceType = this.getSelectedClass(anActionEvent);
        InstancesProvider instancesProvider = (InstancesProvider)anActionEvent.getData(ClassesTable.NEW_INSTANCES_PROVIDER_KEY);
        int n2 = this.getInstancesCount(anActionEvent);
        return super.isEnabled(anActionEvent) && referenceType != null && instancesProvider != null && n2 > 0;
    }

    @Override
    protected String getLabel() {
        return a;
    }

    @Override
    protected int getInstancesCount(AnActionEvent anActionEvent) {
        ClassesTable.ReferenceCountProvider referenceCountProvider = (ClassesTable.ReferenceCountProvider)anActionEvent.getData(ClassesTable.REF_COUNT_PROVIDER_KEY);
        ReferenceType referenceType = this.getSelectedClass(anActionEvent);
        if (referenceCountProvider == null || referenceType == null) {
            return -1;
        }
        return referenceCountProvider.getNewInstancesCount(referenceType);
    }

    @Override
    protected void perform(AnActionEvent anActionEvent) {
        XDebugSession xDebugSession;
        Project project2 = anActionEvent.getProject();
        ReferenceType referenceType = this.getSelectedClass(anActionEvent);
        InstancesProvider instancesProvider = (InstancesProvider)anActionEvent.getData(ClassesTable.NEW_INSTANCES_PROVIDER_KEY);
        XDebugSession xDebugSession2 = xDebugSession = project2 != null ? XDebuggerManager.getInstance((Project)project2).getCurrentSession() : null;
        if (referenceType != null && instancesProvider != null && xDebugSession != null) {
            new InstancesWindow(xDebugSession, instancesProvider, referenceType.name()).show();
        }
    }
}

