/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.filtering;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.memory.filtering.CheckingResult;
import com.intellij.debugger.memory.filtering.ConditionChecker;
import com.intellij.debugger.memory.filtering.ConditionCheckerImpl;
import com.intellij.debugger.memory.filtering.FilteringResult;
import com.intellij.debugger.memory.filtering.FilteringTaskCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XExpression;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

public class FilteringTask
implements Runnable {
    private final ValuesList c;
    private final ConditionChecker d;
    private final FilteringTaskCallback a;
    private volatile boolean b;

    public FilteringTask(@NotNull String string, @NotNull DebugProcessImpl debugProcessImpl, @NotNull XExpression xExpression, @NotNull ValuesList valuesList, @NotNull FilteringTaskCallback filteringTaskCallback) {
        if (string == null) {
            FilteringTask.a(0);
        }
        if (debugProcessImpl == null) {
            FilteringTask.a(1);
        }
        if (xExpression == null) {
            FilteringTask.a(2);
        }
        if (valuesList == null) {
            FilteringTask.a(3);
        }
        if (filteringTaskCallback == null) {
            FilteringTask.a(4);
        }
        this.b = false;
        this.d = StringUtil.isEmptyOrSpaces((String)xExpression.getExpression()) ? ConditionChecker.ALL_MATCHED_CHECKER : new ConditionCheckerImpl(debugProcessImpl, xExpression, string);
        this.c = valuesList;
        this.a = filteringTaskCallback;
    }

    public void cancel() {
        this.b = true;
    }

    public boolean isCancelled() {
        return this.b;
    }

    @Override
    public void run() {
        Object object;
        int n2;
        this.a.started(this.c.size());
        for (n2 = 0; n2 < this.c.size() && !this.b; ++n2) {
            object = this.c.get(n2);
            CheckingResult checkingResult = this.d.check((Value)object);
            FilteringTaskCallback.Action action = FilteringTaskCallback.Action.CONTINUE;
            switch (checkingResult.getResult()) {
                case MATCH: {
                    action = this.a.matched((Value)object);
                    break;
                }
                case NO_MATCH: {
                    action = this.a.notMatched((Value)object);
                    break;
                }
                case ERROR: {
                    action = this.a.error((Value)object, checkingResult.getFailureDescription());
                }
            }
            if (action == FilteringTaskCallback.Action.STOP) break;
        }
        object = this.b ? FilteringResult.INTERRUPTED : (n2 == this.c.size() ? FilteringResult.ALL_CHECKED : FilteringResult.LIMIT_REACHED);
        this.a.completed((FilteringResult)((Object)object));
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "className";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "debugProcess";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "expression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "values";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "callback";
                break;
            }
        }
        objectArray[1] = "com/intellij/debugger/memory/filtering/FilteringTask";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ValuesList {
        public int size();

        public Value get(int var1);
    }
}

