/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.tracking;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.memory.component.InstancesTracker;
import com.intellij.debugger.memory.component.MemoryViewDebugProcessData;
import com.intellij.debugger.memory.event.InstancesTrackerListener;
import com.intellij.debugger.memory.tracking.BackgroundTracker;
import com.intellij.debugger.memory.tracking.TrackerForNewInstances;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.SyntheticLineBreakpoint;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstructorInstancesTracker
implements TrackerForNewInstances,
Disposable,
BackgroundTracker {
    private static final int e = 2000;
    private final String f;
    private final Project b;
    private final MyConstructorBreakpoints d;
    @Nullable
    private HashSet<ObjectReference> g;
    @NotNull
    private HashSet<ObjectReference> a;
    private volatile boolean c;
    private volatile boolean h;

    public ConstructorInstancesTracker(@NotNull ReferenceType referenceType, @NotNull XDebugSession xDebugSession, @NotNull InstancesTracker instancesTracker) {
        if (referenceType == null) {
            ConstructorInstancesTracker.a(0);
        }
        if (xDebugSession == null) {
            ConstructorInstancesTracker.a(1);
        }
        if (instancesTracker == null) {
            ConstructorInstancesTracker.a(2);
        }
        this.g = null;
        this.a = new HashSet();
        this.b = xDebugSession.getProject();
        this.h = instancesTracker.isBackgroundTrackingEnabled();
        this.f = referenceType.name();
        final DebugProcessImpl debugProcessImpl = (DebugProcessImpl)DebuggerManager.getInstance((Project)this.b).getDebugProcess(xDebugSession.getDebugProcess().getProcessHandler());
        instancesTracker.addTrackerListener(new InstancesTrackerListener(){

            @Override
            public void backgroundTrackingValueChanged(final boolean bl2) {
                if (ConstructorInstancesTracker.this.h != bl2) {
                    ConstructorInstancesTracker.this.h = bl2;
                    debugProcessImpl.getManagerThread().schedule(new DebuggerCommandImpl(){

                        @Override
                        protected void action() throws Exception {
                            if (bl2) {
                                ConstructorInstancesTracker.this.d.enable();
                            } else {
                                ConstructorInstancesTracker.this.d.disable();
                            }
                        }
                    });
                }
            }
        }, this);
        this.d = new MyConstructorBreakpoints(this.b);
        this.d.createRequestForPreparedClass(debugProcessImpl, referenceType);
    }

    public void obsolete() {
        DebugProcess debugProcess;
        MemoryViewDebugProcessData memoryViewDebugProcessData;
        XDebugSession xDebugSession;
        if (this.g != null) {
            this.g.forEach(ObjectReference::enableCollection);
        }
        this.g = null;
        if (!this.c || this.h) {
            this.d.enable();
        }
        if ((xDebugSession = XDebuggerManager.getInstance((Project)this.b).getCurrentSession()) != null && (memoryViewDebugProcessData = (MemoryViewDebugProcessData)(debugProcess = DebuggerManager.getInstance((Project)this.b).getDebugProcess(xDebugSession.getDebugProcess().getProcessHandler())).getUserData(MemoryViewDebugProcessData.KEY)) != null) {
            memoryViewDebugProcessData.getTrackedStacks().release();
        }
    }

    public void commitTracked() {
        this.g = this.a;
        this.a = new HashSet();
    }

    @Override
    @NotNull
    public List<ObjectReference> getNewInstances() {
        List<Object> list2 = this.g == null ? Collections.EMPTY_LIST : new ArrayList<ObjectReference>(this.g);
        if (list2 == null) {
            ConstructorInstancesTracker.a(3);
        }
        return list2;
    }

    @Override
    public int getCount() {
        return this.g == null ? 0 : this.g.size();
    }

    public void enable() {
        this.d.enable();
    }

    public void disable() {
        this.d.disable();
    }

    @Override
    public boolean isReady() {
        return this.g != null;
    }

    public void dispose() {
        this.d.delete();
        this.a.clear();
        this.g = null;
    }

    @Override
    public void setBackgroundMode(boolean bl2) {
        if (this.c == bl2) {
            return;
        }
        this.c = bl2;
        if (bl2) {
            this.b();
        } else {
            this.a();
        }
    }

    private void a() {
        this.d.enable();
    }

    private void b() {
        if (!this.h) {
            this.d.disable();
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugSession";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instancesTracker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/tracking/ConstructorInstancesTracker";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/tracking/ConstructorInstancesTracker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewInstances";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyConstructorBreakpointBase
    extends SyntheticLineBreakpoint {
        protected MyConstructorBreakpointBase(@NotNull Project project2) {
            if (project2 == null) {
                MyConstructorBreakpointBase.e(0);
            }
            super(project2);
            this.setSuspendPolicy("SuspendThread");
        }

        @Override
        @Nullable
        public SourcePosition getSourcePosition() {
            return null;
        }

        @Override
        public int getLineIndex() {
            return -1;
        }

        @Override
        public String getEventMessage(LocatableEvent locatableEvent) {
            return "";
        }

        @Override
        @Nullable
        protected JavaLineBreakpointType getXBreakpointType() {
            return null;
        }

        private static /* synthetic */ void e(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/memory/tracking/ConstructorInstancesTracker$MyConstructorBreakpointBase", "<init>"));
        }
    }

    private final class MyConstructorBreakpoints
    extends MyConstructorBreakpointBase {
        private final List<BreakpointRequest> n;
        private final String p;
        private volatile boolean q;
        private volatile boolean o;

        MyConstructorBreakpoints(Project project2) {
            super(project2);
            this.n = new ArrayList<BreakpointRequest>();
            this.p = "MemoryViewConstructorTracker:" + ConstructorInstancesTracker.this.f;
            this.q = false;
            this.o = false;
            this.setVisible(false);
        }

        @Override
        protected void createRequestForPreparedClass(DebugProcessImpl debugProcessImpl, ReferenceType referenceType) {
            referenceType.methods().stream().filter(Method::isConstructor).forEach(method -> {
                Location location = method.location();
                BreakpointRequest breakpointRequest = debugProcessImpl.getRequestsManager().createBreakpointRequest(this, location);
                this.n.add(breakpointRequest);
            });
            if (!ConstructorInstancesTracker.this.c || ConstructorInstancesTracker.this.h) {
                this.enable();
            }
        }

        @Override
        public String getDisplayName() {
            return this.p;
        }

        @Override
        public boolean isEnabled() {
            return this.q;
        }

        void delete() {
            this.n.clear();
            this.o = true;
        }

        @Override
        public boolean processLocatableEvent(SuspendContextCommandImpl suspendContextCommandImpl, LocatableEvent locatableEvent) throws LocatableEventRequestor.EventProcessingException {
            if (this.o) {
                locatableEvent.request().disable();
            } else {
                this.a(suspendContextCommandImpl, locatableEvent);
            }
            return false;
        }

        void enable() {
            if (!this.q && !this.o) {
                this.n.forEach(EventRequest::enable);
                this.q = true;
            }
        }

        void disable() {
            if (this.q && !this.o) {
                this.n.forEach(EventRequest::disable);
                this.q = false;
            }
        }

        private void a(@NotNull SuspendContextCommandImpl suspendContextCommandImpl, @NotNull LocatableEvent locatableEvent) {
            if (suspendContextCommandImpl == null) {
                MyConstructorBreakpoints.f(0);
            }
            if (locatableEvent == null) {
                MyConstructorBreakpoints.f(1);
            }
            try {
                SuspendContextImpl suspendContextImpl = suspendContextCommandImpl.getSuspendContext();
                if (suspendContextImpl != null) {
                    MemoryViewDebugProcessData memoryViewDebugProcessData = (MemoryViewDebugProcessData)suspendContextImpl.getDebugProcess().getUserData(MemoryViewDebugProcessData.KEY);
                    ObjectReference objectReference = this.getThisObject(suspendContextImpl, locatableEvent);
                    if (objectReference != null && objectReference.referenceType().name().equals(ConstructorInstancesTracker.this.f) && memoryViewDebugProcessData != null) {
                        objectReference.disableCollection();
                        ConstructorInstancesTracker.this.a.add(objectReference);
                        memoryViewDebugProcessData.getTrackedStacks().addStack(objectReference, StackFrameItem.createFrames(suspendContextImpl, false));
                    }
                }
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
            if (ConstructorInstancesTracker.this.a.size() >= 2000) {
                this.disable();
            }
        }

        private static /* synthetic */ void f(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "action";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/memory/tracking/ConstructorInstancesTracker$MyConstructorBreakpoints";
            objectArray[2] = "handleEvent";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

