/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.memory.component.InstancesTracker;
import com.intellij.debugger.memory.component.MemoryViewDebugProcessData;
import com.intellij.debugger.memory.component.MemoryViewManager;
import com.intellij.debugger.memory.component.MemoryViewManagerState;
import com.intellij.debugger.memory.event.InstancesTrackerListener;
import com.intellij.debugger.memory.event.MemoryViewManagerListener;
import com.intellij.debugger.memory.tracking.ConstructorInstancesTracker;
import com.intellij.debugger.memory.tracking.TrackerForNewInstances;
import com.intellij.debugger.memory.tracking.TrackingType;
import com.intellij.debugger.memory.ui.ClassesTable;
import com.intellij.debugger.memory.ui.InstancesWindow;
import com.intellij.debugger.memory.utils.AndroidUtil;
import com.intellij.debugger.memory.utils.KeyboardUtils;
import com.intellij.debugger.memory.utils.LowestPriorityCommand;
import com.intellij.debugger.memory.utils.SingleAlarmWithMutableDelay;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.requests.Requestor;
import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.ClassPrepareRequest;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassesFilteredView
extends BorderLayoutPanel
implements Disposable {
    private static final Logger i = Logger.getInstance(ClassesFilteredView.class);
    private static final double l = 0.5;
    private static final double m = TimeUnit.SECONDS.toMillis(2L);
    private static final int c = Integer.MAX_VALUE;
    private static final String o = "The application is running";
    private static final String h = "Classes are not available";
    private static final String b = "Click to load the classes list";
    private final Project r;
    private final SingleAlarmWithMutableDelay k;
    private final SearchTextField a;
    private final ClassesTable p;
    private final InstancesTracker q;
    private final Map<ReferenceType, ConstructorInstancesTracker> j;
    private final MyDebuggerSessionListener d;
    private final AtomicInteger n;
    private final AtomicInteger f;
    private final AtomicBoolean g;
    private volatile boolean e;

    public ClassesFilteredView(final @NotNull XDebugSession xDebugSession, final @NotNull DebugProcessImpl debugProcessImpl, final @NotNull InstancesTracker instancesTracker) {
        if (xDebugSession == null) {
            ClassesFilteredView.a(0);
        }
        if (debugProcessImpl == null) {
            ClassesFilteredView.a(1);
        }
        if (instancesTracker == null) {
            ClassesFilteredView.a(2);
        }
        this.a = new FilterTextField();
        this.j = new ConcurrentHashMap<ReferenceType, ConstructorInstancesTracker>();
        this.n = new AtomicInteger(0);
        this.f = new AtomicInteger(Integer.MIN_VALUE);
        this.g = new AtomicBoolean(false);
        this.r = xDebugSession.getProject();
        final DebuggerManagerThreadImpl debuggerManagerThreadImpl = debugProcessImpl.getManagerThread();
        this.q = instancesTracker;
        final InstancesTrackerListener instancesTrackerListener = new InstancesTrackerListener(){

            @Override
            public void classChanged(@NotNull String string, final @NotNull TrackingType trackingType) {
                ReferenceType referenceType;
                if (string == null) {
                    1.b(0);
                }
                if (trackingType == null) {
                    1.b(1);
                }
                if ((referenceType = ClassesFilteredView.this.p.getClassByName(string)) != null) {
                    final boolean bl2 = ClassesFilteredView.this.g.get();
                    debuggerManagerThreadImpl.schedule(new DebuggerCommandImpl(){

                        @Override
                        protected void action() {
                            ClassesFilteredView.this.a(xDebugSession, referenceType, trackingType, bl2);
                        }
                    });
                }
                ClassesFilteredView.this.p.repaint();
            }

            @Override
            public void classRemoved(@NotNull String string) {
                ReferenceType referenceType;
                if (string == null) {
                    1.b(2);
                }
                if ((referenceType = ClassesFilteredView.this.p.getClassByName(string)) != null && ClassesFilteredView.this.j.containsKey(referenceType)) {
                    ConstructorInstancesTracker constructorInstancesTracker = (ConstructorInstancesTracker)ClassesFilteredView.this.j.remove(referenceType);
                    Disposer.dispose((Disposable)constructorInstancesTracker);
                    ClassesFilteredView.this.p.getRowSorter().allRowsChanged();
                }
            }

            private static /* synthetic */ void b(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/debugger/memory/ui/ClassesFilteredView$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "classChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "classRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        xDebugSession.addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                xDebugSession.removeSessionListener((XDebugSessionListener)this);
                ClassesFilteredView.this.q.removeTrackerListener(instancesTrackerListener);
            }
        });
        debugProcessImpl.addDebugProcessListener(new DebugProcessListener(){

            public void processAttached(DebugProcess debugProcess) {
                debugProcessImpl.removeDebugProcessListener(this);
                debuggerManagerThreadImpl.invoke(new DebuggerCommandImpl(){

                    @Override
                    protected void action() {
                        boolean bl2 = ClassesFilteredView.this.g.get();
                        VirtualMachineProxyImpl virtualMachineProxyImpl = debugProcessImpl.getVirtualMachineProxy();
                        instancesTracker.getTrackedClasses().forEach((string, trackingType) -> {
                            List<ReferenceType> list2;
                            if (xDebugSession == null) {
                                1.a(0);
                            }
                            if (debugProcessImpl == null) {
                                1.a(1);
                            }
                            if ((list2 = virtualMachineProxyImpl.classesByName((String)string)).isEmpty()) {
                                this.a(string, xDebugSession, debugProcessImpl, trackingType);
                            } else {
                                for (ReferenceType referenceType : list2) {
                                    ClassesFilteredView.this.a(xDebugSession, referenceType, trackingType, bl2);
                                }
                            }
                        });
                        instancesTracker.addTrackerListener(instancesTrackerListener);
                    }

                    private static /* synthetic */ void a(int n2) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n2) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "debugSession";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "debugProcess";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/debugger/memory/ui/ClassesFilteredView$3$1";
                        objectArray[2] = "lambda$action$0";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }

            private void a(@NotNull String string, final @NotNull XDebugSession xDebugSession2, final @NotNull DebugProcessImpl debugProcessImpl2, final @NotNull TrackingType trackingType) {
                if (string == null) {
                    3.a(0);
                }
                if (xDebugSession2 == null) {
                    3.a(1);
                }
                if (debugProcessImpl2 == null) {
                    3.a(2);
                }
                if (trackingType == null) {
                    3.a(3);
                }
                ClassPrepareRequestor classPrepareRequestor = new ClassPrepareRequestor(){

                    public void processClassPrepare(DebugProcess debugProcess, ReferenceType referenceType) {
                        debugProcessImpl2.getRequestsManager().deleteRequest((Requestor)this);
                        ClassesFilteredView.this.a(xDebugSession2, referenceType, trackingType, ClassesFilteredView.this.g.get());
                    }
                };
                ClassPrepareRequest classPrepareRequest = debugProcessImpl2.getRequestsManager().createClassPrepareRequest(classPrepareRequestor, string);
                if (classPrepareRequest != null) {
                    classPrepareRequest.enable();
                } else {
                    i.warn("Cannot create a 'class prepare' request. Class " + string + " not tracked.");
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "className";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "session";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "process";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/memory/ui/ClassesFilteredView$3";
                objectArray[2] = "trackWhenPrepared";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        MemoryViewManagerState memoryViewManagerState2 = MemoryViewManager.getInstance().getState();
        this.p = new ClassesTable(instancesTracker, this, memoryViewManagerState2.isShowWithDiffOnly, memoryViewManagerState2.isShowWithInstancesOnly, memoryViewManagerState2.isShowTrackedOnly);
        this.p.getEmptyText().setText(o);
        Disposer.register((Disposable)this, (Disposable)this.p);
        this.p.addMouseMotionListener(new MyMouseMotionListener());
        this.p.addMouseListener(new MyOpenNewInstancesListener());
        new MyDoubleClickListener().installOn((Component)((Object)this.p));
        this.p.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                int n2 = keyEvent.getKeyCode();
                if (KeyboardUtils.isEnterKey(n2)) {
                    ClassesFilteredView.this.a(ClassesFilteredView.this.p.getSelectedClass());
                } else if (KeyboardUtils.isCharacter(n2) || KeyboardUtils.isBackSpace(n2)) {
                    String string = ClassesFilteredView.this.a.getText();
                    String string2 = KeyboardUtils.isBackSpace(n2) ? string.substring(0, string.length() - 1) : string + keyEvent.getKeyChar();
                    ClassesFilteredView.this.a.setText(string2);
                    IdeFocusManager.getInstance((Project)ClassesFilteredView.this.r).requestFocus((Component)ClassesFilteredView.this.a, false);
                }
            }
        });
        this.a.addKeyboardListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                this.a(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                this.a(keyEvent);
            }

            private void a(KeyEvent keyEvent) {
                int n2 = keyEvent.getKeyCode();
                if (ClassesFilteredView.this.p.isInClickableMode() && (KeyboardUtils.isCharacter(n2) || KeyboardUtils.isEnterKey(n2))) {
                    ClassesFilteredView.this.p.exitClickableMode();
                    ClassesFilteredView.this.b(true);
                } else if (KeyboardUtils.isUpDownKey(n2) || KeyboardUtils.isEnterKey(n2)) {
                    ClassesFilteredView.this.p.dispatchEvent(keyEvent);
                }
            }
        });
        this.a.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent documentEvent) {
                ClassesFilteredView.this.p.setFilterPattern(ClassesFilteredView.this.a.getText());
            }
        });
        MemoryViewManagerListener memoryViewManagerListener = memoryViewManagerState -> {
            this.p.setFilteringByDiffNonZero(memoryViewManagerState.isShowWithDiffOnly);
            this.p.setFilteringByInstanceExists(memoryViewManagerState.isShowWithInstancesOnly);
            this.p.setFilteringByTrackingState(memoryViewManagerState.isShowTrackedOnly);
            if (memoryViewManagerState.isAutoUpdateModeOn && this.p.isInClickableMode()) {
                this.b(true);
            }
        };
        MemoryViewManager.getInstance().addMemoryViewManagerListener(memoryViewManagerListener, this);
        this.d = new MyDebuggerSessionListener();
        xDebugSession.addSessionListener((XDebugSessionListener)this.d, (Disposable)this);
        this.k = new SingleAlarmWithMutableDelay(suspendContextImpl -> {
            ApplicationManager.getApplication().invokeLater(() -> this.p.setBusy(true));
            suspendContextImpl.getDebugProcess().getManagerThread().schedule(new MyUpdateClassesCommand(suspendContextImpl));
        }, this);
        this.k.setDelay((int)TimeUnit.MILLISECONDS.toMillis(500L));
        this.p.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component component, int n2, int n3) {
                ActionPopupMenu actionPopupMenu = ClassesFilteredView.e();
                actionPopupMenu.getComponent().show(component, n2, n3);
            }
        });
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.p), (int)2);
        DefaultActionGroup defaultActionGroup = (DefaultActionGroup)ActionManager.getInstance().getAction("MemoryView.SettingsPopupActionGroup");
        defaultActionGroup.setPopup(true);
        Presentation presentation = new Presentation("Memory View Settings");
        presentation.setIcon(AllIcons.General.SecondaryGroup);
        ActionButton actionButton = new ActionButton((AnAction)defaultActionGroup, presentation, "unknown", (Dimension)new JBDimension(25, 25));
        BorderLayoutPanel borderLayoutPanel = new BorderLayoutPanel();
        borderLayoutPanel.addToCenter((Component)this.a);
        borderLayoutPanel.addToRight((Component)actionButton);
        this.addToTop((Component)borderLayoutPanel);
        this.addToCenter(jScrollPane);
    }

    @Nullable
    TrackerForNewInstances getStrategy(@NotNull ReferenceType referenceType) {
        if (referenceType == null) {
            ClassesFilteredView.a(3);
        }
        return this.j.getOrDefault(referenceType, null);
    }

    private void a(@NotNull XDebugSession xDebugSession, @NotNull ReferenceType referenceType, @NotNull TrackingType trackingType, boolean bl2) {
        if (xDebugSession == null) {
            ClassesFilteredView.a(4);
        }
        if (referenceType == null) {
            ClassesFilteredView.a(5);
        }
        if (trackingType == null) {
            ClassesFilteredView.a(6);
        }
        i.assertTrue(DebuggerManager.getInstance((Project)this.r).isDebuggerManagerThread());
        if (trackingType == TrackingType.CREATION) {
            ConstructorInstancesTracker constructorInstancesTracker = this.j.getOrDefault(referenceType, null);
            if (constructorInstancesTracker != null) {
                Disposer.dispose((Disposable)constructorInstancesTracker);
            }
            ConstructorInstancesTracker constructorInstancesTracker2 = new ConstructorInstancesTracker(referenceType, xDebugSession, this.q);
            constructorInstancesTracker2.setBackgroundMode(!this.e);
            if (bl2) {
                constructorInstancesTracker2.enable();
            } else {
                constructorInstancesTracker2.disable();
            }
            this.j.put(referenceType, constructorInstancesTracker2);
        }
    }

    private void a(@Nullable ReferenceType referenceType) {
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)this.r).getCurrentSession();
        if (referenceType != null && xDebugSession != null && xDebugSession.isSuspended()) {
            if (!referenceType.virtualMachine().canGetInstanceInfo()) {
                XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification("The virtual machine implementation does not provide an ability to get instances", NotificationType.INFORMATION).notify(xDebugSession.getProject());
                return;
            }
            new InstancesWindow(xDebugSession, n2 -> {
                List<ObjectReference> list2 = referenceType.instances(n2);
                return list2 == null ? Collections.emptyList() : list2;
            }, referenceType.name()).show();
        }
    }

    private void g() {
        this.j.values().forEach(ConstructorInstancesTracker::commitTracked);
    }

    private void b(boolean bl2) {
        ApplicationManager.getApplication().invokeLater(() -> {
            DebugProcessImpl debugProcessImpl;
            SuspendContextImpl suspendContextImpl;
            DebugProcess debugProcess;
            XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)this.r).getCurrentSession();
            if (xDebugSession != null && (debugProcess = DebuggerManager.getInstance((Project)this.r).getDebugProcess(xDebugSession.getDebugProcess().getProcessHandler())) != null && debugProcess.isAttached() && debugProcess instanceof DebugProcessImpl && (suspendContextImpl = (debugProcessImpl = (DebugProcessImpl)debugProcess).getDebuggerContext().getSuspendContext()) != null) {
                if (bl2) {
                    this.k.cancelAndRequestImmediate(suspendContextImpl);
                } else {
                    this.k.cancelAndRequest(suspendContextImpl);
                }
            }
        }, this.r.getDisposed());
    }

    private static ActionPopupMenu e() {
        ActionGroup actionGroup = (ActionGroup)ActionManager.getInstance().getAction("MemoryView.ClassesPopupActionGroup");
        return ActionManager.getInstance().createActionPopupMenu("MemoryView.ClassesPopupActionGroup", actionGroup);
    }

    public void dispose() {
        this.j.clear();
    }

    public void setActive(final boolean bl2, @NotNull DebuggerManagerThreadImpl debuggerManagerThreadImpl) {
        if (debuggerManagerThreadImpl == null) {
            ClassesFilteredView.a(7);
        }
        if (this.e == bl2) {
            return;
        }
        this.e = bl2;
        debuggerManagerThreadImpl.schedule(new DebuggerCommandImpl(){

            @Override
            protected void action() {
                if (bl2) {
                    ClassesFilteredView.this.f();
                } else {
                    ClassesFilteredView.this.j();
                }
            }
        });
    }

    private void f() {
        this.d.setActive(true);
        this.j.values().forEach(constructorInstancesTracker -> constructorInstancesTracker.setBackgroundMode(false));
        if (this.a()) {
            if (MemoryViewManager.getInstance().isAutoUpdateModeEnabled()) {
                this.b(true);
            } else {
                this.d();
            }
        }
    }

    private void d() {
        ApplicationManager.getApplication().invokeLater(() -> this.p.makeClickable(b, () -> this.b(true)));
    }

    private void j() {
        this.d.setActive(false);
        this.k.cancelAllRequests();
        this.j.values().forEach(constructorInstancesTracker -> constructorInstancesTracker.setBackgroundMode(true));
    }

    private boolean a() {
        return this.f.get() != this.n.get();
    }

    private void i() {
        this.f.set(this.n.get());
    }

    private boolean a(@NotNull MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            ClassesFilteredView.a(8);
        }
        int n2 = this.p.columnAtPoint(mouseEvent.getPoint());
        int n3 = this.p.rowAtPoint(mouseEvent.getPoint());
        if (n2 == -1 || n3 == -1 || this.p.convertColumnIndexToModel(n2) != 2) {
            return false;
        }
        int n4 = this.p.convertRowIndexToModel(n3);
        ReferenceType referenceType = (ReferenceType)this.p.getModel().getValueAt(n4, 0);
        ConstructorInstancesTracker constructorInstancesTracker = this.j.getOrDefault(referenceType, null);
        return constructorInstancesTracker != null && constructorInstancesTracker.isReady() && constructorInstancesTracker.getCount() > 0;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugSession";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "managerThread";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/memory/ui/ClassesFilteredView";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getStrategy";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "trackClass";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setActive";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isShowNewInstancesEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyDebuggerSessionListener
    implements XDebugSessionListener {
        private volatile boolean a = false;

        private MyDebuggerSessionListener() {
        }

        void setActive(boolean bl2) {
            this.a = bl2;
        }

        public void sessionResumed() {
            if (this.a) {
                ClassesFilteredView.this.j.values().forEach(ConstructorInstancesTracker::obsolete);
                ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredView.this.p.hideContent(ClassesFilteredView.o));
                ClassesFilteredView.this.k.cancelAllRequests();
            }
        }

        public void sessionStopped() {
            ClassesFilteredView.this.j.values().forEach(Disposer::dispose);
            ClassesFilteredView.this.j.clear();
            ClassesFilteredView.this.k.cancelAllRequests();
            ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredView.this.p.clean(ClassesFilteredView.h));
        }

        public void sessionPaused() {
            ClassesFilteredView.this.n.incrementAndGet();
            if (this.a) {
                if (MemoryViewManager.getInstance().isAutoUpdateModeEnabled()) {
                    ClassesFilteredView.this.b(false);
                } else {
                    ClassesFilteredView.this.d();
                }
            }
        }
    }

    private class MyMouseMotionListener
    implements MouseMotionListener {
        private MyMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (ClassesFilteredView.this.p.isInClickableMode()) {
                return;
            }
            if (ClassesFilteredView.this.a(mouseEvent)) {
                ClassesFilteredView.this.p.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                ClassesFilteredView.this.p.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class MyDoubleClickListener
    extends DoubleClickListener {
        private MyDoubleClickListener() {
        }

        protected boolean onDoubleClick(MouseEvent mouseEvent) {
            if (!ClassesFilteredView.this.a(mouseEvent)) {
                ClassesFilteredView.this.a(ClassesFilteredView.this.p.getSelectedClass());
                return true;
            }
            return false;
        }
    }

    private class MyOpenNewInstancesListener
    extends MouseAdapter {
        private MyOpenNewInstancesListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() != 1 || mouseEvent.getButton() != 1 || !ClassesFilteredView.this.a(mouseEvent)) {
                return;
            }
            ReferenceType referenceType = ClassesFilteredView.this.p.getSelectedClass();
            TrackerForNewInstances trackerForNewInstances = referenceType == null ? null : ClassesFilteredView.this.getStrategy(referenceType);
            XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)ClassesFilteredView.this.r).getCurrentSession();
            if (trackerForNewInstances != null && xDebugSession != null) {
                DebugProcess debugProcess = DebuggerManager.getInstance((Project)ClassesFilteredView.this.r).getDebugProcess(xDebugSession.getDebugProcess().getProcessHandler());
                MemoryViewDebugProcessData memoryViewDebugProcessData = (MemoryViewDebugProcessData)debugProcess.getUserData(MemoryViewDebugProcessData.KEY);
                if (memoryViewDebugProcessData != null) {
                    List<ObjectReference> list2 = trackerForNewInstances.getNewInstances();
                    memoryViewDebugProcessData.getTrackedStacks().pinStacks(referenceType);
                    InstancesWindow instancesWindow = new InstancesWindow(xDebugSession, n2 -> list2, referenceType.name());
                    Disposer.register((Disposable)instancesWindow.getDisposable(), () -> memoryViewDebugProcessData.getTrackedStacks().unpinStacks(referenceType));
                    instancesWindow.show();
                } else {
                    i.warn("MemoryViewDebugProcessData not found in debug session user data");
                }
            }
        }
    }

    private static class FilterTextField
    extends SearchTextField {
        FilterTextField() {
            super(false);
        }

        protected void showPopup() {
        }

        protected boolean hasIconsOutsideOfTextField() {
            return false;
        }
    }

    private final class MyUpdateClassesCommand
    extends LowestPriorityCommand {
        MyUpdateClassesCommand(SuspendContextImpl suspendContextImpl) {
            super(suspendContextImpl);
        }

        @Override
        public void contextAction(@NotNull SuspendContextImpl suspendContextImpl) {
            if (suspendContextImpl == null) {
                MyUpdateClassesCommand.b(0);
            }
            this.b();
            VirtualMachineProxyImpl virtualMachineProxyImpl = suspendContextImpl.getDebugProcess().getVirtualMachineProxy();
            List<ReferenceType> list2 = virtualMachineProxyImpl.allClasses();
            if (!list2.isEmpty()) {
                VirtualMachine virtualMachine = list2.get(0).virtualMachine();
                if (virtualMachineProxyImpl.canGetInstanceInfo()) {
                    Map<ReferenceType, Long> map = this.a(list2, virtualMachine);
                    ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredView.this.p.updateContent(map));
                } else {
                    ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredView.this.p.updateClassesOnly(list2));
                }
            }
            ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredView.this.p.setBusy(false));
            ClassesFilteredView.this.i();
        }

        private void b() {
            if (!ClassesFilteredView.this.g.get()) {
                ClassesFilteredView.this.j.values().forEach(ConstructorInstancesTracker::enable);
                ClassesFilteredView.this.g.set(true);
            } else {
                ClassesFilteredView.this.g();
            }
        }

        private Map<ReferenceType, Long> a(@NotNull List<ReferenceType> list2, @NotNull VirtualMachine virtualMachine) {
            if (list2 == null) {
                MyUpdateClassesCommand.b(1);
            }
            if (virtualMachine == null) {
                MyUpdateClassesCommand.b(2);
            }
            int n2 = AndroidUtil.isAndroidVM(virtualMachine) ? 500 : Integer.MAX_VALUE;
            int n3 = list2.size();
            LinkedHashMap<ReferenceType, Long> linkedHashMap = new LinkedHashMap<ReferenceType, Long>();
            int n4 = 0;
            int n5 = Math.min(n2, n3);
            while (n4 != n3) {
                int n6;
                List<ReferenceType> list3 = list2.subList(n4, n5);
                long l2 = System.nanoTime();
                long[] lArray = virtualMachine.instanceCounts(list3);
                long l3 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l2);
                for (n6 = 0; n6 < list3.size(); ++n6) {
                    linkedHashMap.put(list3.get(n6), lArray[n6]);
                }
                n6 = (int)Math.min(0.5 * (double)l3, m);
                ClassesFilteredView.this.k.setDelay(n6);
                i.debug(String.format("Instances query time = %d ms. Count of classes = %d", l3, list3.size()));
                n4 = n5;
                n5 = Math.min(n5 + n2, n3);
            }
            return linkedHashMap;
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suspendContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vm";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/memory/ui/ClassesFilteredView$MyUpdateClassesCommand";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contextAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getInstancesCounts";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

