/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.memory.component.InstancesTracker;
import com.intellij.debugger.memory.tracking.TrackerForNewInstances;
import com.intellij.debugger.memory.tracking.TrackingType;
import com.intellij.debugger.memory.ui.ClassesFilteredView;
import com.intellij.debugger.memory.utils.AbstractTableColumnDescriptor;
import com.intellij.debugger.memory.utils.AbstractTableModelWithColumns;
import com.intellij.debugger.memory.utils.InstancesProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.FList;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassesTable
extends JBTable
implements DataProvider,
Disposable {
    public static final DataKey<ReferenceType> SELECTED_CLASS_KEY = DataKey.create((String)"ClassesTable.SelectedClass");
    public static final DataKey<InstancesProvider> NEW_INSTANCES_PROVIDER_KEY = DataKey.create((String)"ClassesTable.NewInstances");
    public static final DataKey<ReferenceCountProvider> REF_COUNT_PROVIDER_KEY = DataKey.create((String)"ClassesTable.ReferenceCountProvider");
    private static final Border q = BorderFactory.createEmptyBorder();
    private static final JBColor n = new JBColor(new Color(250, 251, 252), new Color(62, 66, 69));
    private static final String k = "Nothing to show";
    private static final int d = 250;
    private static final int l = 80;
    private static final int s = 80;
    private static final UnknownDiffValue a = new UnknownDiffValue();
    private final DiffViewTableModel b;
    private final Map<ReferenceType, DiffValue> r;
    private final InstancesTracker t;
    private final ClassesFilteredView h;
    private final ReferenceCountProvider e;
    private boolean j;
    private boolean g;
    private boolean m;
    private MinusculeMatcher i;
    private String o;
    private volatile List<ReferenceType> p;
    private boolean c;
    private MouseListener f;

    public ClassesTable(@NotNull InstancesTracker instancesTracker, @NotNull ClassesFilteredView classesFilteredView, boolean bl2, boolean bl3, boolean bl4) {
        if (instancesTracker == null) {
            ClassesTable.a(0);
        }
        if (classesFilteredView == null) {
            ClassesTable.a(1);
        }
        this.b = new DiffViewTableModel();
        this.r = new ConcurrentHashMap<ReferenceType, DiffValue>();
        this.i = NameUtil.buildMatcher((String)"*").build();
        this.o = "";
        this.p = Collections.unmodifiableList(new ArrayList());
        this.c = true;
        this.f = null;
        this.setModel(this.b);
        this.j = bl2;
        this.m = bl3;
        this.g = bl4;
        this.t = instancesTracker;
        this.h = classesFilteredView;
        TableColumnModel tableColumnModel = this.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        TableColumn tableColumn2 = tableColumnModel.getColumn(1);
        TableColumn tableColumn3 = tableColumnModel.getColumn(2);
        this.setAutoResizeMode(2);
        tableColumn.setPreferredWidth(JBUI.scale((int)250));
        tableColumn2.setMinWidth(JBUI.scale((int)80));
        tableColumn3.setMinWidth(JBUI.scale((int)80));
        this.setShowGrid(false);
        this.setIntercellSpacing((Dimension)new JBDimension(0, 0));
        this.setDefaultRenderer(ReferenceType.class, (TableCellRenderer)((Object)new MyClassColumnRenderer()));
        this.setDefaultRenderer(Long.class, (TableCellRenderer)((Object)new MyCountColumnRenderer()));
        this.setDefaultRenderer(DiffValue.class, (TableCellRenderer)((Object)new MyDiffColumnRenderer()));
        TableRowSorter<DiffViewTableModel> tableRowSorter = new TableRowSorter<DiffViewTableModel>(this.b);
        tableRowSorter.setRowFilter(new RowFilter<DiffViewTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends DiffViewTableModel, ? extends Integer> entry) {
                int n2 = entry.getIdentifier();
                ReferenceType referenceType = (ReferenceType)ClassesTable.this.p.get(n2);
                DiffValue diffValue = ClassesTable.this.r.getOrDefault(referenceType, a);
                boolean bl2 = ClassesTable.this.j && diffValue.diff() == 0L || ClassesTable.this.m && !diffValue.hasInstance() || ClassesTable.this.g && ClassesTable.this.h.getStrategy(referenceType) == null;
                return !bl2 && ClassesTable.this.i.matches(referenceType.name());
            }
        });
        List<RowSorter.SortKey> list2 = Arrays.asList(new RowSorter.SortKey(2, SortOrder.DESCENDING), new RowSorter.SortKey(1, SortOrder.DESCENDING), new RowSorter.SortKey(0, SortOrder.ASCENDING));
        tableRowSorter.setSortKeys(list2);
        this.setRowSorter(tableRowSorter);
        this.setSelectionMode(0);
        this.e = new ReferenceCountProvider(){

            @Override
            public int getTotalCount(@NotNull ReferenceType referenceType) {
                if (referenceType == null) {
                    2.a(0);
                }
                return (int)((DiffValue)ClassesTable.this.r.get(referenceType)).a;
            }

            @Override
            public int getDiffCount(@NotNull ReferenceType referenceType) {
                if (referenceType == null) {
                    2.a(1);
                }
                return (int)((DiffValue)ClassesTable.this.r.get(referenceType)).diff();
            }

            @Override
            public int getNewInstancesCount(@NotNull ReferenceType referenceType) {
                TrackerForNewInstances trackerForNewInstances;
                if (referenceType == null) {
                    2.a(2);
                }
                return (trackerForNewInstances = ClassesTable.this.h.getStrategy(referenceType)) == null || !trackerForNewInstances.isReady() ? -1 : trackerForNewInstances.getCount();
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "ref";
                objectArray2[1] = "com/intellij/debugger/memory/ui/ClassesTable$2";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getTotalCount";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getDiffCount";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getNewInstancesCount";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    ReferenceType getSelectedClass() {
        int n2 = this.getSelectedRow();
        if (n2 != -1) {
            int n3 = this.convertRowIndexToModel(n2);
            return this.p.get(n3);
        }
        return null;
    }

    @Nullable
    ReferenceType getClassByName(@NotNull String string) {
        if (string == null) {
            ClassesTable.a(2);
        }
        for (ReferenceType referenceType : this.p) {
            if (!string.equals(referenceType.name())) continue;
            return referenceType;
        }
        return null;
    }

    boolean isInClickableMode() {
        return this.f != null;
    }

    void makeClickable(@NotNull String string, final @NotNull Runnable runnable) {
        if (string == null) {
            ClassesTable.a(3);
        }
        if (runnable == null) {
            ClassesTable.a(4);
        }
        this.b();
        this.getEmptyText().setText(string);
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.getMousePosition() != null) {
            this.setBackground((Color)n);
        }
        this.f = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                runnable.run();
                ClassesTable.this.b();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ClassesTable.this.setBackground((Color)n);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ClassesTable.this.setBackground(JBColor.background());
            }
        };
        this.addMouseListener(this.f);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    void exitClickableMode() {
        this.b();
        this.getEmptyText().setText(k);
    }

    private void b() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isInClickableMode()) {
            this.removeMouseListener(this.f);
            this.f = null;
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.setBackground(JBColor.background());
        }
    }

    void setBusy(boolean bl2) {
        this.setPaintBusy(bl2);
    }

    void setFilterPattern(String string) {
        if (!this.o.equals(string)) {
            this.o = string;
            this.i = NameUtil.buildMatcher((String)("*" + string)).build();
            this.a();
            if (this.getSelectedClass() == null && this.getRowCount() > 0) {
                this.getSelectionModel().setSelectionInterval(0, 0);
            }
        }
    }

    void setFilteringByInstanceExists(boolean bl2) {
        if (bl2 != this.m) {
            this.m = bl2;
            this.a();
        }
    }

    void setFilteringByDiffNonZero(boolean bl2) {
        if (this.j != bl2) {
            this.j = bl2;
            this.a();
        }
    }

    void setFilteringByTrackingState(boolean bl2) {
        if (this.g != bl2) {
            this.g = bl2;
            this.a();
        }
    }

    public void updateClassesOnly(@NotNull List<ReferenceType> list2) {
        if (list2 == null) {
            ClassesTable.a(5);
        }
        this.c = false;
        LinkedHashMap<ReferenceType, Long> linkedHashMap = new LinkedHashMap<ReferenceType, Long>();
        list2.forEach(referenceType -> linkedHashMap.put((ReferenceType)referenceType, 0L));
        this.a(linkedHashMap);
    }

    public void updateContent(@NotNull Map<ReferenceType, Long> map) {
        if (map == null) {
            ClassesTable.a(6);
        }
        this.c = true;
        this.a(map);
    }

    void hideContent(@NotNull String string) {
        if (string == null) {
            ClassesTable.a(7);
        }
        this.b();
        this.getEmptyText().setText(string);
        this.b.hide();
    }

    private void d() {
        this.b.show();
    }

    private void a(@NotNull Map<ReferenceType, Long> map) {
        if (map == null) {
            ClassesTable.a(8);
        }
        this.b();
        this.getEmptyText().setText(k);
        ReferenceType referenceType = this.b.getSelectedClassBeforeHide();
        int n2 = -1;
        boolean bl2 = !this.p.isEmpty();
        this.p = Collections.unmodifiableList(new ArrayList<ReferenceType>(map.keySet()));
        int n3 = 0;
        for (ReferenceType referenceType2 : map.keySet()) {
            if (referenceType2.equals(referenceType)) {
                n2 = n3;
            }
            DiffValue diffValue = bl2 && !this.r.containsKey(referenceType2) ? new DiffValue(0L, 0L) : this.r.getOrDefault(referenceType2, a);
            this.r.put(referenceType2, diffValue.update(map.get(referenceType2)));
            ++n3;
        }
        this.d();
        if (n2 != -1 && !this.b.isHidden()) {
            int n4 = this.convertRowIndexToView(n2);
            this.changeSelection(n4, 0, false, false);
        }
        this.a();
    }

    @Nullable
    public Object getData(@NonNls String string) {
        TrackerForNewInstances trackerForNewInstances;
        ReferenceType referenceType;
        if (SELECTED_CLASS_KEY.is(string)) {
            return this.getSelectedClass();
        }
        if (NEW_INSTANCES_PROVIDER_KEY.is(string) && (referenceType = this.getSelectedClass()) != null && (trackerForNewInstances = this.h.getStrategy(referenceType)) != null && trackerForNewInstances.isReady()) {
            List<ObjectReference> list2 = trackerForNewInstances.getNewInstances();
            return n2 -> list2;
        }
        if (REF_COUNT_PROVIDER_KEY.is(string)) {
            return this.e;
        }
        return null;
    }

    public void clean(@NotNull String string) {
        if (string == null) {
            ClassesTable.a(9);
        }
        this.clearSelection();
        this.b();
        this.getEmptyText().setText(string);
        this.p = Collections.emptyList();
        this.r.clear();
        this.b.b = null;
        this.a();
    }

    public void dispose() {
        ApplicationManager.getApplication().invokeLater(() -> this.clean(""));
    }

    @Nullable
    private TrackingType b(int n2) {
        ReferenceType referenceType = (ReferenceType)this.getValueAt(n2, this.convertColumnIndexToView(0));
        return this.t.getTrackingType(referenceType.name());
    }

    private void a() {
        this.b.fireTableDataChanged();
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onClick";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "class2Count";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/memory/ui/ClassesTable";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getClassByName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "makeClickable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateClassesOnly";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateContent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "hideContent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "updateCountsInternal";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "clean";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyDiffColumnRenderer
    extends MyNumericRenderer {
        private final SimpleTextAttributes a;

        private MyDiffColumnRenderer() {
            this.a = new SimpleTextAttributes(16, (Color)JBColor.BLUE);
        }

        @Override
        void appendText(@NotNull Object object, int n2) {
            TrackingType trackingType;
            if (object == null) {
                MyDiffColumnRenderer.b(0);
            }
            if ((trackingType = ClassesTable.this.b(n2)) != null) {
                this.setIcon(AllIcons.Debugger.MemoryView.ClassTracked);
                this.setTransparentIconBackground(true);
            }
            ReferenceType referenceType = (ReferenceType)ClassesTable.this.p.get(ClassesTable.this.convertRowIndexToModel(n2));
            long l2 = ClassesTable.this.e.getDiffCount(referenceType);
            String string = String.format("%s%d", l2 > 0L ? "+" : "", l2);
            int n3 = ClassesTable.this.e.getNewInstancesCount(referenceType);
            if (n3 >= 0) {
                if ((long)n3 == l2) {
                    this.append(string, l2 == 0L ? SimpleTextAttributes.REGULAR_ATTRIBUTES : this.a);
                } else {
                    this.append(string, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    if (n3 != 0) {
                        this.append(String.format(" (%d)", n3), this.a);
                    }
                }
            } else {
                this.append(string, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }

        private static /* synthetic */ void b(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/debugger/memory/ui/ClassesTable$MyDiffColumnRenderer", "appendText"));
        }
    }

    private class MyCountColumnRenderer
    extends MyNumericRenderer {
        private MyCountColumnRenderer() {
        }

        @Override
        void appendText(@NotNull Object object, int n2) {
            if (object == null) {
                MyCountColumnRenderer.b(0);
            }
            this.append(object.toString());
        }

        private static /* synthetic */ void b(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/debugger/memory/ui/ClassesTable$MyCountColumnRenderer", "appendText"));
        }
    }

    private abstract class MyNumericRenderer
    extends MyTableCellRenderer {
        private MyNumericRenderer() {
        }

        @Override
        protected void addText(@NotNull Object object, boolean bl2, int n2) {
            if (object == null) {
                MyNumericRenderer.a(0);
            }
            if (ClassesTable.this.c) {
                this.setTextAlign(4);
                this.appendText(object, n2);
            }
        }

        abstract void appendText(@NotNull Object var1, int var2);

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/debugger/memory/ui/ClassesTable$MyNumericRenderer", "addText"));
        }
    }

    private class MyClassColumnRenderer
    extends MyTableCellRenderer {
        private MyClassColumnRenderer() {
        }

        @Override
        protected void addText(@NotNull Object object, boolean bl2, int n2) {
            if (object == null) {
                MyClassColumnRenderer.a(0);
            }
            String string = ((ReferenceType)object).name();
            this.append(" ");
            if (bl2) {
                FList fList = ClassesTable.this.i.matchingFragments(string);
                if (fList != null) {
                    SimpleTextAttributes simpleTextAttributes = new SimpleTextAttributes(this.getBackground(), this.getForeground(), null, 64);
                    SpeedSearchUtil.appendColoredFragments((SimpleColoredComponent)this, (String)string, (Iterable)fList, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (SimpleTextAttributes)simpleTextAttributes);
                }
            } else {
                this.append(String.format("%s", string), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/debugger/memory/ui/ClassesTable$MyClassColumnRenderer", "addText"));
        }
    }

    private static abstract class MyTableCellRenderer
    extends ColoredTableCellRenderer {
        private MyTableCellRenderer() {
        }

        protected void customizeCellRenderer(JTable jTable, @Nullable Object object, boolean bl2, boolean bl3, int n2, int n3) {
            if (bl3) {
                this.setBorder(q);
            }
            if (object != null) {
                this.addText(object, bl2, n2);
            }
        }

        protected abstract void addText(@NotNull Object var1, boolean var2, int var3);
    }

    private static class DiffValue
    implements Comparable<DiffValue> {
        private long b;
        private long a;

        DiffValue(long l2) {
            this(l2, l2);
        }

        DiffValue(long l2, long l3) {
            this.a = l3;
            this.b = l2;
        }

        DiffValue update(long l2) {
            this.b = this.a;
            this.a = l2;
            return this;
        }

        boolean hasInstance() {
            return this.a > 0L;
        }

        long diff() {
            return this.a - this.b;
        }

        @Override
        public int compareTo(@NotNull DiffValue diffValue) {
            if (diffValue == null) {
                DiffValue.a(0);
            }
            return Long.compare(this.diff(), diffValue.diff());
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/debugger/memory/ui/ClassesTable$DiffValue", "compareTo"));
        }
    }

    private static class UnknownDiffValue
    extends DiffValue {
        UnknownDiffValue() {
            super(-1L);
        }

        @Override
        boolean hasInstance() {
            return true;
        }

        @Override
        DiffValue update(long l2) {
            return new DiffValue(l2);
        }
    }

    class DiffViewTableModel
    extends AbstractTableModelWithColumns {
        static final int CLASSNAME_COLUMN_INDEX = 0;
        static final int COUNT_COLUMN_INDEX = 1;
        static final int DIFF_COLUMN_INDEX = 2;
        private ReferenceType b;
        private boolean c;

        DiffViewTableModel() {
            super(new AbstractTableColumnDescriptor[]{new AbstractTableColumnDescriptor("Class", ReferenceType.class){

                @Override
                public Object getValue(int n2) {
                    return ClassesTable.this.p.get(n2);
                }
            }, new AbstractTableColumnDescriptor("Count", Long.class){

                @Override
                public Object getValue(int n2) {
                    return ((DiffValue)ClassesTable.this.r.getOrDefault(ClassesTable.this.p.get(n2), a)).a;
                }
            }, new AbstractTableColumnDescriptor("Diff", DiffValue.class){

                @Override
                public Object getValue(int n2) {
                    return ClassesTable.this.r.getOrDefault(ClassesTable.this.p.get(n2), a);
                }
            }});
            this.b = null;
            this.c = false;
        }

        ReferenceType getSelectedClassBeforeHide() {
            return this.b;
        }

        void hide() {
            if (this.c) {
                this.b = ClassesTable.this.getSelectedClass();
                this.c = false;
                ClassesTable.this.clearSelection();
                this.fireTableDataChanged();
            }
        }

        void show() {
            if (!this.c) {
                this.c = true;
                this.fireTableDataChanged();
            }
        }

        boolean isHidden() {
            return !this.c;
        }

        @Override
        public int getRowCount() {
            return this.c ? ClassesTable.this.p.size() : 0;
        }
    }

    public static interface ReferenceCountProvider {
        public int getTotalCount(@NotNull ReferenceType var1);

        public int getDiffCount(@NotNull ReferenceType var1);

        public int getNewInstancesCount(@NotNull ReferenceType var1);
    }
}

