/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.memory.component.InstancesTracker;
import com.intellij.debugger.memory.component.MemoryViewDebugProcessData;
import com.intellij.debugger.memory.event.InstancesTrackerListener;
import com.intellij.debugger.memory.tracking.TrackingType;
import com.intellij.debugger.memory.ui.InstancesTree;
import com.intellij.debugger.memory.ui.StackFrameList;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.xdebugger.XDebugSession;
import com.sun.jdi.ObjectReference;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.TreeSelectionEvent;
import org.jetbrains.annotations.NotNull;

class InstancesWithStackFrameView {
    private static final float e = 0.7f;
    private static final String a = "Select instance to see stack frame";
    private static final String c = "No stack frame for this instance";
    private static final String f = "Arrays could not be tracked";
    private float b;
    private final JBSplitter d;
    private boolean g;

    InstancesWithStackFrameView(@NotNull XDebugSession xDebugSession, @NotNull InstancesTree instancesTree, @NotNull StackFrameList stackFrameList, final @NotNull String string) {
        Object object;
        ActionLink actionLink;
        JBLabel jBLabel;
        if (xDebugSession == null) {
            InstancesWithStackFrameView.a(0);
        }
        if (instancesTree == null) {
            InstancesWithStackFrameView.a(1);
        }
        if (stackFrameList == null) {
            InstancesWithStackFrameView.a(2);
        }
        if (string == null) {
            InstancesWithStackFrameView.a(3);
        }
        this.d = new JBSplitter(false, 0.7f);
        this.g = false;
        this.d.setFirstComponent((JComponent)new JBScrollPane((Component)((Object)instancesTree)));
        Project project2 = xDebugSession.getProject();
        stackFrameList.setEmptyText(a);
        if (InstancesWithStackFrameView.a(string)) {
            jBLabel = new JBLabel(f, 0);
        } else {
            actionLink = new ActionLink("Enable tracking for new instances", AllIcons.Debugger.MemoryView.ClassTracked, new AnAction(){

                public void actionPerformed(AnActionEvent anActionEvent) {
                    Project project2 = anActionEvent.getProject();
                    if (project2 != null && !project2.isDisposed()) {
                        InstancesTracker.getInstance(project2).add(string, TrackingType.CREATION);
                    }
                }
            });
            actionLink.setHorizontalAlignment(0);
            actionLink.setPaintUnderline(false);
            jBLabel = actionLink;
        }
        this.d.setSplitterProportionKey("InstancesWithStackFrameView.SplitterKey");
        actionLink = new JBScrollPane((Component)((Object)stackFrameList));
        if (!project2.isDisposed()) {
            object = InstancesTracker.getInstance(project2);
            object.addTrackerListener(new InstancesTrackerListener((JComponent)actionLink, (JLabel)jBLabel){
                final /* synthetic */ JComponent val$stackComponent;
                final /* synthetic */ JLabel val$stackTraceLabel;
                {
                    this.val$stackComponent = jComponent;
                    this.val$stackTraceLabel = jLabel;
                }

                @Override
                public void classChanged(@NotNull String string2, @NotNull TrackingType trackingType) {
                    if (string2 == null) {
                        2.b(0);
                    }
                    if (trackingType == null) {
                        2.b(1);
                    }
                    if (Objects.equals(string, string2) && trackingType == TrackingType.CREATION) {
                        InstancesWithStackFrameView.this.d.setSecondComponent(this.val$stackComponent);
                    }
                }

                @Override
                public void classRemoved(@NotNull String string2) {
                    if (string2 == null) {
                        2.b(2);
                    }
                    if (Objects.equals(string2, string)) {
                        InstancesWithStackFrameView.this.d.setSecondComponent((JComponent)this.val$stackTraceLabel);
                    }
                }

                private static /* synthetic */ void b(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "name";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "type";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/debugger/memory/ui/InstancesWithStackFrameView$2";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "classChanged";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "classRemoved";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (Disposable)instancesTree);
            this.d.setSecondComponent((JComponent)(object.isTracked(string) ? actionLink : jBLabel));
        }
        this.d.setHonorComponentsMinimumSize(false);
        this.b = 0.7f;
        object = (MemoryViewDebugProcessData)DebuggerManager.getInstance((Project)project2).getDebugProcess(xDebugSession.getDebugProcess().getProcessHandler()).getUserData(MemoryViewDebugProcessData.KEY);
        instancesTree.addTreeSelectionListener(arg_0 -> this.a(instancesTree, (MemoryViewDebugProcessData)object, stackFrameList, arg_0));
    }

    JComponent getComponent() {
        return this.d;
    }

    private static boolean a(@NotNull String string) {
        if (string == null) {
            InstancesWithStackFrameView.a(4);
        }
        return string.contains("[]");
    }

    private void a() {
        if (!this.g) {
            this.b = this.d.getProportion();
            this.d.getSecondComponent().setVisible(false);
            this.d.setProportion(1.0f);
            this.g = true;
        }
    }

    private void b() {
        if (this.g) {
            this.d.getSecondComponent().setVisible(true);
            this.d.setProportion(this.b);
            this.g = false;
        }
    }

    private /* synthetic */ void a(@NotNull InstancesTree instancesTree, MemoryViewDebugProcessData memoryViewDebugProcessData, @NotNull StackFrameList stackFrameList, TreeSelectionEvent treeSelectionEvent) {
        ObjectReference objectReference;
        if (instancesTree == null) {
            InstancesWithStackFrameView.a(5);
        }
        if (stackFrameList == null) {
            InstancesWithStackFrameView.a(6);
        }
        if ((objectReference = instancesTree.getSelectedReference()) != null && memoryViewDebugProcessData != null) {
            List<StackFrameItem> list2 = memoryViewDebugProcessData.getTrackedStacks().getStack(objectReference);
            if (list2 != null) {
                stackFrameList.setFrameItems(list2);
                if (this.d.getProportion() == 1.0f) {
                    this.d.setProportion(0.7f);
                }
                return;
            }
            stackFrameList.setEmptyText(c);
        } else {
            stackFrameList.setEmptyText(a);
        }
        stackFrameList.setFrameItems(Collections.emptyList());
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugSession";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/memory/ui/InstancesWithStackFrameView";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isArrayType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$new$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

