/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.settings.CapturePoint;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.JavaDebuggerSupport;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.DumbAwareActionButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.xmlb.XmlSerializer;
import java.awt.Component;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaptureConfigurable
implements SearchableConfigurable {
    private static final Logger a = Logger.getInstance(CaptureConfigurable.class);
    private JCheckBox c;
    private MyTableModel d;
    private JCheckBox b;

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            CaptureConfigurable.a(0);
        }
        return string;
    }

    @NotNull
    public String getHelpTopic() {
        if ("reference.idesettings.debugger.capture" == null) {
            CaptureConfigurable.a(1);
        }
        return "reference.idesettings.debugger.capture";
    }

    @Nullable
    public JComponent createComponent() {
        this.d = new MyTableModel();
        final JBTable jBTable = new JBTable((TableModel)this.d);
        jBTable.setColumnSelectionAllowed(false);
        TableColumnModel tableColumnModel = jBTable.getColumnModel();
        TableUtil.setupCheckboxColumn((TableColumn)tableColumnModel.getColumn(0));
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTable)jBTable);
        toolbarDecorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                CaptureConfigurable.this.d.addRow();
            }
        });
        toolbarDecorator.setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                TableUtil.removeSelectedItems((JTable)jBTable);
            }
        });
        toolbarDecorator.setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                TableUtil.moveSelectedItemsUp((JTable)jBTable);
            }
        });
        toolbarDecorator.setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                TableUtil.moveSelectedItemsDown((JTable)jBTable);
            }
        });
        toolbarDecorator.addExtraAction((AnActionButton)new DumbAwareActionButton("Duplicate", "Duplicate", PlatformIcons.COPY_ICON){

            public boolean isEnabled() {
                return jBTable.getSelectedRowCount() == 1;
            }

            public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
                if (anActionEvent == null) {
                    5.a(0);
                }
                CaptureConfigurable.this.a(jBTable).forEach(capturePoint -> {
                    try {
                        int n2 = CaptureConfigurable.this.d.add(capturePoint.clone());
                        jBTable.getSelectionModel().setSelectionInterval(n2, n2);
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        a.error((Throwable)cloneNotSupportedException);
                    }
                });
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/settings/CaptureConfigurable$5", "actionPerformed"));
            }
        });
        toolbarDecorator.addExtraAction((AnActionButton)new DumbAwareActionButton("Enable Selected", "Enable Selected", PlatformIcons.SELECT_ALL_ICON){

            public boolean isEnabled() {
                return jBTable.getSelectedRowCount() > 0;
            }

            public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
                if (anActionEvent == null) {
                    6.a(0);
                }
                CaptureConfigurable.this.a(jBTable).forEach(capturePoint -> {
                    capturePoint.myEnabled = true;
                });
                jBTable.repaint();
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/settings/CaptureConfigurable$6", "actionPerformed"));
            }
        });
        toolbarDecorator.addExtraAction((AnActionButton)new DumbAwareActionButton("Disable Selected", "Disable Selected", PlatformIcons.UNSELECT_ALL_ICON){

            public boolean isEnabled() {
                return jBTable.getSelectedRowCount() > 0;
            }

            public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
                if (anActionEvent == null) {
                    7.a(0);
                }
                CaptureConfigurable.this.a(jBTable).forEach(capturePoint -> {
                    capturePoint.myEnabled = false;
                });
                jBTable.repaint();
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/settings/CaptureConfigurable$7", "actionPerformed"));
            }
        });
        new DumbAwareAction("Toggle"){

            public void update(@NotNull AnActionEvent anActionEvent) {
                if (anActionEvent == null) {
                    8.a(0);
                }
                anActionEvent.getPresentation().setEnabled(jBTable.getSelectedRowCount() == 1 && !jBTable.isEditing());
            }

            public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
                if (anActionEvent == null) {
                    8.a(1);
                }
                CaptureConfigurable.this.a(jBTable).forEach(capturePoint -> {
                    capturePoint.myEnabled = !capturePoint.myEnabled;
                });
                jBTable.repaint();
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/debugger/settings/CaptureConfigurable$8";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(32, 0)), (JComponent)jBTable);
        toolbarDecorator.addExtraAction((AnActionButton)new DumbAwareActionButton("Import", "Import", AllIcons.Actions.Install){

            public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
                if (anActionEvent == null) {
                    9.a(0);
                }
                FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, false, true, false, true, true){

                    public boolean isFileVisible(VirtualFile virtualFile, boolean bl2) {
                        return super.isFileVisible(virtualFile, bl2) && (virtualFile.isDirectory() || "xml".equals(virtualFile.getExtension()) || virtualFile.getFileType() == FileTypes.ARCHIVE);
                    }

                    public boolean isFileSelectable(VirtualFile virtualFile) {
                        return virtualFile.getFileType() == StdFileTypes.XML;
                    }
                };
                fileChooserDescriptor.setDescription("Please select a file to import.");
                fileChooserDescriptor.setTitle("Import Capture Points");
                Object[] objectArray = FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Project)anActionEvent.getProject(), null);
                if (ArrayUtil.isEmpty((Object[])objectArray)) {
                    return;
                }
                jBTable.getSelectionModel().clearSelection();
                for (Object object : objectArray) {
                    Object object2;
                    try {
                        Document document = JDOMUtil.loadDocument((InputStream)object.getInputStream());
                        object2 = document.getRootElement().getChildren();
                        object2.forEach(element -> {
                            int n2 = CaptureConfigurable.this.d.addIfNeeded((CapturePoint)XmlSerializer.deserialize((Element)element, CapturePoint.class));
                            jBTable.getSelectionModel().addSelectionInterval(n2, n2);
                        });
                    }
                    catch (Exception exception) {
                        object2 = exception.getLocalizedMessage();
                        Messages.showErrorDialog((Project)anActionEvent.getProject(), (String)(object2 != null && ((String)object2).length() > 0 ? object2 : exception.toString()), (String)"Export Failed");
                    }
                }
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/settings/CaptureConfigurable$9", "actionPerformed"));
            }
        });
        toolbarDecorator.addExtraAction((AnActionButton)new DumbAwareActionButton("Export", "Export", AllIcons.Actions.Export){

            public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
                VirtualFileWrapper virtualFileWrapper;
                if (anActionEvent == null) {
                    10.a(0);
                }
                if ((virtualFileWrapper = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor("Export Selected Capture Points to File...", "", new String[]{"xml"}), anActionEvent.getProject()).save(null, null)) == null) {
                    return;
                }
                Element element = new Element("capture-points");
                CaptureConfigurable.this.a(jBTable).forEach(capturePoint -> {
                    try {
                        CapturePoint capturePoint2 = capturePoint.clone();
                        capturePoint2.myEnabled = false;
                        element.addContent(XmlSerializer.serialize((Object)capturePoint2));
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        a.error((Throwable)cloneNotSupportedException);
                    }
                });
                try {
                    JDOMUtil.write((Parent)element, (File)virtualFileWrapper.getFile());
                }
                catch (Exception exception) {
                    String string = exception.getLocalizedMessage();
                    Messages.showErrorDialog((Project)anActionEvent.getProject(), (String)(string != null && string.length() > 0 ? string : exception.toString()), (String)"Export Failed");
                }
            }

            public boolean isEnabled() {
                return jBTable.getSelectedRowCount() > 0;
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/settings/CaptureConfigurable$10", "actionPerformed"));
            }
        });
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel();
        this.c = new JCheckBox(DebuggerBundle.message((String)"label.capture.configurable.debugger.agent", (Object[])new Object[0]));
        borderLayoutPanel.addToTop((Component)this.c);
        BorderLayoutPanel borderLayoutPanel2 = JBUI.Panels.simplePanel();
        borderLayoutPanel2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Breakpoints based", (boolean)false));
        borderLayoutPanel2.addToCenter((Component)toolbarDecorator.createPanel());
        this.b = new JCheckBox(DebuggerBundle.message((String)"label.capture.configurable.capture.variables", (Object[])new Object[0]));
        borderLayoutPanel2.addToBottom((Component)this.b);
        borderLayoutPanel.addToCenter((Component)borderLayoutPanel2);
        return borderLayoutPanel;
    }

    private StreamEx<CapturePoint> a(JBTable jBTable) {
        return IntStreamEx.of((int[])jBTable.getSelectedRows()).map(arg_0 -> jBTable.convertRowIndexToModel(arg_0)).mapToObj(this.d::get);
    }

    public boolean isModified() {
        return DebuggerSettings.getInstance().CAPTURE_VARIABLES != this.b.isSelected() || DebuggerSettings.getInstance().INSTRUMENTING_AGENT != this.c.isSelected() || !DebuggerSettings.getInstance().getCapturePoints().equals(this.d.myCapturePoints);
    }

    public void apply() throws ConfigurationException {
        DebuggerSettings.getInstance().setCapturePoints(this.d.myCapturePoints);
        DebuggerSettings.getInstance().CAPTURE_VARIABLES = this.b.isSelected();
        DebuggerSettings.getInstance().INSTRUMENTING_AGENT = this.c.isSelected();
    }

    public void reset() {
        this.b.setSelected(DebuggerSettings.getInstance().CAPTURE_VARIABLES);
        this.c.setSelected(DebuggerSettings.getInstance().INSTRUMENTING_AGENT);
        this.d.myCapturePoints = DebuggerSettings.getInstance().cloneCapturePoints();
        this.d.a();
        this.d.fireTableDataChanged();
    }

    @Nls
    public String getDisplayName() {
        return DebuggerBundle.message((String)"async.stacktraces.configurable.display.name", (Object[])new Object[0]);
    }

    static void processCaptureAnnotations(BiConsumer<Boolean, PsiModifierListOwner> biConsumer) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        CaptureConfigurable.a(true, biConsumer);
        CaptureConfigurable.a(false, biConsumer);
    }

    private static void a(boolean bl2, BiConsumer<Boolean, PsiModifierListOwner> biConsumer) {
        try {
            String string = CaptureConfigurable.getAnnotationName(bl2);
            Project project2 = JavaDebuggerSupport.getContextProjectForEditorFieldsInDebuggerConfigurables();
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project2);
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)project2).findClass(string, globalSearchScope);
            if (psiClass != null) {
                AnnotatedElementsSearch.searchElements((PsiClass)psiClass, (SearchScope)globalSearchScope, (Class[])new Class[]{PsiMethod.class, PsiParameter.class}).forEach(psiModifierListOwner -> biConsumer.accept(bl2, (PsiModifierListOwner)psiModifierListOwner));
            }
        }
        catch (ProcessCanceledException | IndexNotReadyException throwable) {
        }
        catch (Exception exception) {
            a.error((Throwable)exception);
        }
    }

    static String getAnnotationName(boolean bl2) {
        return (bl2 ? Async.Schedule.class : Async.Execute.class).getName().replace("$", ".");
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/debugger/settings/CaptureConfigurable";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MyTableModel
    extends AbstractTableModel
    implements ItemRemovable {
        public static final int ENABLED_COLUMN = 0;
        public static final int CLASS_COLUMN = 1;
        public static final int METHOD_COLUMN = 2;
        public static final int PARAM_COLUMN = 3;
        public static final int INSERT_CLASS_COLUMN = 4;
        public static final int INSERT_METHOD_COLUMN = 5;
        public static final int INSERT_KEY_EXPR = 6;
        static final String[] COLUMN_NAMES = new String[]{"", "Capture class name", "Capture method name", "Capture key expression", "Insert class name", "Insert method name", "Insert key expression"};
        List<CapturePoint> myCapturePoints = DebuggerSettings.getInstance().cloneCapturePoints();

        private MyTableModel() {
            this.a();
        }

        private void a() {
            if (Registry.is((String)"debugger.capture.points.annotations")) {
                ArrayList arrayList = new ArrayList();
                CaptureConfigurable.processCaptureAnnotations((bl2, psiModifierListOwner) -> {
                    if (psiModifierListOwner instanceof PsiMethod) {
                        MyTableModel.a(psiModifierListOwner, (PsiMethod)psiModifierListOwner, "this", bl2, arrayList);
                    } else if (psiModifierListOwner instanceof PsiParameter) {
                        PsiParameter psiParameter = (PsiParameter)psiModifierListOwner;
                        PsiMethod psiMethod = (PsiMethod)psiParameter.getDeclarationScope();
                        MyTableModel.a((PsiModifierListOwner)psiParameter, psiMethod, "param_" + psiMethod.getParameterList().getParameterIndex(psiParameter), bl2, arrayList);
                    }
                });
                arrayList.forEach(this::addIfNeeded);
            }
        }

        private static void a(PsiModifierListOwner psiModifierListOwner, PsiMethod psiMethod, String string, boolean bl2, List<CapturePoint> list2) {
            PsiAnnotation psiAnnotation;
            CapturePoint capturePoint = new CapturePoint();
            capturePoint.myEnabled = false;
            if (bl2) {
                capturePoint.myClassName = JVMNameUtil.getNonAnonymousClassName(psiMethod.getContainingClass());
                capturePoint.myMethodName = JVMNameUtil.getJVMMethodName(psiMethod);
            } else {
                capturePoint.myInsertClassName = JVMNameUtil.getNonAnonymousClassName(psiMethod.getContainingClass());
                capturePoint.myInsertMethodName = JVMNameUtil.getJVMMethodName(psiMethod);
            }
            PsiModifierList psiModifierList = psiModifierListOwner.getModifierList();
            if (psiModifierList != null && (psiAnnotation = psiModifierList.findAnnotation(CaptureConfigurable.getAnnotationName(bl2))) != null) {
                String string2;
                String string3;
                PsiAnnotationMemberValue psiAnnotationMemberValue = psiAnnotation.findAttributeValue("keyExpression");
                String string4 = string3 = psiAnnotationMemberValue != null ? StringUtil.unquoteString((String)psiAnnotationMemberValue.getText()) : null;
                if (StringUtil.isEmpty((String)string3)) {
                    string3 = string;
                }
                if (bl2) {
                    capturePoint.myCaptureKeyExpression = string3;
                } else {
                    capturePoint.myInsertKeyExpression = string3;
                }
                PsiAnnotationMemberValue psiAnnotationMemberValue2 = psiAnnotation.findAttributeValue("group");
                String string5 = string2 = psiAnnotationMemberValue2 != null ? StringUtil.unquoteString((String)psiAnnotationMemberValue2.getText()) : null;
                if (!StringUtil.isEmpty((String)string2)) {
                    for (CapturePoint capturePoint2 : list2) {
                        if (!StringUtil.startsWith((CharSequence)string2, (CharSequence)capturePoint2.myClassName) || !StringUtil.endsWith((CharSequence)string2, (CharSequence)capturePoint2.myMethodName)) continue;
                        capturePoint2.myInsertClassName = capturePoint.myInsertClassName;
                        capturePoint2.myInsertMethodName = capturePoint.myInsertMethodName;
                        capturePoint2.myInsertKeyExpression = capturePoint.myInsertKeyExpression;
                        return;
                    }
                }
            }
            list2.add(capturePoint);
        }

        @Override
        public String getColumnName(int n2) {
            return COLUMN_NAMES[n2];
        }

        @Override
        public int getRowCount() {
            return this.myCapturePoints.size();
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            CapturePoint capturePoint = this.myCapturePoints.get(n2);
            switch (n3) {
                case 0: {
                    return capturePoint.myEnabled;
                }
                case 1: {
                    return capturePoint.myClassName;
                }
                case 2: {
                    return capturePoint.myMethodName;
                }
                case 3: {
                    return capturePoint.myCaptureKeyExpression;
                }
                case 4: {
                    return capturePoint.myInsertClassName;
                }
                case 5: {
                    return capturePoint.myInsertMethodName;
                }
                case 6: {
                    return capturePoint.myInsertKeyExpression;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n2, int n3) {
            return true;
        }

        @Override
        public void setValueAt(Object object, int n2, int n3) {
            CapturePoint capturePoint = this.myCapturePoints.get(n2);
            switch (n3) {
                case 0: {
                    capturePoint.myEnabled = (Boolean)object;
                    break;
                }
                case 1: {
                    capturePoint.myClassName = (String)object;
                    break;
                }
                case 2: {
                    capturePoint.myMethodName = (String)object;
                    break;
                }
                case 3: {
                    capturePoint.myCaptureKeyExpression = (String)object;
                    break;
                }
                case 4: {
                    capturePoint.myInsertClassName = (String)object;
                    break;
                }
                case 5: {
                    capturePoint.myInsertMethodName = (String)object;
                    break;
                }
                case 6: {
                    capturePoint.myInsertKeyExpression = (String)object;
                }
            }
            this.fireTableCellUpdated(n2, n3);
        }

        public Class getColumnClass(int n2) {
            switch (n2) {
                case 0: {
                    return Boolean.class;
                }
            }
            return String.class;
        }

        CapturePoint get(int n2) {
            return this.myCapturePoints.get(n2);
        }

        int add(CapturePoint capturePoint) {
            this.myCapturePoints.add(capturePoint);
            int n2 = this.getRowCount() - 1;
            this.fireTableRowsInserted(n2, n2);
            return n2;
        }

        int addIfNeeded(CapturePoint capturePoint) {
            CapturePoint capturePoint2 = capturePoint;
            try {
                capturePoint2 = capturePoint.clone();
                capturePoint2.myEnabled = !capturePoint2.myEnabled;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                a.error((Throwable)cloneNotSupportedException);
            }
            int n2 = this.myCapturePoints.indexOf(capturePoint);
            if (n2 < 0) {
                n2 = this.myCapturePoints.indexOf(capturePoint2);
            }
            if (n2 < 0) {
                n2 = this.add(capturePoint);
            }
            return n2;
        }

        public void addRow() {
            this.add(new CapturePoint());
        }

        public void removeRow(int n2) {
            this.myCapturePoints.remove(n2);
            this.fireTableRowsDeleted(n2, n2);
        }
    }
}

