/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.settings.CaptureConfigurable;
import com.intellij.debugger.settings.CapturePoint;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;

public class CaptureSettingsProvider {
    private static final Logger e = Logger.getInstance(CaptureSettingsProvider.class);
    private static final List<AgentCapturePoint> b = new ArrayList<AgentCapturePoint>();
    private static final List<AgentInsertPoint> f = new ArrayList<AgentInsertPoint>();
    private static final List<CapturePoint> g;
    private static final KeyProvider c;
    private static final KeyProvider d;
    private static final String a = "*";

    public static List<AgentPoint> getPoints() {
        List list2 = ContainerUtil.concat(b, f);
        if (Registry.is((String)"debugger.capture.points.agent.annotations")) {
            list2 = ContainerUtil.concat((List)list2, CaptureSettingsProvider.a());
        }
        return list2;
    }

    public static List<CapturePoint> getIdeInsertPoints() {
        List list2 = Collections.unmodifiableList(g);
        if (Registry.is((String)"debugger.capture.points.agent.annotations")) {
            list2 = ContainerUtil.concat(list2, (List)StreamEx.of(CaptureSettingsProvider.a()).select(AgentInsertPoint.class).map(agentInsertPoint -> agentInsertPoint.myInsertPoint).nonNull().toList());
        }
        return list2;
    }

    private static List<AgentPoint> a() {
        return (List)ReadAction.compute(() -> {
            ArrayList arrayList = new ArrayList();
            CaptureConfigurable.processCaptureAnnotations((bl2, psiModifierListOwner) -> {
                PsiAnnotationMemberValue psiAnnotationMemberValue;
                Object object;
                Object object2;
                KeyProvider keyProvider;
                PsiMethod psiMethod;
                if (psiModifierListOwner instanceof PsiMethod) {
                    psiMethod = (PsiMethod)psiModifierListOwner;
                    keyProvider = c;
                } else if (psiModifierListOwner instanceof PsiParameter) {
                    object2 = (PsiParameter)psiModifierListOwner;
                    psiMethod = (PsiMethod)object2.getDeclarationScope();
                    keyProvider = CaptureSettingsProvider.a(psiMethod.getParameterList().getParameterIndex(object2));
                } else {
                    return;
                }
                object2 = JVMNameUtil.getNonAnonymousClassName(psiMethod.getContainingClass()).replaceAll("\\.", "/");
                String string = JVMNameUtil.getJVMMethodName(psiMethod);
                String string2 = a;
                try {
                    string2 = JVMNameUtil.getJVMSignature(psiMethod).getName(null);
                }
                catch (EvaluateException evaluateException) {
                    e.error((Throwable)evaluateException);
                }
                PsiModifierList psiModifierList = psiModifierListOwner.getModifierList();
                if (psiModifierList != null && (object = psiModifierList.findAnnotation(CaptureConfigurable.getAnnotationName(bl2))) != null && (psiAnnotationMemberValue = object.findAttributeValue("keyExpression")) != null && !"\"\"".equals(psiAnnotationMemberValue.getText())) {
                    keyProvider = new FieldKeyProvider((String)object2, StringUtil.unquoteString((String)psiAnnotationMemberValue.getText()));
                }
                object = bl2 != false ? new AgentCapturePoint((String)object2, string, string2, keyProvider) : new AgentInsertPoint((String)object2, string, string2, keyProvider);
                arrayList.add(object);
            });
            return arrayList;
        });
    }

    private static KeyProvider a(int n2) {
        return new StringKeyProvider(Integer.toString(n2));
    }

    private static void b(String string, String string2, KeyProvider keyProvider) {
        b.add(new AgentCapturePoint(string, string2, a, keyProvider));
    }

    private static void a(String string, String string2, KeyProvider keyProvider) {
        f.add(new AgentInsertPoint(string, string2, a, keyProvider));
    }

    static {
        c = new StringKeyProvider("this");
        d = CaptureSettingsProvider.a(0);
        CaptureSettingsProvider.b("java/awt/event/InvocationEvent", "<init>", c);
        CaptureSettingsProvider.a("java/awt/event/InvocationEvent", "dispatch", c);
        CaptureSettingsProvider.b("java/lang/Thread", "start", c);
        CaptureSettingsProvider.a("java/lang/Thread", "run", c);
        CaptureSettingsProvider.b("java/util/concurrent/FutureTask", "<init>", c);
        CaptureSettingsProvider.a("java/util/concurrent/FutureTask", "run", c);
        CaptureSettingsProvider.a("java/util/concurrent/FutureTask", "runAndReset", c);
        CaptureSettingsProvider.b("java/util/concurrent/CompletableFuture", "supplyAsync", d);
        AgentInsertPoint agentInsertPoint2 = new AgentInsertPoint("java/util/concurrent/CompletableFuture$AsyncSupply", "run", a, new FieldKeyProvider("java/util/concurrent/CompletableFuture$AsyncSupply", "fn"));
        agentInsertPoint2.myInsertPoint.myInsertMethodName = "run$$$capture";
        agentInsertPoint2.myInsertPoint.myInsertKeyExpression = "f";
        f.add(agentInsertPoint2);
        CaptureSettingsProvider.b("java/util/concurrent/CompletableFuture", "runAsync", d);
        agentInsertPoint2 = new AgentInsertPoint("java/util/concurrent/CompletableFuture$AsyncRun", "run", a, new FieldKeyProvider("java/util/concurrent/CompletableFuture$AsyncRun", "fn"));
        agentInsertPoint2.myInsertPoint.myInsertMethodName = "run$$$capture";
        agentInsertPoint2.myInsertPoint.myInsertKeyExpression = "f";
        f.add(agentInsertPoint2);
        CaptureSettingsProvider.b("java/util/concurrent/CompletableFuture", "thenAcceptAsync", d);
        CaptureSettingsProvider.a("java/util/concurrent/CompletableFuture$UniAccept", "tryFire", new FieldKeyProvider("java/util/concurrent/CompletableFuture$UniAccept", "fn"));
        CaptureSettingsProvider.b("java/util/concurrent/CompletableFuture", "thenRunAsync", d);
        CaptureSettingsProvider.a("java/util/concurrent/CompletableFuture$UniRun", "tryFire", new FieldKeyProvider("java/util/concurrent/CompletableFuture$UniRun", "fn"));
        CaptureSettingsProvider.b("io/netty/util/concurrent/SingleThreadEventExecutor", "addTask", d);
        CaptureSettingsProvider.a("io/netty/util/concurrent/AbstractEventExecutor", "safeExecute", d);
        CaptureSettingsProvider.b("scala/concurrent/impl/Future$PromiseCompletingRunnable", "<init>", c);
        CaptureSettingsProvider.a("scala/concurrent/impl/Future$PromiseCompletingRunnable", "run", c);
        CaptureSettingsProvider.b("scala/concurrent/impl/CallbackRunnable", "<init>", c);
        CaptureSettingsProvider.a("scala/concurrent/impl/CallbackRunnable", "run", c);
        CaptureSettingsProvider.b("akka/actor/ScalaActorRef", "$bang", d);
        CaptureSettingsProvider.b("akka/actor/RepointableActorRef", "$bang", d);
        CaptureSettingsProvider.b("akka/actor/LocalActorRef", "$bang", d);
        CaptureSettingsProvider.a("akka/actor/Actor$class", "aroundReceive", CaptureSettingsProvider.a(2));
        g = StreamEx.of(f).map(agentInsertPoint -> agentInsertPoint.myInsertPoint).nonNull().toList();
    }

    private static class FieldKeyProvider
    implements KeyProvider {
        private final String a;
        private final String b;

        public FieldKeyProvider(String string, String string2) {
            this.a = string;
            this.b = string2;
        }

        @Override
        public String asString() {
            return this.a + " " + this.b;
        }
    }

    private static class StringKeyProvider
    implements KeyProvider {
        private final String a;

        public StringKeyProvider(String string) {
            this.a = string;
        }

        @Override
        public String asString() {
            return this.a;
        }
    }

    public static interface KeyProvider {
        public String asString();
    }

    public static class AgentInsertPoint
    extends AgentPoint {
        public final CapturePoint myInsertPoint = new CapturePoint();

        public AgentInsertPoint(String string, String string2, String string3, KeyProvider keyProvider) {
            super(string, string2, string3, keyProvider);
            this.myInsertPoint.myInsertClassName = string.replaceAll("/", ".");
            this.myInsertPoint.myInsertMethodName = string2;
            if (this.myKey instanceof FieldKeyProvider) {
                this.myInsertPoint.myInsertKeyExpression = ((FieldKeyProvider)this.myKey).b;
            } else {
                String string4 = keyProvider.asString();
                try {
                    this.myInsertPoint.myInsertKeyExpression = "param_" + Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    this.myInsertPoint.myInsertKeyExpression = string4;
                }
            }
        }

        @Override
        public boolean isCapture() {
            return false;
        }
    }

    public static class AgentCapturePoint
    extends AgentPoint {
        public AgentCapturePoint(String string, String string2, String string3, KeyProvider keyProvider) {
            super(string, string2, string3, keyProvider);
        }

        @Override
        public boolean isCapture() {
            return true;
        }
    }

    public static abstract class AgentPoint {
        public final String myClassName;
        public final String myMethodName;
        public final String myMethodDesc;
        public final KeyProvider myKey;
        public static final String SEPARATOR = " ";

        public AgentPoint(String string, String string2, String string3, KeyProvider keyProvider) {
            assert (!string.contains(".")) : "Classname should not contain . here";
            this.myClassName = string;
            this.myMethodName = string2;
            this.myMethodDesc = string3;
            this.myKey = keyProvider;
        }

        public abstract boolean isCapture();

        public String toString() {
            return this.myClassName + "." + this.myMethodName + SEPARATOR + this.myKey.asString();
        }
    }
}

