/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.CapturePoint;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DebuggerSettings", defaultStateAsResource=true, storages={@Storage(value="debugger.xml"), @Storage(value="other.xml", deprecated=true)})
public class DebuggerSettings
implements Cloneable,
PersistentStateComponent<Element> {
    private static final Logger a = Logger.getInstance(DebuggerSettings.class);
    public static final int SOCKET_TRANSPORT = 0;
    public static final int SHMEM_TRANSPORT = 1;
    @NonNls
    public static final String SUSPEND_ALL = "SuspendAll";
    @NonNls
    public static final String SUSPEND_THREAD = "SuspendThread";
    @NonNls
    public static final String SUSPEND_NONE = "SuspendNone";
    @NonNls
    public static final String RUN_HOTSWAP_ALWAYS = "RunHotswapAlways";
    @NonNls
    public static final String RUN_HOTSWAP_NEVER = "RunHotswapNever";
    @NonNls
    public static final String RUN_HOTSWAP_ASK = "RunHotswapAsk";
    @NonNls
    public static final String EVALUATE_FINALLY_ALWAYS = "EvaluateFinallyAlways";
    @NonNls
    public static final String EVALUATE_FINALLY_NEVER = "EvaluateFinallyNever";
    @NonNls
    public static final String EVALUATE_FINALLY_ASK = "EvaluateFinallyAsk";
    public boolean TRACING_FILTERS_ENABLED = true;
    public int DEBUGGER_TRANSPORT;
    public boolean FORCE_CLASSIC_VM = true;
    public boolean DISABLE_JIT;
    public boolean SHOW_ALTERNATIVE_SOURCE = true;
    public boolean HOTSWAP_IN_BACKGROUND = true;
    public boolean SKIP_SYNTHETIC_METHODS = true;
    public boolean SKIP_CONSTRUCTORS;
    public boolean SKIP_GETTERS;
    public boolean SKIP_CLASSLOADERS = true;
    public String RUN_HOTSWAP_AFTER_COMPILE = "RunHotswapAsk";
    public boolean COMPILE_BEFORE_HOTSWAP = true;
    public boolean HOTSWAP_HANG_WARNING_ENABLED = false;
    public volatile boolean WATCH_RETURN_VALUES = false;
    public volatile boolean AUTO_VARIABLES_MODE = false;
    public volatile boolean KILL_PROCESS_IMMEDIATELY = false;
    public String EVALUATE_FINALLY_ON_POP_FRAME = "EvaluateFinallyAsk";
    public boolean RESUME_ONLY_CURRENT_THREAD = false;
    private ClassFilter[] d = ClassFilter.EMPTY_ARRAY;
    public boolean INSTRUMENTING_AGENT = true;
    private List<CapturePoint> b = new ArrayList<CapturePoint>();
    public boolean CAPTURE_VARIABLES;
    private final EventDispatcher<CapturePointsSettingsListener> e = EventDispatcher.create(CapturePointsSettingsListener.class);
    private Map<String, ContentState> c = new LinkedHashMap();

    @Transient
    public ClassFilter[] getSteppingFilters() {
        ClassFilter[] classFilterArray = new ClassFilter[this.d.length];
        for (int i2 = 0; i2 < classFilterArray.length; ++i2) {
            classFilterArray[i2] = this.d[i2].clone();
        }
        return classFilterArray;
    }

    public static DebuggerSettings getInstance() {
        return (DebuggerSettings)ServiceManager.getService(DebuggerSettings.class);
    }

    public void setSteppingFilters(ClassFilter[] classFilterArray) {
        this.d = classFilterArray != null ? classFilterArray : ClassFilter.EMPTY_ARRAY;
    }

    @Nullable
    public Element getState() {
        Element element = XmlSerializer.serialize((Object)this, (SerializationFilter)new SkipDefaultsSerializationFilter());
        try {
            DebuggerUtilsEx.writeFilters(element, "filter", this.d);
        }
        catch (WriteExternalException writeExternalException) {
            a.error((Throwable)writeExternalException);
            return null;
        }
        for (ContentState contentState : this.c.values()) {
            Element element2;
            if (!contentState.write(element2 = new Element("content"))) continue;
            element.addContent(element2);
        }
        return element;
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            DebuggerSettings.a(0);
        }
        XmlSerializer.deserializeInto((Object)this, (Element)element);
        try {
            this.setSteppingFilters(DebuggerUtilsEx.readFilters(element.getChildren("filter")));
        }
        catch (InvalidDataException invalidDataException) {
            a.error((Throwable)invalidDataException);
        }
        this.c.clear();
        for (Element element2 : element.getChildren("content")) {
            ContentState contentState = new ContentState(element2);
            this.c.put(contentState.getType(), contentState);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof DebuggerSettings)) {
            return false;
        }
        DebuggerSettings debuggerSettings = (DebuggerSettings)object;
        return this.TRACING_FILTERS_ENABLED == debuggerSettings.TRACING_FILTERS_ENABLED && this.DEBUGGER_TRANSPORT == debuggerSettings.DEBUGGER_TRANSPORT && StringUtil.equals((CharSequence)this.EVALUATE_FINALLY_ON_POP_FRAME, (CharSequence)debuggerSettings.EVALUATE_FINALLY_ON_POP_FRAME) && this.FORCE_CLASSIC_VM == debuggerSettings.FORCE_CLASSIC_VM && this.DISABLE_JIT == debuggerSettings.DISABLE_JIT && this.SHOW_ALTERNATIVE_SOURCE == debuggerSettings.SHOW_ALTERNATIVE_SOURCE && this.KILL_PROCESS_IMMEDIATELY == debuggerSettings.KILL_PROCESS_IMMEDIATELY && this.HOTSWAP_IN_BACKGROUND == debuggerSettings.HOTSWAP_IN_BACKGROUND && this.SKIP_SYNTHETIC_METHODS == debuggerSettings.SKIP_SYNTHETIC_METHODS && this.SKIP_CLASSLOADERS == debuggerSettings.SKIP_CLASSLOADERS && this.SKIP_CONSTRUCTORS == debuggerSettings.SKIP_CONSTRUCTORS && this.SKIP_GETTERS == debuggerSettings.SKIP_GETTERS && this.RESUME_ONLY_CURRENT_THREAD == debuggerSettings.RESUME_ONLY_CURRENT_THREAD && this.COMPILE_BEFORE_HOTSWAP == debuggerSettings.COMPILE_BEFORE_HOTSWAP && this.HOTSWAP_HANG_WARNING_ENABLED == debuggerSettings.HOTSWAP_HANG_WARNING_ENABLED && (this.RUN_HOTSWAP_AFTER_COMPILE != null ? this.RUN_HOTSWAP_AFTER_COMPILE.equals(debuggerSettings.RUN_HOTSWAP_AFTER_COMPILE) : debuggerSettings.RUN_HOTSWAP_AFTER_COMPILE == null) && DebuggerUtilsEx.filterEquals(this.d, debuggerSettings.d) && this.b.equals(((DebuggerSettings)object).b);
    }

    public DebuggerSettings clone() {
        try {
            DebuggerSettings debuggerSettings = (DebuggerSettings)super.clone();
            debuggerSettings.c = new HashMap<String, ContentState>();
            for (Map.Entry<String, ContentState> entry : this.c.entrySet()) {
                debuggerSettings.c.put(entry.getKey(), entry.getValue().clone());
            }
            debuggerSettings.d = new ClassFilter[this.d.length];
            for (int i2 = 0; i2 < this.d.length; ++i2) {
                debuggerSettings.d[i2] = this.d[i2].clone();
            }
            debuggerSettings.b = this.cloneCapturePoints();
            return debuggerSettings;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            a.error((Throwable)cloneNotSupportedException);
            return null;
        }
    }

    List<CapturePoint> cloneCapturePoints() {
        try {
            ArrayList<CapturePoint> arrayList = new ArrayList<CapturePoint>(this.b.size());
            for (CapturePoint capturePoint : this.b) {
                arrayList.add(capturePoint.clone());
            }
            return arrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            a.error((Throwable)cloneNotSupportedException);
            return Collections.emptyList();
        }
    }

    @XCollection(propertyElementName="capture-points")
    public List<CapturePoint> getCapturePoints() {
        return this.b;
    }

    public void setCapturePoints(List<CapturePoint> list2) {
        this.b = list2;
        ((CapturePointsSettingsListener)this.e.getMulticaster()).capturePointsChanged();
    }

    public void addCapturePointsSettingsListener(CapturePointsSettingsListener capturePointsSettingsListener, Disposable disposable) {
        this.e.addListener((EventListener)capturePointsSettingsListener, disposable);
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/debugger/settings/DebuggerSettings", "loadState"));
    }

    public static interface CapturePointsSettingsListener
    extends EventListener {
        public void capturePointsChanged();
    }

    public static class ContentState
    implements Cloneable {
        private final String b;
        private boolean g;
        private String e;
        private double d;
        private boolean f;
        private boolean a;
        private boolean c;

        public ContentState(String string) {
            this.b = string;
        }

        public ContentState(Element element) {
            this.b = element.getAttributeValue("type");
            this.g = Boolean.parseBoolean(element.getAttributeValue("minimized"));
            this.c = Boolean.parseBoolean(element.getAttributeValue("maximized"));
            this.e = element.getAttributeValue("selected");
            String string = element.getAttributeValue("split");
            if (string != null) {
                this.d = Double.valueOf(string);
            }
            this.f = Boolean.parseBoolean(element.getAttributeValue("detached"));
            this.a = !"false".equalsIgnoreCase(element.getAttributeValue("horizontal"));
        }

        public boolean write(Element element) {
            element.setAttribute("type", this.b);
            element.setAttribute("minimized", Boolean.valueOf(this.g).toString());
            element.setAttribute("maximized", Boolean.valueOf(this.c).toString());
            if (this.e != null) {
                element.setAttribute("selected", this.e);
            }
            element.setAttribute("split", Double.toString(this.d));
            element.setAttribute("detached", Boolean.valueOf(this.f).toString());
            element.setAttribute("horizontal", Boolean.valueOf(this.a).toString());
            return true;
        }

        public String getType() {
            return this.b;
        }

        public String getSelectedTab() {
            return this.e;
        }

        public boolean isMinimized() {
            return this.g;
        }

        public void setMinimized(boolean bl2) {
            this.g = bl2;
        }

        public void setMaximized(boolean bl2) {
            this.c = bl2;
        }

        public boolean isMaximized() {
            return this.c;
        }

        public void setSelectedTab(String string) {
            this.e = string;
        }

        public void setSplitProportion(double d2) {
            this.d = d2;
        }

        public double getSplitProportion(double d2) {
            return this.d <= 0.0 || this.d >= 1.0 ? d2 : this.d;
        }

        public void setDetached(boolean bl2) {
            this.f = bl2;
        }

        public boolean isDetached() {
            return this.f;
        }

        public boolean isHorizontalToolbar() {
            return this.a;
        }

        public void setHorizontalToolbar(boolean bl2) {
            this.a = bl2;
        }

        public ContentState clone() throws CloneNotSupportedException {
            return (ContentState)super.clone();
        }
    }
}

