/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.RendererConfiguration;
import com.intellij.debugger.ui.impl.watch.ArrayElementDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.CompoundTypeRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.EnumerationChildrenRenderer;
import com.intellij.debugger.ui.tree.render.ExpressionChildrenRenderer;
import com.intellij.debugger.ui.tree.render.HexRenderer;
import com.intellij.debugger.ui.tree.render.LabelRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.NodeRendererSettingsListener;
import com.intellij.debugger.ui.tree.render.PrimitiveRenderer;
import com.intellij.debugger.ui.tree.render.ReferenceRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.debugger.ui.tree.render.ToStringRenderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.InternalIterator;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NodeRendererSettings", storages={@Storage(value="debugger.renderers.xml")})
public class NodeRendererSettings
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String k = "Reference renderer";
    @NonNls
    public static final String RENDERER_TAG = "Renderer";
    @NonNls
    private static final String c = "ID";
    private final EventDispatcher<NodeRendererSettingsListener> b = EventDispatcher.create(NodeRendererSettingsListener.class);
    private RendererConfiguration e = new RendererConfiguration(this);
    private final PrimitiveRenderer l = new PrimitiveRenderer();
    private final ArrayRenderer h = new ArrayRenderer();
    private final ClassRenderer f = new ClassRenderer();
    private final HexRenderer a = new HexRenderer();
    private final ToStringRenderer m = new ToStringRenderer();
    private final NodeRenderer[] d = new NodeRenderer[]{this.createCompoundReferenceRenderer("Map", "java.util.Map", NodeRendererSettings.a(" size = ", "size()", null), NodeRendererSettings.a("entrySet().toArray()", "!isEmpty()", this.h)), this.createCompoundReferenceRenderer("Map.Entry", "java.util.Map$Entry", new MapEntryLabelRenderer(), NodeRendererSettings.createEnumerationChildrenRenderer(new String[][]{{"key", "getKey()"}, {"value", "getValue()"}})), new ListObjectRenderer(this, this.h), this.createCompoundReferenceRenderer("Collection", "java.util.Collection", NodeRendererSettings.a(" size = ", "size()", null), NodeRendererSettings.a("toArray()", "!isEmpty()", this.h))};
    @NonNls
    private static final String i = "HEX_VIEW_ENABLED";
    @NonNls
    private static final String j = "ALTERNATIVE_COLLECTION_VIEW_ENABLED";
    @NonNls
    private static final String g = "CustomRenderers";

    public NodeRendererSettings() {
        this.a.setEnabled(false);
        this.m.setEnabled(true);
        this.setAlternateCollectionViewsEnabled(true);
    }

    public static NodeRendererSettings getInstance() {
        return (NodeRendererSettings)ServiceManager.getService(NodeRendererSettings.class);
    }

    public void setAlternateCollectionViewsEnabled(boolean bl2) {
        for (NodeRenderer nodeRenderer : this.d) {
            nodeRenderer.setEnabled(bl2);
        }
    }

    public boolean areAlternateCollectionViewsEnabled() {
        return this.d[0].isEnabled();
    }

    public boolean equals(Object object) {
        if (!(object instanceof NodeRendererSettings)) {
            return false;
        }
        return DebuggerUtilsEx.elementsEqual(this.getState(), ((NodeRendererSettings)object).getState());
    }

    public void addListener(NodeRendererSettingsListener nodeRendererSettingsListener, Disposable disposable) {
        this.b.addListener((EventListener)nodeRendererSettingsListener, disposable);
    }

    public Element getState() {
        Element element = new Element("NodeRendererSettings");
        if (this.a.isEnabled()) {
            JDOMExternalizerUtil.writeField((Element)element, (String)i, (String)"true");
        }
        if (!this.areAlternateCollectionViewsEnabled()) {
            JDOMExternalizerUtil.writeField((Element)element, (String)j, (String)"false");
        }
        try {
            element.addContent(this.writeRenderer(this.m));
            element.addContent(this.writeRenderer(this.f));
            element.addContent(this.writeRenderer(this.l));
            if (this.e.getRendererCount() > 0) {
                Element element2 = new Element(g);
                element.addContent(element2);
                this.e.writeExternal(element2);
            }
        }
        catch (WriteExternalException writeExternalException) {
            // empty catch block
        }
        return element;
    }

    public void loadState(@NotNull Element element) {
        String string;
        String string2;
        if (element == null) {
            NodeRendererSettings.a(0);
        }
        if ((string2 = JDOMExternalizerUtil.readField((Element)element, (String)i)) != null) {
            this.a.setEnabled(Boolean.parseBoolean(string2));
        }
        if ((string = JDOMExternalizerUtil.readField((Element)element, (String)j)) != null) {
            this.setAlternateCollectionViewsEnabled(Boolean.parseBoolean(string));
        }
        for (Element element2 : element.getChildren(RENDERER_TAG)) {
            String string3 = element2.getAttributeValue(c);
            if (string3 == null) continue;
            try {
                if ("ToStringRenderer".equals(string3)) {
                    this.m.readExternal(element2);
                    if (this.m.isEnabled()) continue;
                    this.m.setEnabled(true);
                    this.m.setOnDemand(true);
                    continue;
                }
                if ("ClassRenderer".equals(string3)) {
                    this.f.readExternal(element2);
                    continue;
                }
                if (!"PrimitiveRenderer".equals(string3)) continue;
                this.l.readExternal(element2);
            }
            catch (InvalidDataException invalidDataException) {}
        }
        Element element3 = element.getChild(g);
        if (element3 != null) {
            this.e.readExternal(element3);
        }
        ((NodeRendererSettingsListener)this.b.getMulticaster()).renderersChanged();
    }

    public RendererConfiguration getCustomRenderers() {
        return this.e;
    }

    public void setCustomRenderers(@NotNull RendererConfiguration rendererConfiguration) {
        if (rendererConfiguration == null) {
            NodeRendererSettings.a(1);
        }
        RendererConfiguration rendererConfiguration2 = this.e;
        this.e = rendererConfiguration;
        if (rendererConfiguration2 == null || !rendererConfiguration2.equals(rendererConfiguration)) {
            this.fireRenderersChanged();
        }
    }

    public PrimitiveRenderer getPrimitiveRenderer() {
        return this.l;
    }

    public ArrayRenderer getArrayRenderer() {
        return this.h;
    }

    public ClassRenderer getClassRenderer() {
        return this.f;
    }

    public HexRenderer getHexRenderer() {
        return this.a;
    }

    public ToStringRenderer getToStringRenderer() {
        return this.m;
    }

    public NodeRenderer[] getAlternateCollectionRenderers() {
        return this.d;
    }

    public void fireRenderersChanged() {
        ((NodeRendererSettingsListener)this.b.getMulticaster()).renderersChanged();
    }

    public List<NodeRenderer> getAllRenderers() {
        ArrayList<NodeRenderer> arrayList = new ArrayList<NodeRenderer>();
        this.e.iterateRenderers((InternalIterator<NodeRenderer>)((InternalIterator)nodeRenderer -> {
            arrayList.add((NodeRenderer)nodeRenderer);
            return true;
        }));
        Collections.addAll(arrayList, NodeRenderer.EP_NAME.getExtensions());
        arrayList.add(this.a);
        arrayList.add(this.l);
        Collections.addAll(arrayList, this.d);
        arrayList.add(this.m);
        arrayList.add(this.h);
        arrayList.add(this.f);
        return arrayList;
    }

    public Renderer readRenderer(Element element) throws InvalidDataException {
        if (element == null) {
            return null;
        }
        if (!RENDERER_TAG.equals(element.getName())) {
            throw new InvalidDataException("Cannot read renderer - tag name is not 'Renderer'");
        }
        String string = element.getAttributeValue(c);
        if (string == null) {
            throw new InvalidDataException("unknown renderer ID: " + string);
        }
        Renderer renderer = this.createRenderer(string);
        if (renderer == null) {
            throw new InvalidDataException("unknown renderer ID: " + string);
        }
        renderer.readExternal(element);
        return renderer;
    }

    public Element writeRenderer(Renderer renderer) throws WriteExternalException {
        Element element = new Element(RENDERER_TAG);
        if (renderer != null) {
            element.setAttribute(c, renderer.getUniqueId());
            renderer.writeExternal(element);
        }
        return element;
    }

    public Renderer createRenderer(String string) {
        if ("ClassRenderer".equals(string)) {
            return this.f;
        }
        if ("ArrayRenderer".equals(string)) {
            return this.h;
        }
        if ("PrimitiveRenderer".equals(string)) {
            return this.l;
        }
        if ("HexRenderer".equals(string)) {
            return this.a;
        }
        if (string.equals("ExpressionChildrenRenderer")) {
            return new ExpressionChildrenRenderer();
        }
        if (string.equals("LabelRenderer")) {
            return new LabelRenderer();
        }
        if (string.equals("EnumerationChildrenRenderer")) {
            return new EnumerationChildrenRenderer();
        }
        if (string.equals("ToStringRenderer")) {
            return this.m;
        }
        if (string.equals("CompoundNodeRenderer") || string.equals(k)) {
            return this.createCompoundReferenceRenderer("unnamed", "java.lang.Object", null, null);
        }
        if (string.equals("CompoundTypeRenderer")) {
            return this.createCompoundTypeRenderer("unnamed", "java.lang.Object", null, null);
        }
        return null;
    }

    public CompoundTypeRenderer createCompoundTypeRenderer(@NonNls String string, @NonNls String string2, ValueLabelRenderer valueLabelRenderer, ChildrenRenderer childrenRenderer) {
        CompoundTypeRenderer compoundTypeRenderer = new CompoundTypeRenderer(this, string, valueLabelRenderer, childrenRenderer);
        compoundTypeRenderer.setClassName(string2);
        return compoundTypeRenderer;
    }

    public CompoundReferenceRenderer createCompoundReferenceRenderer(@NonNls String string, @NonNls String string2, ValueLabelRenderer valueLabelRenderer, ChildrenRenderer childrenRenderer) {
        CompoundReferenceRenderer compoundReferenceRenderer = new CompoundReferenceRenderer(this, string, valueLabelRenderer, childrenRenderer);
        compoundReferenceRenderer.setClassName(string2);
        return compoundReferenceRenderer;
    }

    private static ExpressionChildrenRenderer a(String string, String string2, ArrayRenderer arrayRenderer) {
        ExpressionChildrenRenderer expressionChildrenRenderer = NodeRendererSettings.createExpressionChildrenRenderer(string, string2);
        expressionChildrenRenderer.setPredictedRenderer(arrayRenderer);
        return expressionChildrenRenderer;
    }

    public static ExpressionChildrenRenderer createExpressionChildrenRenderer(@NonNls String string, @NonNls String string2) {
        ExpressionChildrenRenderer expressionChildrenRenderer = new ExpressionChildrenRenderer();
        expressionChildrenRenderer.setChildrenExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, string, "", (FileType)StdFileTypes.JAVA));
        if (string2 != null) {
            expressionChildrenRenderer.setChildrenExpandable(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, string2, "", (FileType)StdFileTypes.JAVA));
        }
        return expressionChildrenRenderer;
    }

    public static EnumerationChildrenRenderer createEnumerationChildrenRenderer(@NonNls String[][] stringArray) {
        EnumerationChildrenRenderer enumerationChildrenRenderer = new EnumerationChildrenRenderer();
        if (stringArray != null && stringArray.length > 0) {
            ArrayList<EnumerationChildrenRenderer.ChildInfo> arrayList = new ArrayList<EnumerationChildrenRenderer.ChildInfo>(stringArray.length);
            for (String[] stringArray2 : stringArray) {
                arrayList.add(new EnumerationChildrenRenderer.ChildInfo(stringArray2[0], new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, stringArray2[1], "", (FileType)StdFileTypes.JAVA), false));
            }
            enumerationChildrenRenderer.setChildren(arrayList);
        }
        return enumerationChildrenRenderer;
    }

    private static LabelRenderer a(final @NonNls String string, @NonNls String string2, final @NonNls String string3) {
        LabelRenderer labelRenderer = new LabelRenderer(){

            @Override
            public String calcLabel(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
                String string2 = super.calcLabel(valueDescriptor, evaluationContext, descriptorLabelListener);
                if (string == null && string3 == null) {
                    return string2;
                }
                if (string != null && string3 != null) {
                    return string + string2 + string3;
                }
                if (string != null) {
                    return string + string2;
                }
                return string2 + string3;
            }
        };
        labelRenderer.setLabelExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, string2, "", (FileType)StdFileTypes.JAVA));
        return labelRenderer;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customRenderers";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/settings/NodeRendererSettings";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setCustomRenderers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DescriptorUpdater
    implements DescriptorLabelListener {
        private final ValueDescriptor a;
        @Nullable
        private ValueDescriptorImpl d;
        @Nullable
        private ValueDescriptorImpl c;
        private final DescriptorLabelListener b;

        private DescriptorUpdater(ValueDescriptor valueDescriptor, DescriptorLabelListener descriptorLabelListener) {
            this.a = valueDescriptor;
            this.b = descriptorLabelListener;
        }

        public void setKeyDescriptor(@Nullable ValueDescriptorImpl valueDescriptorImpl) {
            this.d = valueDescriptorImpl;
        }

        public void setValueDescriptor(@Nullable ValueDescriptorImpl valueDescriptorImpl) {
            this.c = valueDescriptorImpl;
        }

        @Override
        public void labelChanged() {
            this.a.setValueLabel(DescriptorUpdater.constructLabelText(DescriptorUpdater.a(this.d), DescriptorUpdater.a(this.c)));
            this.b.labelChanged();
        }

        static String constructLabelText(String string, String string2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('\"').append(string).append("\" -> ");
            if (!StringUtil.isEmpty((String)string2)) {
                stringBuilder.append('\"').append(string2).append('\"');
            }
            return stringBuilder.toString();
        }

        private static String a(ValueDescriptorImpl valueDescriptorImpl) {
            return valueDescriptorImpl == null ? "null" : valueDescriptorImpl.getValueLabel();
        }
    }

    private static class ListObjectRenderer
    extends CompoundReferenceRenderer {
        public ListObjectRenderer(NodeRendererSettings nodeRendererSettings, ArrayRenderer arrayRenderer) {
            super(nodeRendererSettings, "List", NodeRendererSettings.a(" size = ", "size()", null), NodeRendererSettings.a("toArray()", "!isEmpty()", arrayRenderer));
            this.setClassName("java.util.List");
        }

        @Override
        public PsiElement getChildValueExpression(DebuggerTreeNode debuggerTreeNode, DebuggerContext debuggerContext) throws EvaluateException {
            LOG.assertTrue(debuggerTreeNode.getDescriptor() instanceof ArrayElementDescriptorImpl);
            try {
                return this.getChildValueExpression("this.get(" + ((ArrayElementDescriptorImpl)debuggerTreeNode.getDescriptor()).getIndex() + ")", debuggerTreeNode, debuggerContext);
            }
            catch (IncorrectOperationException incorrectOperationException) {
                return super.getChildValueExpression(debuggerTreeNode, debuggerContext);
            }
        }
    }

    private static class MapEntryLabelRenderer
    extends ReferenceRenderer
    implements ValueLabelRenderer {
        private static final Computable<String> b = () -> "null";
        private final MyCachedEvaluator d = new MyCachedEvaluator();
        private final MyCachedEvaluator c = new MyCachedEvaluator();

        private MapEntryLabelRenderer() {
            super("java.util.Map$Entry");
            this.d.setReferenceExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "this.getKey()", "", (FileType)StdFileTypes.JAVA));
            this.c.setReferenceExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "this.getValue()", "", (FileType)StdFileTypes.JAVA));
        }

        @Override
        public Icon calcValueIcon(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
            return null;
        }

        @Override
        public String calcLabel(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
            DescriptorUpdater descriptorUpdater = new DescriptorUpdater(valueDescriptor, descriptorLabelListener);
            Value value = valueDescriptor.getValue();
            Pair<Computable<String>, ValueDescriptorImpl> pair2 = this.a(evaluationContext, value, this.d, descriptorUpdater);
            Pair<Computable<String>, ValueDescriptorImpl> pair3 = this.a(evaluationContext, value, this.c, descriptorUpdater);
            descriptorUpdater.setKeyDescriptor((ValueDescriptorImpl)pair2.second);
            descriptorUpdater.setValueDescriptor((ValueDescriptorImpl)pair3.second);
            return DescriptorUpdater.constructLabelText((String)((Computable)pair2.first).compute(), (String)((Computable)pair3.first).compute());
        }

        private Pair<Computable<String>, ValueDescriptorImpl> a(EvaluationContext evaluationContext, Value value, MyCachedEvaluator myCachedEvaluator, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
            Value value2 = this.a(evaluationContext, value, myCachedEvaluator);
            if (value2 != null) {
                WatchItemDescriptor watchItemDescriptor = new WatchItemDescriptor(evaluationContext.getProject(), myCachedEvaluator.getReferenceExpression(), value2);
                watchItemDescriptor.setShowIdLabel(false);
                return new Pair(() -> {
                    watchItemDescriptor.updateRepresentation((EvaluationContextImpl)evaluationContext, descriptorLabelListener);
                    return watchItemDescriptor.getValueLabel();
                }, (Object)watchItemDescriptor);
            }
            return new Pair(b, null);
        }

        @Override
        public String getUniqueId() {
            return "MapEntry renderer";
        }

        private Value a(EvaluationContext evaluationContext, Value value, MyCachedEvaluator myCachedEvaluator) throws EvaluateException {
            DebugProcess debugProcess = evaluationContext.getDebugProcess();
            if (value == null) {
                return null;
            }
            try {
                ExpressionEvaluator expressionEvaluator = myCachedEvaluator.getEvaluator(debugProcess.getProject());
                if (!debugProcess.isAttached()) {
                    throw EvaluateExceptionUtil.PROCESS_EXITED;
                }
                EvaluationContext evaluationContext2 = evaluationContext.createEvaluationContext(value);
                return expressionEvaluator.evaluate(evaluationContext2);
            }
            catch (EvaluateException evaluateException) {
                throw new EvaluateException(DebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]) + " " + evaluateException.getMessage(), (Throwable)evaluateException);
            }
        }

        private class MyCachedEvaluator
        extends CachedEvaluator {
            private MyCachedEvaluator() {
            }

            @Override
            protected String getClassName() {
                return MapEntryLabelRenderer.this.getClassName();
            }

            @Override
            public ExpressionEvaluator getEvaluator(Project project2) throws EvaluateException {
                return super.getEvaluator(project2);
            }
        }
    }
}

