/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.CommonBundle;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.OptionsDialog;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.plaf.LabelUI;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class RunHotswapDialog
extends OptionsDialog {
    private final JPanel a;
    private final ElementsChooser<SessionItem> b;
    private final boolean c;

    public RunHotswapDialog(Project project2, List<DebuggerSession> list2, boolean bl2) {
        super(project2);
        this.c = bl2;
        this.a = new JPanel(new BorderLayout());
        ArrayList<SessionItem> arrayList = new ArrayList<SessionItem>(list2.size());
        for (DebuggerSession debuggerSession : list2) {
            arrayList.add(new SessionItem(debuggerSession));
        }
        arrayList.sort(Comparator.comparing(sessionItem -> sessionItem.getSession().getSessionName()));
        this.b = new ElementsChooser(arrayList, true);
        this.a.setBorder((Border)JBUI.Borders.empty((int)10, (int)0, (int)5, (int)0));
        if (list2.size() > 0) {
            this.b.selectElements(arrayList.subList(0, 1));
        }
        this.a.add((Component)this.b, "Center");
        if (list2.size() == 1) {
            this.setTitle(DebuggerBundle.message((String)"hotswap.dialog.title.with.session", (Object[])new Object[]{list2.get(0).getSessionName()}));
            this.a.setVisible(false);
        } else {
            this.setTitle(DebuggerBundle.message((String)"hotswap.dialog.title", (Object[])new Object[0]));
        }
        this.setButtonsAlignment(0);
        this.init();
    }

    protected boolean isToBeShown() {
        return "RunHotswapAsk".equals(DebuggerSettings.getInstance().RUN_HOTSWAP_AFTER_COMPILE);
    }

    protected void setToBeShown(boolean bl2, boolean bl3) {
        DebuggerSettings.getInstance().RUN_HOTSWAP_AFTER_COMPILE = bl2 ? "RunHotswapAsk" : (bl3 ? "RunHotswapAlways" : "RunHotswapNever");
    }

    protected boolean shouldSaveOptionsOnCancel() {
        return true;
    }

    @NotNull
    protected Action[] createActions() {
        this.setOKButtonText(CommonBundle.getYesButtonText());
        this.setCancelButtonText(CommonBundle.getNoButtonText());
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            RunHotswapDialog.a(0);
        }
        return actionArray;
    }

    protected JComponent createNorthPanel() {
        JLabel jLabel = new JLabel(DebuggerBundle.message((String)"hotswap.dialog.run.prompt", (Object[])new Object[0]));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "Center");
        Icon icon = UIUtil.getQuestionIcon();
        jLabel.setIcon(icon);
        jLabel.setIconTextGap(7);
        if (this.c) {
            JLabel jLabel2 = new JLabel("WARNING! " + DebuggerBundle.message((String)"hotswap.dialog.hang.warning", (Object[])new Object[0]));
            jLabel2.setUI((LabelUI)new MultiLineLabelUI());
            jPanel.add((Component)jLabel2, "South");
        }
        return jPanel;
    }

    protected JComponent createCenterPanel() {
        return this.a;
    }

    public Collection<DebuggerSession> getSessionsToReload() {
        return StreamEx.of((Collection)this.b.getMarkedElements()).map(SessionItem::getSession).toList();
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/RunHotswapDialog", "createActions"));
    }

    private static class SessionItem {
        private final DebuggerSession a;

        public SessionItem(DebuggerSession debuggerSession) {
            this.a = debuggerSession;
        }

        public DebuggerSession getSession() {
            return this.a;
        }

        public String toString() {
            return this.a.getSessionName();
        }
    }
}

