/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.ui.JavaDebuggerSupport;
import com.intellij.debugger.ui.breakpoints.AnyExceptionBreakpoint;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointDefaults;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint;
import com.intellij.debugger.ui.breakpoints.FieldBreakpoint;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaExceptionBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaFieldBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaMethodBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaWildcardMethodBreakpointType;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.sun.jdi.InternalException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.InvalidRequestStateException;
import gnu.trove.THashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaExceptionBreakpointProperties;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public class BreakpointManager {
    private static final Logger j = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.BreakpointManager");
    @NonNls
    private static final String k = "master_breakpoint";
    @NonNls
    private static final String d = "slave_breakpoint";
    @NonNls
    private static final String b = "default_suspend_policy";
    @NonNls
    private static final String i = "default_condition_enabled";
    @NonNls
    private static final String h = "breakpoint_rules";
    private static final String c = "converted";
    private final Project e;
    private final Map<String, String> g;
    private final StartupManager f;
    private final Map<String, Element> a;

    public BreakpointManager(@NotNull Project project2, @NotNull StartupManager startupManager, @NotNull DebuggerManagerImpl debuggerManagerImpl) {
        if (project2 == null) {
            BreakpointManager.a(0);
        }
        if (startupManager == null) {
            BreakpointManager.a(1);
        }
        if (debuggerManagerImpl == null) {
            BreakpointManager.a(2);
        }
        this.g = new LinkedHashMap<String, String>();
        this.a = new LinkedHashMap<String, Element>();
        this.e = project2;
        this.f = startupManager;
        debuggerManagerImpl.getContextManager().addListener(new DebuggerContextListener(){
            private DebuggerSession a;

            @Override
            public void changeEvent(@NotNull DebuggerContextImpl debuggerContextImpl, DebuggerSession.Event event) {
                if (debuggerContextImpl == null) {
                    1.a(0);
                }
                if (event == DebuggerSession.Event.ATTACHED) {
                    for (XBreakpoint xBreakpoint : BreakpointManager.this.a().getAllBreakpoints()) {
                        if (BreakpointManager.a(xBreakpoint)) break;
                    }
                }
                if (debuggerContextImpl.getDebuggerSession() != this.a || event == DebuggerSession.Event.DETACHED) {
                    BreakpointManager.this.updateBreakpointsUI();
                    this.a = debuggerContextImpl.getDebuggerSession();
                }
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContext", "com/intellij/debugger/ui/breakpoints/BreakpointManager$1", "changeEvent"));
            }
        });
    }

    private static boolean a(XBreakpoint xBreakpoint) {
        XBreakpointProperties xBreakpointProperties = xBreakpoint.getProperties();
        if (xBreakpoint.isEnabled() && xBreakpointProperties instanceof JavaMethodBreakpointProperties && !((JavaMethodBreakpointProperties)xBreakpointProperties).EMULATED) {
            XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(DebuggerBundle.message((String)"method.breakpoints.slowness.warning", (Object[])new Object[0]), MessageType.WARNING).notify(((XBreakpointBase)xBreakpoint).getProject());
            return true;
        }
        return false;
    }

    public void init() {
        XBreakpointManager xBreakpointManager = XDebuggerManager.getInstance((Project)this.e).getBreakpointManager();
        xBreakpointManager.addBreakpointListener(new XBreakpointListener<XBreakpoint<?>>(){

            public void breakpointAdded(@NotNull XBreakpoint<?> xBreakpoint) {
                Breakpoint breakpoint;
                if (xBreakpoint == null) {
                    2.a(0);
                }
                if ((breakpoint = BreakpointManager.getJavaBreakpoint(xBreakpoint)) != null) {
                    BreakpointManager.addBreakpoint(breakpoint);
                }
            }

            public void breakpointChanged(@NotNull XBreakpoint xBreakpoint) {
                Breakpoint breakpoint;
                if (xBreakpoint == null) {
                    2.a(1);
                }
                if ((breakpoint = BreakpointManager.getJavaBreakpoint(xBreakpoint)) != null) {
                    BreakpointManager.this.fireBreakpointChanged(breakpoint);
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "xBreakpoint";
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/BreakpointManager$2";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private XBreakpointManager a() {
        return XDebuggerManager.getInstance((Project)this.e).getBreakpointManager();
    }

    public void editBreakpoint(Breakpoint breakpoint, Editor editor) {
        DebuggerInvocationUtil.swingInvokeLater(this.e, () -> {
            GutterIconRenderer gutterIconRenderer;
            RangeHighlighter rangeHighlighter;
            XBreakpoint xBreakpoint = breakpoint.myXBreakpoint;
            if (xBreakpoint instanceof XLineBreakpointImpl && (rangeHighlighter = ((XLineBreakpointImpl)xBreakpoint).getHighlighter()) != null && (gutterIconRenderer = rangeHighlighter.getGutterIconRenderer()) != null) {
                DebuggerSupport.getDebuggerSupport(JavaDebuggerSupport.class).getEditBreakpointAction().editBreakpoint(this.e, editor, breakpoint.myXBreakpoint, gutterIconRenderer);
            }
        });
    }

    public void setBreakpointDefaults(Key<? extends Breakpoint> key, BreakpointDefaults breakpointDefaults) {
        Class clazz = null;
        if (LineBreakpoint.CATEGORY.toString().equals(key.toString())) {
            clazz = JavaLineBreakpointType.class;
        } else if (MethodBreakpoint.CATEGORY.toString().equals(key.toString())) {
            clazz = JavaMethodBreakpointType.class;
        } else if (FieldBreakpoint.CATEGORY.toString().equals(key.toString())) {
            clazz = JavaFieldBreakpointType.class;
        } else if (ExceptionBreakpoint.CATEGORY.toString().equals(key.toString())) {
            clazz = JavaExceptionBreakpointType.class;
        }
        if (clazz != null) {
            XBreakpointType xBreakpointType = XDebuggerUtil.getInstance().findBreakpointType(clazz);
            ((XBreakpointManagerImpl)this.a()).getBreakpointDefaults(xBreakpointType).setSuspendPolicy(Breakpoint.transformSuspendPolicy(breakpointDefaults.getSuspendPolicy()));
        }
    }

    @Nullable
    public RunToCursorBreakpoint addRunToCursorBreakpoint(@NotNull XSourcePosition xSourcePosition, boolean bl2) {
        if (xSourcePosition == null) {
            BreakpointManager.a(3);
        }
        return RunToCursorBreakpoint.create(this.e, xSourcePosition, bl2);
    }

    @Nullable
    public StepIntoBreakpoint addStepIntoBreakpoint(@NotNull BreakpointStepMethodFilter breakpointStepMethodFilter) {
        if (breakpointStepMethodFilter == null) {
            BreakpointManager.a(4);
        }
        return StepIntoBreakpoint.create(this.e, breakpointStepMethodFilter);
    }

    @Nullable
    public LineBreakpoint addLineBreakpoint(Document document, int n2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!LineBreakpoint.canAddLineBreakpoint(this.e, document, n2)) {
            return null;
        }
        XLineBreakpoint xLineBreakpoint = this.a(JavaLineBreakpointType.class, document, n2);
        Breakpoint breakpoint = BreakpointManager.getJavaBreakpoint((XBreakpoint)xLineBreakpoint);
        if (breakpoint instanceof LineBreakpoint) {
            BreakpointManager.addBreakpoint(breakpoint);
            return (LineBreakpoint)breakpoint;
        }
        return null;
    }

    @Nullable
    public FieldBreakpoint addFieldBreakpoint(@NotNull Document document, int n2) {
        PsiField psiField;
        if (document == null) {
            BreakpointManager.a(5);
        }
        if ((psiField = FieldBreakpoint.findField(this.e, document, n2)) == null) {
            return null;
        }
        int n3 = document.getLineNumber(n2);
        if (document.getLineNumber(psiField.getNameIdentifier().getTextOffset()) < n3) {
            return null;
        }
        return this.addFieldBreakpoint(document, n3, psiField.getName());
    }

    @Nullable
    public FieldBreakpoint addFieldBreakpoint(Document document, int n2, String string) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        XLineBreakpoint xLineBreakpoint = this.a(JavaFieldBreakpointType.class, document, n2);
        Breakpoint breakpoint = BreakpointManager.getJavaBreakpoint((XBreakpoint)xLineBreakpoint);
        if (breakpoint instanceof FieldBreakpoint) {
            FieldBreakpoint fieldBreakpoint = (FieldBreakpoint)breakpoint;
            fieldBreakpoint.setFieldName(string);
            BreakpointManager.addBreakpoint(breakpoint);
            return fieldBreakpoint;
        }
        return null;
    }

    @Nullable
    public ExceptionBreakpoint addExceptionBreakpoint(@NotNull String string, String string2) {
        if (string == null) {
            BreakpointManager.a(6);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        JavaExceptionBreakpointType javaExceptionBreakpointType = (JavaExceptionBreakpointType)XDebuggerUtil.getInstance().findBreakpointType(JavaExceptionBreakpointType.class);
        return (ExceptionBreakpoint)WriteAction.compute(() -> {
            XBreakpoint xBreakpoint;
            Breakpoint breakpoint;
            if (string == null) {
                BreakpointManager.a(18);
            }
            if ((breakpoint = BreakpointManager.getJavaBreakpoint(xBreakpoint = XDebuggerManager.getInstance((Project)this.e).getBreakpointManager().addBreakpoint((XBreakpointType)javaExceptionBreakpointType, (XBreakpointProperties)new JavaExceptionBreakpointProperties(string, string2)))) instanceof ExceptionBreakpoint) {
                ExceptionBreakpoint exceptionBreakpoint = (ExceptionBreakpoint)breakpoint;
                exceptionBreakpoint.setQualifiedName(string);
                exceptionBreakpoint.setPackageName(string2);
                BreakpointManager.addBreakpoint(exceptionBreakpoint);
                j.debug("ExceptionBreakpoint Added");
                return exceptionBreakpoint;
            }
            return null;
        });
    }

    @Nullable
    public MethodBreakpoint addMethodBreakpoint(Document document, int n2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        XLineBreakpoint xLineBreakpoint = this.a(JavaMethodBreakpointType.class, document, n2);
        Breakpoint breakpoint = BreakpointManager.getJavaBreakpoint((XBreakpoint)xLineBreakpoint);
        if (breakpoint instanceof MethodBreakpoint) {
            BreakpointManager.addBreakpoint(breakpoint);
            return (MethodBreakpoint)breakpoint;
        }
        return null;
    }

    private <B extends XBreakpoint<?>> XLineBreakpoint a(Class<? extends XBreakpointType<B, ?>> clazz, Document document, int n2) {
        XBreakpointType xBreakpointType = XDebuggerUtil.getInstance().findBreakpointType(clazz);
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        return (XLineBreakpoint)WriteAction.compute(() -> XDebuggerManager.getInstance((Project)this.e).getBreakpointManager().addLineBreakpoint((XLineBreakpointType)xBreakpointType, virtualFile.getUrl(), n2, ((XLineBreakpointType)xBreakpointType).createBreakpointProperties(virtualFile, n2)));
    }

    @Nullable
    public <T extends BreakpointWithHighlighter> T findBreakpoint(Document document, int n2, @Nullable Key<T> key) {
        for (Breakpoint breakpoint : this.getBreakpoints()) {
            if (!(breakpoint instanceof BreakpointWithHighlighter) || !((BreakpointWithHighlighter)breakpoint).isAt(document, n2) || key != null && !key.equals(breakpoint.getCategory())) continue;
            return (T)((BreakpointWithHighlighter)breakpoint);
        }
        return null;
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            BreakpointManager.a(7);
        }
        this.a.clear();
        for (Element element2 : element.getChildren()) {
            this.a.put(element2.getName(), JDOMUtil.internElement((Element)element2));
        }
        if (!this.e.isDefault()) {
            this.f.runWhenProjectIsInitialized(() -> {
                if (element == null) {
                    BreakpointManager.a(17);
                }
                this.c(element);
            });
        }
    }

    private void c(@NotNull Element element) {
        if (element == null) {
            BreakpointManager.a(8);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object;
            Object object2;
            Element element2;
            String string;
            Element element3;
            List list2;
            if (element == null) {
                BreakpointManager.a(16);
            }
            THashMap tHashMap = new THashMap();
            try {
                list2 = element.getChildren();
                for (Object object3 : list2) {
                    XBreakpoint xBreakpoint;
                    Breakpoint breakpoint;
                    Object object4;
                    XBreakpointManager xBreakpointManager;
                    Element element4;
                    element3 = (Element)object3;
                    if (element3.getName().equals(h) || element3.getAttribute(c) != null) continue;
                    string = element3.getName();
                    element2 = BreakpointCategory.lookup(string);
                    object2 = element3.getAttributeValue(b);
                    boolean bl2 = Boolean.parseBoolean(element3.getAttributeValue(i, "true"));
                    this.setBreakpointDefaults((Key<? extends Breakpoint>)element2, new BreakpointDefaults((String)object2, bl2));
                    if (!AnyExceptionBreakpoint.ANY_EXCEPTION_BREAKPOINT.equals((Object)element2)) {
                        element4 = element3.getChild(AnyExceptionBreakpoint.ANY_EXCEPTION_BREAKPOINT.toString());
                        object = element3.getChildren("breakpoint").iterator();
                        while (object.hasNext()) {
                            xBreakpointManager = (Element)object.next();
                            object4 = this.a(string, (Element)xBreakpointManager);
                            ((Breakpoint)object4).readExternal((Element)xBreakpointManager);
                            tHashMap.put(((Breakpoint)object4).getDisplayName(), object4);
                        }
                    } else {
                        element4 = element3;
                    }
                    if (element4 == null || (object = element3.getChild("breakpoint")) == null || (breakpoint = BreakpointManager.getJavaBreakpoint(xBreakpoint = (xBreakpointManager = XDebuggerManager.getInstance((Project)this.e).getBreakpointManager()).getDefaultBreakpoint((XBreakpointType)(object4 = (JavaExceptionBreakpointType)XDebuggerUtil.getInstance().findBreakpointType(JavaExceptionBreakpointType.class))))) == null) continue;
                    breakpoint.readExternal((Element)object);
                    BreakpointManager.addBreakpoint(breakpoint);
                }
            }
            catch (InvalidDataException invalidDataException) {
                // empty catch block
            }
            if ((list2 = element.getChild(h)) != null) {
                Object object3;
                List list3 = list2.getChildren("rule");
                object3 = list3.iterator();
                while (object3.hasNext()) {
                    Breakpoint breakpoint;
                    element3 = (Element)object3.next();
                    if (element3.getAttribute(c) != null || (string = element3.getChild(k)) == null || (element2 = element3.getChild(d)) == null || (object2 = (Breakpoint)tHashMap.get(string.getAttributeValue("name"))) == null || (breakpoint = (Breakpoint)tHashMap.get(element2.getAttributeValue("name"))) == null) continue;
                    boolean bl3 = Boolean.parseBoolean(element3.getAttributeValue("leaveEnabled"));
                    object = ((XBreakpointManagerImpl)this.a()).getDependentBreakpointManager();
                    object.setMasterBreakpoint(breakpoint.myXBreakpoint, ((Breakpoint)object2).myXBreakpoint, bl3);
                }
            }
            DebuggerInvocationUtil.invokeLater(this.e, this::updateBreakpointsUI);
        });
        this.g.clear();
        Element element2 = element.getChild("ui_properties");
        if (element2 != null) {
            List list2 = element2.getChildren("property");
            for (Object e2 : list2) {
                Element element3 = (Element)e2;
                String string = element3.getAttributeValue("name");
                String string2 = element3.getAttributeValue("value");
                if (string == null || string2 == null) continue;
                this.g.put(string, string2);
            }
        }
    }

    private Breakpoint a(String string, Element element) throws InvalidDataException {
        Object object = null;
        if (string.equals(LineBreakpoint.CATEGORY.toString())) {
            object = this.a(JavaLineBreakpointType.class, element);
        } else if (string.equals(MethodBreakpoint.CATEGORY.toString())) {
            object = element.getAttribute("url") != null ? this.a(JavaMethodBreakpointType.class, element) : this.a(JavaWildcardMethodBreakpointType.class);
        } else if (string.equals(FieldBreakpoint.CATEGORY.toString())) {
            object = this.a(JavaFieldBreakpointType.class, element);
        } else if (string.equals(ExceptionBreakpoint.CATEGORY.toString())) {
            object = this.a(JavaExceptionBreakpointType.class);
        }
        if (object == null) {
            throw new IllegalStateException("Unknown breakpoint category " + string);
        }
        return BreakpointManager.getJavaBreakpoint((XBreakpoint)object);
    }

    private <B extends XBreakpoint<?>> XBreakpoint a(Class<? extends XBreakpointType<B, ?>> clazz) {
        XBreakpointType xBreakpointType = XDebuggerUtil.getInstance().findBreakpointType(clazz);
        return (XBreakpoint)WriteAction.compute(() -> XDebuggerManager.getInstance((Project)this.e).getBreakpointManager().addBreakpoint(xBreakpointType, xBreakpointType.createProperties()));
    }

    private <B extends XBreakpoint<?>> XLineBreakpoint a(Class<? extends XBreakpointType<B, ?>> clazz, Element element) throws InvalidDataException {
        int n2;
        String string = element.getAttributeValue("url");
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(string);
        if (virtualFile == null) {
            throw new InvalidDataException(DebuggerBundle.message((String)"error.breakpoint.file.not.found", (Object[])new Object[]{string}));
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            throw new InvalidDataException(DebuggerBundle.message((String)"error.cannot.load.breakpoint.file", (Object[])new Object[]{string}));
        }
        try {
            n2 = Integer.parseInt(element.getAttributeValue("line"));
        }
        catch (Exception exception) {
            throw new InvalidDataException("Line number is invalid for breakpoint");
        }
        return this.a(clazz, document, n2);
    }

    public static void addBreakpoint(@NotNull Breakpoint breakpoint) {
        if (breakpoint == null) {
            BreakpointManager.a(9);
        }
        assert (breakpoint.myXBreakpoint.getUserData(Breakpoint.DATA_KEY) == breakpoint);
        breakpoint.updateUI();
        BreakpointManager.a(breakpoint.myXBreakpoint);
    }

    public void removeBreakpoint(@Nullable Breakpoint breakpoint) {
        if (breakpoint == null) {
            return;
        }
        WriteAction.run(() -> this.a().removeBreakpoint(breakpoint.myXBreakpoint));
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            BreakpointManager.a(10);
        }
        for (Element element2 : this.a.values()) {
            Element element3 = element2.clone();
            if (element3.getAttribute(c) == null) {
                element3.setAttribute(c, "true");
            }
            element.addContent(element3);
        }
    }

    @NotNull
    public List<Breakpoint> getBreakpoints() {
        List list2 = (List)ReadAction.compute(() -> ContainerUtil.mapNotNull((Object[])this.a().getAllBreakpoints(), BreakpointManager::getJavaBreakpoint));
        if (list2 == null) {
            BreakpointManager.a(11);
        }
        return list2;
    }

    @Nullable
    public static Breakpoint getJavaBreakpoint(@Nullable XBreakpoint xBreakpoint) {
        if (xBreakpoint == null) {
            return null;
        }
        Breakpoint breakpoint = (Breakpoint)xBreakpoint.getUserData(Breakpoint.DATA_KEY);
        if (breakpoint == null && xBreakpoint.getType() instanceof JavaBreakpointType) {
            Project project2 = ((XBreakpointBase)xBreakpoint).getProject();
            breakpoint = ((JavaBreakpointType)xBreakpoint.getType()).createJavaBreakpoint(project2, xBreakpoint);
            xBreakpoint.putUserData(Breakpoint.DATA_KEY, breakpoint);
        }
        return breakpoint;
    }

    public void disableBreakpoints(@NotNull DebugProcessImpl debugProcessImpl) {
        List<Breakpoint> list2;
        if (debugProcessImpl == null) {
            BreakpointManager.a(12);
        }
        if (!(list2 = this.getBreakpoints()).isEmpty()) {
            RequestManagerImpl requestManagerImpl = debugProcessImpl.getRequestsManager();
            for (Breakpoint breakpoint : list2) {
                breakpoint.markVerified(requestManagerImpl.isVerified(breakpoint));
                requestManagerImpl.deleteRequest(breakpoint);
            }
            SwingUtilities.invokeLater(this::updateBreakpointsUI);
        }
    }

    public void enableBreakpoints(DebugProcessImpl debugProcessImpl) {
        List<Breakpoint> list2 = this.getBreakpoints();
        if (!list2.isEmpty()) {
            for (Breakpoint breakpoint : list2) {
                breakpoint.markVerified(false);
                breakpoint.createRequest(debugProcessImpl);
            }
            SwingUtilities.invokeLater(this::updateBreakpointsUI);
        }
    }

    public void applyThreadFilter(@NotNull DebugProcessImpl debugProcessImpl, @Nullable ThreadReference threadReference) {
        RequestManagerImpl requestManagerImpl;
        ThreadReference threadReference2;
        if (debugProcessImpl == null) {
            BreakpointManager.a(13);
        }
        if (Comparing.equal((Object)threadReference, (Object)(threadReference2 = (requestManagerImpl = debugProcessImpl.getRequestsManager()).getFilterThread()))) {
            return;
        }
        requestManagerImpl.setFilterThread(threadReference);
        if (threadReference == null || threadReference2 != null) {
            List<Breakpoint> list2 = this.getBreakpoints();
            for (Breakpoint breakpoint : list2) {
                if (!LineBreakpoint.CATEGORY.equals(breakpoint.getCategory()) && !MethodBreakpoint.CATEGORY.equals(breakpoint.getCategory())) continue;
                requestManagerImpl.deleteRequest(breakpoint);
                breakpoint.createRequest(debugProcessImpl);
            }
        } else {
            EventRequestManager eventRequestManager = requestManagerImpl.getVMRequestManager();
            if (eventRequestManager != null) {
                BreakpointManager.a(eventRequestManager.breakpointRequests(), (T breakpointRequest) -> breakpointRequest.addThreadFilter(threadReference));
                BreakpointManager.a(eventRequestManager.methodEntryRequests(), (T methodEntryRequest) -> methodEntryRequest.addThreadFilter(threadReference));
                BreakpointManager.a(eventRequestManager.methodExitRequests(), (T methodExitRequest) -> methodExitRequest.addThreadFilter(threadReference));
            }
        }
    }

    private static <T extends EventRequest> void a(@NotNull List<T> list2, Consumer<T> consumer) {
        if (list2 == null) {
            BreakpointManager.a(14);
        }
        for (EventRequest eventRequest : list2) {
            try {
                boolean bl2 = eventRequest.isEnabled();
                if (bl2) {
                    eventRequest.disable();
                }
                consumer.accept(eventRequest);
                if (!bl2) continue;
                eventRequest.enable();
            }
            catch (InternalException | InvalidRequestStateException runtimeException) {
                j.info((Throwable)runtimeException);
            }
        }
    }

    public void updateBreakpointsUI() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.getBreakpoints().forEach(Breakpoint::updateUI);
    }

    public void reloadBreakpoints() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.getBreakpoints().forEach(Breakpoint::reload);
    }

    public void fireBreakpointChanged(Breakpoint breakpoint) {
        breakpoint.reload();
        breakpoint.updateUI();
    }

    @Nullable
    public Breakpoint findMasterBreakpoint(@NotNull Breakpoint breakpoint) {
        if (breakpoint == null) {
            BreakpointManager.a(15);
        }
        XDependentBreakpointManager xDependentBreakpointManager = ((XBreakpointManagerImpl)this.a()).getDependentBreakpointManager();
        return BreakpointManager.getJavaBreakpoint(xDependentBreakpointManager.getMasterBreakpoint(breakpoint.myXBreakpoint));
    }

    public String getProperty(String string) {
        return this.g.get(string);
    }

    public String setProperty(String string, String string2) {
        return this.g.put(string, string2);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startupManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClassName";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/BreakpointManager";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentBreakpoint";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/BreakpointManager";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpoints";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addRunToCursorBreakpoint";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addStepIntoBreakpoint";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addFieldBreakpoint";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addExceptionBreakpoint";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doRead";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addBreakpoint";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "disableBreakpoints";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "applyThreadFilter";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "applyFilter";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findMasterBreakpoint";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doRead$4";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$readExternal$3";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addExceptionBreakpoint$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

