/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.CommonBundle;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.ui.breakpoints.AddFieldBreakpointDialog;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.FieldBreakpoint;
import com.intellij.debugger.ui.breakpoints.FieldBreakpointPropertiesPanel;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointTypeBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaFieldBreakpointProperties;

public class JavaFieldBreakpointType
extends JavaLineBreakpointTypeBase<JavaFieldBreakpointProperties>
implements JavaBreakpointType<JavaFieldBreakpointProperties> {
    public JavaFieldBreakpointType() {
        super("java-field", DebuggerBundle.message((String)"field.watchpoints.tab.title", (Object[])new Object[0]));
    }

    public boolean isAddBreakpointButtonVisible() {
        return true;
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_field_breakpoint;
        if (icon == null) {
            JavaFieldBreakpointType.b(0);
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_disabled_field_breakpoint;
        if (icon == null) {
            JavaFieldBreakpointType.b(1);
        }
        return icon;
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_field_breakpoint;
        if (icon == null) {
            JavaFieldBreakpointType.b(2);
        }
        return icon;
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_disabled_field_breakpoint;
        if (icon == null) {
            JavaFieldBreakpointType.b(3);
        }
        return icon;
    }

    protected String getHelpID() {
        return "debugging.fieldWatchpoint";
    }

    public String getDisplayName() {
        return DebuggerBundle.message((String)"field.watchpoints.tab.title", (Object[])new Object[0]);
    }

    public String getShortText(XLineBreakpoint<JavaFieldBreakpointProperties> xLineBreakpoint) {
        return this.getText(xLineBreakpoint);
    }

    public String getText(XLineBreakpoint<JavaFieldBreakpointProperties> xLineBreakpoint) {
        JavaFieldBreakpointProperties javaFieldBreakpointProperties = (JavaFieldBreakpointProperties)xLineBreakpoint.getProperties();
        String string = javaFieldBreakpointProperties.myClassName;
        return string != null && !string.isEmpty() ? string + "." + javaFieldBreakpointProperties.myFieldName : javaFieldBreakpointProperties.myFieldName;
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XLineBreakpoint<JavaFieldBreakpointProperties>> createCustomPropertiesPanel() {
        return new FieldBreakpointPropertiesPanel();
    }

    @Nullable
    public JavaFieldBreakpointProperties createProperties() {
        return new JavaFieldBreakpointProperties();
    }

    @Nullable
    public JavaFieldBreakpointProperties createBreakpointProperties(@NotNull VirtualFile virtualFile, int n2) {
        if (virtualFile == null) {
            JavaFieldBreakpointType.b(4);
        }
        return new JavaFieldBreakpointProperties();
    }

    @Nullable
    public XLineBreakpoint<JavaFieldBreakpointProperties> addBreakpoint(final Project project2, JComponent jComponent) {
        final Ref ref = Ref.create(null);
        AddFieldBreakpointDialog addFieldBreakpointDialog = new AddFieldBreakpointDialog(project2){

            @Override
            protected boolean validateData() {
                String string = this.getClassName();
                if (string.length() == 0) {
                    Messages.showMessageDialog((Project)project2, (String)DebuggerBundle.message((String)"error.field.breakpoint.class.name.not.specified", (Object[])new Object[0]), (String)DebuggerBundle.message((String)"add.field.breakpoint.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                    return false;
                }
                String string2 = this.getFieldName();
                if (string2.length() == 0) {
                    Messages.showMessageDialog((Project)project2, (String)DebuggerBundle.message((String)"error.field.breakpoint.field.name.not.specified", (Object[])new Object[0]), (String)DebuggerBundle.message((String)"add.field.breakpoint.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                    return false;
                }
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)project2).findClass(string, GlobalSearchScope.allScope((Project)project2));
                if (psiClass != null) {
                    PsiFile psiFile = psiClass.getContainingFile();
                    Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile);
                    if (document != null) {
                        PsiField psiField = psiClass.findFieldByName(string2, true);
                        if (psiField != null) {
                            int n2 = document.getLineNumber(psiField.getTextOffset());
                            WriteAction.run(() -> {
                                XLineBreakpoint xLineBreakpoint = XDebuggerManager.getInstance((Project)project2).getBreakpointManager().addLineBreakpoint((XLineBreakpointType)JavaFieldBreakpointType.this, psiFile.getVirtualFile().getUrl(), n2, (XBreakpointProperties)new JavaFieldBreakpointProperties(string2, string));
                                ref.set((Object)xLineBreakpoint);
                            });
                            return true;
                        }
                        Messages.showMessageDialog((Project)project2, (String)DebuggerBundle.message((String)"error.field.breakpoint.field.not.found", (Object[])new Object[]{string, string2, string2}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                    }
                } else {
                    Messages.showMessageDialog((Project)project2, (String)DebuggerBundle.message((String)"error.field.breakpoint.class.sources.not.found", (Object[])new Object[]{string, string2, string}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                }
                return false;
            }
        };
        addFieldBreakpointDialog.show();
        return (XLineBreakpoint)ref.get();
    }

    @Override
    @NotNull
    public Breakpoint<JavaFieldBreakpointProperties> createJavaBreakpoint(Project project2, XBreakpoint xBreakpoint) {
        FieldBreakpoint fieldBreakpoint = new FieldBreakpoint(project2, xBreakpoint);
        if (fieldBreakpoint == null) {
            JavaFieldBreakpointType.b(5);
        }
        return fieldBreakpoint;
    }

    public boolean canBeHitInOtherPlaces() {
        return true;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 4: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/JavaFieldBreakpointType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutedEnabledIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutedDisabledIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/JavaFieldBreakpointType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaBreakpoint";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createBreakpointProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

