/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointTypeBase;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.debugger.ui.breakpoints.MethodBreakpointPropertiesPanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public class JavaMethodBreakpointType
extends JavaLineBreakpointTypeBase<JavaMethodBreakpointProperties>
implements JavaBreakpointType<JavaMethodBreakpointProperties> {
    public JavaMethodBreakpointType() {
        super("java-method", DebuggerBundle.message((String)"method.breakpoints.tab.title", (Object[])new Object[0]));
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_method_breakpoint;
        if (icon == null) {
            JavaMethodBreakpointType.b(0);
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_disabled_method_breakpoint;
        if (icon == null) {
            JavaMethodBreakpointType.b(1);
        }
        return icon;
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_method_breakpoint;
        if (icon == null) {
            JavaMethodBreakpointType.b(2);
        }
        return icon;
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_disabled_method_breakpoint;
        if (icon == null) {
            JavaMethodBreakpointType.b(3);
        }
        return icon;
    }

    protected String getHelpID() {
        return "debugging.methodBreakpoint";
    }

    public String getDisplayName() {
        return DebuggerBundle.message((String)"method.breakpoints.tab.title", (Object[])new Object[0]);
    }

    public String getShortText(XLineBreakpoint<JavaMethodBreakpointProperties> xLineBreakpoint) {
        return JavaMethodBreakpointType.getText(xLineBreakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getText(XBreakpoint<JavaMethodBreakpointProperties> xBreakpoint) {
        StringBuilder stringBuilder = StringBuilderSpinAllocator.alloc();
        try {
            boolean bl2;
            String string = ((JavaMethodBreakpointProperties)xBreakpoint.getProperties()).myClassPattern;
            boolean bl3 = bl2 = string != null && string.length() > 0;
            if (bl2) {
                stringBuilder.append(string);
            }
            if (((JavaMethodBreakpointProperties)xBreakpoint.getProperties()).myMethodName != null) {
                if (bl2) {
                    stringBuilder.append(".");
                }
                stringBuilder.append(((JavaMethodBreakpointProperties)xBreakpoint.getProperties()).myMethodName);
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)stringBuilder);
        }
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel createCustomPropertiesPanel() {
        return new MethodBreakpointPropertiesPanel();
    }

    @Nullable
    public JavaMethodBreakpointProperties createProperties() {
        return new JavaMethodBreakpointProperties();
    }

    @Nullable
    public JavaMethodBreakpointProperties createBreakpointProperties(@NotNull VirtualFile virtualFile, int n2) {
        if (virtualFile == null) {
            JavaMethodBreakpointType.b(4);
        }
        JavaMethodBreakpointProperties javaMethodBreakpointProperties = new JavaMethodBreakpointProperties();
        if (Registry.is((String)"debugger.emulate.method.breakpoints")) {
            javaMethodBreakpointProperties.EMULATED = true;
        }
        return javaMethodBreakpointProperties;
    }

    @Override
    @NotNull
    public Breakpoint<JavaMethodBreakpointProperties> createJavaBreakpoint(Project project2, XBreakpoint xBreakpoint) {
        MethodBreakpoint methodBreakpoint = new MethodBreakpoint(project2, xBreakpoint);
        if (methodBreakpoint == null) {
            JavaMethodBreakpointType.b(5);
        }
        return methodBreakpoint;
    }

    public boolean canBeHitInOtherPlaces() {
        return true;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 4: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/JavaMethodBreakpointType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutedEnabledIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutedDisabledIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/JavaMethodBreakpointType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaBreakpoint";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createBreakpointProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

