/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluatorImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.ClassesByNameProvider;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.GeneratedLocation;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.settings.CapturePoint;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.breakpoints.WildcardMethodBreakpoint;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import com.sun.jdi.event.LocatableEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public class StackCapturingLineBreakpoint
extends WildcardMethodBreakpoint {
    private static final Logger g = Logger.getInstance(StackCapturingLineBreakpoint.class);
    private final CapturePoint h;
    private final String e;
    private final MyEvaluator i;
    private final MyEvaluator l;
    public static final Key<List<StackCapturingLineBreakpoint>> CAPTURE_BREAKPOINTS = Key.create((String)"CAPTURE_BREAKPOINTS");
    private static final Key<Map<Object, List<StackFrameItem>>> j = Key.create((String)"CAPTURED_STACKS");
    private static final int f = 1000;
    public static final int MAX_STACK_LENGTH = 500;
    private final JavaMethodBreakpointProperties d = new JavaMethodBreakpointProperties();
    private static final Key<Pair<ClassType, Method>> k = Key.create((String)"CAPTURE_STORAGE_METHOD");
    public static final Pair<ClassType, Method> NO_CAPTURE_AGENT = Pair.empty();

    public StackCapturingLineBreakpoint(Project project2, CapturePoint capturePoint) {
        super(project2, (XBreakpoint<JavaMethodBreakpointProperties>)null);
        this.h = capturePoint;
        this.e = null;
        this.d.EMULATED = true;
        this.d.WATCH_EXIT = false;
        this.d.myClassPattern = this.h.myClassName;
        this.d.myMethodName = this.h.myMethodName;
        this.i = new MyEvaluator(this.h.myCaptureKeyExpression);
        this.l = new MyEvaluator(this.h.myInsertKeyExpression);
    }

    @Override
    @NotNull
    protected JavaMethodBreakpointProperties getProperties() {
        JavaMethodBreakpointProperties javaMethodBreakpointProperties = this.d;
        if (javaMethodBreakpointProperties == null) {
            StackCapturingLineBreakpoint.c(0);
        }
        return javaMethodBreakpointProperties;
    }

    @Override
    public String getSuspendPolicy() {
        return "SuspendThread";
    }

    @Override
    public boolean processLocatableEvent(SuspendContextCommandImpl suspendContextCommandImpl, LocatableEvent locatableEvent) throws LocatableEventRequestor.EventProcessingException {
        ThreadReferenceProxyImpl threadReferenceProxyImpl;
        SuspendContextImpl suspendContextImpl = suspendContextCommandImpl.getSuspendContext();
        if (suspendContextImpl != null && (threadReferenceProxyImpl = suspendContextImpl.getThread()) != null) {
            DebugProcessImpl debugProcessImpl = suspendContextImpl.getDebugProcess();
            try {
                StackFrameProxyImpl stackFrameProxyImpl = (StackFrameProxyImpl)ContainerUtil.getFirstItem(threadReferenceProxyImpl.forceFrames());
                if (stackFrameProxyImpl != null) {
                    Value value;
                    Map map = (Map)debugProcessImpl.getUserData(j);
                    if (map == null) {
                        map = new CapturedStacksMap();
                        StackCapturingLineBreakpoint.putProcessUserData(j, Collections.synchronizedMap(map), debugProcessImpl);
                    }
                    if ((value = this.i.evaluate(new EvaluationContextImpl(suspendContextImpl, stackFrameProxyImpl))) instanceof ObjectReference) {
                        List<StackFrameItem> list2 = StackFrameItem.createFrames(suspendContextImpl, true);
                        if (list2.size() > 500) {
                            list2 = list2.subList(0, 500);
                        }
                        map.put(StackCapturingLineBreakpoint.a((ObjectReference)value), list2);
                    }
                }
            }
            catch (EvaluateException evaluateException) {
                g.debug((Throwable)evaluateException);
                debugProcessImpl.printToConsole(DebuggerBundle.message((String)"error.unable.to.evaluate.capture.expression", (Object[])new Object[]{evaluateException.getMessage()}) + "\n");
            }
        }
        return false;
    }

    @Override
    protected void fireBreakpointChanged() {
    }

    @Override
    public StreamEx matchingMethods(StreamEx<Method> streamEx, DebugProcessImpl debugProcessImpl) {
        String string = this.getMethodName();
        return (StreamEx)((StreamEx)streamEx.filter(method -> Comparing.equal((String)string, (String)method.name()) && (this.e == null || Comparing.equal((String)this.e, (String)method.signature())))).limit(1L);
    }

    public static void deleteAll(DebugProcessImpl debugProcessImpl) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        List list2 = (List)debugProcessImpl.getUserData(CAPTURE_BREAKPOINTS);
        if (!ContainerUtil.isEmpty((Collection)list2)) {
            list2.forEach(debugProcessImpl.getRequestsManager()::deleteRequest);
            list2.clear();
        }
    }

    public static void createAll(DebugProcessImpl debugProcessImpl) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        StreamEx streamEx = (StreamEx)StreamEx.of(DebuggerSettings.getInstance().getCapturePoints()).filter(capturePoint -> capturePoint.myEnabled);
        if (StackCapturingLineBreakpoint.isAgentEnabled()) {
            streamEx = streamEx.append(debugProcessImpl.getAgentInsertPoints());
        }
        streamEx.forEach(capturePoint -> StackCapturingLineBreakpoint.b(debugProcessImpl, capturePoint));
    }

    public static void clearCaches(DebugProcessImpl debugProcessImpl) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        List list2 = (List)debugProcessImpl.getUserData(CAPTURE_BREAKPOINTS);
        if (!ContainerUtil.isEmpty((Collection)list2)) {
            list2.forEach(stackCapturingLineBreakpoint -> {
                stackCapturingLineBreakpoint.i.clearCache();
                stackCapturingLineBreakpoint.l.clearCache();
            });
        }
    }

    @Override
    public void createRequest(DebugProcessImpl debugProcessImpl) {
        if (!StringUtil.isEmpty((String)this.getClassName())) {
            super.createRequest(debugProcessImpl);
        }
    }

    @Override
    public void customizeRenderer(SimpleColoredComponent simpleColoredComponent) {
        simpleColoredComponent.append("Capture point at " + this.h.myClassName + "." + this.h.myMethodName);
    }

    @Override
    public boolean isEnabled() {
        return this.h.myEnabled;
    }

    @Override
    public void setEnabled(boolean bl2) {
        this.h.myEnabled = bl2;
        DebuggerSettings.getInstance().setCapturePoints(DebuggerSettings.getInstance().getCapturePoints());
    }

    private static void b(DebugProcessImpl debugProcessImpl, CapturePoint capturePoint) {
        StackCapturingLineBreakpoint stackCapturingLineBreakpoint = new StackCapturingLineBreakpoint(debugProcessImpl.getProject(), capturePoint);
        stackCapturingLineBreakpoint.createRequest(debugProcessImpl);
        CopyOnWriteArrayList<StackCapturingLineBreakpoint> copyOnWriteArrayList = (CopyOnWriteArrayList<StackCapturingLineBreakpoint>)debugProcessImpl.getUserData(CAPTURE_BREAKPOINTS);
        if (copyOnWriteArrayList == null) {
            copyOnWriteArrayList = new CopyOnWriteArrayList<StackCapturingLineBreakpoint>();
            StackCapturingLineBreakpoint.putProcessUserData(CAPTURE_BREAKPOINTS, copyOnWriteArrayList, debugProcessImpl);
        }
        copyOnWriteArrayList.add(stackCapturingLineBreakpoint);
    }

    public static <T> void putProcessUserData(final @NotNull Key<T> key, @Nullable T t2, DebugProcessImpl debugProcessImpl) {
        if (key == null) {
            StackCapturingLineBreakpoint.c(1);
        }
        debugProcessImpl.putUserData(key, t2);
        debugProcessImpl.addDebugProcessListener(new DebugProcessListener(){

            public void processDetached(DebugProcess debugProcess, boolean bl2) {
                debugProcess.putUserData(key, null);
            }
        });
    }

    @Nullable
    public static CapturePoint getMatchingDisabledInsertionPoint(@NotNull StackFrameProxyImpl stackFrameProxyImpl) {
        List<CapturePoint> list2;
        if (stackFrameProxyImpl == null) {
            StackCapturingLineBreakpoint.c(2);
        }
        if (!(list2 = DebuggerSettings.getInstance().getCapturePoints()).isEmpty()) {
            try {
                Location location = stackFrameProxyImpl.location();
                String string = location.declaringType().name();
                String string2 = location.method().name();
                for (CapturePoint capturePoint : list2) {
                    if (capturePoint.myEnabled || !StringUtil.equals((CharSequence)capturePoint.myInsertClassName, (CharSequence)string) || !StringUtil.equals((CharSequence)capturePoint.myInsertMethodName, (CharSequence)string2)) continue;
                    return capturePoint;
                }
            }
            catch (EvaluateException | InternalException throwable) {
                g.debug(throwable);
            }
        }
        return null;
    }

    @Nullable
    public static List<StackFrameItem> getRelatedStack(@NotNull StackFrameProxyImpl stackFrameProxyImpl, @NotNull SuspendContextImpl suspendContextImpl, boolean bl2) {
        DebugProcessImpl debugProcessImpl;
        Map map;
        if (stackFrameProxyImpl == null) {
            StackCapturingLineBreakpoint.c(3);
        }
        if (suspendContextImpl == null) {
            StackCapturingLineBreakpoint.c(4);
        }
        if (ContainerUtil.isEmpty((Map)(map = (Map)(debugProcessImpl = suspendContextImpl.getDebugProcess()).getUserData(j))) && !StackCapturingLineBreakpoint.isAgentEnabled()) {
            return null;
        }
        List list2 = (List)debugProcessImpl.getUserData(CAPTURE_BREAKPOINTS);
        if (ContainerUtil.isEmpty((Collection)list2)) {
            return null;
        }
        try {
            Location location = stackFrameProxyImpl.location();
            String string = location.declaringType().name();
            String string2 = location.method().name();
            for (StackCapturingLineBreakpoint stackCapturingLineBreakpoint : list2) {
                String string3 = stackCapturingLineBreakpoint.h.myInsertClassName;
                if (!StringUtil.isEmpty((String)string3) && !StringUtil.equals((CharSequence)string3, (CharSequence)string) || !StringUtil.equals((CharSequence)stackCapturingLineBreakpoint.h.myInsertMethodName, (CharSequence)string2)) continue;
                try {
                    EvaluationContextImpl evaluationContextImpl = new EvaluationContextImpl(suspendContextImpl, stackFrameProxyImpl);
                    Value value = stackCapturingLineBreakpoint.l.evaluate(evaluationContextImpl);
                    List<StackFrameItem> list3 = null;
                    if (value instanceof ObjectReference) {
                        if (map != null) {
                            list3 = (List<StackFrameItem>)map.get(StackCapturingLineBreakpoint.a((ObjectReference)value));
                        }
                        if (list3 == null && bl2) {
                            list3 = StackCapturingLineBreakpoint.a(value, evaluationContextImpl);
                        }
                    }
                    return list3;
                }
                catch (EvaluateException evaluateException) {
                    g.debug((Throwable)evaluateException);
                    if (evaluateException.getCause() instanceof IncompatibleThreadStateException) continue;
                    debugProcessImpl.printToConsole(DebuggerBundle.message((String)"error.unable.to.evaluate.insert.expression", (Object[])new Object[]{evaluateException.getMessage()}) + "\n");
                }
            }
        }
        catch (EvaluateException evaluateException) {
            g.debug((Throwable)evaluateException);
        }
        return null;
    }

    private static List<StackFrameItem> a(Value value, EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        Object object;
        DebugProcessImpl debugProcessImpl = (evaluationContextImpl = evaluationContextImpl.withAutoLoadClasses(false)).getDebugProcess();
        Pair pair2 = (Pair)debugProcessImpl.getUserData(k);
        if (pair2 == null) {
            try {
                object = (ClassType)debugProcessImpl.findClass(evaluationContextImpl, "com.intellij.rt.debugger.agent.CaptureStorage", null);
                if (object == null) {
                    pair2 = NO_CAPTURE_AGENT;
                    g.debug("Error loading debug agent", new Object[]{"agent class not found"});
                } else {
                    pair2 = Pair.create((Object)object, (Object)object.methodsByName("getRelatedStack").get(0));
                }
            }
            catch (EvaluateException evaluateException) {
                pair2 = NO_CAPTURE_AGENT;
                g.debug("Error loading debug agent", (Throwable)evaluateException);
            }
            StackCapturingLineBreakpoint.putProcessUserData(k, pair2, debugProcessImpl);
        }
        if (pair2 == NO_CAPTURE_AGENT) {
            return null;
        }
        object = debugProcessImpl.getVirtualMachineProxy();
        List<Value> list2 = Arrays.asList(value, ((VirtualMachineProxyImpl)object).mirrorOf(500));
        Value value2 = debugProcessImpl.invokeMethod(evaluationContextImpl, (ClassType)pair2.first, (Method)pair2.second, list2, 1, true);
        DebuggerUtilsEx.keep(value2, evaluationContextImpl);
        if (value2 instanceof ArrayReference) {
            List<Value> list3 = ((ArrayReference)value2).getValues();
            ArrayList<StackFrameItem> arrayList = new ArrayList<StackFrameItem>(list3.size());
            ClassesByNameProvider classesByNameProvider = ClassesByNameProvider.createCache(((VirtualMachineProxyImpl)object).allClasses());
            for (Value value3 : list3) {
                if (value3 == null) {
                    arrayList.add(null);
                    continue;
                }
                List<Value> list4 = ((ArrayReference)value3).getValues();
                String string = StackCapturingLineBreakpoint.a((StringReference)list4.get(0));
                String string2 = StackCapturingLineBreakpoint.a((StringReference)list4.get(2));
                int n2 = Integer.parseInt(((StringReference)list4.get(3)).value());
                Location location = StackCapturingLineBreakpoint.a(debugProcessImpl, (ReferenceType)ContainerUtil.getFirstItem(classesByNameProvider.get(string)), string2, n2);
                arrayList.add(new ProcessStackFrameItem(location, string, string2));
            }
            return arrayList;
        }
        return null;
    }

    private static String a(StringReference stringReference) {
        return stringReference != null ? stringReference.value() : null;
    }

    private static Location a(DebugProcessImpl debugProcessImpl, ReferenceType referenceType, String string, int n2) {
        if (referenceType != null && n2 >= 0) {
            try {
                Location location2 = referenceType.locationsOfLine("Java", null, n2).stream().filter(location -> location.method().name().equals(string)).findFirst().orElse(null);
                if (location2 != null) {
                    return location2;
                }
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
        }
        return new GeneratedLocation(debugProcessImpl, referenceType, string, n2);
    }

    @Nullable
    public static List<StackFrameItem> getRelatedStack(@Nullable ObjectReference objectReference, @Nullable DebugProcessImpl debugProcessImpl) {
        Map map;
        if (debugProcessImpl != null && objectReference != null && (map = (Map)debugProcessImpl.getUserData(j)) != null) {
            return (List)map.get(objectReference);
        }
        return null;
    }

    private static Object a(ObjectReference objectReference) {
        return objectReference instanceof StringReference ? ((StringReference)objectReference).value() : objectReference;
    }

    public static boolean isAgentEnabled() {
        return DebuggerSettings.getInstance().INSTRUMENTING_AGENT;
    }

    private static /* synthetic */ void c(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/StackCapturingLineBreakpoint";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/StackCapturingLineBreakpoint";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "putProcessUserData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingDisabledInsertionPoint";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedStack";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyEvaluator {
        private final String b;
        private ExpressionEvaluator c;
        private final Map<Location, ExpressionEvaluator> a = ContainerUtil.createWeakMap();

        public MyEvaluator(String string) {
            boolean bl2;
            this.b = string;
            final int n2 = DecompiledLocalVariable.getParamId(this.b);
            boolean bl3 = bl2 = n2 > -1;
            if (bl2) {
                this.c = new ExpressionEvaluatorImpl(new Evaluator(){

                    @Override
                    public Object evaluate(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
                        List<Value> list2 = evaluationContextImpl.getFrameProxy().getArgumentValues();
                        if (n2 >= list2.size()) {
                            throw new EvaluateException("Param index " + n2 + " requested, but only " + list2.size() + " available");
                        }
                        return list2.get(n2);
                    }
                });
            }
        }

        @Nullable
        Value evaluate(EvaluationContext evaluationContext) throws EvaluateException {
            Location location;
            ExpressionEvaluator expressionEvaluator = this.c;
            if (expressionEvaluator == null && (expressionEvaluator = this.a.get(location = evaluationContext.getFrameProxy().location())) == null && !StringUtil.isEmpty((String)this.b)) {
                expressionEvaluator = (ExpressionEvaluator)ApplicationManager.getApplication().runReadAction(() -> {
                    SourcePosition sourcePosition = ContextUtil.getSourcePosition((StackFrameContext)evaluationContext);
                    PsiElement psiElement = ContextUtil.getContextElement(sourcePosition);
                    return EvaluatorBuilderImpl.build(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, this.b), psiElement, sourcePosition, evaluationContext.getProject());
                });
                this.a.put(location, expressionEvaluator);
            }
            if (expressionEvaluator != null) {
                return expressionEvaluator.evaluate(evaluationContext);
            }
            return null;
        }

        void clearCache() {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            this.a.clear();
        }
    }

    private static class ProcessStackFrameItem
    extends StackFrameItem {
        final String myClass;
        final String myMethod;

        public ProcessStackFrameItem(Location location, String string, String string2) {
            super(location, null);
            this.myClass = string;
            this.myMethod = string2;
        }

        @Override
        @NotNull
        public String path() {
            String string = this.myClass;
            if (string == null) {
                ProcessStackFrameItem.b(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String method() {
            String string = this.myMethod;
            if (string == null) {
                ProcessStackFrameItem.b(1);
            }
            return string;
        }

        @Override
        public String toString() {
            return this.myClass + "." + this.myMethod + ":" + this.line();
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/debugger/ui/breakpoints/StackCapturingLineBreakpoint$ProcessStackFrameItem";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "path";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "method";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class CapturedStacksMap
    extends LinkedHashMap<Object, List<StackFrameItem>> {
        private CapturedStacksMap() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 1000;
        }
    }
}

