/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.GotoFrameSourceAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.ui.impl.DebuggerTreePanel;
import com.intellij.debugger.ui.impl.ThreadsDebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTree;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ThreadsPanel
extends DebuggerTreePanel {
    @NonNls
    private static final String g = "debugging.debugThreads";
    private final Alarm i = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private static final int h = 200;

    public ThreadsPanel(Project project2, final DebuggerStateManager debuggerStateManager) {
        super(project2, debuggerStateManager);
        Disposable disposable = DebuggerAction.installEditAction((JTree)((Object)this.getThreadsTree()), "Debugger.EditFrameSource");
        this.registerDisposable(disposable);
        this.getThreadsTree().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && ThreadsPanel.this.getThreadsTree().getSelectionCount() == 1) {
                    GotoFrameSourceAction.doAction(DataManager.getInstance().getDataContext((Component)((Object)ThreadsPanel.this.getThreadsTree())));
                }
            }
        });
        this.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.getThreadsTree())), "Center");
        debuggerStateManager.addListener(new DebuggerContextListener(){

            @Override
            public void changeEvent(@NotNull DebuggerContextImpl debuggerContextImpl, DebuggerSession.Event event) {
                if (debuggerContextImpl == null) {
                    2.a(0);
                }
                if (DebuggerSession.Event.ATTACHED == event || DebuggerSession.Event.RESUME == event) {
                    ThreadsPanel.this.c();
                } else if (DebuggerSession.Event.PAUSE == event || DebuggerSession.Event.DETACHED == event || DebuggerSession.Event.DISPOSE == event) {
                    ThreadsPanel.this.i.cancelAllRequests();
                }
                if (DebuggerSession.Event.DETACHED == event || DebuggerSession.Event.DISPOSE == event) {
                    debuggerStateManager.removeListener(this);
                }
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContext", "com/intellij/debugger/ui/impl/ThreadsPanel$2", "changeEvent"));
            }
        });
        this.c();
    }

    private void c() {
        if (this.i.isDisposed()) {
            return;
        }
        this.i.cancelAllRequests();
        this.i.addRequest(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean bl2 = false;
                try {
                    DebugProcessImpl debugProcessImpl;
                    ThreadsDebuggerTree threadsDebuggerTree;
                    DebuggerTreeNodeImpl debuggerTreeNodeImpl;
                    if (ThreadsPanel.this.isUpdateEnabled() && (debuggerTreeNodeImpl = (DebuggerTreeNodeImpl)(threadsDebuggerTree = ThreadsPanel.this.getThreadsTree()).getModel().getRoot()) != null && (debugProcessImpl = ThreadsPanel.this.getContext().getDebugProcess()) != null) {
                        debugProcessImpl.getManagerThread().invoke(new DebuggerCommandImpl(){

                            @Override
                            protected void action() throws Exception {
                                try {
                                    ThreadsPanel.a(debuggerTreeNodeImpl);
                                }
                                finally {
                                    this.a();
                                }
                            }

                            @Override
                            protected void commandCancelled() {
                                this.a();
                            }
                        });
                        bl2 = true;
                    }
                }
                finally {
                    if (!bl2) {
                        this.a();
                    }
                }
            }

            private void a() {
                DebuggerSession debuggerSession = ThreadsPanel.this.getContext().getDebuggerSession();
                if (debuggerSession != null && debuggerSession.isAttached() && !debuggerSession.isPaused() && !ThreadsPanel.this.i.isDisposed()) {
                    ThreadsPanel.this.i.addRequest((Runnable)this, 200, ModalityState.NON_MODAL);
                }
            }
        }, 200, ModalityState.NON_MODAL);
    }

    @Override
    public void dispose() {
        Disposer.dispose((Disposable)this.i);
        super.dispose();
    }

    private static void a(DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
        int n2 = debuggerTreeNodeImpl.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            DebuggerTreeNodeImpl debuggerTreeNodeImpl2 = (DebuggerTreeNodeImpl)debuggerTreeNodeImpl.getChildAt(i2);
            debuggerTreeNodeImpl2.getDescriptor().updateRepresentation(null, debuggerTreeNodeImpl2::labelChanged);
            ThreadsPanel.a(debuggerTreeNodeImpl2);
        }
    }

    @Override
    protected DebuggerTree createTreeView() {
        return new ThreadsDebuggerTree(this.getProject());
    }

    @Override
    protected ActionPopupMenu createPopupMenu() {
        DefaultActionGroup defaultActionGroup = (DefaultActionGroup)ActionManager.getInstance().getAction("Debugger.ThreadsPanelPopup");
        return ActionManager.getInstance().createActionPopupMenu("Debugger.ThreadsPanelPopup", (ActionGroup)defaultActionGroup);
    }

    @Override
    public Object getData(String string) {
        if (PlatformDataKeys.HELP_ID.is(string)) {
            return g;
        }
        return super.getData(string);
    }

    public ThreadsDebuggerTree getThreadsTree() {
        return (ThreadsDebuggerTree)this.getTree();
    }
}

