/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.JavaValueModifier;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.LocalVariablesUtil;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XValueModifier;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

public class ArgumentValueDescriptorImpl
extends ValueDescriptorImpl {
    private final DecompiledLocalVariable p;

    public ArgumentValueDescriptorImpl(Project project2, DecompiledLocalVariable decompiledLocalVariable, Value value) {
        super(project2, value);
        this.p = decompiledLocalVariable;
        this.setLvalue(true);
    }

    @Override
    public boolean canSetValue() {
        return LocalVariablesUtil.canSetValues();
    }

    @Override
    public boolean isPrimitive() {
        return this.getValue() instanceof PrimitiveValue;
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        return this.getValue();
    }

    public DecompiledLocalVariable getVariable() {
        return this.p;
    }

    @Override
    public String getName() {
        return this.p.getDisplayName();
    }

    public boolean isParameter() {
        return this.p.isParam();
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext debuggerContext) throws EvaluateException {
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
        try {
            return psiElementFactory.createExpressionFromText(this.getName(), PositionUtil.getContextElement((StackFrameContext)debuggerContext));
        }
        catch (IncorrectOperationException incorrectOperationException) {
            throw new EvaluateException(DebuggerBundle.message((String)"error.invalid.local.variable.name", (Object[])new Object[]{this.getName()}), (Throwable)incorrectOperationException);
        }
    }

    @Override
    public XValueModifier getModifier(JavaValue javaValue) {
        return new JavaValueModifier(javaValue){

            @Override
            protected void setValueImpl(@NotNull XExpression xExpression, @NotNull XValueModifier.XModificationCallback xModificationCallback) {
                DecompiledLocalVariable decompiledLocalVariable;
                if (xExpression == null) {
                    1.b(0);
                }
                if (xModificationCallback == null) {
                    1.b(1);
                }
                if ((decompiledLocalVariable = ArgumentValueDescriptorImpl.this.getVariable()) != null) {
                    final DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(ArgumentValueDescriptorImpl.this.getProject()).getContext();
                    this.set(xExpression, xModificationCallback, debuggerContextImpl, new JavaValueModifier.SetValueRunnable(){

                        @Override
                        public void setValue(EvaluationContextImpl evaluationContextImpl, Value value) throws ClassNotLoadedException, InvalidTypeException, EvaluateException {
                            LocalVariablesUtil.setValue(debuggerContextImpl.getFrameProxy().getStackFrame(), decompiledLocalVariable.getSlot(), value);
                            1.update(debuggerContextImpl);
                        }

                        @Override
                        public ReferenceType loadClass(EvaluationContextImpl evaluationContextImpl, String string) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, EvaluateException {
                            return evaluationContextImpl.getDebugProcess().loadClass(evaluationContextImpl, string, evaluationContextImpl.getClassLoader());
                        }
                    });
                }
            }

            private static /* synthetic */ void b(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callback";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/ui/impl/watch/ArgumentValueDescriptorImpl$1";
                objectArray[2] = "setValueImpl";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }
}

