/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.JavaValueModifier;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.ArrayElementDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XValueModifier;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

public class ArrayElementDescriptorImpl
extends ValueDescriptorImpl
implements ArrayElementDescriptor {
    private final int q;
    private final ArrayReference p;

    public ArrayElementDescriptorImpl(Project project2, ArrayReference arrayReference, int n2) {
        super(project2);
        this.p = arrayReference;
        this.q = n2;
        this.setLvalue(true);
    }

    @Override
    public int getIndex() {
        return this.q;
    }

    @Override
    public ArrayReference getArray() {
        return this.p;
    }

    @Override
    public String getName() {
        return String.valueOf(this.q);
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        return ArrayElementDescriptorImpl.getArrayElement(this.p, this.q);
    }

    public static Value getArrayElement(ArrayReference arrayReference, int n2) throws EvaluateException {
        try {
            return arrayReference.getValue(n2);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw EvaluateExceptionUtil.ARRAY_WAS_COLLECTED;
        }
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext debuggerContext) throws EvaluateException {
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
        try {
            return psiElementFactory.createExpressionFromText("this[" + this.q + "]", null);
        }
        catch (IncorrectOperationException incorrectOperationException) {
            throw new EvaluateException(incorrectOperationException.getMessage(), (Throwable)incorrectOperationException);
        }
    }

    @Override
    public XValueModifier getModifier(JavaValue javaValue) {
        return new JavaValueModifier(javaValue){

            @Override
            protected void setValueImpl(@NotNull XExpression xExpression, @NotNull XValueModifier.XModificationCallback xModificationCallback) {
                ArrayElementDescriptorImpl arrayElementDescriptorImpl;
                ArrayReference arrayReference;
                if (xExpression == null) {
                    1.b(0);
                }
                if (xModificationCallback == null) {
                    1.b(1);
                }
                if ((arrayReference = (arrayElementDescriptorImpl = ArrayElementDescriptorImpl.this).getArray()) != null) {
                    if (VirtualMachineProxyImpl.isCollected(arrayReference)) {
                        Messages.showWarningDialog((Project)ArrayElementDescriptorImpl.this.getProject(), (String)(DebuggerBundle.message((String)"evaluation.error.array.collected", (Object[])new Object[0]) + "\n" + DebuggerBundle.message((String)"warning.recalculate", (Object[])new Object[0])), (String)DebuggerBundle.message((String)"title.set.value", (Object[])new Object[0]));
                        return;
                    }
                    final ArrayType arrayType = (ArrayType)arrayReference.referenceType();
                    final DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(ArrayElementDescriptorImpl.this.getProject()).getContext();
                    this.set(xExpression, xModificationCallback, debuggerContextImpl, new JavaValueModifier.SetValueRunnable(){

                        @Override
                        public void setValue(EvaluationContextImpl evaluationContextImpl, Value value) throws ClassNotLoadedException, InvalidTypeException, EvaluateException {
                            arrayReference.setValue(arrayElementDescriptorImpl.getIndex(), 1.preprocessValue(evaluationContextImpl, value, arrayType.componentType()));
                            1.update(debuggerContextImpl);
                        }

                        @Override
                        public ReferenceType loadClass(EvaluationContextImpl evaluationContextImpl, String string) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, EvaluateException {
                            return evaluationContextImpl.getDebugProcess().loadClass(evaluationContextImpl, string, arrayType.classLoader());
                        }
                    });
                }
            }

            private static /* synthetic */ void b(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callback";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/ui/impl/watch/ArrayElementDescriptorImpl$1";
                objectArray[2] = "setValueImpl";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }
}

