/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.JavaValueModifier;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.ViewsGeneralSettings;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XValueModifier;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldDescriptorImpl
extends ValueDescriptorImpl
implements FieldDescriptor {
    public static final String OUTER_LOCAL_VAR_FIELD_PREFIX = "val$";
    private final Field p;
    private final ObjectReference r;
    private Boolean q;
    private final boolean s;

    public FieldDescriptorImpl(Project project2, ObjectReference objectReference, @NotNull Field field) {
        if (field == null) {
            FieldDescriptorImpl.b(0);
        }
        super(project2);
        this.q = null;
        this.r = objectReference;
        this.p = field;
        this.s = field.isStatic();
        this.setLvalue(!field.isFinal());
    }

    @Override
    public Field getField() {
        return this.p;
    }

    @Override
    public ObjectReference getObject() {
        return this.r;
    }

    @Override
    public void setAncestor(NodeDescriptor nodeDescriptor) {
        super.setAncestor(nodeDescriptor);
        Boolean bl2 = ((FieldDescriptorImpl)nodeDescriptor).q;
        if (bl2 != null) {
            this.q = bl2;
        }
    }

    @Override
    public boolean isPrimitive() {
        if (this.q == null) {
            Value value = this.getValue();
            this.q = value != null ? Boolean.valueOf(super.isPrimitive()) : Boolean.valueOf(DebuggerUtils.isPrimitiveType((String)this.p.typeName()));
        }
        return this.q;
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            if (this.r != null) {
                Value value = this.r.getValue(this.p);
                if (this.a(value, evaluationContextImpl)) {
                    value = this.r.getValue(this.p);
                }
                return value;
            }
            return this.p.declaringType().getValue(this.p);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw EvaluateExceptionUtil.OBJECT_WAS_COLLECTED;
        }
    }

    private boolean a(Value value, EvaluationContextImpl evaluationContextImpl) {
        if ("stackTrace".equals(this.getName()) && ViewsGeneralSettings.getInstance().POPULATE_THROWABLE_STACKTRACE && value instanceof ArrayReference && ((ArrayReference)value).length() == 0 && DebuggerUtils.instanceOf((Type)this.r.type(), (String)"java.lang.Throwable")) {
            try {
                FieldDescriptorImpl.invokeExceptionGetStackTrace(this.r, evaluationContextImpl);
                return true;
            }
            catch (Throwable throwable) {
                LOG.info(throwable);
            }
        }
        return false;
    }

    public boolean isStatic() {
        return this.s;
    }

    @Override
    public String getName() {
        return this.p.name();
    }

    @Override
    public String calcValueName() {
        String string = super.calcValueName();
        if (Boolean.TRUE.equals(this.getUserData(SHOW_DECLARING_TYPE))) {
            return NodeRendererSettings.getInstance().getClassRenderer().renderTypeName(this.p.declaringType().name()) + "." + string;
        }
        return string;
    }

    public boolean isOuterLocalVariableValue() {
        try {
            return DebuggerUtils.isSynthetic((TypeComponent)this.p) && this.p.name().startsWith(OUTER_LOCAL_VAR_FIELD_PREFIX);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return false;
        }
    }

    @Override
    @Nullable
    public String getDeclaredType() {
        return this.p.typeName();
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext debuggerContext) throws EvaluateException {
        String string;
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
        if (this.isStatic()) {
            String string2 = this.p.declaringType().name().replace('$', '.');
            string2 = DebuggerTreeNodeExpression.normalize(string2, PositionUtil.getContextElement((StackFrameContext)debuggerContext), this.myProject);
            string = string2 + "." + this.getName();
        } else {
            string = this.isOuterLocalVariableValue() ? StringUtil.trimStart((String)this.getName(), (String)OUTER_LOCAL_VAR_FIELD_PREFIX) : "this." + this.getName();
        }
        try {
            return psiElementFactory.createExpressionFromText(string, null);
        }
        catch (IncorrectOperationException incorrectOperationException) {
            throw new EvaluateException(DebuggerBundle.message((String)"error.invalid.field.name", (Object[])new Object[]{this.getName()}), (Throwable)incorrectOperationException);
        }
    }

    @Override
    public XValueModifier getModifier(JavaValue javaValue) {
        return new JavaValueModifier(javaValue){

            @Override
            protected void setValueImpl(@NotNull XExpression xExpression, @NotNull XValueModifier.XModificationCallback xModificationCallback) {
                if (xExpression == null) {
                    1.b(0);
                }
                if (xModificationCallback == null) {
                    1.b(1);
                }
                final DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(FieldDescriptorImpl.this.getProject()).getContext();
                FieldDescriptorImpl fieldDescriptorImpl = FieldDescriptorImpl.this;
                final Field field = fieldDescriptorImpl.getField();
                if (!field.isStatic()) {
                    final ObjectReference objectReference = fieldDescriptorImpl.getObject();
                    if (objectReference != null) {
                        this.set(xExpression, xModificationCallback, debuggerContextImpl, new JavaValueModifier.SetValueRunnable(){

                            @Override
                            public void setValue(EvaluationContextImpl evaluationContextImpl, Value value) throws ClassNotLoadedException, InvalidTypeException, EvaluateException {
                                objectReference.setValue(field, 1.preprocessValue(evaluationContextImpl, value, field.type()));
                                1.update(debuggerContextImpl);
                            }

                            @Override
                            public ReferenceType loadClass(EvaluationContextImpl evaluationContextImpl, String string) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, EvaluateException {
                                return evaluationContextImpl.getDebugProcess().loadClass(evaluationContextImpl, string, field.declaringType().classLoader());
                            }
                        });
                    }
                } else {
                    ReferenceType referenceType = field.declaringType();
                    if (referenceType instanceof ClassType) {
                        final ClassType classType = (ClassType)referenceType;
                        this.set(xExpression, xModificationCallback, debuggerContextImpl, new JavaValueModifier.SetValueRunnable(){

                            @Override
                            public void setValue(EvaluationContextImpl evaluationContextImpl, Value value) throws ClassNotLoadedException, InvalidTypeException, EvaluateException {
                                classType.setValue(field, 1.preprocessValue(evaluationContextImpl, value, field.type()));
                                1.update(debuggerContextImpl);
                            }

                            @Override
                            public ReferenceType loadClass(EvaluationContextImpl evaluationContextImpl, String string) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, EvaluateException {
                                return evaluationContextImpl.getDebugProcess().loadClass(evaluationContextImpl, string, field.declaringType().classLoader());
                            }
                        });
                    }
                }
            }

            private static /* synthetic */ void b(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callback";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/ui/impl/watch/FieldDescriptorImpl$1";
                objectArray[2] = "setValueImpl";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void b(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/debugger/ui/impl/watch/FieldDescriptorImpl", "<init>"));
    }
}

