/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.codeInspection.SmartHashMap;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.InconsistentDebugInfoException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.VMDisconnectedException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class NodeDescriptorImpl
implements NodeDescriptor {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl");
    public static final String UNKNOWN_VALUE_MESSAGE = "";
    public boolean myIsExpanded = false;
    public boolean myIsSelected = false;
    public boolean myIsVisible = false;
    public boolean myIsSynthetic = false;
    private EvaluateException a;
    private String b = "";
    private Map<Key, Object> c;
    private static final Key<Map<ObjectReference, ValueMarkup>> d = new Key("ValueMarkupMap");

    public String getName() {
        return null;
    }

    public <T> T getUserData(Key<T> key) {
        if (this.c == null) {
            return null;
        }
        return (T)this.c.get(key);
    }

    public <T> void putUserData(Key<T> key, T t2) {
        if (this.c == null) {
            this.c = new SmartHashMap();
        }
        this.c.put(key, t2);
    }

    public void updateRepresentation(EvaluationContextImpl evaluationContextImpl, DescriptorLabelListener descriptorLabelListener) {
        this.updateRepresentationNoNotify(evaluationContextImpl, descriptorLabelListener);
        descriptorLabelListener.labelChanged();
    }

    protected void updateRepresentationNoNotify(EvaluationContextImpl evaluationContextImpl, DescriptorLabelListener descriptorLabelListener) {
        try {
            try {
                this.a = null;
                this.b = this.calcRepresentation(evaluationContextImpl, descriptorLabelListener);
            }
            catch (InconsistentDebugInfoException inconsistentDebugInfoException) {
                throw new EvaluateException(DebuggerBundle.message((String)"error.inconsistent.debug.info", (Object[])new Object[0]));
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throw new EvaluateException(DebuggerBundle.message((String)"error.invalid.stackframe", (Object[])new Object[0]));
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                throw vMDisconnectedException;
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException.getCause() instanceof InterruptedException) {
                    throw runtimeException;
                }
                LOG.error((Throwable)runtimeException);
                throw new EvaluateException("Internal error, see logs for more details");
            }
        }
        catch (EvaluateException evaluateException) {
            this.setFailed(evaluateException);
        }
    }

    protected abstract String calcRepresentation(EvaluationContextImpl var1, DescriptorLabelListener var2) throws EvaluateException;

    public void displayAs(NodeDescriptor nodeDescriptor) {
        if (nodeDescriptor instanceof NodeDescriptorImpl) {
            NodeDescriptorImpl nodeDescriptorImpl = (NodeDescriptorImpl)nodeDescriptor;
            this.myIsExpanded = nodeDescriptorImpl.myIsExpanded;
            this.myIsSelected = nodeDescriptorImpl.myIsSelected;
            this.myIsVisible = nodeDescriptorImpl.myIsVisible;
            HashMap<Key, Object> hashMap = this.c = nodeDescriptorImpl.c != null ? new HashMap<Key, Object>(nodeDescriptorImpl.c) : null;
            if (this.c != null) {
                this.c.remove(OnDemandRenderer.ON_DEMAND_CALCULATED);
            }
        }
    }

    public abstract boolean isExpandable();

    public abstract void setContext(EvaluationContextImpl var1);

    public EvaluateException getEvaluateException() {
        return this.a;
    }

    public String getLabel() {
        return this.b;
    }

    public String toString() {
        return this.getLabel();
    }

    protected String setFailed(EvaluateException evaluateException) {
        this.a = evaluateException;
        return evaluateException.getMessage();
    }

    protected String setLabel(String string) {
        this.b = string;
        return this.b;
    }

    public void clear() {
        this.a = null;
        this.b = UNKNOWN_VALUE_MESSAGE;
    }

    public void setAncestor(NodeDescriptor nodeDescriptor) {
        this.displayAs(nodeDescriptor);
    }

    @Nullable
    public static Map<ObjectReference, ValueMarkup> getMarkupMap(DebugProcess debugProcess) {
        if (debugProcess == null) {
            return null;
        }
        HashMap hashMap = (HashMap)debugProcess.getUserData(d);
        if (hashMap == null) {
            hashMap = new HashMap();
            debugProcess.putUserData(d, hashMap);
        }
        return hashMap;
    }
}

