/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.StaticDescriptor;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;

public class StaticDescriptorImpl
extends NodeDescriptorImpl
implements StaticDescriptor {
    private final ReferenceType e;
    private final boolean f;

    public StaticDescriptorImpl(ReferenceType referenceType) {
        this.e = referenceType;
        this.f = this.e.allFields().stream().anyMatch(TypeComponent::isStatic);
    }

    @Override
    public ReferenceType getType() {
        return this.e;
    }

    @Override
    public String getName() {
        return "static";
    }

    @Override
    public boolean isExpandable() {
        return this.f;
    }

    @Override
    public void setContext(EvaluationContextImpl evaluationContextImpl) {
    }

    @Override
    protected String calcRepresentation(EvaluationContextImpl evaluationContextImpl, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
        return this.getName() + " = " + classRenderer.renderTypeName(this.e.name());
    }
}

