/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.overhead;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.overhead.OverheadProducer;
import com.intellij.debugger.ui.overhead.OverheadTimings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Function;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SortOrder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverheadView
extends BorderLayoutPanel
implements Disposable,
DataProvider {
    @NotNull
    private final DebugProcessImpl a;
    static final EnabledColumnInfo ENABLED_COLUMN = new EnabledColumnInfo();
    static final NameColumnInfo NAME_COLUMN = new NameColumnInfo();
    private final TableView<OverheadProducer> e;
    private final ListTableModel<OverheadProducer> b;
    private final MergingUpdateQueue c;
    private Runnable d;

    public OverheadView(final @NotNull DebugProcessImpl debugProcessImpl) {
        if (debugProcessImpl == null) {
            OverheadView.a(0);
        }
        this.a = debugProcessImpl;
        this.b = new ListTableModel(new ColumnInfo[]{ENABLED_COLUMN, NAME_COLUMN, new TimingColumnInfo("Hits", overheadProducer -> OverheadTimings.getHits(this.a, overheadProducer)), new TimingColumnInfo("Time (ms)", overheadProducer -> OverheadTimings.getTime(this.a, overheadProducer))}, new ArrayList<OverheadProducer>(OverheadTimings.getProducers(debugProcessImpl)), 3, SortOrder.DESCENDING);
        this.b.setSortable(true);
        this.e = new TableView(this.b);
        this.addToCenter(ScrollPaneFactory.createScrollPane(this.e));
        TableUtil.setupCheckboxColumn((TableColumn)this.e.getColumnModel().getColumn(0));
        this.c = new MergingUpdateQueue("OverheadView", 500, true, null, (Disposable)this);
        this.c.setPassThrough(false);
        OverheadTimings.addListener(new OverheadTimings.OverheadTimingsListener(){

            @Override
            public void timingAdded(final OverheadProducer overheadProducer) {
                OverheadView.this.c.queue(new Update(overheadProducer){

                    public void run() {
                        int n2 = OverheadView.this.b.indexOf((Object)overheadProducer);
                        if (n2 != -1) {
                            OverheadView.this.b.fireTableRowsUpdated(n2, n2);
                            return;
                        }
                        OverheadView.this.b.setItems(new ArrayList<OverheadProducer>(OverheadTimings.getProducers(debugProcessImpl)));
                    }
                });
            }

            @Override
            public void excessiveOverheadDetected() {
                if (OverheadView.this.d != null) {
                    DebuggerUIUtil.invokeLater((Runnable)OverheadView.this.d);
                }
            }
        }, debugProcessImpl);
        new DumbAwareAction("Toggle"){

            public void update(@NotNull AnActionEvent anActionEvent) {
                if (anActionEvent == null) {
                    2.a(0);
                }
                anActionEvent.getPresentation().setEnabled(OverheadView.this.e.getSelectedRowCount() == 1);
            }

            public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
                if (anActionEvent == null) {
                    2.a(1);
                }
                OverheadView.this.e.getSelection().forEach(overheadProducer -> overheadProducer.setEnabled(!overheadProducer.isEnabled()));
                OverheadView.this.e.repaint();
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/debugger/ui/overhead/OverheadView$2";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(32, 0)), this.e);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent mouseEvent) {
                OverheadView.this.a().findFirst().ifPresent(navigatable -> navigatable.navigate(true));
                return true;
            }
        }.installOn(this.e);
    }

    private StreamEx<Navigatable> a() {
        return StreamEx.of((Collection)this.e.getSelection()).select(Breakpoint.class).map(Breakpoint::getXBreakpoint).nonNull().map(XBreakpoint::getNavigatable).nonNull();
    }

    @Nullable
    public Object getData(String string) {
        Navigatable[] navigatableArray;
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(string) && (navigatableArray = (Navigatable[])this.a().toArray(Navigatable.class)).length > 0) {
            return navigatableArray;
        }
        return null;
    }

    public void dispose() {
    }

    public void setBouncer(Runnable runnable) {
        this.d = runnable;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/debugger/ui/overhead/OverheadView", "<init>"));
    }

    private static class TimingColumnInfo
    extends ColumnInfo<OverheadProducer, OverheadProducer> {
        private final Function<OverheadProducer, Long> a;

        public TimingColumnInfo(@NotNull String string, Function<OverheadProducer, Long> function) {
            if (string == null) {
                TimingColumnInfo.a(0);
            }
            super(string);
            this.a = function;
        }

        @Nullable
        public OverheadProducer valueOf(OverheadProducer overheadProducer) {
            return overheadProducer;
        }

        public Class<?> getColumnClass() {
            return OverheadProducer.class;
        }

        @Nullable
        public TableCellRenderer getRenderer(OverheadProducer overheadProducer) {
            return new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(JTable jTable, @Nullable Object object, boolean bl2, boolean bl3, int n2, int n3) {
                    if (object instanceof OverheadProducer) {
                        OverheadProducer overheadProducer = (OverheadProducer)object;
                        Long l2 = (Long)a.apply(overheadProducer);
                        this.append(l2 != null ? String.valueOf(l2) : "", overheadProducer.isEnabled() ? SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                }
            };
        }

        @Nullable
        public Comparator<OverheadProducer> getComparator() {
            return Comparator.comparing(overheadProducer -> {
                Long l2 = this.a.apply((OverheadProducer)overheadProducer);
                return l2 != null ? l2 : Long.MAX_VALUE;
            });
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/debugger/ui/overhead/OverheadView$TimingColumnInfo", "<init>"));
        }
    }

    private static class NameColumnInfo
    extends ColumnInfo<OverheadProducer, OverheadProducer> {
        public NameColumnInfo() {
            super("Name");
        }

        @Nullable
        public OverheadProducer valueOf(OverheadProducer overheadProducer) {
            return overheadProducer;
        }

        public Class<?> getColumnClass() {
            return OverheadProducer.class;
        }

        @Nullable
        public TableCellRenderer getRenderer(OverheadProducer overheadProducer) {
            return new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(JTable jTable, @Nullable Object object, boolean bl2, boolean bl3, int n2, int n3) {
                    if (object instanceof OverheadProducer) {
                        OverheadProducer overheadProducer = (OverheadProducer)object;
                        if (!overheadProducer.isEnabled()) {
                            SimpleColoredComponent simpleColoredComponent = new SimpleColoredComponent();
                            overheadProducer.customizeRenderer(simpleColoredComponent);
                            simpleColoredComponent.iterator().forEachRemaining(string -> this.append((String)string, SimpleTextAttributes.GRAYED_ATTRIBUTES));
                            this.setIcon(simpleColoredComponent.getIcon());
                        } else {
                            overheadProducer.customizeRenderer((SimpleColoredComponent)this);
                        }
                    }
                    this.setTransparentIconBackground(true);
                }
            };
        }
    }

    private static class EnabledColumnInfo
    extends ColumnInfo<OverheadProducer, Boolean> {
        public EnabledColumnInfo() {
            super("");
        }

        public Class<?> getColumnClass() {
            return Boolean.class;
        }

        @Nullable
        public Boolean valueOf(OverheadProducer overheadProducer) {
            return overheadProducer.isEnabled();
        }

        public boolean isCellEditable(OverheadProducer overheadProducer) {
            return true;
        }

        public void setValue(OverheadProducer overheadProducer, Boolean bl2) {
            overheadProducer.setEnabled(bl2);
        }
    }
}

