/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.intellij.debugger.engine.managerThread.DebuggerCommand;
import com.intellij.debugger.engine.managerThread.SuspendContextCommand;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.ui.tree.render.ToStringCommand;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.rt.debugger.BatchEvaluatorServer;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import one.util.streamex.StreamEx;

public class BatchEvaluator {
    private static final Logger f = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.BatchEvaluator");
    private final DebugProcess c;
    private boolean a;
    private ObjectReference e;
    private Method d;
    private static final Key<BatchEvaluator> b = new Key("BatchEvaluator");
    public static final Key<Boolean> REMOTE_SESSION_KEY = new Key("is_remote_session_key");
    private final HashMap<SuspendContext, List<ToStringCommand>> g = new HashMap();

    private BatchEvaluator(DebugProcess debugProcess) {
        this.c = debugProcess;
        this.c.addDebugProcessListener(new DebugProcessListener(){

            public void processDetached(DebugProcess debugProcess, boolean bl2) {
                BatchEvaluator.this.a = false;
                BatchEvaluator.this.e = null;
                BatchEvaluator.this.d = null;
            }
        });
    }

    public boolean hasBatchEvaluator(EvaluationContext evaluationContext) {
        if (!this.a) {
            Method method;
            this.a = true;
            if (DebuggerUtilsImpl.isRemote(this.c)) {
                return false;
            }
            ThreadReferenceProxy threadReferenceProxy = evaluationContext.getSuspendContext().getThread();
            if (threadReferenceProxy == null) {
                return false;
            }
            ThreadReference threadReference = threadReferenceProxy.getThreadReference();
            if (threadReference == null) {
                return false;
            }
            ClassType classType = null;
            try {
                classType = (ClassType)this.c.findClass(evaluationContext, BatchEvaluatorServer.class.getName(), evaluationContext.getClassLoader());
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
            if (classType != null && (method = classType.concreteMethodByName("<init>", "()V")) != null) {
                ObjectReference objectReference = null;
                try {
                    objectReference = this.c.newInstance(evaluationContext, classType, method, Collections.emptyList());
                }
                catch (Exception exception) {
                    f.debug((Throwable)exception);
                }
                this.e = objectReference;
                if (this.e != null) {
                    this.d = classType.concreteMethodByName("evaluate", "([Ljava/lang/Object;)[Ljava/lang/Object;");
                }
            }
        }
        return this.d != null;
    }

    public void invoke(ToStringCommand toStringCommand) {
        f.assertTrue(DebuggerManager.getInstance((Project)this.c.getProject()).isDebuggerManagerThread());
        final EvaluationContext evaluationContext = toStringCommand.getEvaluationContext();
        final SuspendContext suspendContext = evaluationContext.getSuspendContext();
        if (!Registry.is((String)"debugger.batch.evaluation") || !this.hasBatchEvaluator(evaluationContext)) {
            this.c.getManagerThread().invokeCommand((DebuggerCommand)toStringCommand);
        } else {
            List<ToStringCommand> list2 = this.g.get(suspendContext);
            if (list2 == null) {
                final ArrayList<ToStringCommand> arrayList = new ArrayList<ToStringCommand>();
                list2 = arrayList;
                this.g.put(suspendContext, arrayList);
                this.c.getManagerThread().invokeCommand((DebuggerCommand)new SuspendContextCommand(){

                    public SuspendContext getSuspendContext() {
                        return suspendContext;
                    }

                    public void action() {
                        BatchEvaluator.this.g.remove(suspendContext);
                        if (!BatchEvaluator.this.a(arrayList, evaluationContext)) {
                            arrayList.forEach(ToStringCommand::action);
                        }
                    }

                    public void commandCancelled() {
                        BatchEvaluator.this.g.remove(suspendContext);
                    }
                });
            }
            list2.add(toStringCommand);
        }
    }

    public static BatchEvaluator getBatchEvaluator(DebugProcess debugProcess) {
        BatchEvaluator batchEvaluator = (BatchEvaluator)debugProcess.getUserData(b);
        if (batchEvaluator == null) {
            batchEvaluator = new BatchEvaluator(debugProcess);
            debugProcess.putUserData(b, (Object)batchEvaluator);
        }
        return batchEvaluator;
    }

    private boolean a(List<ToStringCommand> list2, EvaluationContext evaluationContext) {
        try {
            DebugProcess debugProcess = evaluationContext.getDebugProcess();
            List list3 = StreamEx.of(list2).map(ToStringCommand::getValue).toList();
            ArrayType arrayType = (ArrayType)debugProcess.findClass(evaluationContext, "java.lang.Object[]", evaluationContext.getClassLoader());
            if (arrayType == null) {
                return false;
            }
            ArrayReference arrayReference = debugProcess.newInstance(arrayType, list3.size());
            ((SuspendContextImpl)evaluationContext.getSuspendContext()).keep(arrayReference);
            arrayReference.setValues(list3);
            ArrayList<ArrayReference> arrayList = new ArrayList<ArrayReference>(1);
            arrayList.add(arrayReference);
            Value value = debugProcess.invokeMethod(evaluationContext, this.e, this.d, arrayList);
            if (value instanceof ArrayReference) {
                ((SuspendContextImpl)evaluationContext.getSuspendContext()).keep((ArrayReference)value);
                ArrayReference arrayReference2 = (ArrayReference)value;
                List<Value> list4 = arrayReference2.getValues();
                Value[] valueArray = list4.toArray(new Value[0]);
                int n2 = 0;
                for (ToStringCommand toStringCommand : list2) {
                    Value value2 = valueArray[n2];
                    if (value2 == null || value2 instanceof StringReference) {
                        try {
                            String string = value2 == null ? null : ((StringReference)value2).value();
                            toStringCommand.evaluationResult(string);
                        }
                        catch (ObjectCollectedException objectCollectedException) {}
                    } else if (value2 instanceof ObjectReference) {
                        toStringCommand.evaluationError(EvaluateExceptionUtil.createEvaluateException((Throwable)new InvocationException((ObjectReference)value2)).getMessage());
                    } else {
                        f.assertTrue(false);
                    }
                    toStringCommand.setEvaluated();
                    ++n2;
                }
            }
            return true;
        }
        catch (EvaluateException | ClassNotLoadedException | InvalidTypeException | ObjectCollectedException throwable) {
            return false;
        }
    }
}

