/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnsupportedExpressionException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.ui.impl.watch.CompilingEvaluatorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiType;
import com.intellij.reference.SoftReference;
import org.jetbrains.annotations.Nullable;

public abstract class CachedEvaluator {
    SoftReference<Cache> myCache = new SoftReference(null);
    private TextWithImports a;

    protected abstract String getClassName();

    public TextWithImports getReferenceExpression() {
        return this.a != null ? this.a : DebuggerUtils.getInstance().createExpressionWithImports("");
    }

    public void setReferenceExpression(TextWithImports textWithImports) {
        this.a = textWithImports;
        this.clear();
    }

    public void clear() {
        this.myCache.clear();
    }

    protected Cache initEvaluatorAndChildrenExpression(Project project2) {
        Cache cache;
        block6: {
            cache = new Cache();
            try {
                String string = this.getClassName();
                Pair<PsiElement, PsiType> pair2 = DebuggerUtilsImpl.getPsiClassAndType(string, project2);
                PsiElement psiElement2 = (PsiElement)pair2.first;
                if (psiElement2 == null) {
                    throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.find.source", (Object[])new Object[]{string}));
                }
                CodeFragmentFactory codeFragmentFactory = DebuggerUtilsEx.findAppropriateCodeFragmentFactory(this.a, psiElement2);
                JavaCodeFragment javaCodeFragment = codeFragmentFactory.createCodeFragment(this.a, this.overrideContext(psiElement2), project2);
                javaCodeFragment.setThisType((PsiType)pair2.second);
                DebuggerUtils.checkSyntax((PsiCodeFragment)javaCodeFragment);
                cache.myPsiChildrenExpression = javaCodeFragment instanceof PsiExpressionCodeFragment ? ((PsiExpressionCodeFragment)javaCodeFragment).getExpression() : null;
                try {
                    cache.myEvaluator = codeFragmentFactory.getEvaluatorBuilder().build((PsiElement)javaCodeFragment, null);
                }
                catch (UnsupportedExpressionException unsupportedExpressionException) {
                    ExpressionEvaluator expressionEvaluator = CompilingEvaluatorImpl.create(project2, psiElement2, psiElement -> javaCodeFragment);
                    if (expressionEvaluator != null) {
                        cache.myEvaluator = expressionEvaluator;
                        break block6;
                    }
                    throw unsupportedExpressionException;
                }
            }
            catch (EvaluateException evaluateException) {
                cache.myException = evaluateException;
            }
        }
        this.myCache = new SoftReference((Object)cache);
        return cache;
    }

    protected PsiElement overrideContext(PsiElement psiElement) {
        return psiElement;
    }

    protected ExpressionEvaluator getEvaluator(Project project2) throws EvaluateException {
        Cache cache = (Cache)this.myCache.get();
        if (cache == null) {
            cache = (Cache)PsiDocumentManager.getInstance((Project)project2).commitAndRunReadAction(() -> this.initEvaluatorAndChildrenExpression(project2));
        }
        if (cache.myException != null) {
            throw cache.myException;
        }
        return cache.myEvaluator;
    }

    @Nullable
    protected PsiExpression getPsiExpression(Project project2) {
        Cache cache = (Cache)this.myCache.get();
        if (cache == null) {
            cache = this.initEvaluatorAndChildrenExpression(project2);
        }
        return cache.myPsiChildrenExpression;
    }

    private static class Cache {
        protected ExpressionEvaluator myEvaluator;
        protected EvaluateException myException;
        protected PsiExpression myPsiChildrenExpression;

        private Cache() {
        }
    }
}

