/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.NodeManager;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassRenderer
extends NodeRendererImpl {
    private static final Logger b = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.ClassRenderer");
    @NonNls
    public static final String UNIQUE_ID = "ClassRenderer";
    public boolean SHOW_SYNTHETICS = true;
    public boolean SHOW_VAL_FIELDS_AS_LOCAL_VARIABLES = true;
    public boolean SHOW_STATIC = false;
    public boolean SHOW_STATIC_FINAL = false;
    public boolean SHOW_FQ_TYPE_NAMES = false;
    public boolean SHOW_DECLARED_TYPE = false;
    public boolean SHOW_OBJECT_ID = true;
    public boolean SHOW_STRINGS_TYPE = false;

    public ClassRenderer() {
        this.myProperties.setEnabled(true);
    }

    @Nullable
    public final String renderTypeName(@Nullable String string) {
        if (this.SHOW_FQ_TYPE_NAMES || string == null) {
            return string;
        }
        String string2 = DebuggerUtilsEx.getLambdaBaseClassName(string);
        if (string2 != null) {
            return this.renderTypeName(string2) + "$lambda";
        }
        int n2 = string.lastIndexOf(46);
        if (n2 > 0) {
            return string.substring(n2 + 1);
        }
        return string;
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public ClassRenderer clone() {
        return (ClassRenderer)super.clone();
    }

    @Override
    public String calcLabel(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
        return ClassRenderer.calcLabel(valueDescriptor);
    }

    protected static String calcLabel(ValueDescriptor valueDescriptor) {
        ValueDescriptorImpl valueDescriptorImpl = (ValueDescriptorImpl)valueDescriptor;
        Value value = valueDescriptorImpl.getValue();
        if (value instanceof ObjectReference) {
            if (value instanceof StringReference) {
                return ((StringReference)value).value();
            }
            if (value instanceof ClassObjectReference) {
                ReferenceType referenceType = ((ClassObjectReference)value).reflectedType();
                return referenceType != null ? referenceType.name() : "{...}";
            }
            ObjectReference objectReference = (ObjectReference)value;
            Type type = objectReference.type();
            if (type instanceof ClassType && ((ClassType)type).isEnum()) {
                String string = ClassRenderer.getEnumConstantName(objectReference, (ClassType)type);
                if (string != null) {
                    return string;
                }
                return type.name();
            }
            return "";
        }
        if (value == null) {
            return "null";
        }
        return DebuggerBundle.message((String)"label.undefined", (Object[])new Object[0]);
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder childrenBuilder, EvaluationContext evaluationContext) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ValueDescriptorImpl valueDescriptorImpl = (ValueDescriptorImpl)childrenBuilder.getParentDescriptor();
        NodeManager nodeManager = childrenBuilder.getNodeManager();
        NodeDescriptorFactory nodeDescriptorFactory = childrenBuilder.getDescriptorManager();
        ArrayList<DebuggerTreeNode> arrayList = new ArrayList<DebuggerTreeNode>();
        if (value instanceof ObjectReference) {
            ObjectReference objectReference = (ObjectReference)value;
            ReferenceType referenceType = objectReference.referenceType();
            List<Field> list2 = referenceType.allFields();
            if (!list2.isEmpty()) {
                HashSet<String> hashSet = new HashSet<String>();
                for (Field field : list2) {
                    if (!this.shouldDisplay(evaluationContext, objectReference, field)) continue;
                    FieldDescriptor fieldDescriptor = this.createFieldDescriptor(valueDescriptorImpl, nodeDescriptorFactory, objectReference, field, evaluationContext);
                    String string = fieldDescriptor.getName();
                    if (hashSet.contains(string)) {
                        fieldDescriptor.putUserData(FieldDescriptor.SHOW_DECLARING_TYPE, Boolean.TRUE);
                    } else {
                        hashSet.add(string);
                    }
                    arrayList.add(nodeManager.createNode(fieldDescriptor, evaluationContext));
                }
                if (arrayList.isEmpty()) {
                    arrayList.add(nodeManager.createMessageNode(DebuggerBundle.message((String)"message.node.class.no.fields.to.display", (Object[])new Object[0])));
                } else if (XDebuggerSettingsManager.getInstance().getDataViewSettings().isSortValues()) {
                    arrayList.sort(NodeManagerImpl.getNodeComparator());
                }
            } else {
                arrayList.add(nodeManager.createMessageNode(MessageDescriptor.CLASS_HAS_NO_FIELDS.getLabel()));
            }
        }
        childrenBuilder.setChildren(arrayList);
    }

    @NotNull
    protected FieldDescriptor createFieldDescriptor(ValueDescriptorImpl valueDescriptorImpl, NodeDescriptorFactory nodeDescriptorFactory, ObjectReference objectReference, Field field, EvaluationContext evaluationContext) {
        FieldDescriptor fieldDescriptor = nodeDescriptorFactory.getFieldDescriptor(valueDescriptorImpl, objectReference, field);
        if (fieldDescriptor == null) {
            ClassRenderer.b(0);
        }
        return fieldDescriptor;
    }

    protected boolean shouldDisplay(EvaluationContext evaluationContext, @NotNull ObjectReference objectReference, @NotNull Field field) {
        if (objectReference == null) {
            ClassRenderer.b(1);
        }
        if (field == null) {
            ClassRenderer.b(2);
        }
        boolean bl2 = DebuggerUtils.isSynthetic((TypeComponent)field);
        if (!this.SHOW_SYNTHETICS && bl2) {
            return false;
        }
        if (this.SHOW_VAL_FIELDS_AS_LOCAL_VARIABLES && bl2) {
            try {
                Location location;
                StackFrameProxy stackFrameProxy = evaluationContext.getFrameProxy();
                if (stackFrameProxy != null && (location = stackFrameProxy.location()) != null && objectReference.equals(evaluationContext.computeThisObject()) && Comparing.equal((Object)objectReference.referenceType(), (Object)location.declaringType()) && StringUtil.startsWith((CharSequence)field.name(), (CharSequence)"val$")) {
                    return false;
                }
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        if (!this.SHOW_STATIC && field.isStatic()) {
            return false;
        }
        return this.SHOW_STATIC_FINAL || !field.isStatic() || !field.isFinal();
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    @Override
    public PsiElement getChildValueExpression(DebuggerTreeNode debuggerTreeNode, DebuggerContext debuggerContext) throws EvaluateException {
        FieldDescriptor fieldDescriptor = (FieldDescriptor)debuggerTreeNode.getDescriptor();
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)debuggerTreeNode.getProject()).getElementFactory();
        try {
            return psiElementFactory.createExpressionFromText("this." + fieldDescriptor.getField().name(), (PsiElement)DebuggerUtils.findClass((String)fieldDescriptor.getObject().referenceType().name(), (Project)debuggerContext.getProject(), (GlobalSearchScope)debuggerContext.getDebugProcess().getSearchScope()));
        }
        catch (IncorrectOperationException incorrectOperationException) {
            throw new EvaluateException(DebuggerBundle.message((String)"error.invalid.field.name", (Object[])new Object[]{fieldDescriptor.getField().name()}), null);
        }
    }

    private static boolean a(Value value) {
        try {
            if (value instanceof ArrayReference) {
                return ((ArrayReference)value).length() > 0;
            }
            if (value instanceof ObjectReference) {
                return true;
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            return true;
        }
        return false;
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext evaluationContext, NodeDescriptor nodeDescriptor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return ClassRenderer.a(value);
    }

    @Override
    public boolean isApplicable(Type type) {
        return type instanceof ReferenceType && !(type instanceof ArrayType);
    }

    @Override
    @NonNls
    public String getName() {
        return "Object";
    }

    @Override
    public void setName(String string) {
        b.assertTrue(false);
    }

    @Nullable
    public static String getEnumConstantName(@NotNull ObjectReference objectReference, ClassType classType) {
        if (objectReference == null) {
            ClassRenderer.b(3);
        }
        do {
            if (!classType.isPrepared()) {
                return null;
            }
            if ((classType = classType.superclass()) != null) continue;
            return null;
        } while (!"java.lang.Enum".equals(classType.name()));
        Field field = classType.fieldByName("name");
        if (field == null) {
            return null;
        }
        Value value = objectReference.getValue(field);
        if (!(value instanceof StringReference)) {
            return null;
        }
        return ((StringReference)value).value();
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/tree/render/ClassRenderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objInstance";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objRef";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/tree/render/ClassRenderer";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldDisplay";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEnumConstantName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

