/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.HexRenderer;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.sun.jdi.CharValue;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VoidType;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class PrimitiveRenderer
extends NodeRendererImpl {
    @NonNls
    public static final String UNIQUE_ID = "PrimitiveRenderer";
    private static final Logger b = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.PrimitiveRenderer");
    public boolean SHOW_HEX_VALUE = false;

    public PrimitiveRenderer() {
        super("Primitive");
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public void setName(String string) {
    }

    @Override
    public final boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean bl2) {
    }

    @Override
    public boolean isApplicable(Type type) {
        return type == null || type instanceof PrimitiveType || type instanceof VoidType;
    }

    @Override
    public String calcLabel(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener descriptorLabelListener) {
        Value value = valueDescriptor.getValue();
        if (value == null) {
            return "null";
        }
        if (value instanceof PrimitiveValue) {
            if (value instanceof CharValue) {
                StringBuilder stringBuilder = new StringBuilder();
                PrimitiveRenderer.appendCharValue((CharValue)value, stringBuilder);
                if (this.SHOW_HEX_VALUE) {
                    PrimitiveRenderer.a((CharValue)value, stringBuilder);
                } else {
                    stringBuilder.append(' ').append(((PrimitiveValue)value).longValue());
                }
                return stringBuilder.toString();
            }
            if (this.SHOW_HEX_VALUE) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(value.toString());
                PrimitiveRenderer.a((PrimitiveValue)value, stringBuilder);
                return stringBuilder.toString();
            }
            return value.toString();
        }
        return DebuggerBundle.message((String)"label.undefined", (Object[])new Object[0]);
    }

    static void appendCharValue(CharValue charValue, StringBuilder stringBuilder) {
        stringBuilder.append('\'');
        String string = charValue.toString();
        StringUtil.escapeStringCharacters((int)string.length(), (String)string, (String)"'", (StringBuilder)stringBuilder);
        stringBuilder.append('\'');
    }

    private static void a(PrimitiveValue primitiveValue, StringBuilder stringBuilder) {
        if (NodeRendererSettings.getInstance().getHexRenderer().isApplicable(primitiveValue.type())) {
            stringBuilder.append(" (");
            HexRenderer.appendHexValue(primitiveValue, stringBuilder);
            stringBuilder.append(')');
        }
    }

    public boolean isShowHexValue() {
        return this.SHOW_HEX_VALUE;
    }

    public void setShowHexValue(boolean bl2) {
        this.SHOW_HEX_VALUE = bl2;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }
}

