/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.BatchEvaluator;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.debugger.ui.tree.render.ToStringCommand;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ToStringRenderer
extends NodeRendererImpl
implements OnDemandRenderer {
    @NonNls
    public static final String UNIQUE_ID = "ToStringRenderer";
    private boolean b = false;
    private boolean c;
    private ClassFilter[] d = ClassFilter.EMPTY_ARRAY;

    public ToStringRenderer() {
        super("unnamed", true);
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public String getName() {
        return "toString";
    }

    @Override
    public void setName(String string) {
    }

    @Override
    public ToStringRenderer clone() {
        ToStringRenderer toStringRenderer = (ToStringRenderer)super.clone();
        ClassFilter[] classFilterArray = this.d.length > 0 ? new ClassFilter[this.d.length] : ClassFilter.EMPTY_ARRAY;
        for (int i2 = 0; i2 < classFilterArray.length; ++i2) {
            classFilterArray[i2] = this.d[i2].clone();
        }
        toStringRenderer.d = classFilterArray;
        return toStringRenderer;
    }

    @Override
    public String calcLabel(final ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, final DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
        if (!this.isShowValue(valueDescriptor, evaluationContext)) {
            return "";
        }
        final Value value = valueDescriptor.getValue();
        BatchEvaluator.getBatchEvaluator(evaluationContext.getDebugProcess()).invoke(new ToStringCommand(evaluationContext, value){

            @Override
            public void evaluationResult(String string) {
                valueDescriptor.setValueLabel(StringUtil.notNullize((String)string));
                descriptorLabelListener.labelChanged();
            }

            @Override
            public void evaluationError(String string) {
                String string2 = value != null ? string + " " + DebuggerBundle.message((String)"evaluation.error.cannot.evaluate.tostring", (Object[])new Object[]{value.type().name()}) : string;
                valueDescriptor.setValueLabelFailed(new EvaluateException(string2, null));
                descriptorLabelListener.labelChanged();
            }
        });
        return XDebuggerUIConstants.COLLECTING_DATA_MESSAGE;
    }

    @Override
    @NotNull
    public String getLinkText() {
        String string = DebuggerBundle.message((String)"message.node.toString", (Object[])new Object[0]);
        if (string == null) {
            ToStringRenderer.b(0);
        }
        return string;
    }

    public boolean isUseClassFilters() {
        return this.b;
    }

    public void setUseClassFilters(boolean bl2) {
        this.b = bl2;
    }

    @Override
    public boolean isOnDemand(EvaluationContext evaluationContext, ValueDescriptor valueDescriptor) {
        if (this.c || this.b && !this.b(valueDescriptor.getType())) {
            return true;
        }
        return OnDemandRenderer.super.isOnDemand(evaluationContext, valueDescriptor);
    }

    @Override
    public boolean isApplicable(Type type) {
        if (!(type instanceof ReferenceType)) {
            return false;
        }
        if ("java.lang.String".equals(type.name())) {
            return false;
        }
        return ToStringRenderer.a(type);
    }

    private static boolean a(Type type) {
        if (type instanceof ClassType) {
            Method method = ((ClassType)type).concreteMethodByName("toString", "()Ljava/lang/String;");
            return method != null && !"java.lang.Object".equals(method.declaringType().name());
        }
        return false;
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder childrenBuilder, EvaluationContext evaluationContext) {
        DebugProcessImpl.getDefaultRenderer(value).buildChildren(value, childrenBuilder, evaluationContext);
    }

    @Override
    public PsiElement getChildValueExpression(DebuggerTreeNode debuggerTreeNode, DebuggerContext debuggerContext) throws EvaluateException {
        return DebugProcessImpl.getDefaultRenderer(((ValueDescriptor)debuggerTreeNode.getParent().getDescriptor()).getType()).getChildValueExpression(debuggerTreeNode, debuggerContext);
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext evaluationContext, NodeDescriptor nodeDescriptor) {
        return DebugProcessImpl.getDefaultRenderer(value).isExpandable(value, evaluationContext, nodeDescriptor);
    }

    @Override
    public void readExternal(Element element) {
        super.readExternal(element);
        this.c = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)"ON_DEMAND"));
        this.b = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)"USE_CLASS_FILTERS"));
        this.d = DebuggerUtilsEx.readFilters(element.getChildren("filter"));
    }

    @Override
    public void writeExternal(Element element) {
        super.writeExternal(element);
        if (this.c) {
            JDOMExternalizerUtil.writeField((Element)element, (String)"ON_DEMAND", (String)"true");
        }
        if (this.b) {
            JDOMExternalizerUtil.writeField((Element)element, (String)"USE_CLASS_FILTERS", (String)"true");
        }
        DebuggerUtilsEx.writeFilters(element, "filter", this.d);
    }

    public ClassFilter[] getClassFilters() {
        return this.d;
    }

    public void setClassFilters(ClassFilter[] classFilterArray) {
        this.d = classFilterArray != null ? classFilterArray : ClassFilter.EMPTY_ARRAY;
    }

    private boolean b(Type type) {
        if (type instanceof ReferenceType) {
            for (ClassFilter classFilter : this.d) {
                if (!classFilter.isEnabled() || !DebuggerUtils.instanceOf((Type)type, (String)classFilter.getPattern())) continue;
                return true;
            }
        }
        return DebuggerUtilsEx.isFiltered(type.name(), this.d);
    }

    public boolean isOnDemand() {
        return this.c;
    }

    public void setOnDemand(boolean bl2) {
        this.c = bl2;
    }

    @Override
    public boolean hasOverhead() {
        return true;
    }

    private static /* synthetic */ void b(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/tree/render/ToStringRenderer", "getLinkText"));
    }
}

