/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer;

import com.intellij.designer.DesignerToolWindowContent;
import com.intellij.designer.componentTree.ComponentTree;
import com.intellij.designer.componentTree.ComponentTreeBuilder;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.propertyTable.PropertyTablePanel;
import com.intellij.designer.propertyTable.RadPropertyTable;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;

public final class DesignerToolWindow
implements DesignerToolWindowContent {
    private final Splitter d;
    private ComponentTree b = new ComponentTree();
    private ComponentTreeBuilder c;
    private PropertyTablePanel a;

    public DesignerToolWindow(Project project2, boolean bl2) {
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.b));
        jScrollPane.setBorder(IdeBorderFactory.createBorder((int)8));
        jScrollPane.setPreferredSize(new Dimension(250, -1));
        this.b.initQuickFixManager(jScrollPane.getViewport());
        this.a = new PropertyTablePanel(project2);
        this.d = new Splitter(true, 0.42f){

            public void doLayout() {
                super.doLayout();
                JComponent jComponent = this.getFirstComponent();
                JComponent jComponent2 = this.getSecondComponent();
                if (jComponent == null || jComponent2 == null) {
                    return;
                }
                int n2 = jComponent.getHeight();
                int n3 = this.getDivider().getHeight();
                int n4 = this.getSize().height;
                if (n2 + n3 + jComponent2.getHeight() != n4) {
                    Rectangle rectangle = jComponent2.getBounds();
                    rectangle.height = n4 - n2 - n3;
                    jComponent2.setBounds(rectangle);
                }
            }
        };
        this.d.setDividerWidth(3);
        this.d.setShowDividerControls(false);
        this.d.setShowDividerIcon(false);
        this.d.setFirstComponent((JComponent)jScrollPane);
        this.d.setSecondComponent((JComponent)this.a);
        if (bl2) {
            this.d.addComponentListener((ComponentListener)new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    boolean bl2;
                    Dimension dimension = DesignerToolWindow.this.d.getSize();
                    boolean bl3 = bl2 = dimension.width < dimension.height;
                    if (DesignerToolWindow.this.d.getOrientation() != bl2) {
                        DesignerToolWindow.this.d.setOrientation(bl2);
                    }
                }
            });
        }
    }

    void update(DesignerEditorPanel designerEditorPanel) {
        this.a();
        this.b.newModel();
        if (designerEditorPanel == null) {
            this.b.setDesignerPanel(null);
            this.a.setArea(null, null);
        } else {
            this.b.setDesignerPanel(designerEditorPanel);
            this.c = new ComponentTreeBuilder(this.b, designerEditorPanel);
            this.a.setArea(designerEditorPanel, this.c.getTreeArea());
        }
    }

    public void dispose() {
        this.a();
        this.d.dispose();
        this.b = null;
        this.a = null;
    }

    private void a() {
        if (this.c != null) {
            Disposer.dispose((Disposable)this.c);
            this.c = null;
        }
    }

    Splitter getToolWindowPanel() {
        return this.d;
    }

    AnAction[] createActions() {
        AnAction anAction = new AnAction("Expand All", null, AllIcons.Actions.Expandall){

            public void actionPerformed(AnActionEvent anActionEvent) {
                if (DesignerToolWindow.this.c != null) {
                    TreeUtil.expandAll((JTree)((Object)DesignerToolWindow.this.b));
                }
            }
        };
        AnAction anAction2 = new AnAction("Collapse All", null, AllIcons.Actions.Collapseall){

            public void actionPerformed(AnActionEvent anActionEvent) {
                if (DesignerToolWindow.this.c != null) {
                    TreeUtil.collapseAll((JTree)((Object)DesignerToolWindow.this.b), (int)1);
                }
            }
        };
        return new AnAction[]{anAction, anAction2};
    }

    public ComponentTree getComponentTree() {
        return this.b;
    }

    public RadPropertyTable getPropertyTable() {
        return this.a.getPropertyTable();
    }

    @Override
    public void expandFromState() {
        if (this.c != null) {
            this.c.expandFromState();
        }
    }

    @Override
    public void refresh(boolean bl2) {
        if (this.c != null) {
            if (bl2) {
                this.c.selectFromSurface();
            } else {
                this.c.queueUpdate();
            }
        }
    }

    @Override
    public void updateInspections() {
        if (this.b != null) {
            this.b.updateInspections();
        }
        if (this.a != null) {
            this.a.getPropertyTable().updateInspections();
        }
    }
}

